/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.resources.auth.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpExtendService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiParamsPositionService;
import com.jxdinfo.hussar.eai.migration.business.resources.auth.service.IEaiWebserviceAuthResourcesService;
import com.jxdinfo.hussar.eai.migration.business.resources.auth.service.impl.EaiCommonAuthAbstract;
import com.jxdinfo.hussar.eai.migration.dto.EaiCommonResourcesDto;
import com.jxdinfo.hussar.eai.migration.dto.EaiCommonResourcesResultDto;
import com.jxdinfo.hussar.eai.migration.enums.ApplicationMigrationExportEnum;
import com.jxdinfo.hussar.eai.migration.enums.EaiServiceTypeEnum;
import com.jxdinfo.hussar.eai.migration.manifest.EaiServiceManiFest;
import com.jxdinfo.hussar.eai.migration.resources.auth.dto.EaiWsAuthResourcesDto;
import com.jxdinfo.hussar.eai.migration.resources.service.IEaiResourcesService;
import com.jxdinfo.hussar.eai.migration.resources.service.MigrationResultDto;
import com.jxdinfo.hussar.eai.migration.util.MigrationUtil;
import com.jxdinfo.hussar.eai.webservice.manager.api.model.EaiAuthWsdlInfo;
import com.jxdinfo.hussar.eai.webservice.manager.api.model.EaiWebserviceTemplate;
import com.jxdinfo.hussar.eai.webservice.manager.api.service.IEaiAppWsdlVersionService;
import com.jxdinfo.hussar.eai.webservice.manager.api.service.IEaiAuthWsdlInfoService;
import com.jxdinfo.hussar.eai.webservice.manager.api.service.IEaiWebserviceTemplateService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.migration.business.resources.auth.service.impl.EaiWebserviceAuthResourcesServiceImpl")
public class EaiWebserviceAuthResourcesServiceImpl
extends EaiCommonAuthAbstract<EaiWsAuthResourcesDto>
implements IEaiWebserviceAuthResourcesService {
    @Autowired
    private IEaiWebserviceTemplateService eaiWebserviceTemplateService;
    @Autowired
    private IEaiHttpExtendService eaiHttpExtendService;
    @Autowired
    private IEaiAuthWsdlInfoService eaiAuthWsdlInfoService;
    @Autowired
    private IEaiParamsPositionService eaiParamsPositionService;
    @Autowired
    private IEaiAppWsdlVersionService wsdlVersionService;

    public EaiCommonResourcesDto getDumpResources(SysApplication sysApplication, String appVersion, String args) {
        EaiCommonResourcesDto commonResourcesDto = new EaiCommonResourcesDto();
        EaiWsAuthResourcesDto wsAuthResourcesDto = new EaiWsAuthResourcesDto();
        EaiWebserviceTemplate webserviceTemplate = (EaiWebserviceTemplate)this.eaiWebserviceTemplateService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiWebserviceTemplate::getApplicationCode, (Object)sysApplication.getAppCode())).isNull(EaiWebserviceTemplate::getTemplateType));
        if (HussarUtils.isEmpty((Object)webserviceTemplate)) {
            return commonResourcesDto;
        }
        webserviceTemplate.setTemplateType("0");
        wsAuthResourcesDto.setWebserviceTemplate(webserviceTemplate);
        ArrayList<Long> constantVersionIds = new ArrayList<Long>();
        ArrayList<Long> structureVersionIds = new ArrayList<Long>();
        List<Long> extendIds = this.commonAuthResources(webserviceTemplate.getId(), wsAuthResourcesDto, constantVersionIds, structureVersionIds);
        if (HussarUtils.isNotEmpty(extendIds)) {
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(EaiAuthWsdlInfo::getExtendId, extendIds);
            List eaiAuthWsdlInfos = this.eaiAuthWsdlInfoService.list((Wrapper)queryWrapper);
            if (HussarUtils.isNotEmpty((Object)eaiAuthWsdlInfos)) {
                List wsdlIds = eaiAuthWsdlInfos.stream().map(EaiAuthWsdlInfo::getWsdlId).collect(Collectors.toList());
                wsdlIds = wsdlIds.stream().distinct().collect(Collectors.toList());
                List wsdlVersions = this.wsdlVersionService.listByIds(wsdlIds);
                commonResourcesDto.setWsdlList(wsdlVersions);
                wsAuthResourcesDto.setEaiAuthWsdlInfos(eaiAuthWsdlInfos);
            }
            this.setResources(constantVersionIds, structureVersionIds, commonResourcesDto, wsAuthResourcesDto);
        }
        ArrayList<EaiWsAuthResourcesDto> list = new ArrayList<EaiWsAuthResourcesDto>(1);
        list.add(wsAuthResourcesDto);
        commonResourcesDto.setResult(list);
        return commonResourcesDto;
    }

    public MigrationResultDto<EaiWsAuthResourcesDto> replaceIdMaps(List<EaiWsAuthResourcesDto> resultList, EaiCommonResourcesResultDto eaiCommonResourcesResultDto) {
        MigrationResultDto resultDto = new MigrationResultDto();
        if (HussarUtils.isEmpty(resultList)) {
            resultDto.setResult(Collections.emptyList());
            resultDto.setTotal(0);
            return resultDto;
        }
        List result = JSON.parseArray((String)JSON.toJSONString(resultList), EaiWsAuthResourcesDto.class);
        Map constantIdMap = eaiCommonResourcesResultDto.getConstantIdMap();
        Map structureIdMap = eaiCommonResourcesResultDto.getStructureIdMap();
        Map wsdlIdMap = eaiCommonResourcesResultDto.getAppWsdlIdMap();
        if (HussarUtils.isEmpty((Object)constantIdMap) && HussarUtils.isEmpty((Object)structureIdMap) && HussarUtils.isEmpty((Object)wsdlIdMap)) {
            resultDto.setResult(result);
            resultDto.setTotal(this.getCountNum(result));
            return resultDto;
        }
        this.replaceIds(result, constantIdMap, structureIdMap);
        this.replaceWsdlIds(result, wsdlIdMap);
        resultDto.setResult(result);
        resultDto.setTotal(this.getCountNum(result));
        return resultDto;
    }

    private void replaceWsdlIds(List<EaiWsAuthResourcesDto> result, Map<Long, Long> wsdlIdMap) {
        if (HussarUtils.isEmpty(wsdlIdMap) || HussarUtils.isEmpty(result)) {
            return;
        }
        for (EaiWsAuthResourcesDto wsAuthResourcesDto : result) {
            List wsdlInfos = wsAuthResourcesDto.getEaiAuthWsdlInfos();
            if (!HussarUtils.isNotEmpty((Object)wsdlInfos)) continue;
            for (EaiAuthWsdlInfo wsdlInfo : wsdlInfos) {
                if (!wsdlIdMap.containsKey(wsdlInfo.getWsdlId())) continue;
                wsdlInfo.setWsdlId(wsdlIdMap.get(wsdlInfo.getWsdlId()));
            }
            wsAuthResourcesDto.setEaiAuthWsdlInfos(wsdlInfos);
        }
    }

    private int getCountNum(List<EaiWsAuthResourcesDto> result) {
        int i = 0;
        if (HussarUtils.isEmpty(result)) {
            return 0;
        }
        for (EaiWsAuthResourcesDto resourcesDto : result) {
            ++i;
            i += this.countNum(resourcesDto);
            if (HussarUtils.isNotEmpty((Object)resourcesDto.getEaiAuthWsdlInfos())) {
                i += resourcesDto.getEaiAuthWsdlInfos().size();
            }
            if (!HussarUtils.isNotEmpty((Object)resourcesDto.getWsdlList())) continue;
            i += resourcesDto.getWsdlList().size();
        }
        return i;
    }

    public EaiServiceManiFest resourcesMetadata() {
        return MigrationUtil.createResourcesManiFest((ApplicationMigrationExportEnum)ApplicationMigrationExportEnum.APP_AUTH_WSDL_INFO_FILE, (IEaiResourcesService)this, (EaiServiceTypeEnum)EaiServiceTypeEnum.AUTH);
    }
}

