/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.resources.auth.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpTemplate;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpTemplateService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpVerifyBaseService;
import com.jxdinfo.hussar.eai.migration.business.resources.auth.service.IEaiHttpAuthResourcesService;
import com.jxdinfo.hussar.eai.migration.business.resources.auth.service.impl.EaiCommonAuthAbstract;
import com.jxdinfo.hussar.eai.migration.business.service.IEaiAuthResourceIdsService;
import com.jxdinfo.hussar.eai.migration.dto.EaiCommonResourcesDto;
import com.jxdinfo.hussar.eai.migration.dto.EaiCommonResourcesResultDto;
import com.jxdinfo.hussar.eai.migration.enums.ApplicationMigrationExportEnum;
import com.jxdinfo.hussar.eai.migration.enums.EaiServiceTypeEnum;
import com.jxdinfo.hussar.eai.migration.manifest.EaiServiceManiFest;
import com.jxdinfo.hussar.eai.migration.resources.auth.dto.EaiHttpAuthResourcesDto;
import com.jxdinfo.hussar.eai.migration.resources.service.IEaiResourcesService;
import com.jxdinfo.hussar.eai.migration.resources.service.MigrationResultDto;
import com.jxdinfo.hussar.eai.migration.util.MigrationUtil;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.serevice.IConstantVersionService;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.serevice.IStructureVersionService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.migration.business.resources.auth.service.impl.EaiHttpAuthResourcesServiceImpl")
public class EaiHttpAuthResourcesServiceImpl
extends EaiCommonAuthAbstract<EaiHttpAuthResourcesDto>
implements IEaiHttpAuthResourcesService {
    @Autowired
    private IEaiHttpTemplateService eaiHttpTemplateService;
    @Autowired
    private IEaiHttpVerifyBaseService eaiHttpVerifyBaseService;
    @Autowired
    private IConstantVersionService constantVersionService;
    @Autowired
    private IStructureVersionService structureVersionService;
    @Autowired
    private IEaiAuthResourceIdsService eaiAuthResourceIdsService;

    public EaiCommonResourcesDto getDumpResources(SysApplication sysApplication, String appVersion, String args) {
        EaiCommonResourcesDto commonResourcesDto = new EaiCommonResourcesDto();
        EaiHttpAuthResourcesDto httpAuthResourcesDto = new EaiHttpAuthResourcesDto();
        EaiHttpTemplate httpTemplate = (EaiHttpTemplate)this.eaiHttpTemplateService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiHttpTemplate::getApplicationCode, (Object)sysApplication.getAppCode())).isNull(EaiHttpTemplate::getTemplateType));
        if (HussarUtils.isEmpty((Object)httpTemplate)) {
            return commonResourcesDto;
        }
        httpTemplate.setTemplateType("0");
        httpAuthResourcesDto.setEaiHttpTemplate(httpTemplate);
        ArrayList<Long> constantVersionIds = new ArrayList<Long>();
        ArrayList<Long> structureVersionIds = new ArrayList<Long>();
        List<Long> extendIds = this.commonAuthResources(httpTemplate.getTemplateId(), httpAuthResourcesDto, constantVersionIds, structureVersionIds);
        if (HussarUtils.isNotEmpty(extendIds)) {
            this.setResources(constantVersionIds, structureVersionIds, commonResourcesDto, httpAuthResourcesDto);
        }
        ArrayList<EaiHttpAuthResourcesDto> eaiHttpAuthResourcesDtos = new ArrayList<EaiHttpAuthResourcesDto>(1);
        eaiHttpAuthResourcesDtos.add(httpAuthResourcesDto);
        commonResourcesDto.setResult(eaiHttpAuthResourcesDtos);
        return commonResourcesDto;
    }

    public MigrationResultDto<EaiHttpAuthResourcesDto> replaceIdMaps(List<EaiHttpAuthResourcesDto> resultList, EaiCommonResourcesResultDto eaiCommonResourcesResultDto) {
        MigrationResultDto resultDto = new MigrationResultDto();
        if (HussarUtils.isEmpty(resultList)) {
            resultDto.setResult(Collections.emptyList());
            resultDto.setTotal(0);
            return resultDto;
        }
        List result = JSON.parseArray((String)JSON.toJSONString(resultList), EaiHttpAuthResourcesDto.class);
        Map constantIdMap = eaiCommonResourcesResultDto.getConstantIdMap();
        Map structureIdMap = eaiCommonResourcesResultDto.getStructureIdMap();
        if (HussarUtils.isEmpty((Object)constantIdMap) && HussarUtils.isEmpty((Object)structureIdMap)) {
            resultDto.setResult(result);
            resultDto.setTotal(this.getCountNum(result));
            return resultDto;
        }
        this.replaceIds(result, constantIdMap, structureIdMap);
        resultDto.setResult(result);
        resultDto.setTotal(this.getCountNum(result));
        return resultDto;
    }

    private int getCountNum(List<EaiHttpAuthResourcesDto> result) {
        int i = 0;
        if (HussarUtils.isEmpty(result)) {
            return 0;
        }
        for (EaiHttpAuthResourcesDto resourcesDto : result) {
            ++i;
            i += this.countNum(resourcesDto);
        }
        return i;
    }

    public EaiServiceManiFest resourcesMetadata() {
        return MigrationUtil.createResourcesManiFest((ApplicationMigrationExportEnum)ApplicationMigrationExportEnum.APP_AUTH_HTTP_INFO_FILE, (IEaiResourcesService)this, (EaiServiceTypeEnum)EaiServiceTypeEnum.AUTH);
    }
}

