/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.resources.auth.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiCustomizeAuth;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpExtend;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpParams;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpVerifyBase;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiParamsPosition;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiTokenInvali;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiCustomizeAuthSerivce;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpExtendService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpParamsService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpVerifyBaseService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiParamsPositionService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiTokenInvaliService;
import com.jxdinfo.hussar.eai.migration.business.resources.service.IEaiCleanStructureItemService;
import com.jxdinfo.hussar.eai.migration.business.service.IEaiAuthResourceIdsService;
import com.jxdinfo.hussar.eai.migration.dto.EaiCommonResourcesDto;
import com.jxdinfo.hussar.eai.migration.resources.auth.dto.EaiAuthResourcesDto;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.ConstantVersion;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.StructureVersion;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.serevice.IConstantVersionService;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.serevice.IStructureVersionService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class EaiCommonAuthAbstract<T extends EaiAuthResourcesDto> {
    @Autowired
    private IEaiHttpExtendService eaiHttpExtendService;
    @Autowired
    private IEaiCustomizeAuthSerivce eaiCustomizeAuthSerivce;
    @Autowired
    private IEaiParamsPositionService eaiParamsPositionService;
    @Autowired
    private IEaiTokenInvaliService eaiTokenInvaliService;
    @Autowired
    private IConstantVersionService constantVersionService;
    @Autowired
    private IStructureVersionService structureVersionService;
    @Autowired
    private IEaiHttpVerifyBaseService eaiHttpVerifyBaseService;
    @Autowired
    protected IEaiAuthResourceIdsService eaiAuthResourceIdsService;
    @Autowired
    private IEaiHttpParamsService eaiHttpParamsService;
    @Autowired
    private IEaiCleanStructureItemService eaiCleanStructureItemService;

    public List<Long> commonAuthResources(Long templateId, T resourceDto, List<Long> constantVersionIds, List<Long> structureVersionIds) {
        List verifyBaseList;
        List httpExtendList = this.eaiHttpExtendService.list((Wrapper)new LambdaQueryWrapper().eq(EaiHttpExtend::getTemplateId, (Object)templateId));
        if (HussarUtils.isEmpty((Object)httpExtendList)) {
            return null;
        }
        resourceDto.setAuthExtends(httpExtendList);
        List<Long> extendIds = httpExtendList.stream().map(EaiHttpExtend::getExtendId).collect(Collectors.toList());
        List customizeAuthList = this.eaiCustomizeAuthSerivce.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(EaiCustomizeAuth::getExtendId, extendIds));
        resourceDto.setCustomizeAuths(customizeAuthList);
        List paramsPositionList = this.eaiParamsPositionService.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(EaiParamsPosition::getExtendId, extendIds));
        if (HussarUtils.isNotEmpty((Object)paramsPositionList)) {
            paramsPositionList = this.eaiAuthResourceIdsService.replaceAuthParams(paramsPositionList);
        }
        resourceDto.setParamsPositions(paramsPositionList);
        List tokenInvaliList = this.eaiTokenInvaliService.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(EaiTokenInvali::getExtendId, extendIds));
        resourceDto.setTokenInvalis(tokenInvaliList);
        if (HussarUtils.isNotEmpty((Object)paramsPositionList)) {
            constantVersionIds.addAll(this.eaiAuthResourceIdsService.getPositionResourceIds(paramsPositionList));
        }
        if (HussarUtils.isNotEmpty((Object)(verifyBaseList = this.eaiHttpVerifyBaseService.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(EaiHttpVerifyBase::getExtendId, extendIds))))) {
            resourceDto.setVerifyBaseList(verifyBaseList);
            constantVersionIds.addAll(this.eaiAuthResourceIdsService.getConstantIdsFromVerifyBase(verifyBaseList));
            List httpIds = verifyBaseList.stream().map(EaiHttpVerifyBase::getHttpBaseId).collect(Collectors.toList());
            List httpParamsList = this.eaiHttpParamsService.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(EaiHttpParams::getHttpId, httpIds));
            if (HussarUtils.isNotEmpty((Object)httpParamsList)) {
                httpParamsList = this.eaiAuthResourceIdsService.replaceHttpParams(httpParamsList);
            }
            resourceDto.setHttpParams(httpParamsList);
            this.eaiAuthResourceIdsService.getResourceIds(constantVersionIds, structureVersionIds, httpParamsList);
        }
        return extendIds;
    }

    protected void setResources(List<Long> constantVersionIds, List<Long> structureVersionIds, EaiCommonResourcesDto commonResourcesDto, T t) {
        if (HussarUtils.isNotEmpty(constantVersionIds)) {
            constantVersionIds = constantVersionIds.stream().distinct().collect(Collectors.toList());
            List constantVersions = null;
            if (HussarUtils.isEmpty((Object)commonResourcesDto.getConnectionList())) {
                constantVersions = this.constantVersionService.listByIds(constantVersionIds);
                commonResourcesDto.setConstantList(constantVersions);
            } else {
                constantVersionIds.removeAll(commonResourcesDto.getConstantList().stream().map(ConstantVersion::getId).collect(Collectors.toList()));
                if (HussarUtils.isNotEmpty(constantVersionIds)) {
                    constantVersions = this.constantVersionService.listByIds(constantVersionIds);
                    commonResourcesDto.getConstantList().addAll(constantVersions);
                }
            }
        }
        if (HussarUtils.isNotEmpty(structureVersionIds)) {
            structureVersionIds = structureVersionIds.stream().distinct().collect(Collectors.toList());
            List structureVersions = null;
            if (HussarUtils.isEmpty((Object)commonResourcesDto.getStructureList())) {
                structureVersions = this.structureVersionService.listByIds(structureVersionIds);
                commonResourcesDto.setStructureList(structureVersions);
            } else {
                structureVersionIds.removeAll(commonResourcesDto.getStructureList().stream().map(StructureVersion::getId).collect(Collectors.toList()));
                if (HussarUtils.isNotEmpty(structureVersionIds)) {
                    structureVersions = this.structureVersionService.listByIds(structureVersionIds);
                    commonResourcesDto.getStructureList().addAll(structureVersions);
                }
            }
        }
    }

    protected void replaceIds(List<T> result, Map<Long, Long> constantIdMap, Map<Long, Long> structureIdMap) {
        for (EaiAuthResourcesDto httpAuthResourcesDto : result) {
            List paramsPositionList;
            List verifyBaseList;
            List httpParams = httpAuthResourcesDto.getHttpParams();
            if (HussarUtils.isNotEmpty((Object)httpParams)) {
                this.eaiAuthResourceIdsService.replaceResourceIds(constantIdMap, structureIdMap, httpParams);
                httpAuthResourcesDto.setHttpParams(httpParams);
            }
            if (HussarUtils.isNotEmpty((Object)(verifyBaseList = httpAuthResourcesDto.getVerifyBaseList())) && HussarUtils.isNotEmpty(constantIdMap)) {
                this.eaiAuthResourceIdsService.replaceConstantIdsFromVerifyBase(verifyBaseList, constantIdMap);
                httpAuthResourcesDto.setVerifyBaseList(verifyBaseList);
            }
            if (!HussarUtils.isNotEmpty((Object)(paramsPositionList = httpAuthResourcesDto.getParamsPositions())) || !HussarUtils.isNotEmpty(constantIdMap)) continue;
            this.eaiAuthResourceIdsService.replacePositionResourceIds(paramsPositionList, constantIdMap);
            httpAuthResourcesDto.setParamsPositions(paramsPositionList);
        }
    }

    protected int countNum(T resourcesDto) {
        int i = 0;
        if (HussarUtils.isNotEmpty((Object)resourcesDto.getStructureList())) {
            i += resourcesDto.getStructureList().size();
        }
        if (HussarUtils.isNotEmpty((Object)resourcesDto.getConstantList())) {
            i += resourcesDto.getConstantList().size();
        }
        if (HussarUtils.isNotEmpty((Object)resourcesDto.getHttpParams())) {
            i += resourcesDto.getHttpParams().size();
        }
        if (HussarUtils.isNotEmpty((Object)resourcesDto.getAuthExtends())) {
            i += resourcesDto.getAuthExtends().size();
        }
        if (HussarUtils.isNotEmpty((Object)resourcesDto.getParamsPositions())) {
            i += resourcesDto.getParamsPositions().size();
        }
        if (HussarUtils.isNotEmpty((Object)resourcesDto.getTokenInvalis())) {
            i += resourcesDto.getTokenInvalis().size();
        }
        if (HussarUtils.isNotEmpty((Object)resourcesDto.getCustomizeAuths())) {
            i += resourcesDto.getCustomizeAuths().size();
        }
        if (HussarUtils.isNotEmpty((Object)resourcesDto.getVerifyBaseList())) {
            i += resourcesDto.getVerifyBaseList().size();
        }
        return i;
    }
}

