/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.resources.api.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.eai.apirelease.api.model.EaiApiVersion;
import com.jxdinfo.hussar.eai.migration.business.resources.api.factory.EaiApiExtraResourcesFactory;
import com.jxdinfo.hussar.eai.migration.business.resources.api.service.IEaiApiConfigService;
import com.jxdinfo.hussar.eai.migration.business.resources.api.service.IEaiWsApiInfoService;
import com.jxdinfo.hussar.eai.migration.dto.EaiCommonResourcesResultDto;
import com.jxdinfo.hussar.eai.migration.resources.api.dto.ApiResourceCodeMaps;
import com.jxdinfo.hussar.eai.migration.resources.api.dto.EaiApiResourcesDto;
import com.jxdinfo.hussar.eai.webservice.manager.api.model.EaiAppWsdlVersion;
import com.jxdinfo.hussar.eai.webservice.manager.api.model.EaiEditApiWsdl;
import com.jxdinfo.hussar.eai.webservice.manager.api.service.IEaiAppWsdlVersionService;
import com.jxdinfo.hussar.eai.webservice.manager.api.service.IEaiEditApiWsdlService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.migration.business.resources.api.service.impl.EaiWsApiInfoServiceImpl")
public class EaiWsApiInfoServiceImpl
implements IEaiWsApiInfoService {
    @Autowired
    private IEaiEditApiWsdlService eaiEditApiWsdlService;
    @Autowired
    private IEaiAppWsdlVersionService eaiAppWsdlVersionService;
    private static final String WSDL = "wsdl";

    public List<EaiEditApiWsdl> getExtraList(List<EaiApiVersion> apiVersionList, EaiApiResourcesDto eaiApiResourcesDto) {
        if (HussarUtils.isEmpty(apiVersionList)) {
            return Collections.emptyList();
        }
        List ids = apiVersionList.stream().map(EaiApiVersion::getApiVersionId).collect(Collectors.toList());
        List eaiEditApiWsdls = this.eaiEditApiWsdlService.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(EaiEditApiWsdl::getApiId, ids));
        if (HussarUtils.isEmpty((Object)eaiEditApiWsdls)) {
            return Collections.emptyList();
        }
        List wsdlIds = eaiEditApiWsdls.stream().map(EaiEditApiWsdl::getWsdlId).collect(Collectors.toList());
        wsdlIds = wsdlIds.stream().distinct().collect(Collectors.toList());
        List wsdlVersions = this.eaiAppWsdlVersionService.listByIds(wsdlIds);
        if (HussarUtils.isNotEmpty((Object)eaiApiResourcesDto.getWsdlList())) {
            eaiApiResourcesDto.getWsdlList().addAll(wsdlVersions);
        } else {
            eaiApiResourcesDto.setWsdlList(wsdlVersions);
        }
        List<ApiResourceCodeMaps> resourceCodeMaps = this.getResourceMap(eaiEditApiWsdls, apiVersionList, wsdlVersions);
        if (HussarUtils.isEmpty(resourceCodeMaps)) {
            return eaiEditApiWsdls;
        }
        if (HussarUtils.isNotEmpty((Object)eaiApiResourcesDto.getApiResourceCodeMaps())) {
            List<ApiResourceCodeMaps> old = eaiApiResourcesDto.getApiResourceCodeMaps();
            Map<String, ApiResourceCodeMaps> map = resourceCodeMaps.stream().collect(Collectors.toMap(ApiResourceCodeMaps::getApiCode, Function.identity()));
            old = this.codeMap(old, map);
            eaiApiResourcesDto.setApiResourceCodeMaps(old);
        } else {
            eaiApiResourcesDto.setApiResourceCodeMaps(resourceCodeMaps);
        }
        return eaiEditApiWsdls;
    }

    private List<ApiResourceCodeMaps> codeMap(List<ApiResourceCodeMaps> old, Map<String, ApiResourceCodeMaps> map) {
        for (ApiResourceCodeMaps apiResourceCodeMaps : old) {
            ApiResourceCodeMaps newCodeMap;
            if (!map.containsKey(apiResourceCodeMaps.getApiCode()) || HussarUtils.isEmpty((Object)(newCodeMap = map.get(apiResourceCodeMaps.getApiCode()))) || HussarUtils.isEmpty((Object)newCodeMap.getTypeCodes())) continue;
            if (HussarUtils.isNotEmpty((Object)apiResourceCodeMaps.getTypeCodes())) {
                List allCodes = (List)apiResourceCodeMaps.getTypeCodes().get(WSDL);
                if (HussarUtils.isEmpty((Object)allCodes)) {
                    apiResourceCodeMaps.getTypeCodes().put(WSDL, newCodeMap.getTypeCodes().get(WSDL));
                    continue;
                }
                ((List)apiResourceCodeMaps.getTypeCodes().get(WSDL)).addAll((Collection)newCodeMap.getTypeCodes().get(WSDL));
                continue;
            }
            HashMap map1 = new HashMap();
            map1.put(WSDL, newCodeMap.getTypeCodes().get(WSDL));
            apiResourceCodeMaps.setTypeCodes(map1);
        }
        return old;
    }

    private List<ApiResourceCodeMaps> getResourceMap(List<EaiEditApiWsdl> eaiEditApiWsdls, List<EaiApiVersion> apiVersionList, List<EaiAppWsdlVersion> eaiAppWsdlVersions) {
        if (HussarUtils.isEmpty(eaiAppWsdlVersions)) {
            return null;
        }
        Map<Long, String> map = eaiAppWsdlVersions.stream().collect(Collectors.toMap(EaiAppWsdlVersion::getWsdlId, EaiAppWsdlVersion::getWsdlPath));
        HashMap<Long, String> apiMap = new HashMap<Long, String>();
        for (EaiEditApiWsdl eaiEditApiWsdl : eaiEditApiWsdls) {
            if (!map.containsKey(eaiEditApiWsdl.getWsdlId())) continue;
            apiMap.put(eaiEditApiWsdl.getApiId(), map.get(eaiEditApiWsdl.getWsdlId()));
        }
        ArrayList<ApiResourceCodeMaps> resourceCodeMaps = new ArrayList<ApiResourceCodeMaps>();
        for (EaiApiVersion apiVersion : apiVersionList) {
            ApiResourceCodeMaps resourceCodeMap = new ApiResourceCodeMaps();
            resourceCodeMap.setApiCode(apiVersion.getApiCode());
            ArrayList codes = new ArrayList(1);
            codes.add(apiMap.get(apiVersion.getApiVersionId()));
            HashMap map1 = new HashMap();
            map1.put(WSDL, codes);
            resourceCodeMap.setTypeCodes(map1);
            resourceCodeMaps.add(resourceCodeMap);
        }
        return resourceCodeMaps;
    }

    public List<EaiEditApiWsdl> replaceIds(List<EaiEditApiWsdl> resultList, EaiCommonResourcesResultDto eaiCommonResourcesResultDto) {
        if (HussarUtils.isNotEmpty(resultList)) {
            List result = JSON.parseArray((String)JSON.toJSONString(resultList), EaiEditApiWsdl.class);
            Map wsdlIdMap = eaiCommonResourcesResultDto.getAppWsdlIdMap();
            for (EaiEditApiWsdl eaiEditApiWsdl : result) {
                if (!HussarUtils.isNotEmpty((Object)wsdlIdMap) || !wsdlIdMap.containsKey(eaiEditApiWsdl.getWsdlId())) continue;
                eaiEditApiWsdl.setWsdlId((Long)wsdlIdMap.get(eaiEditApiWsdl.getWsdlId()));
            }
        }
        return resultList;
    }

    public int saveExtraList(List<EaiEditApiWsdl> resultList, Map<Long, Long> apiIdMap) {
        if (HussarUtils.isEmpty(resultList)) {
            return 0;
        }
        List result = JSON.parseArray((String)JSON.toJSONString(resultList), EaiEditApiWsdl.class);
        for (EaiEditApiWsdl editApiWsdl : result) {
            editApiWsdl.setId(EngineUtil.getId());
            editApiWsdl.setApiId(apiIdMap.get(editApiWsdl.getApiId()));
        }
        this.eaiEditApiWsdlService.saveBatch((Collection)result);
        return result.size();
    }

    public int saveExtraList(Long oldId, Long newId, List<EaiEditApiWsdl> resultList) {
        if (HussarUtils.isEmpty(resultList)) {
            return 0;
        }
        List result = JSON.parseArray((String)JSON.toJSONString(resultList), EaiEditApiWsdl.class);
        ArrayList<EaiEditApiWsdl> saveInfo = new ArrayList<EaiEditApiWsdl>(1);
        for (EaiEditApiWsdl editApiWsdl : result) {
            if (!oldId.equals(editApiWsdl.getApiId())) continue;
            editApiWsdl.setId(EngineUtil.getId());
            editApiWsdl.setApiId(newId);
            saveInfo.add(editApiWsdl);
        }
        if (HussarUtils.isNotEmpty(saveInfo)) {
            this.eaiEditApiWsdlService.saveBatch(saveInfo);
        }
        return saveInfo.size();
    }

    public void afterPropertiesSet() throws Exception {
        EaiApiExtraResourcesFactory.register("1", (IEaiApiConfigService)this);
    }
}

