/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.resources.api.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.eai.apirelease.api.model.EaiApiVersion;
import com.jxdinfo.hussar.eai.datasource.rdb.model.EaiQuerySqlConf;
import com.jxdinfo.hussar.eai.datasource.rdb.service.IEaiQuerySqlConfService;
import com.jxdinfo.hussar.eai.migration.business.resources.api.factory.EaiApiExtraResourcesFactory;
import com.jxdinfo.hussar.eai.migration.business.resources.api.service.IEaiApiConfigService;
import com.jxdinfo.hussar.eai.migration.business.resources.api.service.IEaiSqlApiInfoService;
import com.jxdinfo.hussar.eai.migration.resources.api.dto.EaiApiResourcesDto;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.migration.business.resources.api.service.impl.EaiSqlApiInfoServiceImpl")
public class EaiSqlApiInfoServiceImpl
implements IEaiSqlApiInfoService {
    @Autowired
    private IEaiQuerySqlConfService eaiQuerySqlConfService;

    public List<EaiQuerySqlConf> getExtraList(List<EaiApiVersion> apiVersionList, EaiApiResourcesDto eaiApiResourcesDto) {
        if (HussarUtils.isEmpty(apiVersionList)) {
            return Collections.emptyList();
        }
        List ids = apiVersionList.stream().map(EaiApiVersion::getApiVersionId).collect(Collectors.toList());
        return this.eaiQuerySqlConfService.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(EaiQuerySqlConf::getApiId, ids));
    }

    public int saveExtraList(List<EaiQuerySqlConf> result, Map<Long, Long> apiIdMap) {
        if (HussarUtils.isEmpty(result)) {
            return 0;
        }
        for (EaiQuerySqlConf eaiQuerySqlConf : result) {
            eaiQuerySqlConf.setApiId(apiIdMap.get(eaiQuerySqlConf.getApiId()));
            eaiQuerySqlConf.setId(EngineUtil.getId());
        }
        this.eaiQuerySqlConfService.saveBatch(result);
        return result.size();
    }

    public int saveExtraList(Long oldId, Long newId, List<EaiQuerySqlConf> result) {
        if (HussarUtils.isEmpty(result)) {
            return 0;
        }
        ArrayList<EaiQuerySqlConf> saveInfo = new ArrayList<EaiQuerySqlConf>(1);
        for (EaiQuerySqlConf eaiQuerySqlConf : result) {
            if (!oldId.equals(eaiQuerySqlConf.getApiId())) continue;
            eaiQuerySqlConf.setApiId(newId);
            eaiQuerySqlConf.setId(EngineUtil.getId());
            saveInfo.add(eaiQuerySqlConf);
        }
        if (HussarUtils.isNotEmpty(saveInfo)) {
            this.eaiQuerySqlConfService.saveBatch(saveInfo);
        }
        return saveInfo.size();
    }

    public void afterPropertiesSet() throws Exception {
        EaiApiExtraResourcesFactory.register("2", (IEaiApiConfigService)this);
    }
}

