/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.resources.api.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiCallSpecificationInfo;
import com.jxdinfo.hussar.eai.apiinfo.api.model.EditApi;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IApiCallSpecificationInfoService;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiEditApiService;
import com.jxdinfo.hussar.eai.apirelease.api.model.EaiApiVersion;
import com.jxdinfo.hussar.eai.apirelease.api.srevice.IApiVersionService;
import com.jxdinfo.hussar.eai.apirelease.api.srevice.IEaiApiClassificationVersionService;
import com.jxdinfo.hussar.eai.appinfo.api.model.EaiResourcesInfo;
import com.jxdinfo.hussar.eai.appinfo.api.service.IEaiResourcesInfoService;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.constant.EaiDataType;
import com.jxdinfo.hussar.eai.common.enums.app.EaiResourcesEnum;
import com.jxdinfo.hussar.eai.migration.business.distinct.service.IEaiCanvasInfoResourcesService;
import com.jxdinfo.hussar.eai.migration.business.resources.api.dto.EaiApiResourceId;
import com.jxdinfo.hussar.eai.migration.business.resources.api.factory.EaiApiExtraResourcesFactory;
import com.jxdinfo.hussar.eai.migration.business.resources.api.service.IEaiApiConfigService;
import com.jxdinfo.hussar.eai.migration.business.resources.api.service.IEaiApiInfoService;
import com.jxdinfo.hussar.eai.migration.business.service.IEaiCanvasResourceIdReplaceService;
import com.jxdinfo.hussar.eai.migration.dto.EaiCommonLogicDto;
import com.jxdinfo.hussar.eai.migration.dto.EaiCommonResourcesDto;
import com.jxdinfo.hussar.eai.migration.dto.EaiCommonResourcesResultDto;
import com.jxdinfo.hussar.eai.migration.enums.ApplicationMigrationExportEnum;
import com.jxdinfo.hussar.eai.migration.enums.EaiServiceTypeEnum;
import com.jxdinfo.hussar.eai.migration.manager.HussarEaiMigrationTaskManager;
import com.jxdinfo.hussar.eai.migration.manifest.EaiServiceManiFest;
import com.jxdinfo.hussar.eai.migration.properties.HussarEaiMigrationProperties;
import com.jxdinfo.hussar.eai.migration.resources.api.dto.ApiResourceCodeMaps;
import com.jxdinfo.hussar.eai.migration.resources.api.dto.EaiApiResourcesDto;
import com.jxdinfo.hussar.eai.migration.resources.service.IEaiResourcesService;
import com.jxdinfo.hussar.eai.migration.resources.service.MigrationResultDto;
import com.jxdinfo.hussar.eai.migration.util.MigrationUtil;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.ConstantVersion;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.StructureVersion;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.serevice.IConstantVersionService;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.serevice.IStructureVersionService;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CanvasInfo;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICanvasInfoService;
import com.jxdinfo.hussar.eai.resourceexternalopen.api.model.ConnectionVersion;
import com.jxdinfo.hussar.eai.resourceexternalopen.api.model.LogicVersion;
import com.jxdinfo.hussar.eai.resourceexternalopen.api.service.IConnectionVersionService;
import com.jxdinfo.hussar.eai.resourceexternalopen.api.service.IEaiLogicVersionService;
import com.jxdinfo.hussar.eai.webservice.manager.api.model.EaiAppWsdlVersion;
import com.jxdinfo.hussar.eai.webservice.manager.api.service.IEaiAppWsdlVersionService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.rmi.core.utils.TypeReference;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.migration.business.resources.api.service.impl.EaiApiInfoServiceImpl")
public class EaiApiInfoServiceImpl
implements IEaiApiInfoService {
    private static final Logger logger = LoggerFactory.getLogger(EaiApiInfoServiceImpl.class);
    @Autowired
    private IApiVersionService apiVersionService;
    @Autowired
    private IEaiEditApiService eaiEditApiService;
    @Autowired
    private ICanvasInfoService canvasInfoService;
    @Autowired
    private IEaiResourcesInfoService eaiResourcesInfoService;
    @Autowired
    private IEaiApiClassificationVersionService eaiApiClassificationVersionService;
    @Autowired
    private IApiCallSpecificationInfoService apiCallSpecificationInfoService;
    @Autowired
    private HussarEaiMigrationProperties properties;
    @Autowired
    private IConnectionVersionService connectionVersionService;
    @Autowired
    private IConstantVersionService constantVersionService;
    @Autowired
    private IStructureVersionService structureVersionService;
    @Autowired
    private IEaiLogicVersionService logicVersionService;
    @Autowired
    private IEaiAppWsdlVersionService wsdlVersionService;
    @Autowired
    private HussarEaiMigrationTaskManager hussarEaiMigrationTaskManager;
    @Autowired
    private IEaiCanvasResourceIdReplaceService eaiCanvasResourceIdReplaceService;
    private static final String ERROR_MSG = "\u83b7\u53d6\u63a5\u53e3\u76f8\u5173\u8d44\u6e90\u4fe1\u606f\u5f02\u5e38";
    private static final String ERROR_LOG_STRUCTURE_MSG = "\u5bfc\u51fa\u5931\u8d25,\u6570\u636e\u7ed3\u6784\u4fe1\u606f\u4e0d\u5b8c\u6574,\u6570\u636e\u7ed3\u6784\u4fe1\u606f:%s";
    private static final String ERROR_STRUCTURE_MSG = "\u5bfc\u51fa\u5931\u8d25,\u6570\u636e\u7ed3\u6784\u4fe1\u606f\u4e0d\u5b8c\u6574:itemType = null";
    @Resource
    private IEaiCanvasInfoResourcesService eaiCanvasInfoResourcesService;
    private static final Pattern pattern = Pattern.compile("\"wsdlId\":\"[0-9]{18}\"");

    public EaiCommonResourcesDto getDumpResources(SysApplication sysApplication, String appVersion, String args) {
        EaiApiResourcesDto eaiApiResourcesDto = new EaiApiResourcesDto();
        EaiCommonResourcesDto eaiCommonResourcesDto = new EaiCommonResourcesDto();
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(EaiApiVersion::getApiVersion, this.versions(appVersion))).eq(EaiApiVersion::getApplicationCode, (Object)sysApplication.getAppCode());
        List selectedApiVersionList = this.apiVersionService.list((Wrapper)queryWrapper);
        if (HussarUtils.isEmpty((Object)selectedApiVersionList)) {
            return eaiCommonResourcesDto;
        }
        List<EaiApiVersion> apiVersionList = this.getLatestApiVersions(selectedApiVersionList, sysApplication.getAppCode());
        if (HussarUtils.isEmpty(apiVersionList)) {
            return eaiCommonResourcesDto;
        }
        List<StructureVersion> structureVersions = this.getFromApiInfo(apiVersionList, eaiApiResourcesDto);
        eaiCommonResourcesDto.setStructureList(structureVersions);
        List classifyIds = apiVersionList.stream().map(EaiApiVersion::getClassificId).collect(Collectors.toList());
        ArrayList<Object> cId = new ArrayList<Object>();
        if (HussarUtils.isNotEmpty(classifyIds)) {
            for (Object classifyId : classifyIds) {
                if (classifyId == null || cId.contains(classifyId)) continue;
                cId.add(classifyId);
            }
        }
        if (HussarUtils.isNotEmpty(cId)) {
            List classifications = this.eaiApiClassificationVersionService.listByIds(cId);
            eaiApiResourcesDto.setClassificationList(classifications);
        }
        eaiApiResourcesDto.setApiVersionList(apiVersionList);
        List<List<EaiApiVersion>> apiVersions = this.getPageList(apiVersionList);
        for (List list : apiVersions) {
            try {
                EaiApiResourcesDto future = this.hussarEaiMigrationTaskManager.getExecutorService().submit(new OtherResourcesCallAble(list)).get();
                if (!HussarUtils.isNotEmpty((Object)future)) continue;
                this.addResources(eaiApiResourcesDto, future);
            }
            catch (Exception e) {
                logger.error(ERROR_MSG, (Throwable)e);
                throw new BaseException(ERROR_MSG, (Throwable)e);
            }
        }
        eaiCommonResourcesDto.setWsdlList(eaiApiResourcesDto.getWsdlList());
        if (HussarUtils.isNotEmpty((Object)eaiCommonResourcesDto.getStructureList())) {
            if (HussarUtils.isNotEmpty((Object)eaiApiResourcesDto.getStructureList())) {
                eaiCommonResourcesDto.getStructureList().addAll(eaiApiResourcesDto.getStructureList());
            }
        } else {
            eaiCommonResourcesDto.setStructureList(eaiApiResourcesDto.getStructureList());
        }
        eaiCommonResourcesDto.setCommonLogicList(eaiApiResourcesDto.getCommonLogicList());
        eaiCommonResourcesDto.setConnectionList(eaiApiResourcesDto.getConnectionList());
        eaiCommonResourcesDto.setConstantList(eaiApiResourcesDto.getConstantList());
        ArrayList<EaiApiResourcesDto> eaiApiResourcesDtos = new ArrayList<EaiApiResourcesDto>(1);
        eaiApiResourcesDtos.add(eaiApiResourcesDto);
        eaiCommonResourcesDto.setResult(eaiApiResourcesDtos);
        return eaiCommonResourcesDto;
    }

    public MigrationResultDto<EaiApiResourcesDto> replaceIdMaps(List<EaiApiResourcesDto> resultList, EaiCommonResourcesResultDto eaiCommonResourcesResultDto) {
        MigrationResultDto resultDto = new MigrationResultDto();
        if (HussarUtils.isEmpty(resultList)) {
            resultDto.setTotal(0);
            resultDto.setResult(Collections.emptyList());
            return resultDto;
        }
        List result = JSON.parseArray((String)JSON.toJSONString(resultList), EaiApiResourcesDto.class);
        this.replaceIds(result, eaiCommonResourcesResultDto);
        resultDto.setResult(result);
        resultDto.setTotal(this.getCountNum(result));
        return resultDto;
    }

    private List<EaiApiVersion> getLatestApiVersions(List<EaiApiVersion> apiVersions, String appCode) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiResourcesInfo::getApplicationCode, (Object)appCode)).eq(EaiResourcesInfo::getDeleteState, (Object)"0");
        List eaiResourcesInfos = this.eaiResourcesInfoService.list((Wrapper)queryWrapper);
        if (HussarUtils.isEmpty((Object)eaiResourcesInfos)) {
            return Collections.emptyList();
        }
        List versionIds = eaiResourcesInfos.stream().map(EaiResourcesInfo::getResourceVersionId).collect(Collectors.toList());
        ArrayList<EaiApiVersion> apiVersionList = new ArrayList<EaiApiVersion>(apiVersions.size());
        for (EaiApiVersion apiVersion : apiVersions) {
            if (!versionIds.contains(apiVersion.getApiVersionId())) continue;
            apiVersionList.add(apiVersion);
        }
        return apiVersionList;
    }

    private List<StructureVersion> getFromApiInfo(List<EaiApiVersion> apiVersionList, EaiApiResourcesDto eaiApiResourcesDto) {
        List structureVersions;
        HashMap<String, ArrayList<Long>> map = new HashMap<String, ArrayList<Long>>();
        List<Object> id = new ArrayList();
        for (EaiApiVersion apiVersion : apiVersionList) {
            String outParams;
            ArrayList<Long> ids = new ArrayList<Long>();
            String inParams = apiVersion.getInParams();
            if (HussarUtils.isNotEmpty((Object)inParams)) {
                List paramsItems = JSON.parseArray((String)inParams, EaiParamsItems.class);
                this.getStructureVersion(paramsItems, ids);
            }
            if (HussarUtils.isNotEmpty((Object)(outParams = apiVersion.getOutParams()))) {
                List paramsItems = JSON.parseArray((String)outParams, EaiParamsItems.class);
                this.getStructureVersion(paramsItems, ids);
            }
            if (!HussarUtils.isNotEmpty(ids)) continue;
            id.addAll(ids);
            map.put(apiVersion.getApiCode(), ids);
        }
        if (HussarUtils.isNotEmpty(map) && HussarUtils.isNotEmpty((Object)(structureVersions = this.structureVersionService.listByIds(id = id.stream().distinct().collect(Collectors.toList()))))) {
            Map<Long, String> idCodeMap = structureVersions.stream().collect(Collectors.toMap(StructureVersion::getId, StructureVersion::getStructureCode));
            List codeMaps = eaiApiResourcesDto.getApiResourceCodeMaps();
            Map<Object, Object> resourceCodeMapsMap = new HashMap();
            if (HussarUtils.isNotEmpty((Object)codeMaps)) {
                resourceCodeMapsMap = codeMaps.stream().collect(Collectors.toMap(ApiResourceCodeMaps::getApiCode, Function.identity()));
            }
            for (Map.Entry entry : map.entrySet()) {
                for (Map.Entry<Long, String> idCode : idCodeMap.entrySet()) {
                    ArrayList<String> codes;
                    if (!HussarUtils.isNotEmpty(entry.getValue()) || !((List)entry.getValue()).contains(idCode.getKey())) continue;
                    ApiResourceCodeMaps apiResourceCodeMaps = null;
                    if (resourceCodeMapsMap.containsKey(entry.getKey())) {
                        apiResourceCodeMaps = (ApiResourceCodeMaps)resourceCodeMapsMap.get(entry.getKey());
                    } else {
                        apiResourceCodeMaps = new ApiResourceCodeMaps();
                        apiResourceCodeMaps.setApiCode((String)entry.getKey());
                    }
                    if (HussarUtils.isNotEmpty((Object)apiResourceCodeMaps.getTypeCodes()) && HussarUtils.isNotEmpty(apiResourceCodeMaps.getTypeCodes().get(EaiResourcesEnum.STRUCTURE.getType()))) {
                        ((List)apiResourceCodeMaps.getTypeCodes().get(EaiResourcesEnum.STRUCTURE.getType())).add(idCode.getValue());
                    } else if (HussarUtils.isEmpty((Object)apiResourceCodeMaps.getTypeCodes())) {
                        codes = new ArrayList<String>();
                        codes.add(idCode.getValue());
                        HashMap<String, ArrayList<String>> map1 = new HashMap<String, ArrayList<String>>();
                        map1.put(EaiResourcesEnum.STRUCTURE.getType(), codes);
                        apiResourceCodeMaps.setTypeCodes(map1);
                    } else {
                        codes = new ArrayList();
                        codes.add(idCode.getValue());
                        apiResourceCodeMaps.getTypeCodes().put(EaiResourcesEnum.STRUCTURE.getType(), codes);
                    }
                    resourceCodeMapsMap.put(entry.getKey(), apiResourceCodeMaps);
                }
            }
            eaiApiResourcesDto.setApiResourceCodeMaps(new ArrayList<Object>(resourceCodeMapsMap.values()));
            return structureVersions;
        }
        return Collections.emptyList();
    }

    private List<Long> getStructureVersion(List<EaiParamsItems> paramsItems, List<Long> ids) {
        for (EaiParamsItems paramsItem : paramsItems) {
            if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == paramsItem.getType().intValue()) {
                ids.add(Long.valueOf(paramsItem.getQuoteStructureId()));
                continue;
            }
            if (EaiDataType.DATA_TYPE_LIST.getType() != paramsItem.getType().intValue()) continue;
            if (HussarUtils.isEmpty((Object)paramsItem.getItemType())) {
                logger.error(String.format(ERROR_LOG_STRUCTURE_MSG, "itemType\u4e3anull" + JSON.toJSONString(paramsItems)));
                throw new BaseException(ERROR_STRUCTURE_MSG);
            }
            if (EaiDataType.DATA_TYPE_STRUCTURE.getType() != paramsItem.getItemType().intValue()) continue;
            ids.add(Long.valueOf(((EaiParamsItems)paramsItem.getItems().get(0)).getQuoteStructureId()));
        }
        return ids;
    }

    private void replaceIds(List<EaiApiResourcesDto> result, EaiCommonResourcesResultDto eaiCommonResourcesResultDto) {
        HashMap<Long, Long> structureIdMap = eaiCommonResourcesResultDto.getStructureIdMap() == null ? new HashMap() : eaiCommonResourcesResultDto.getStructureIdMap();
        for (EaiApiResourcesDto resourcesDto : result) {
            if (HussarUtils.isNotEmpty(structureIdMap)) {
                List apiVersions = resourcesDto.getApiVersionList();
                this.replaceApiVersion(apiVersions, structureIdMap);
                resourcesDto.setApiVersionList(apiVersions);
                List editApis = resourcesDto.getEditApiList();
                this.replaceEditApi(editApis, structureIdMap);
            }
            this.replaceLogic(resourcesDto.getCommonLogicList(), structureIdMap, eaiCommonResourcesResultDto);
            List<CanvasInfo> canvasInfos = this.replaceCanvas(resourcesDto.getCanvasInfoList(), eaiCommonResourcesResultDto);
            resourcesDto.setCanvasInfoList(canvasInfos);
            Map extras = resourcesDto.getExtraList();
            if (!HussarUtils.isNotEmpty((Object)extras)) continue;
            HashMap resultMap = new HashMap();
            for (Map.Entry entry : extras.entrySet()) {
                List val = EaiApiExtraResourcesFactory.getByModel((String)entry.getKey()).replaceIds((List)entry.getValue(), eaiCommonResourcesResultDto);
                resultMap.put(entry.getKey(), val);
            }
            resourcesDto.setExtraList(resultMap);
        }
    }

    private void replaceLogic(List<EaiCommonLogicDto> commonLogicDtos, Map<Long, Long> structureIdMap, EaiCommonResourcesResultDto commonResourcesResultDto) {
        if (HussarUtils.isEmpty(commonLogicDtos)) {
            return;
        }
        for (EaiCommonLogicDto commonLogicDto : commonLogicDtos) {
            LogicVersion logicVersion = commonLogicDto.getLogicVersion();
            String in = this.replaceIds(logicVersion.getInParams(), structureIdMap);
            String out = this.replaceIds(logicVersion.getOutParams(), structureIdMap);
            logicVersion.setInParams(in);
            logicVersion.setOutParams(out);
            commonLogicDto.setLogicVersion(logicVersion);
            if (!HussarUtils.isNotEmpty((Object)commonLogicDto.getCanvasInfo())) continue;
            List<CanvasInfo> canvasInfos = new ArrayList<CanvasInfo>();
            canvasInfos.add(commonLogicDto.getCanvasInfo());
            canvasInfos = this.replaceCanvas(canvasInfos, commonResourcesResultDto);
            commonLogicDto.setCanvasInfo(canvasInfos.get(0));
        }
    }

    private List<CanvasInfo> replaceCanvas(List<CanvasInfo> canvasInfoList, EaiCommonResourcesResultDto commonResourcesResultDto) {
        if (HussarUtils.isNotEmpty(canvasInfoList)) {
            ArrayList<CanvasInfo> list = new ArrayList<CanvasInfo>(canvasInfoList.size());
            for (CanvasInfo canvasInfo : canvasInfoList) {
                canvasInfo = this.eaiCanvasInfoResourcesService.replaceIds(canvasInfo, commonResourcesResultDto);
                list.add(canvasInfo);
            }
            return list;
        }
        return Collections.emptyList();
    }

    private void replaceApiVersion(List<EaiApiVersion> apiVersions, Map<Long, Long> structureIdMap) {
        for (EaiApiVersion apiVersion : apiVersions) {
            if (HussarUtils.isNotEmpty((Object)apiVersion.getInParams())) {
                apiVersion.setInParams(this.replaceIds(apiVersion.getInParams(), structureIdMap));
            }
            if (!HussarUtils.isNotEmpty((Object)apiVersion.getOutParams())) continue;
            apiVersion.setOutParams(this.replaceIds(apiVersion.getOutParams(), structureIdMap));
        }
    }

    private void replaceEditApi(List<EditApi> editApis, Map<Long, Long> structureIdMap) {
        for (EditApi editApi : editApis) {
            if (HussarUtils.isNotEmpty((Object)editApi.getInParams())) {
                editApi.setInParams(this.replaceIds(editApi.getInParams(), structureIdMap));
            }
            if (!HussarUtils.isNotEmpty((Object)editApi.getOutParams())) continue;
            editApi.setOutParams(this.replaceIds(editApi.getOutParams(), structureIdMap));
        }
    }

    private String replaceIds(String val, Map<Long, Long> map) {
        if (HussarUtils.isNotEmpty(map) && HussarUtils.isNotEmpty((Object)val)) {
            for (Map.Entry<Long, Long> entry : map.entrySet()) {
                val = val.replace(this.getStrId(entry.getKey()), this.getStrId(entry.getValue()));
            }
        }
        return val;
    }

    private String getStrId(Long id) {
        StringBuilder sb = new StringBuilder().append("\"").append(id).append("\"");
        return sb.toString();
    }

    private int getCountNum(List<EaiApiResourcesDto> result) {
        int i = 0;
        if (HussarUtils.isEmpty(result)) {
            return 0;
        }
        for (EaiApiResourcesDto resourcesDto : result) {
            i += this.countNum(resourcesDto);
        }
        return i;
    }

    protected EaiApiResourcesDto otherResources(List<EaiApiVersion> apiVersions) {
        EaiApiResourcesDto eaiApiResourcesDto = new EaiApiResourcesDto();
        List ids = apiVersions.stream().map(EaiApiVersion::getApiVersionId).collect(Collectors.toList());
        Map<Long, String> idCodeMap = apiVersions.stream().collect(Collectors.toMap(EaiApiVersion::getApiVersionId, EaiApiVersion::getApiCode));
        HashMap<Long, Long> canvaApiIdMap = new HashMap<Long, Long>();
        LambdaQueryWrapper editApiQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(EditApi::getApiId, ids);
        List editApis = this.eaiEditApiService.list((Wrapper)editApiQueryWrapper);
        eaiApiResourcesDto.setEditApiList(editApis);
        if (HussarUtils.isNotEmpty((Object)editApis)) {
            ArrayList<Long> canvasIds = new ArrayList<Long>();
            for (EditApi editApi : editApis) {
                if (!HussarUtils.isNotEmpty((Object)editApi.getCanvasId())) continue;
                canvasIds.add(editApi.getCanvasId());
                canvaApiIdMap.put(editApi.getCanvasId(), editApi.getApiId());
            }
            if (HussarUtils.isNotEmpty(canvasIds)) {
                List canvasInfoList = this.canvasInfoService.listByIds(canvasIds);
                eaiApiResourcesDto.setCanvasInfoList(canvasInfoList);
                this.canvasResources(idCodeMap, canvaApiIdMap, canvasInfoList, eaiApiResourcesDto);
            }
        } else {
            logger.debug("\u5bfc\u51fa\u63a5\u53e3\u4fe1\u606f\u672a\u5173\u8054editApi \u63a5\u53e3\u8be6\u7ec6\u4fe1\u606f{}", (Object)(apiVersions != null ? JSON.toJSONString(apiVersions) : "\u65e0\u63a5\u53e3\u4fe1\u606f"));
            throw new BaseException(String.format("\u5bfc\u51fa\u63a5\u53e3\u4fe1\u606f\u672a\u5173\u8054editApi \u63a5\u53e3\u540d\u79f0\u3010%s\u3011", apiVersions != null ? JSON.toJSONString(apiVersions.stream().map(EaiApiVersion::getApiName).collect(Collectors.toList())) : "\u65e0\u63a5\u53e3\u4fe1\u606f"));
        }
        List callSpecificationInfoList = this.apiCallSpecificationInfoService.list((Wrapper)new LambdaQueryWrapper().in(ApiCallSpecificationInfo::getApiId, ids));
        eaiApiResourcesDto.setCallSpecificationInfoList(callSpecificationInfoList);
        Map<String, List<EaiApiVersion>> map = this.getTypeList(apiVersions);
        HashMap<String, List> extrasMap = new HashMap<String, List>();
        for (Map.Entry<String, List<EaiApiVersion>> entry : map.entrySet()) {
            List extras;
            IEaiApiConfigService service = EaiApiExtraResourcesFactory.getByModel(entry.getKey());
            if (!HussarUtils.isNotEmpty((Object)service) || !HussarUtils.isNotEmpty((Object)(extras = service.getExtraList(new ArrayList(entry.getValue()), eaiApiResourcesDto)))) continue;
            if (extrasMap.containsKey(entry.getKey())) {
                ((List)extrasMap.get(entry.getKey())).addAll(extras);
                continue;
            }
            extrasMap.put(entry.getKey(), extras);
        }
        eaiApiResourcesDto.setExtraList(extrasMap);
        return eaiApiResourcesDto;
    }

    private Map<String, List<EaiApiVersion>> getTypeList(List<EaiApiVersion> apiVersions) {
        HashMap<String, List<EaiApiVersion>> map = new HashMap<String, List<EaiApiVersion>>();
        for (EaiApiVersion apiVersion : apiVersions) {
            String str;
            String string = str = HussarUtils.isEmpty((Object)apiVersion.getApiType()) ? "0" : apiVersion.getApiType();
            if (map.containsKey(str)) {
                ((List)map.get(str)).add(apiVersion);
                continue;
            }
            ArrayList<EaiApiVersion> list = new ArrayList<EaiApiVersion>();
            list.add(apiVersion);
            map.put(str, list);
        }
        return map;
    }

    private void canvasResources(Map<Long, String> idCodeMap, Map<Long, Long> canvaApiIdMap, List<CanvasInfo> canvasInfoList, EaiApiResourcesDto eaiApiResourcesDto) {
        if (HussarUtils.isNotEmpty(canvasInfoList)) {
            Map<Long, CanvasInfo> resources = canvasInfoList.stream().collect(Collectors.toMap(CanvasInfo::getId, Function.identity()));
            EaiApiResourcesDto apiResourcesDto = this.getResources(idCodeMap, canvaApiIdMap, resources);
            this.addResources(eaiApiResourcesDto, apiResourcesDto);
        }
    }

    private void addLinkResources(List<EaiApiResourceId> apiResourceIdMaps, EaiApiResourcesDto eaiApiResourcesDto, List<ConnectionVersion> connectionVersions) {
        if (HussarUtils.isNotEmpty(connectionVersions)) {
            Map<Long, String> connIdCodeMap = connectionVersions.stream().collect(Collectors.toMap(ConnectionVersion::getId, ConnectionVersion::getConnectionNameEn));
            this.setTypeCode(apiResourceIdMaps, eaiApiResourcesDto, connIdCodeMap, EaiResourcesEnum.LINK.getType());
            if (HussarUtils.isEmpty((Object)eaiApiResourcesDto.getConnectionList())) {
                eaiApiResourcesDto.setConnectionList(connectionVersions);
            } else {
                eaiApiResourcesDto.getConnectionList().addAll(connectionVersions);
            }
        }
    }

    private void addConstantResources(List<EaiApiResourceId> apiResourceIdMaps, EaiApiResourcesDto eaiApiResourcesDto, List<ConstantVersion> constantVersions) {
        if (HussarUtils.isNotEmpty(constantVersions)) {
            Map<Long, String> constantIdCodeMap = constantVersions.stream().collect(Collectors.toMap(ConstantVersion::getId, ConstantVersion::getConstantNameEn));
            this.setTypeCode(apiResourceIdMaps, eaiApiResourcesDto, constantIdCodeMap, EaiResourcesEnum.CONSTANT.getType());
            if (HussarUtils.isEmpty((Object)eaiApiResourcesDto.getConstantList())) {
                eaiApiResourcesDto.setConstantList(constantVersions);
            } else {
                eaiApiResourcesDto.getConstantList().addAll(constantVersions);
            }
        }
    }

    private void addStructureResources(List<EaiApiResourceId> apiResourceIdMaps, EaiApiResourcesDto eaiApiResourcesDto, List<StructureVersion> structureVersions) {
        if (HussarUtils.isNotEmpty(structureVersions)) {
            Map<Long, String> structureIdCodeMap = structureVersions.stream().collect(Collectors.toMap(StructureVersion::getId, StructureVersion::getStructureCode));
            this.setTypeCode(apiResourceIdMaps, eaiApiResourcesDto, structureIdCodeMap, EaiResourcesEnum.STRUCTURE.getType());
            if (HussarUtils.isEmpty((Object)eaiApiResourcesDto.getStructureList())) {
                eaiApiResourcesDto.setStructureList(structureVersions);
            } else {
                eaiApiResourcesDto.getStructureList().addAll(structureVersions);
            }
        }
    }

    private void addWsdlResources(List<EaiApiResourceId> apiResourceIdMaps, EaiApiResourcesDto eaiApiResourcesDto, List<EaiAppWsdlVersion> wsdlVersions) {
        if (HussarUtils.isNotEmpty(wsdlVersions)) {
            Map<Long, String> wsdlIdCodeMap = wsdlVersions.stream().collect(Collectors.toMap(EaiAppWsdlVersion::getId, EaiAppWsdlVersion::getWsdlPath));
            this.setTypeCode(apiResourceIdMaps, eaiApiResourcesDto, wsdlIdCodeMap, "wsdl");
            if (HussarUtils.isEmpty((Object)eaiApiResourcesDto.getWsdlList())) {
                eaiApiResourcesDto.setWsdlList(wsdlVersions);
            } else {
                eaiApiResourcesDto.getWsdlList().addAll(wsdlVersions);
            }
        }
    }

    private void setTypeCode(List<EaiApiResourceId> apiResourceIdMaps, EaiApiResourcesDto eaiApiResourcesDto, Map<Long, String> resourceIdCodeMap, String type) {
        if (HussarUtils.isEmpty(apiResourceIdMaps)) {
            return;
        }
        List apiResourceCodeMaps = eaiApiResourcesDto.getApiResourceCodeMaps();
        for (EaiApiResourceId apiResourceId : apiResourceIdMaps) {
            for (ApiResourceCodeMaps apiResourceCodeMap : apiResourceCodeMaps) {
                if (!apiResourceId.getApiCode().equals(apiResourceCodeMap.getApiCode())) continue;
                Map<String, List<String>> codes = this.setTypeCode(apiResourceId.getTypeIds(), apiResourceCodeMap.getTypeCodes(), resourceIdCodeMap, type);
                apiResourceCodeMap.setTypeCodes(codes);
            }
        }
        eaiApiResourcesDto.setApiResourceCodeMaps(apiResourceCodeMaps);
    }

    private Map<String, List<String>> setTypeCode(Map<String, List<Long>> apiResourceIdMaps, Map<String, List<String>> eaiApiResourcesDto, Map<Long, String> resourceIdCodeMap, String type) {
        if (HussarUtils.isEmpty(apiResourceIdMaps) || HussarUtils.isEmpty(resourceIdCodeMap)) {
            return eaiApiResourcesDto;
        }
        List<Long> ids = apiResourceIdMaps.get(type);
        List codes = resourceIdCodeMap.entrySet().stream().filter(f -> ids.contains(f.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(eaiApiResourcesDto)) {
            List<String> oldCodes = eaiApiResourcesDto.get(type);
            if (HussarUtils.isNotEmpty(oldCodes)) {
                oldCodes.addAll(codes);
                oldCodes = oldCodes.stream().distinct().collect(Collectors.toList());
            } else {
                oldCodes = codes;
            }
            eaiApiResourcesDto.put(type, oldCodes);
        } else {
            eaiApiResourcesDto = new HashMap<String, List<String>>();
            eaiApiResourcesDto.put(type, codes);
        }
        return eaiApiResourcesDto;
    }

    private void addLogicResources(List<EaiApiResourceId> apiResourceIdMaps, EaiApiResourcesDto eaiApiResourcesDto, List<LogicVersion> logicVersions) {
        if (HussarUtils.isNotEmpty(logicVersions)) {
            Map<Long, String> logicIdCodeMap = logicVersions.stream().collect(Collectors.toMap(LogicVersion::getId, LogicVersion::getLogicCode));
            this.setTypeCode(apiResourceIdMaps, eaiApiResourcesDto, logicIdCodeMap, EaiResourcesEnum.LOGIC.getType());
            List canvasIds = logicVersions.stream().map(LogicVersion::getCanvasId).collect(Collectors.toList());
            List canvasInfos = this.canvasInfoService.listByIds(canvasIds);
            Map map = canvasInfos.stream().collect(Collectors.toMap(CanvasInfo::getId, Function.identity()));
            ArrayList<EaiCommonLogicDto> list = new ArrayList<EaiCommonLogicDto>();
            for (LogicVersion logicVersion : logicVersions) {
                EaiCommonLogicDto commonLogicDto = new EaiCommonLogicDto();
                commonLogicDto.setLogicVersion(logicVersion);
                commonLogicDto.setCanvasInfo((CanvasInfo)map.get(logicVersion.getCanvasId()));
                list.add(commonLogicDto);
            }
            if (HussarUtils.isEmpty((Object)eaiApiResourcesDto.getCommonLogicList())) {
                eaiApiResourcesDto.setCommonLogicList(list);
            } else {
                eaiApiResourcesDto.getCommonLogicList().addAll(list);
            }
        }
    }

    private Long getId(String id, String type) {
        if (id.startsWith(type) && !(id = id.substring(type.length() + 1)).startsWith("open")) {
            return Long.valueOf(id);
        }
        return null;
    }

    private List<List<EaiApiVersion>> getPageList(List<EaiApiVersion> apiVersions) {
        ArrayList<List<EaiApiVersion>> list = new ArrayList<List<EaiApiVersion>>();
        int pageSize = this.properties.getDefaultApiSize();
        if (apiVersions == null || apiVersions.isEmpty()) {
            return list;
        }
        for (int i = 0; i < apiVersions.size(); i += pageSize) {
            int end = Math.min(i + pageSize, apiVersions.size());
            list.add(apiVersions.subList(i, end));
        }
        return list;
    }

    private Integer getV(String version) {
        return Integer.valueOf(version.substring(1));
    }

    private List<String> versions(String version) {
        Integer v = this.getV(version);
        ArrayList<String> list = new ArrayList<String>(v);
        while (v > 0) {
            list.add(String.format("v%s", v));
            Integer n = v;
            Integer n2 = v = Integer.valueOf(v - 1);
        }
        return list;
    }

    private void addResources(EaiApiResourcesDto eaiApiResourcesDto, EaiApiResourcesDto future) {
        if (HussarUtils.isNotEmpty((Object)future.getEditApiList())) {
            if (HussarUtils.isEmpty((Object)eaiApiResourcesDto.getEditApiList())) {
                eaiApiResourcesDto.setEditApiList(future.getEditApiList());
            } else {
                eaiApiResourcesDto.getEditApiList().addAll(future.getEditApiList());
            }
        }
        if (HussarUtils.isNotEmpty((Object)future.getCallSpecificationInfoList())) {
            if (HussarUtils.isEmpty((Object)eaiApiResourcesDto.getCallSpecificationInfoList())) {
                eaiApiResourcesDto.setCallSpecificationInfoList(future.getCallSpecificationInfoList());
            } else {
                eaiApiResourcesDto.getCallSpecificationInfoList().addAll(future.getCallSpecificationInfoList());
            }
        }
        if (HussarUtils.isNotEmpty((Object)future.getCanvasInfoList())) {
            if (HussarUtils.isEmpty((Object)eaiApiResourcesDto.getCanvasInfoList())) {
                eaiApiResourcesDto.setCanvasInfoList(future.getCanvasInfoList());
            } else {
                eaiApiResourcesDto.getCanvasInfoList().addAll(future.getCanvasInfoList());
            }
        }
        if (HussarUtils.isNotEmpty((Object)future.getConnectionList())) {
            if (HussarUtils.isEmpty((Object)eaiApiResourcesDto.getConnectionList())) {
                eaiApiResourcesDto.setConnectionList(future.getConnectionList());
            } else {
                eaiApiResourcesDto.getConnectionList().addAll(future.getConnectionList());
            }
        }
        if (HussarUtils.isNotEmpty((Object)future.getConstantList())) {
            if (HussarUtils.isEmpty((Object)eaiApiResourcesDto.getConstantList())) {
                eaiApiResourcesDto.setConstantList(future.getConstantList());
            } else {
                eaiApiResourcesDto.getConstantList().addAll(future.getConstantList());
            }
        }
        if (HussarUtils.isNotEmpty((Object)future.getStructureList())) {
            if (HussarUtils.isEmpty((Object)eaiApiResourcesDto.getStructureList())) {
                eaiApiResourcesDto.setStructureList(future.getStructureList());
            } else {
                eaiApiResourcesDto.getStructureList().addAll(future.getStructureList());
            }
        }
        if (HussarUtils.isNotEmpty((Object)future.getCommonLogicList())) {
            if (HussarUtils.isEmpty((Object)eaiApiResourcesDto.getCommonLogicList())) {
                eaiApiResourcesDto.setCommonLogicList(future.getCommonLogicList());
            } else {
                eaiApiResourcesDto.getCommonLogicList().addAll(future.getCommonLogicList());
            }
        }
        if (HussarUtils.isNotEmpty((Object)future.getWsdlList())) {
            if (HussarUtils.isEmpty((Object)eaiApiResourcesDto.getWsdlList())) {
                eaiApiResourcesDto.setWsdlList(future.getWsdlList());
            } else {
                eaiApiResourcesDto.getWsdlList().addAll(future.getWsdlList());
            }
        }
        if (HussarUtils.isNotEmpty((Object)future.getExtraList())) {
            if (HussarUtils.isEmpty((Object)eaiApiResourcesDto.getExtraList())) {
                eaiApiResourcesDto.setExtraList(future.getExtraList());
            } else {
                Map extras = eaiApiResourcesDto.getExtraList();
                Map fExtras = future.getExtraList();
                for (Map.Entry entry : extras.entrySet()) {
                    if (!fExtras.containsKey(entry.getKey())) continue;
                    ((List)entry.getValue()).addAll((Collection)fExtras.get(entry.getKey()));
                }
                eaiApiResourcesDto.setExtraList(extras);
            }
        }
        if (HussarUtils.isNotEmpty((Object)future.getApiResourceCodeMaps())) {
            if (HussarUtils.isNotEmpty((Object)eaiApiResourcesDto.getApiResourceCodeMaps())) {
                Map apiCode = eaiApiResourcesDto.getApiResourceCodeMaps().stream().collect(Collectors.toMap(ApiResourceCodeMaps::getApiCode, Function.identity()));
                for (ApiResourceCodeMaps futureMap : future.getApiResourceCodeMaps()) {
                    if (!apiCode.containsKey(futureMap.getApiCode())) continue;
                    ApiResourceCodeMaps old = (ApiResourceCodeMaps)apiCode.get(futureMap.getApiCode());
                    apiCode.put(futureMap.getApiCode(), this.mergeApiResourceCodeMaps(old, futureMap));
                }
                eaiApiResourcesDto.setApiResourceCodeMaps(new ArrayList(apiCode.values()));
            } else {
                eaiApiResourcesDto.setApiResourceCodeMaps(future.getApiResourceCodeMaps());
            }
        }
    }

    private ApiResourceCodeMaps mergeApiResourceCodeMaps(ApiResourceCodeMaps old, ApiResourceCodeMaps futureMap) {
        if (HussarUtils.isNotEmpty((Object)old.getTypeCodes())) {
            Set strSet = old.getTypeCodes().keySet();
            if (HussarUtils.isNotEmpty((Object)futureMap) && HussarUtils.isNotEmpty((Object)futureMap.getTypeCodes())) {
                for (Map.Entry entry : futureMap.getTypeCodes().entrySet()) {
                    if (HussarUtils.isNotEmpty(entry.getValue()) && strSet.contains(entry.getKey())) {
                        List oldCodes = (List)old.getTypeCodes().get(entry.getKey());
                        if (HussarUtils.isNotEmpty((Object)oldCodes)) {
                            oldCodes.addAll((Collection)entry.getValue());
                        } else {
                            oldCodes = (List)entry.getValue();
                        }
                        old.getTypeCodes().put(entry.getKey(), oldCodes);
                        continue;
                    }
                    if (!HussarUtils.isNotEmpty(entry.getValue()) || strSet.contains(entry.getKey())) continue;
                    old.getTypeCodes().put(entry.getKey(), entry.getValue());
                }
            }
        }
        return old;
    }

    private List<Long> getWsdlId(String val) {
        Matcher matcher = pattern.matcher(val);
        ArrayList<Long> list = new ArrayList<Long>(1);
        while (matcher.find()) {
            String result = matcher.group();
            String[] str = result.split(":");
            String strId = str[1].replace("\"", "");
            if (list.contains(Long.valueOf(strId))) continue;
            list.add(Long.valueOf(strId));
        }
        return list;
    }

    private EaiApiResourcesDto getResources(Map<Long, String> idCodeMap, Map<Long, Long> canvaApiIdMap, Map<Long, CanvasInfo> resources) {
        EaiApiResourcesDto dto = new EaiApiResourcesDto();
        if (HussarUtils.isEmpty(resources)) {
            return null;
        }
        ArrayList<Long> structureId = new ArrayList();
        ArrayList<Long> constantId = new ArrayList();
        ArrayList<Long> linkId = new ArrayList();
        ArrayList<Long> logicId = new ArrayList();
        List<Object> wsdlIds = new ArrayList(1);
        ArrayList<ApiResourceCodeMaps> apiResourceCodeMaps = new ArrayList<ApiResourceCodeMaps>();
        ArrayList<EaiApiResourceId> apiResourceIdMaps = new ArrayList<EaiApiResourceId>();
        for (Map.Entry<Long, CanvasInfo> canvsInfo : resources.entrySet()) {
            String resource = canvsInfo.getValue().getCanvasResources();
            EaiApiResourceId apiResourceId = null;
            if (canvaApiIdMap.containsKey(canvsInfo.getKey())) {
                Long apiId = canvaApiIdMap.get(canvsInfo.getKey());
                String apiCode = idCodeMap.get(apiId);
                ApiResourceCodeMaps apiResourceCode = new ApiResourceCodeMaps();
                apiResourceCode.setApiCode(apiCode);
                apiResourceCodeMaps.add(apiResourceCode);
                apiResourceId = new EaiApiResourceId();
                apiResourceId.setApiCode(apiCode);
            }
            this.getResourcesId(apiResourceId, resource, structureId, constantId, linkId, logicId);
            if (!HussarUtils.isNotEmpty(apiResourceId)) continue;
            String content = canvsInfo.getValue().getCanvasContent();
            wsdlIds = this.getWsdlId(content);
            if (HussarUtils.isNotEmpty((Object)apiResourceId.getTypeIds())) {
                apiResourceId.getTypeIds().put("wsdl", wsdlIds);
            } else {
                HashMap map = new HashMap();
                map.put("wsdl", wsdlIds);
                apiResourceId.setTypeIds(map);
            }
            apiResourceIdMaps.add(apiResourceId);
        }
        dto.setApiResourceCodeMaps(apiResourceCodeMaps);
        if (HussarUtils.isNotEmpty(structureId)) {
            structureId = structureId.stream().distinct().collect(Collectors.toList());
            List structureVersions = this.structureVersionService.listByIds(structureId);
            this.addStructureResources(apiResourceIdMaps, dto, structureVersions);
        }
        if (HussarUtils.isNotEmpty(linkId)) {
            linkId = linkId.stream().distinct().collect(Collectors.toList());
            List connectionVersions = this.connectionVersionService.listByIds(linkId);
            this.addLinkResources(apiResourceIdMaps, dto, connectionVersions);
        }
        if (HussarUtils.isNotEmpty(constantId)) {
            constantId = constantId.stream().distinct().collect(Collectors.toList());
            List constantVersions = this.constantVersionService.listByIds(constantId);
            this.addConstantResources(apiResourceIdMaps, dto, constantVersions);
        }
        if (HussarUtils.isNotEmpty(logicId)) {
            logicId = logicId.stream().distinct().collect(Collectors.toList());
            List logicVersions = this.logicVersionService.listByIds(logicId);
            this.addLogicResources(apiResourceIdMaps, dto, logicVersions);
        }
        if (HussarUtils.isNotEmpty(wsdlIds)) {
            wsdlIds = wsdlIds.stream().distinct().collect(Collectors.toList());
            List wsdlVersions = this.wsdlVersionService.listByIds(wsdlIds);
            this.addWsdlResources(apiResourceIdMaps, dto, wsdlVersions);
        }
        return dto;
    }

    private void getResourcesId(EaiApiResourceId apiResourceId, String resource, List<Long> structureId, List<Long> constantId, List<Long> linkId, List<Long> logicId) {
        Map mapList = (Map)JSON.parseObject((String)resource, (Type)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        ArrayList<Long> tempStructureId = null;
        ArrayList<Long> tempConstantId = null;
        ArrayList<Long> tempLinkId = null;
        ArrayList<Long> tempLogicId = null;
        if (HussarUtils.isNotEmpty((Object)apiResourceId)) {
            tempStructureId = new ArrayList<Long>();
            tempConstantId = new ArrayList<Long>();
            tempLinkId = new ArrayList<Long>();
            tempLogicId = new ArrayList<Long>();
        }
        for (String key : mapList.keySet()) {
            Long id = this.getId(key, EaiResourcesEnum.STRUCTURE.getType());
            if (id != null) {
                structureId.add(id);
                if (tempStructureId == null) continue;
                tempStructureId.add(id);
                continue;
            }
            id = this.getId(key, EaiResourcesEnum.LINK.getType());
            if (id != null) {
                linkId.add(id);
                if (tempLinkId == null) continue;
                tempLinkId.add(id);
                continue;
            }
            id = this.getId(key, EaiResourcesEnum.CONSTANT.getType());
            if (id != null) {
                constantId.add(id);
                if (tempConstantId == null) continue;
                tempConstantId.add(id);
                continue;
            }
            id = this.getId(key, EaiResourcesEnum.LOGIC.getType());
            if (id == null) continue;
            logicId.add(id);
            if (tempLogicId == null) continue;
            tempLogicId.add(id);
        }
        if (HussarUtils.isNotEmpty((Object)apiResourceId)) {
            HashMap map = new HashMap();
            map.put(EaiResourcesEnum.STRUCTURE.getType(), tempStructureId);
            map.put(EaiResourcesEnum.CONSTANT.getType(), tempConstantId);
            map.put(EaiResourcesEnum.LINK.getType(), tempLinkId);
            map.put(EaiResourcesEnum.LOGIC.getType(), tempLogicId);
            apiResourceId.setTypeIds(map);
        }
    }

    private int countNum(EaiApiResourcesDto resourcesDto) {
        int i = 0;
        if (HussarUtils.isNotEmpty((Object)resourcesDto.getApiVersionList())) {
            i += resourcesDto.getApiVersionList().size();
        }
        if (HussarUtils.isNotEmpty((Object)resourcesDto.getEditApiList())) {
            i += resourcesDto.getEditApiList().size();
        }
        if (HussarUtils.isNotEmpty((Object)resourcesDto.getCanvasInfoList())) {
            i += resourcesDto.getCanvasInfoList().size();
        }
        if (HussarUtils.isNotEmpty((Object)resourcesDto.getCallSpecificationInfoList())) {
            i += resourcesDto.getCallSpecificationInfoList().size();
        }
        if (HussarUtils.isNotEmpty((Object)resourcesDto.getClassificationList())) {
            i += resourcesDto.getClassificationList().size();
        }
        if (HussarUtils.isNotEmpty((Object)resourcesDto.getWsdlList())) {
            i += resourcesDto.getWsdlList().size();
        }
        if (HussarUtils.isNotEmpty((Object)resourcesDto.getStructureList())) {
            i += resourcesDto.getStructureList().size();
        }
        if (HussarUtils.isNotEmpty((Object)resourcesDto.getConstantList())) {
            i += resourcesDto.getConstantList().size();
        }
        if (HussarUtils.isNotEmpty((Object)resourcesDto.getConnectionList())) {
            i += resourcesDto.getConnectionList().size();
        }
        if (HussarUtils.isNotEmpty((Object)resourcesDto.getCommonLogicList())) {
            i += resourcesDto.getCommonLogicList().size();
        }
        if (HussarUtils.isNotEmpty((Object)resourcesDto.getExtraList())) {
            for (List val : resourcesDto.getExtraList().values()) {
                i += val.size();
            }
        }
        return i;
    }

    public EaiServiceManiFest resourcesMetadata() {
        return MigrationUtil.createResourcesManiFest((ApplicationMigrationExportEnum)ApplicationMigrationExportEnum.APP_API_INFO_FILE, (IEaiResourcesService)this, (EaiServiceTypeEnum)EaiServiceTypeEnum.API);
    }

    private class OtherResourcesCallAble
    implements Callable<EaiApiResourcesDto> {
        List<EaiApiVersion> apiVersions;

        public OtherResourcesCallAble(List<EaiApiVersion> apiVersions) {
            this.apiVersions = apiVersions;
        }

        @Override
        public EaiApiResourcesDto call() throws Exception {
            return EaiApiInfoServiceImpl.this.otherResources(this.apiVersions);
        }
    }
}

