/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.plugins;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.migration.business.dump.vo.AppExternalResourceMigrationDumpVo;
import com.jxdinfo.hussar.eai.migration.business.migration.preview.app.service.IEaiMigrationAppDumpService;
import com.jxdinfo.hussar.eai.migration.business.service.IEaiGetAppCodeNameService;
import com.jxdinfo.hussar.eai.migration.business.util.EaiMigrationUtil;
import com.jxdinfo.hussar.eai.migration.dto.EaiCommonResourcesDto;
import com.jxdinfo.hussar.eai.migration.dto.EaiCommonResourcesResultDto;
import com.jxdinfo.hussar.eai.migration.dump.dto.AppMigrationDto;
import com.jxdinfo.hussar.eai.migration.dump.dto.EaiMigrationLoadDto;
import com.jxdinfo.hussar.eai.migration.enums.ApplicationMigrationExportEnum;
import com.jxdinfo.hussar.eai.migration.holder.EaiServiceHolder;
import com.jxdinfo.hussar.eai.migration.manifest.EaiServiceManiFest;
import com.jxdinfo.hussar.eai.migration.plugin.context.MigrationDumpContext;
import com.jxdinfo.hussar.eai.migration.plugin.context.MigrationLoadContext;
import com.jxdinfo.hussar.eai.migration.plugin.vo.MigrationDumpItemVo;
import com.jxdinfo.hussar.eai.migration.plugin.vo.MigrationLoadItemVo;
import com.jxdinfo.hussar.eai.migration.plugin.vo.MigrationPreloadItemVo;
import com.jxdinfo.hussar.eai.migration.resources.service.IEaiCommonResourcesService;
import com.jxdinfo.hussar.eai.migration.resources.service.MigrationResultDto;
import com.jxdinfo.hussar.eai.migration.util.EaiImportResourceIdCodeUtil;
import com.jxdinfo.hussar.eai.migration.util.MigrationCacheUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class EaiAppCommonMigrationPlugin<T extends AppMigrationDto> {
    @Autowired
    private List<IEaiCommonResourcesService> eaiCommonResourcesServices;
    @Autowired
    private ISysApplicationService sysApplicationService;
    @Autowired
    private IEaiMigrationAppDumpService eaiMigrationAppDumpService;
    @Autowired
    private IEaiGetAppCodeNameService eaiGetAppCodeNameService;

    public MigrationDumpItemVo<Object> dumpAppTemplate(MigrationDumpContext context, List<EaiServiceManiFest> serviceManiFests, AppMigrationDto dumpDto, EaiCommonResourcesResultDto eaiCommonResourcesResultDto) {
        return this.dumpTemplate(context, serviceManiFests, dumpDto, eaiCommonResourcesResultDto, true);
    }

    public MigrationDumpItemVo<Object> dumpTemplate(MigrationDumpContext context, List<EaiServiceManiFest> serviceManiFests, AppMigrationDto dumpDto, EaiCommonResourcesResultDto eaiCommonResourcesResultDto) {
        return this.dumpTemplate(context, serviceManiFests, dumpDto, eaiCommonResourcesResultDto, false);
    }

    public MigrationDumpItemVo<Object> dumpTemplate(MigrationDumpContext context, List<EaiServiceManiFest> serviceManiFests, AppMigrationDto dumpDto, EaiCommonResourcesResultDto eaiCommonResourcesResultDto, Boolean isApp) {
        long total = 0L;
        if (HussarUtils.isEmpty(serviceManiFests)) {
            return MigrationDumpItemVo.success((Long)total, Collections.emptyList());
        }
        if (ToolUtil.isEmpty((Object)dumpDto) || ToolUtil.isEmpty((Object)dumpDto.getAppCode())) {
            return MigrationDumpItemVo.success((Long)total, Collections.emptyList());
        }
        String appCode = dumpDto.getAppCode();
        String appVersion = dumpDto.getAppVersion();
        ArrayList dumpList = new ArrayList();
        String appCacheKey = MigrationCacheUtil.getDumpAppCacheKey((String)appCode, (String)appVersion);
        SysApplication application = HussarCacheUtil.containKey((String)"hussar:eai:migration:dump", (Object)appCacheKey) ? (SysApplication)HussarCacheUtil.get((String)"hussar:eai:migration:dump", (Object)appCacheKey) : (SysApplication)this.sysApplicationService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysApplication::getAppCode, (Object)appCode));
        if (HussarUtils.isEmpty((Object)application)) {
            return MigrationDumpItemVo.success((Long)total, Collections.emptyList());
        }
        if (isApp.booleanValue()) {
            ++total;
            ArrayList<SysApplication> list = new ArrayList<SysApplication>(1);
            list.add(application);
            context.setPayloadOfJson(ApplicationMigrationExportEnum.APP_CODE_FILE.getFileName(), list);
            context.setAttribute(ApplicationMigrationExportEnum.APP_CODE_FILE.getModel(), (Object)ApplicationMigrationExportEnum.APP_CODE_FILE.getFileName());
            dumpList.addAll(this.eaiMigrationAppDumpService.dumpList(list, null));
        }
        for (EaiServiceManiFest eaiServiceMainFest : serviceManiFests) {
            String resourceCacheKey = MigrationCacheUtil.getDumpResourceCacheKey((String)appCode, (String)appVersion, (String)eaiServiceMainFest.getModel());
            if (HussarCacheUtil.containKey((String)"hussar:eai:migration:dump", (Object)resourceCacheKey)) {
                List real = MigrationCacheUtil.getDumpResourceCache((String)appCode, (String)appVersion, (String)eaiServiceMainFest.getModel());
                context.setPayloadOfJson(eaiServiceMainFest.getFileName(), (Object)real);
                context.setAttribute(eaiServiceMainFest.getModel(), (Object)eaiServiceMainFest.getFileName());
                total += (long)MigrationCacheUtil.getDumpCountCache((String)appCode, (String)appVersion, (String)eaiServiceMainFest.getModel());
                List dump = MigrationCacheUtil.getDumpVoCache((String)appCode, (String)appVersion, (String)eaiServiceMainFest.getModel());
                dumpList.addAll(dump);
                continue;
            }
            EaiCommonResourcesDto result = EaiServiceHolder.getByModel((String)eaiServiceMainFest.getModel()).getDumpResources(application, appVersion, null);
            for (IEaiCommonResourcesService eaiCommonResourcesService : this.eaiCommonResourcesServices) {
                eaiCommonResourcesService.fillExportResourcesDumpInfo(result, eaiCommonResourcesResultDto, appVersion);
            }
            MigrationResultDto real = EaiServiceHolder.getByModel((String)eaiServiceMainFest.getModel()).replaceIdMaps(result.getResult(), eaiCommonResourcesResultDto);
            total += (long)real.getTotal();
            if (EaiCommonResourcesDto.class.isAssignableFrom(eaiServiceMainFest.getClazz())) {
                EaiMigrationUtil.replaceCommonResources(real.getResult(), result);
            }
            context.setPayloadOfJson(eaiServiceMainFest.getFileName(), (Object)real.getResult());
            context.setAttribute(eaiServiceMainFest.getModel(), (Object)eaiServiceMainFest.getFileName());
            List realDumpList = EaiServiceHolder.getViewVoByModel((String)eaiServiceMainFest.getModel()).dumpList(real.getResult(), result);
            if (!HussarUtils.isNotEmpty((Object)realDumpList)) continue;
            dumpList.addAll(realDumpList);
        }
        return MigrationDumpItemVo.success((Long)total, dumpList);
    }

    public List<Object> dumpAppPreviewTemplate(List<EaiServiceManiFest> serviceManiFests, AppMigrationDto dumpDto, EaiCommonResourcesResultDto eaiCommonResourcesResultDto) {
        return this.dumpPreviewTemplate(serviceManiFests, dumpDto, eaiCommonResourcesResultDto, true);
    }

    public List<Object> dumpPreviewTemplate(List<EaiServiceManiFest> serviceManiFests, AppMigrationDto dumpDto, EaiCommonResourcesResultDto eaiCommonResourcesResultDto) {
        return this.dumpPreviewTemplate(serviceManiFests, dumpDto, eaiCommonResourcesResultDto, false);
    }

    public List<Object> dumpPreviewTemplate(List<EaiServiceManiFest> serviceManiFests, AppMigrationDto dumpDto, EaiCommonResourcesResultDto eaiCommonResourcesResultDto, Boolean isApp) {
        String appVersion;
        long total = 0L;
        if (HussarUtils.isEmpty(serviceManiFests)) {
            return Collections.emptyList();
        }
        if (ToolUtil.isEmpty((Object)dumpDto) || ToolUtil.isEmpty((Object)dumpDto.getAppCode())) {
            return Collections.emptyList();
        }
        String appCode = dumpDto.getAppCode();
        String appCacheKey = MigrationCacheUtil.getDumpAppCacheKey((String)appCode, (String)(appVersion = dumpDto.getAppVersion()));
        SysApplication application = HussarCacheUtil.containKey((String)"hussar:eai:migration:dump", (Object)appCacheKey) ? (SysApplication)HussarCacheUtil.get((String)"hussar:eai:migration:dump", (Object)appCacheKey) : (SysApplication)this.sysApplicationService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysApplication::getAppCode, (Object)appCode));
        if (HussarUtils.isEmpty((Object)application)) {
            return Collections.emptyList();
        }
        ArrayList<Object> dumpList = new ArrayList<Object>();
        if (isApp.booleanValue()) {
            ++total;
            ArrayList<SysApplication> list = new ArrayList<SysApplication>(1);
            list.add(application);
            MigrationCacheUtil.saveDumpAppCache((String)appCode, (String)appVersion, (SysApplication)application);
            dumpList.addAll(this.eaiMigrationAppDumpService.dumpList(list, null));
        }
        for (EaiServiceManiFest eaiServiceMainFest : serviceManiFests) {
            EaiCommonResourcesDto result = EaiServiceHolder.getByModel((String)eaiServiceMainFest.getModel()).getDumpResources(application, appVersion, null);
            if (HussarUtils.isEmpty((Object)result)) continue;
            for (IEaiCommonResourcesService eaiCommonResourcesService : this.eaiCommonResourcesServices) {
                eaiCommonResourcesService.fillExportResourcesDumpInfo(result, eaiCommonResourcesResultDto, appVersion);
            }
            MigrationResultDto real = EaiServiceHolder.getByModel((String)eaiServiceMainFest.getModel()).replaceIdMaps(result.getResult(), eaiCommonResourcesResultDto);
            total += (long)real.getTotal();
            if (EaiCommonResourcesDto.class.isAssignableFrom(eaiServiceMainFest.getClazz())) {
                EaiMigrationUtil.replaceCommonResources(real.getResult(), result);
            }
            MigrationCacheUtil.saveDumpResourceCache((String)appCode, (String)appVersion, (String)eaiServiceMainFest.getModel(), (List)real.getResult());
            MigrationCacheUtil.saveDumpCountCache((String)appCode, (String)appVersion, (String)eaiServiceMainFest.getModel(), (int)real.getTotal());
            List realDumpList = EaiServiceHolder.getViewVoByModel((String)eaiServiceMainFest.getModel()).dumpList(real.getResult(), result);
            if (HussarUtils.isNotEmpty((Object)realDumpList)) {
                dumpList.addAll(realDumpList);
            }
            MigrationCacheUtil.saveDumpVoCache((String)appCode, (String)appVersion, (String)eaiServiceMainFest.getModel(), (List)realDumpList);
        }
        return dumpList;
    }

    public MigrationPreloadItemVo<Object> preloadAppTemplate(MigrationLoadContext context, List<EaiServiceManiFest> serviceManiFests, Integer loadType) {
        return this.preloadTemplate(context, serviceManiFests, true, loadType);
    }

    public MigrationPreloadItemVo<Object> preloadTemplate(MigrationLoadContext context, List<EaiServiceManiFest> serviceManiFests, Integer loadType) {
        return this.preloadTemplate(context, serviceManiFests, false, loadType);
    }

    public MigrationPreloadItemVo<Object> preloadTemplate(MigrationLoadContext context, List<EaiServiceManiFest> serviceManiFests, Boolean isApp, Integer loadType) {
        if (HussarUtils.isEmpty(serviceManiFests)) {
            return MigrationPreloadItemVo.success();
        }
        MigrationPreloadItemVo preloadItemVo = new MigrationPreloadItemVo();
        String appCode = context.getAppCode();
        boolean isNewAppCode = 1 == loadType;
        ArrayList result = new ArrayList();
        if (isApp.booleanValue()) {
            List app;
            if (isNewAppCode) {
                appCode = this.createNewAppCode(appCode);
            }
            if (!appCode.equals(context.getAppCode())) {
                context.setAppCode(appCode);
            }
            List<SysApplication> sysApplication = EaiMigrationUtil.getListDataFromJsonFile(context, ApplicationMigrationExportEnum.APP_CODE_FILE.getModel(), ApplicationMigrationExportEnum.APP_CODE_FILE.getFileName(), SysApplication.class);
            if (isNewAppCode) {
                sysApplication.get(0).setAppName(this.createNewAppName(sysApplication.get(0).getAppName()));
            }
            if (HussarUtils.isNotEmpty((Object)(app = this.eaiMigrationAppDumpService.preload(appCode, Boolean.valueOf(isNewAppCode), sysApplication)))) {
                result.addAll(app);
            }
        }
        block0: for (EaiServiceManiFest serviceManiFest : serviceManiFests) {
            List applicationList = EaiMigrationUtil.getListDataFromJsonFile(context, serviceManiFest.getModel(), serviceManiFest.getFileName(), serviceManiFest.getClazz());
            List val = EaiServiceHolder.getViewVoByModel((String)serviceManiFest.getModel()).preload(appCode, Boolean.valueOf(isNewAppCode), applicationList);
            if (!HussarUtils.isNotEmpty((Object)val)) continue;
            result.addAll(val);
            if (!AppExternalResourceMigrationDumpVo.class.isAssignableFrom(val.get(0).getClass())) continue;
            preloadItemVo.setExistFlag(Boolean.valueOf(true));
            for (AppExternalResourceMigrationDumpVo dumpVo : val) {
                if (dumpVo.getExistFlag().booleanValue()) continue;
                preloadItemVo.setExistFlag(Boolean.valueOf(false));
                continue block0;
            }
        }
        return MigrationPreloadItemVo.success(result, (String)appCode);
    }

    public MigrationLoadItemVo<Object> loadAppTemplate(MigrationLoadContext context, List<EaiServiceManiFest> serviceManiFests, List params, EaiCommonResourcesResultDto eaiCommonResourcesResultDto, Integer loadType) {
        return this.loadTemplate(context, serviceManiFests, params, eaiCommonResourcesResultDto, true, loadType);
    }

    public MigrationLoadItemVo<Object> loadTemplate(MigrationLoadContext context, List<EaiServiceManiFest> serviceManiFests, List params, EaiCommonResourcesResultDto eaiCommonResourcesResultDto, Integer loadType) {
        return this.loadTemplate(context, serviceManiFests, params, eaiCommonResourcesResultDto, false, loadType);
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public MigrationLoadItemVo<Object> loadTemplate(MigrationLoadContext context, List<EaiServiceManiFest> serviceManiFests, List params, EaiCommonResourcesResultDto eaiCommonResourcesResultDto, Boolean isApp, Integer loadType) {
        long total = 0L;
        if (HussarUtils.isEmpty(serviceManiFests)) {
            return MigrationLoadItemVo.success((Long)total, Collections.emptyList());
        }
        String appCode = context.getAppCode();
        boolean isNewAppCode = loadType == 1;
        ArrayList result = new ArrayList();
        if (isApp.booleanValue()) {
            if (isNewAppCode) {
                appCode = this.createNewAppCode(appCode);
            }
            if (!appCode.equals(context.getAppCode())) {
                context.setAppCode(appCode);
            }
            List<SysApplication> sysApplication = EaiMigrationUtil.getListDataFromJsonFile(context, ApplicationMigrationExportEnum.APP_CODE_FILE.getModel(), ApplicationMigrationExportEnum.APP_CODE_FILE.getFileName(), SysApplication.class);
            EaiMigrationLoadDto app = this.eaiMigrationAppDumpService.load(appCode, Boolean.valueOf(isNewAppCode), params, sysApplication);
            if (HussarUtils.isNotEmpty((Object)app)) {
                result.addAll(app.getList());
                total += (long)app.getTotal();
            }
        }
        for (EaiServiceManiFest serviceManiFest : serviceManiFests) {
            List<EaiCommonResourcesDto> applicationList = EaiMigrationUtil.getListDataFromJsonFile(context, serviceManiFest.getModel(), serviceManiFest.getFileName(), serviceManiFest.getClazz());
            if (HussarUtils.isEmpty(applicationList)) continue;
            String fappCode = appCode;
            long[] ftotal = new long[1];
            if (EaiCommonResourcesDto.class.isAssignableFrom(serviceManiFest.getClazz())) {
                List<EaiCommonResourcesDto> resourcesList = applicationList;
                resourcesList.forEach(applications -> {
                    EaiMigrationLoadDto val;
                    MigrationResultDto resultDto = EaiImportResourceIdCodeUtil.importResourcesIdCodeMap((String)serviceManiFest.getModel(), (String)fappCode, (Boolean)isNewAppCode, (EaiCommonResourcesDto)applications, (EaiCommonResourcesResultDto)eaiCommonResourcesResultDto);
                    if (HussarUtils.isNotEmpty((Object)resultDto) && HussarUtils.isNotEmpty((Object)(val = EaiServiceHolder.getViewVoByModel((String)serviceManiFest.getModel()).load(fappCode, Boolean.valueOf(isNewAppCode), params, resultDto.getResult()))) && HussarUtils.isNotEmpty((Object)val.getList())) {
                        result.addAll(val.getList());
                        ftotal[0] = ftotal[0] + (long)val.getTotal();
                    }
                });
            } else {
                EaiMigrationLoadDto val = EaiServiceHolder.getViewVoByModel((String)serviceManiFest.getModel()).load(fappCode, Boolean.valueOf(isNewAppCode), params, applicationList);
                if (HussarUtils.isNotEmpty((Object)val) && HussarUtils.isNotEmpty((Object)val.getList())) {
                    result.addAll(val.getList());
                    ftotal[0] = ftotal[0] + (long)val.getTotal();
                }
            }
            total += ftotal[0];
        }
        return MigrationLoadItemVo.success((Long)total, result);
    }

    private String createNewAppName(String name) {
        long count = this.sysApplicationService.count((Wrapper)new LambdaQueryWrapper().eq(SysApplication::getAppName, (Object)name));
        int i = 0;
        String finalName = name;
        while (count > 0L) {
            String newname = String.format("%s_%s", name, ++i);
            count = this.sysApplicationService.count((Wrapper)new LambdaQueryWrapper().eq(SysApplication::getAppName, (Object)newname));
            finalName = newname;
        }
        return finalName;
    }

    private String createNewAppCode(String appCode) {
        return this.eaiGetAppCodeNameService.getAppCode(appCode);
    }
}

