/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.migration.preview.extra.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiInfo;
import com.jxdinfo.hussar.eai.apiinfo.api.model.EditApi;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiApiInfoService;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiEditApiService;
import com.jxdinfo.hussar.eai.apirelease.api.model.EaiApiVersion;
import com.jxdinfo.hussar.eai.apirelease.api.srevice.IApiVersionService;
import com.jxdinfo.hussar.eai.appinfo.api.service.IEaiResourcesInfoService;
import com.jxdinfo.hussar.eai.common.enums.app.EaiResourcesEnum;
import com.jxdinfo.hussar.eai.migration.business.dump.vo.AppExternalResourceMigrationDumpVo;
import com.jxdinfo.hussar.eai.migration.business.enums.AppApiMigrationDataTypeEnum;
import com.jxdinfo.hussar.eai.migration.business.migration.preview.extra.dao.EaiExtraResourceApiMapper;
import com.jxdinfo.hussar.eai.migration.business.migration.preview.extra.service.IEaiMigrationExtraDumpService;
import com.jxdinfo.hussar.eai.migration.dto.EaiCommonResourcesDto;
import com.jxdinfo.hussar.eai.migration.dump.dto.EaiMigrationLoadDto;
import com.jxdinfo.hussar.eai.migration.enums.ApplicationMigrationExportEnum;
import com.jxdinfo.hussar.eai.migration.resources.extra.dto.EaiExtraResourceDto;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CanvasInfo;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICanvasInfoService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.migration.business.migration.preview.extra.service.impl.EaiMigrationExtraDumpServiceImpl")
public class EaiMigrationExtraDumpServiceImpl
implements IEaiMigrationExtraDumpService {
    @Resource
    private IEaiApiInfoService eaiApiInfoService;
    @Resource
    private IEaiEditApiService eaiEditApiService;
    @Resource
    private ICanvasInfoService canvasInfoService;
    @Resource
    private IApiVersionService apiVersionService;
    @Resource
    private IEaiResourcesInfoService eaiResourcesInfoService;
    @Resource
    private EaiExtraResourceApiMapper eaiExtraResourceApiMapper;

    public ApplicationMigrationExportEnum dumpType() {
        return ApplicationMigrationExportEnum.EXTRA_APP_INFO_FILE;
    }

    public List<AppExternalResourceMigrationDumpVo> dumpList(List<EaiExtraResourceDto> result, EaiCommonResourcesDto commonResources) {
        if (HussarUtils.isEmpty(result)) {
            return Collections.emptyList();
        }
        ArrayList<AppExternalResourceMigrationDumpVo> dumpVoList = new ArrayList<AppExternalResourceMigrationDumpVo>();
        result = this.distinctResult(result);
        for (EaiExtraResourceDto eaiExtraResourceDto : result) {
            dumpVoList.add(this.getApiInfoExternalDumpVo(eaiExtraResourceDto));
        }
        return dumpVoList;
    }

    public List<AppExternalResourceMigrationDumpVo> preload(String appCode, Boolean isNewAppCode, List<EaiExtraResourceDto> args) {
        if (HussarUtils.isEmpty(args)) {
            return Collections.emptyList();
        }
        List dtos = JSON.parseArray((String)JSON.toJSONString(args), EaiExtraResourceDto.class);
        ArrayList<AppExternalResourceMigrationDumpVo> dumpList = new ArrayList<AppExternalResourceMigrationDumpVo>();
        ArrayList<String> codeList = new ArrayList<String>();
        for (EaiExtraResourceDto apiResourcesDto : dtos) {
            String code = this.getStr(apiResourcesDto);
            if (codeList.contains(code)) continue;
            codeList.add(code);
            EaiApiVersion apiVersion = this.eaiExtraResourceApiMapper.getExtraApiVersion(apiResourcesDto.getExtraAppCode(), apiResourcesDto.getExtraApiCode());
            if (HussarUtils.isNotEmpty((Object)apiVersion)) {
                dumpList.add(this.getApiInfoExternalDumpVo(apiResourcesDto, true));
                continue;
            }
            dumpList.add(this.getApiInfoExternalDumpVo(apiResourcesDto));
        }
        return dumpList;
    }

    public EaiMigrationLoadDto<AppExternalResourceMigrationDumpVo> load(String appCode, Boolean isNewAppCode, List<AppExternalResourceMigrationDumpVo> userSelectInfos, List<EaiExtraResourceDto> args) {
        EaiMigrationLoadDto result = new EaiMigrationLoadDto();
        if (HussarUtils.isEmpty(args)) {
            result.setTotal(0);
            result.setList(Collections.emptyList());
            return result;
        }
        List dtos = JSON.parseArray((String)JSON.toJSONString(args), EaiExtraResourceDto.class);
        ArrayList<AppExternalResourceMigrationDumpVo> voList = new ArrayList<AppExternalResourceMigrationDumpVo>();
        List userSelectInfo = JSON.parseArray((String)JSON.toJSONString(userSelectInfos), AppExternalResourceMigrationDumpVo.class);
        ArrayList<String> codeList = new ArrayList<String>();
        for (AppExternalResourceMigrationDumpVo userSelect : userSelectInfo) {
            for (EaiExtraResourceDto extraResourceDto : dtos) {
                String code = this.getStr(extraResourceDto);
                if (codeList.contains(code)) continue;
                codeList.add(code);
                if (!extraResourceDto.getCode().equals(userSelect.getApiCode()) || !extraResourceDto.getExtraApiCode().equals(userSelect.getExtraApiCode()) || !extraResourceDto.getExtraAppCode().equals(userSelect.getExtraAppCode())) continue;
                voList.add(userSelect);
                LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ApiInfo::getApplicationCode, (Object)appCode)).eq(ApiInfo::getApiCode, (Object)extraResourceDto.getCode());
                ApiInfo apiInfo = (ApiInfo)this.eaiApiInfoService.getOne((Wrapper)queryWrapper);
                LambdaQueryWrapper editApiQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EditApi::getApiId, (Object)apiInfo.getId());
                EditApi editApi = (EditApi)this.eaiEditApiService.getOne((Wrapper)editApiQueryWrapper);
                CanvasInfo canvasInfo = (CanvasInfo)this.canvasInfoService.getById((Serializable)editApi.getCanvasId());
                String apiCode = canvasInfo.getApiCodes();
                String resource = canvasInfo.getCanvasResources();
                if (userSelect.getExistFlag().booleanValue()) {
                    EaiApiVersion apiVersion = this.eaiExtraResourceApiMapper.getExtraApiVersion(extraResourceDto.getExtraAppCode(), extraResourceDto.getExtraApiCode());
                    apiCode = this.replace(apiCode, extraResourceDto.getId(), apiVersion.getApiVersionId());
                    resource = this.replace(resource, extraResourceDto.getId(), apiVersion.getApiVersionId());
                } else {
                    apiCode = this.replace(apiCode, extraResourceDto.getId(), null);
                    resource = this.replace(resource, extraResourceDto.getId(), null);
                }
                canvasInfo.setApiCodes(apiCode);
                canvasInfo.setCanvasResources(resource);
                this.canvasInfoService.updateById((Object)canvasInfo);
            }
        }
        if (HussarUtils.isNotEmpty(voList)) {
            result.setList(voList);
            result.setTotal(voList.size());
        }
        return result;
    }

    private String replace(String val, Long id, Long newId) {
        if (HussarUtils.isNotEmpty((Object)val)) {
            return val.replace(String.valueOf(id), String.valueOf(newId));
        }
        return val;
    }

    private List<EaiExtraResourceDto> distinctResult(List<EaiExtraResourceDto> result) {
        ArrayList<EaiExtraResourceDto> list = new ArrayList<EaiExtraResourceDto>();
        ArrayList<String> codeList = new ArrayList<String>();
        for (EaiExtraResourceDto extraResourceDto : result) {
            String code = this.getStr(extraResourceDto);
            if (codeList.contains(code)) continue;
            list.add(extraResourceDto);
            codeList.add(code);
        }
        return list;
    }

    private String getStr(EaiExtraResourceDto extraResourceDto) {
        StringBuilder sb = new StringBuilder();
        sb.append(extraResourceDto.getCode()).append(extraResourceDto.getName()).append(extraResourceDto.getType()).append(extraResourceDto.getExtraAppCode()).append(extraResourceDto.getExtraApiCode());
        return sb.toString();
    }

    private AppExternalResourceMigrationDumpVo getApiInfoExternalDumpVo(EaiExtraResourceDto apiResourcesDto, Boolean existFlag) {
        AppExternalResourceMigrationDumpVo vo = this.getApiInfoExternalDumpVo(apiResourcesDto);
        vo.setExistFlag(existFlag);
        return vo;
    }

    private AppExternalResourceMigrationDumpVo getApiInfoExternalDumpVo(EaiExtraResourceDto apiResourcesDto) {
        AppExternalResourceMigrationDumpVo dumpVo = new AppExternalResourceMigrationDumpVo();
        dumpVo.setId((Serializable)((Object)String.valueOf(apiResourcesDto.getId())));
        dumpVo.setLabel(apiResourcesDto.getName());
        dumpVo.setExistFlag(Boolean.valueOf(false));
        dumpVo.setParentId((Serializable)((Object)String.valueOf(111L)));
        EaiResourcesEnum eaiResourcesEnum = EaiResourcesEnum.getByType((String)apiResourcesDto.getType());
        switch (eaiResourcesEnum) {
            case API: {
                dumpVo.setType(AppApiMigrationDataTypeEnum.API.getType());
                dumpVo.setTypeName(AppApiMigrationDataTypeEnum.API.getTypeName());
                break;
            }
            case LOGIC: {
                dumpVo.setType(AppApiMigrationDataTypeEnum.LOGIC.getType());
                dumpVo.setTypeName(AppApiMigrationDataTypeEnum.LOGIC.getTypeName());
                break;
            }
        }
        dumpVo.setHasChildren(Boolean.valueOf(false));
        dumpVo.setIcon("tree-api-port");
        dumpVo.setAppName(apiResourcesDto.getAppName());
        dumpVo.setAppCode(apiResourcesDto.getAppCode());
        dumpVo.setApiName(apiResourcesDto.getName());
        dumpVo.setApiCode(apiResourcesDto.getCode());
        dumpVo.setExtraAppName(apiResourcesDto.getExtraAppName());
        dumpVo.setExtraAppCode(apiResourcesDto.getExtraAppCode());
        dumpVo.setExtraApiName(apiResourcesDto.getExtraApiName());
        dumpVo.setExtraApiCode(apiResourcesDto.getExtraApiCode());
        return dumpVo;
    }
}

