/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.migration.preview.auth.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.common.enums.app.HttpAuthTypeEnum;
import com.jxdinfo.hussar.eai.migration.business.bo.WebServiceTemplateUpdateBo;
import com.jxdinfo.hussar.eai.migration.business.bo.WsdlTemplateUpdateBo;
import com.jxdinfo.hussar.eai.migration.business.dump.vo.AppAuthMigrationDumpVo;
import com.jxdinfo.hussar.eai.migration.business.enums.AppAuthMigrationDataTypeEnum;
import com.jxdinfo.hussar.eai.migration.business.enums.AppAuthMigrationLabelEnum;
import com.jxdinfo.hussar.eai.migration.business.enums.AppMigrationDataChangeTypeEnum;
import com.jxdinfo.hussar.eai.migration.business.migration.preview.auth.service.IEaiMigrationWsAuthDumpService;
import com.jxdinfo.hussar.eai.migration.business.migration.preview.auth.service.impl.EaiMigrationAuthAbstract;
import com.jxdinfo.hussar.eai.migration.dto.EaiCommonResourcesDto;
import com.jxdinfo.hussar.eai.migration.dump.dto.EaiMigrationLoadDto;
import com.jxdinfo.hussar.eai.migration.enums.ApplicationMigrationExportEnum;
import com.jxdinfo.hussar.eai.migration.resources.auth.dto.EaiWsAuthResourcesDto;
import com.jxdinfo.hussar.eai.migration.resources.service.vo.EaiCompareResult;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.ConstantVersion;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.StructureVersion;
import com.jxdinfo.hussar.eai.webservice.auth.server.factory.EaiWebServiceAuthenticationFactory;
import com.jxdinfo.hussar.eai.webservice.manager.api.model.EaiAppWsdl;
import com.jxdinfo.hussar.eai.webservice.manager.api.model.EaiAppWsdlVersion;
import com.jxdinfo.hussar.eai.webservice.manager.api.model.EaiAuthWsdlInfo;
import com.jxdinfo.hussar.eai.webservice.manager.api.model.EaiWebserviceTemplate;
import com.jxdinfo.hussar.eai.webservice.manager.api.service.IEaiAuthWsdlInfoService;
import com.jxdinfo.hussar.eai.webservice.manager.api.service.IEaiWebserviceTemplateService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.migration.business.migration.preview.auth.service.impl.EaiMigrationWsAuthDumpServiceImpl")
public class EaiMigrationWsAuthDumpServiceImpl
extends EaiMigrationAuthAbstract
implements IEaiMigrationWsAuthDumpService {
    @Resource
    private IEaiWebserviceTemplateService webserviceTemplateService;
    @Resource
    private IEaiAuthWsdlInfoService authWsdlInfoService;
    private static final String HTTP_PREFIX = "http://";
    private static final String HTTPS_PREFIX = "https://";
    private static final String SPLIT_CHAR = "-";

    public List<AppAuthMigrationDumpVo> dumpList(List<EaiWsAuthResourcesDto> result, EaiCommonResourcesDto commonResources) {
        ArrayList<AppAuthMigrationDumpVo> dumpList = new ArrayList<AppAuthMigrationDumpVo>(1);
        if (HussarUtils.isEmpty(result)) {
            return Collections.emptyList();
        }
        for (EaiWsAuthResourcesDto wsAuthResourcesDto : result) {
            EaiWebserviceTemplate webserviceTemplate = wsAuthResourcesDto.getWebserviceTemplate();
            AppAuthMigrationDumpVo httpTemplateVo = this.getWsTemplateDumpVo(webserviceTemplate);
            if (HussarUtils.isNotEmpty((Object)httpTemplateVo)) {
                dumpList.add(httpTemplateVo);
            }
            if (HussarUtils.isNotEmpty((Object)commonResources.getStructureList())) {
                for (StructureVersion structureVersion : commonResources.getStructureList()) {
                    dumpList.add(this.getStructureTemplateDumpVo(structureVersion, webserviceTemplate.getId()));
                }
            }
            if (HussarUtils.isNotEmpty((Object)commonResources.getConstantList())) {
                for (ConstantVersion constantVersion : commonResources.getConstantList()) {
                    dumpList.add(this.getConstantTemplateDumpVo(constantVersion, webserviceTemplate.getId()));
                }
            }
            if (!HussarUtils.isNotEmpty((Object)commonResources.getWsdlList())) continue;
            for (EaiAppWsdlVersion wsdlVersion : commonResources.getWsdlList()) {
                dumpList.add(this.getWSDLTemplateDumpVo(wsdlVersion, webserviceTemplate.getId()));
            }
        }
        return HussarTreeParser.getTreeList(dumpList);
    }

    public List<AppAuthMigrationDumpVo> preload(String appCode, Boolean isNewAppCode, List<EaiWsAuthResourcesDto> args) {
        if (HussarUtils.isEmpty(args)) {
            return Collections.emptyList();
        }
        List dtos = JSON.parseArray((String)JSON.toJSONString(args), EaiWsAuthResourcesDto.class);
        ArrayList<AppAuthMigrationDumpVo> preloadVoList = new ArrayList<AppAuthMigrationDumpVo>();
        for (EaiWsAuthResourcesDto eaiHttpAuthResourcesDto : dtos) {
            List wsdlVersions;
            List structureVersions;
            EaiWebserviceTemplate webserviceTemplate = eaiHttpAuthResourcesDto.getWebserviceTemplate();
            this.wsTemplatePreload(preloadVoList, webserviceTemplate, appCode, isNewAppCode);
            List constantVersions = eaiHttpAuthResourcesDto.getConstantList();
            if (HussarUtils.isNotEmpty((Object)constantVersions)) {
                this.constantPreload(preloadVoList, constantVersions, appCode, isNewAppCode, webserviceTemplate.getId());
            }
            if (HussarUtils.isNotEmpty((Object)(structureVersions = eaiHttpAuthResourcesDto.getStructureList()))) {
                this.structurePreload(preloadVoList, structureVersions, appCode, isNewAppCode, webserviceTemplate.getId());
            }
            if (!HussarUtils.isNotEmpty((Object)(wsdlVersions = eaiHttpAuthResourcesDto.getWsdlList()))) continue;
            this.wsdlPreload(preloadVoList, wsdlVersions, appCode, isNewAppCode, webserviceTemplate.getId());
        }
        return HussarTreeParser.getTreeList(preloadVoList);
    }

    public EaiMigrationLoadDto<AppAuthMigrationDumpVo> load(String appCode, Boolean isNewAppCode, List<AppAuthMigrationDumpVo> userSelectInfos, List<EaiWsAuthResourcesDto> args) {
        if (HussarUtils.isEmpty(args)) {
            return null;
        }
        ArrayList<AppAuthMigrationDumpVo> voList = new ArrayList<AppAuthMigrationDumpVo>();
        int total = 0;
        List dtos = JSON.parseArray((String)JSON.toJSONString(args), EaiWsAuthResourcesDto.class);
        if (isNewAppCode.booleanValue()) {
            for (EaiWsAuthResourcesDto auth : dtos) {
                voList.add(this.getWsTemplateDumpVo(auth.getWebserviceTemplate()));
                total += this.addVoList(auth, voList);
                total += this.savWsAuth(auth, appCode);
            }
        } else {
            if (HussarUtils.isEmpty(userSelectInfos)) {
                return null;
            }
            List userSelectInfo = JSON.parseArray((String)JSON.toJSONString(userSelectInfos), AppAuthMigrationDumpVo.class);
            for (AppAuthMigrationDumpVo userSelected : userSelectInfo) {
                for (EaiWsAuthResourcesDto auth : dtos) {
                    if (userSelected.getType() != AppAuthMigrationDataTypeEnum.WEBSERVICE_TEMPLATE.getType()) continue;
                    voList.add(this.getWsTemplateDumpVo(auth.getWebserviceTemplate()));
                    EaiWebserviceTemplate webserviceTemplate = this.getWsTemplate(appCode);
                    if (null != webserviceTemplate) {
                        EaiWebServiceAuthenticationFactory.getInvokeAuth((String)HttpAuthTypeEnum.getHttpAuthTypeEnum((String)webserviceTemplate.getAuthType()).getAuthKey()).webserviceAuthEdit(null, webserviceTemplate, null);
                    }
                    total += this.addVoList(auth, voList);
                    total += this.savWsAuth(auth, appCode);
                }
            }
        }
        EaiMigrationLoadDto result = new EaiMigrationLoadDto();
        result.setList(HussarTreeParser.getTreeList(voList));
        result.setTotal(total);
        return result;
    }

    private int addVoList(EaiWsAuthResourcesDto auth, List<AppAuthMigrationDumpVo> voList) {
        int total = 0;
        if (HussarUtils.isNotEmpty((Object)auth.getConstantList())) {
            for (ConstantVersion constantVersion : auth.getConstantList()) {
                voList.add(this.getConstantTemplateDumpVo(constantVersion, auth.getWebserviceTemplate().getId()));
                ++total;
            }
        }
        if (HussarUtils.isNotEmpty((Object)auth.getConstantList())) {
            for (ConstantVersion constantVersion : auth.getConstantList()) {
                voList.add(this.getConstantTemplateDumpVo(constantVersion, auth.getWebserviceTemplate().getId()));
                ++total;
            }
        }
        if (HussarUtils.isNotEmpty((Object)auth.getStructureList())) {
            for (StructureVersion structureVersion : auth.getStructureList()) {
                voList.add(this.getStructureTemplateDumpVo(structureVersion, auth.getWebserviceTemplate().getId()));
                ++total;
            }
        }
        if (HussarUtils.isNotEmpty((Object)auth.getWsdlList())) {
            for (EaiAppWsdlVersion wsdlVersion : auth.getWsdlList()) {
                voList.add(this.getWSDLTemplateDumpVo(wsdlVersion, auth.getWebserviceTemplate().getId()));
                ++total;
            }
        }
        return total;
    }

    private int savWsAuth(EaiWsAuthResourcesDto auth, String appCode) {
        int total = 0;
        EaiWebserviceTemplate webserviceTemplate = auth.getWebserviceTemplate();
        webserviceTemplate.setId(EngineUtil.getId());
        webserviceTemplate.setApplicationCode(appCode);
        this.removeLocalWsAuth(appCode);
        this.webserviceTemplateService.save((Object)webserviceTemplate);
        ++total;
        Map<Long, Long> extendIdMap = this.saveEaiHttpExtend(auth.getAuthExtends(), webserviceTemplate.getId());
        total += extendIdMap.size();
        total += this.saveToken(auth.getTokenInvalis(), extendIdMap);
        total += this.saveCustomizeAuth(auth.getCustomizeAuths(), extendIdMap);
        total += this.saveEaiParamsPosition(auth.getParamsPositions(), extendIdMap, appCode);
        Map<Long, Long> httpIdMap = this.saveVerifyBase(auth.getVerifyBaseList(), extendIdMap);
        if (HussarUtils.isNotEmpty(httpIdMap)) {
            total += httpIdMap.size();
        }
        total += this.saveHttpParams(auth.getHttpParams(), httpIdMap, appCode);
        return total += this.saveWsParams(auth.getEaiAuthWsdlInfos(), extendIdMap);
    }

    private void removeLocalWsAuth(String appCode) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiWebserviceTemplate::getApplicationCode, (Object)appCode)).isNotNull(EaiWebserviceTemplate::getTemplateType);
        EaiWebserviceTemplate eaiWebserviceTemplate = (EaiWebserviceTemplate)this.webserviceTemplateService.getOne((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)eaiWebserviceTemplate)) {
            EaiWebServiceAuthenticationFactory.getInvokeAuth((String)HttpAuthTypeEnum.getHttpAuthTypeEnum((String)eaiWebserviceTemplate.getAuthType()).getAuthKey()).webserviceAuthEdit(null, eaiWebserviceTemplate, null);
        }
    }

    private int saveWsParams(List<EaiAuthWsdlInfo> wsdlInfos, Map<Long, Long> extendIdMap) {
        if (HussarUtils.isEmpty(wsdlInfos)) {
            return 0;
        }
        int i = 0;
        ArrayList<Long> wsdlId = new ArrayList<Long>(wsdlInfos.size());
        for (EaiAuthWsdlInfo authWsdlInfo : wsdlInfos) {
            if (!wsdlId.contains(authWsdlInfo.getWsdlId())) {
                wsdlId.add(authWsdlInfo.getWsdlId());
                ++i;
            }
            authWsdlInfo.setId(EngineUtil.getId());
            authWsdlInfo.setExtendId(extendIdMap.get(authWsdlInfo.getExtendId()));
        }
        this.authWsdlInfoService.saveBatch(wsdlInfos);
        return i += wsdlInfos.size();
    }

    private EaiWebserviceTemplate getWsTemplate(String appCode) {
        return (EaiWebserviceTemplate)this.webserviceTemplateService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiWebserviceTemplate::getApplicationCode, (Object)appCode)).in(EaiWebserviceTemplate::getTemplateType, Arrays.asList("0", "1")));
    }

    private void wsTemplatePreload(List<AppAuthMigrationDumpVo> preloadVoList, EaiWebserviceTemplate webserviceTemplate, String appCode, Boolean isNewAppCode) {
        if (ToolUtil.isNotEmpty((Object)webserviceTemplate)) {
            EaiWebserviceTemplate localWsTemplate = null;
            int changeType = AppMigrationDataChangeTypeEnum.ADD.getType();
            if (!isNewAppCode.booleanValue()) {
                localWsTemplate = (EaiWebserviceTemplate)this.webserviceTemplateService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiWebserviceTemplate::getApplicationCode, (Object)webserviceTemplate.getApplicationCode())).isNotNull(EaiWebserviceTemplate::getTemplateType));
                if (HussarUtils.isEmpty((Object)localWsTemplate)) {
                    changeType = AppMigrationDataChangeTypeEnum.UPDATE.getType();
                }
            } else {
                webserviceTemplate.setApplicationCode(appCode);
            }
            AppAuthMigrationDumpVo wsTemplateDumpVo = this.getWsTemplateDumpVo(webserviceTemplate, changeType);
            wsTemplateDumpVo.setUpdateDetailList(this.eaiUpdateDetailManager.getWebServiceTemplateDetailList(WebServiceTemplateUpdateBo.convert((EaiWebserviceTemplate)webserviceTemplate), WebServiceTemplateUpdateBo.convert(localWsTemplate), changeType));
            preloadVoList.add(wsTemplateDumpVo);
        }
    }

    private void wsdlPreload(List<AppAuthMigrationDumpVo> preloadVoList, List<EaiAppWsdlVersion> wsdlVersions, String appCode, Boolean isNewAppCode, Long parentId) {
        EaiCompareResult result = this.eaiCompareService.preloadCompare(wsdlVersions, appCode, isNewAppCode, "wsdl");
        if (HussarUtils.isNotEmpty((Object)result.getAddResult())) {
            for (EaiAppWsdlVersion wsdlVersion : result.getAddResult()) {
                AppAuthMigrationDumpVo constantPreloadVo = this.getWSDLTemplateDumpVo(wsdlVersion, parentId, AppMigrationDataChangeTypeEnum.ADD.getType());
                constantPreloadVo.setUpdateDetailList(this.eaiUpdateDetailManager.getWsdlTemplateDetailList(WsdlTemplateUpdateBo.convert((EaiAppWsdlVersion)wsdlVersion), new WsdlTemplateUpdateBo(), AppMigrationDataChangeTypeEnum.ADD.getType()));
                preloadVoList.add(constantPreloadVo);
            }
        }
        if (HussarUtils.isNotEmpty((Object)result.getUpdateResult())) {
            Map map = result.getUpdateLocalResult().stream().collect(Collectors.toMap(EaiAppWsdl::getWsdlPath, Function.identity()));
            for (EaiAppWsdlVersion wsdlVersion : result.getAddResult()) {
                AppAuthMigrationDumpVo constantPreloadVo = this.getWSDLTemplateDumpVo(wsdlVersion, parentId, AppMigrationDataChangeTypeEnum.UPDATE.getType());
                constantPreloadVo.setUpdateDetailList(this.eaiUpdateDetailManager.getWsdlTemplateDetailList(WsdlTemplateUpdateBo.convert((EaiAppWsdlVersion)wsdlVersion), WsdlTemplateUpdateBo.convert((EaiAppWsdl)((EaiAppWsdl)map.get(wsdlVersion.getWsdlPath()))), AppMigrationDataChangeTypeEnum.UPDATE.getType()));
                preloadVoList.add(constantPreloadVo);
            }
        }
    }

    private AppAuthMigrationDumpVo getWSDLTemplateDumpVo(EaiAppWsdlVersion wsdlVersion, Long templateId, int changeType) {
        AppAuthMigrationDumpVo authDumpVo = this.getWSDLTemplateDumpVo(wsdlVersion, templateId);
        authDumpVo.setChangeType(changeType);
        return authDumpVo;
    }

    private AppAuthMigrationDumpVo getWSDLTemplateDumpVo(EaiAppWsdlVersion wsdlVersion, Long templateId) {
        AppAuthMigrationDumpVo wsdlTemplateDumpVo = this.getWSDLTemplateDumpVo(templateId);
        wsdlTemplateDumpVo.setId(wsdlVersion.getId());
        wsdlTemplateDumpVo.setLabel(this.getWsdlPath(wsdlVersion.getWsdlPath()));
        wsdlTemplateDumpVo.setCode(wsdlVersion.getWsdlPath());
        return wsdlTemplateDumpVo;
    }

    private String getWsdlPath(String path) {
        if (HussarUtils.isEmpty((Object)path)) {
            return "";
        }
        if (path.startsWith(HTTP_PREFIX)) {
            path = path.replace(HTTP_PREFIX, "");
        } else if (path.startsWith(HTTPS_PREFIX)) {
            path = path.replace(HTTPS_PREFIX, "");
        }
        return path.substring(path.indexOf("/") + 1);
    }

    private AppAuthMigrationDumpVo getWSDLTemplateDumpVo(Long templateId) {
        AppAuthMigrationDumpVo wsdlDumpVo = new AppAuthMigrationDumpVo();
        wsdlDumpVo.setParentId(templateId);
        wsdlDumpVo.setType(AppAuthMigrationDataTypeEnum.WSDL.getType());
        wsdlDumpVo.setTypeName(AppAuthMigrationDataTypeEnum.WSDL.getTypeName());
        wsdlDumpVo.setHasChildren(Boolean.valueOf(false));
        wsdlDumpVo.setIcon("tree-WSDL-file");
        return wsdlDumpVo;
    }

    private AppAuthMigrationDumpVo getWsTemplateDumpVo(EaiWebserviceTemplate webserviceTemplate, int changeType) {
        AppAuthMigrationDumpVo authDumpVo = this.getWsTemplateDumpVo(webserviceTemplate);
        authDumpVo.setChangeType(changeType);
        return authDumpVo;
    }

    private AppAuthMigrationDumpVo getWsTemplateDumpVo(EaiWebserviceTemplate wsTemplate) {
        AppAuthMigrationDumpVo authDumpVo = new AppAuthMigrationDumpVo();
        authDumpVo.setId(wsTemplate.getId());
        authDumpVo.setLabel(this.buildLabel(AppAuthMigrationDataTypeEnum.WEBSERVICE_TEMPLATE.getTypeName(), AppAuthMigrationLabelEnum.getByType((String)wsTemplate.getAuthType())));
        authDumpVo.setParentId(Constants.ROOT_NODE_ID);
        authDumpVo.setType(AppAuthMigrationDataTypeEnum.WEBSERVICE_TEMPLATE.getType());
        authDumpVo.setTypeName(AppAuthMigrationDataTypeEnum.WEBSERVICE_TEMPLATE.getTypeName());
        authDumpVo.setHasChildren(Boolean.valueOf(false));
        authDumpVo.setIcon("tree-Webservice-auth-config");
        authDumpVo.setAuthType(wsTemplate.getAuthType());
        return authDumpVo;
    }

    private String buildLabel(String per, AppAuthMigrationLabelEnum authMigrationLabelEnum) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(per).append(SPLIT_CHAR).append(authMigrationLabelEnum.getLabel());
        return stringBuilder.toString();
    }

    public ApplicationMigrationExportEnum dumpType() {
        return ApplicationMigrationExportEnum.APP_AUTH_WSDL_INFO_FILE;
    }
}

