/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.migration.preview.auth.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpTemplate;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpTemplateService;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.factory.EaiHttpAuthenticationFactory;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.service.IHttpAuthenticationService;
import com.jxdinfo.hussar.eai.common.enums.app.HttpAuthTypeEnum;
import com.jxdinfo.hussar.eai.migration.business.bo.HttpTemplateUpdateBo;
import com.jxdinfo.hussar.eai.migration.business.dump.vo.AppAuthMigrationDumpVo;
import com.jxdinfo.hussar.eai.migration.business.enums.AppAuthMigrationDataTypeEnum;
import com.jxdinfo.hussar.eai.migration.business.enums.AppAuthMigrationLabelEnum;
import com.jxdinfo.hussar.eai.migration.business.enums.AppMigrationDataChangeTypeEnum;
import com.jxdinfo.hussar.eai.migration.business.migration.preview.auth.service.IEaiMigrationHttpAuthDumpService;
import com.jxdinfo.hussar.eai.migration.business.migration.preview.auth.service.impl.EaiMigrationAuthAbstract;
import com.jxdinfo.hussar.eai.migration.dto.EaiCommonResourcesDto;
import com.jxdinfo.hussar.eai.migration.dump.dto.EaiMigrationLoadDto;
import com.jxdinfo.hussar.eai.migration.enums.ApplicationMigrationExportEnum;
import com.jxdinfo.hussar.eai.migration.resources.auth.dto.EaiHttpAuthResourcesDto;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.ConstantVersion;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.StructureVersion;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.migration.business.migration.preview.auth.service.impl.EaiMigrationHttpAuthDumpServiceImpl")
public class EaiMigrationHttpAuthDumpServiceImpl
extends EaiMigrationAuthAbstract
implements IEaiMigrationHttpAuthDumpService {
    @Resource
    private IEaiHttpTemplateService eaiHttpTemplateService;
    @Resource
    private IHttpAuthenticationService authenticationService;
    private static final String SPLIT_CHAR = "-";

    public List<AppAuthMigrationDumpVo> dumpList(List<EaiHttpAuthResourcesDto> result, EaiCommonResourcesDto commonResources) {
        ArrayList<AppAuthMigrationDumpVo> dumpList = new ArrayList<AppAuthMigrationDumpVo>(1);
        if (HussarUtils.isEmpty(result)) {
            return Collections.emptyList();
        }
        for (EaiHttpAuthResourcesDto httpAuthResourcesDto : result) {
            EaiHttpTemplate httpTemplate = httpAuthResourcesDto.getEaiHttpTemplate();
            AppAuthMigrationDumpVo httpTemplateVo = this.getHttpTemplateDumpVo(httpTemplate);
            if (HussarUtils.isNotEmpty((Object)httpTemplateVo)) {
                dumpList.add(httpTemplateVo);
            }
            if (HussarUtils.isNotEmpty((Object)commonResources.getStructureList())) {
                for (StructureVersion structureVersion : commonResources.getStructureList()) {
                    dumpList.add(this.getStructureTemplateDumpVo(structureVersion, httpTemplate.getTemplateId()));
                }
            }
            if (!HussarUtils.isNotEmpty((Object)commonResources.getConstantList())) continue;
            for (ConstantVersion constantVersion : commonResources.getConstantList()) {
                dumpList.add(this.getConstantTemplateDumpVo(constantVersion, httpTemplate.getTemplateId()));
            }
        }
        return HussarTreeParser.getTreeList(dumpList);
    }

    public List<AppAuthMigrationDumpVo> preload(String appCode, Boolean isNewAppCode, List<EaiHttpAuthResourcesDto> args) {
        if (HussarUtils.isEmpty(args)) {
            return Collections.emptyList();
        }
        List dtos = JSON.parseArray((String)JSON.toJSONString(args), EaiHttpAuthResourcesDto.class);
        ArrayList<AppAuthMigrationDumpVo> preloadVoList = new ArrayList<AppAuthMigrationDumpVo>();
        for (EaiHttpAuthResourcesDto eaiHttpAuthResourcesDto : dtos) {
            List structureVersions;
            EaiHttpTemplate httpTemplate = eaiHttpAuthResourcesDto.getEaiHttpTemplate();
            this.httpTemplatePreload(preloadVoList, httpTemplate, appCode, isNewAppCode);
            List constantVersions = eaiHttpAuthResourcesDto.getConstantList();
            if (HussarUtils.isNotEmpty((Object)constantVersions)) {
                this.constantPreload(preloadVoList, constantVersions, appCode, isNewAppCode, httpTemplate.getTemplateId());
            }
            if (!HussarUtils.isNotEmpty((Object)(structureVersions = eaiHttpAuthResourcesDto.getStructureList()))) continue;
            this.structurePreload(preloadVoList, structureVersions, appCode, isNewAppCode, httpTemplate.getTemplateId());
        }
        return HussarTreeParser.getTreeList(preloadVoList);
    }

    public EaiMigrationLoadDto<AppAuthMigrationDumpVo> load(String appCode, Boolean isNewAppCode, List<AppAuthMigrationDumpVo> userSelectInfos, List<EaiHttpAuthResourcesDto> args) {
        if (HussarUtils.isEmpty(args)) {
            return null;
        }
        ArrayList<AppAuthMigrationDumpVo> voList = new ArrayList<AppAuthMigrationDumpVo>();
        List dtos = JSON.parseArray((String)JSON.toJSONString(args), EaiHttpAuthResourcesDto.class);
        int total = 0;
        if (isNewAppCode.booleanValue()) {
            for (EaiHttpAuthResourcesDto auth : dtos) {
                voList.add(this.getHttpTemplateDumpVo(auth.getEaiHttpTemplate()));
                total += this.addVoList(auth, voList);
                total += this.savHttpAuth(auth, appCode);
            }
        } else {
            if (HussarUtils.isEmpty(userSelectInfos)) {
                return null;
            }
            List userSelectInfo = JSON.parseArray((String)JSON.toJSONString(userSelectInfos), AppAuthMigrationDumpVo.class);
            for (AppAuthMigrationDumpVo userSelected : userSelectInfo) {
                for (EaiHttpAuthResourcesDto auth : dtos) {
                    if (userSelected.getType() != AppAuthMigrationDataTypeEnum.HTTP_TEMPLATE.getType()) continue;
                    voList.add(this.getHttpTemplateDumpVo(auth.getEaiHttpTemplate()));
                    EaiHttpTemplate eaiHttpTemplate = this.getHttpTemplate(appCode);
                    if (null != eaiHttpTemplate) {
                        EaiHttpAuthenticationFactory.getInvokeAuth((String)HttpAuthTypeEnum.getHttpAuthTypeEnum((String)eaiHttpTemplate.getHttpType()).getAuthKey()).httpAuthEdit(null, eaiHttpTemplate, null);
                    }
                    total += this.addVoList(auth, voList);
                    total += this.savHttpAuth(auth, appCode);
                }
            }
        }
        EaiMigrationLoadDto result = new EaiMigrationLoadDto();
        result.setList(HussarTreeParser.getTreeList(voList));
        result.setTotal(total);
        return result;
    }

    private void removeLocalHttpAuth(String appCode) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiHttpTemplate::getApplicationCode, (Object)appCode)).isNotNull(EaiHttpTemplate::getTemplateType);
        EaiHttpTemplate eaiHttpTemplate = (EaiHttpTemplate)this.eaiHttpTemplateService.getOne((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)eaiHttpTemplate)) {
            EaiHttpAuthenticationFactory.getInvokeAuth((String)HttpAuthTypeEnum.getHttpAuthTypeEnum((String)eaiHttpTemplate.getHttpType()).getAuthKey()).httpAuthEdit(null, eaiHttpTemplate, null);
        }
    }

    private int addVoList(EaiHttpAuthResourcesDto auth, List<AppAuthMigrationDumpVo> voList) {
        int total = 0;
        if (HussarUtils.isNotEmpty((Object)auth.getConstantList())) {
            for (ConstantVersion constantVersion : auth.getConstantList()) {
                voList.add(this.getConstantTemplateDumpVo(constantVersion, auth.getEaiHttpTemplate().getTemplateId()));
                ++total;
            }
        }
        if (HussarUtils.isNotEmpty((Object)auth.getStructureList())) {
            for (StructureVersion structureVersion : auth.getStructureList()) {
                voList.add(this.getStructureTemplateDumpVo(structureVersion, auth.getEaiHttpTemplate().getTemplateId()));
                ++total;
            }
        }
        return total;
    }

    private int savHttpAuth(EaiHttpAuthResourcesDto auth, String appCode) {
        int total = 0;
        EaiHttpTemplate httpTemplate = auth.getEaiHttpTemplate();
        httpTemplate.setTemplateId(EngineUtil.getId());
        httpTemplate.setApplicationCode(appCode);
        this.removeLocalHttpAuth(appCode);
        this.eaiHttpTemplateService.save((Object)httpTemplate);
        ++total;
        Map<Long, Long> extendIdMap = this.saveEaiHttpExtend(auth.getAuthExtends(), httpTemplate.getTemplateId());
        total += extendIdMap.size();
        total += this.saveToken(auth.getTokenInvalis(), extendIdMap);
        total += this.saveCustomizeAuth(auth.getCustomizeAuths(), extendIdMap);
        total += this.saveEaiParamsPosition(auth.getParamsPositions(), extendIdMap, appCode);
        Map<Long, Long> httpIdMap = this.saveVerifyBase(auth.getVerifyBaseList(), extendIdMap);
        if (HussarUtils.isNotEmpty(httpIdMap)) {
            total += httpIdMap.size();
        }
        return total += this.saveHttpParams(auth.getHttpParams(), httpIdMap, appCode);
    }

    private EaiHttpTemplate getHttpTemplate(String appCode) {
        return (EaiHttpTemplate)this.eaiHttpTemplateService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiHttpTemplate::getApplicationCode, (Object)appCode)).in(EaiHttpTemplate::getTemplateType, Arrays.asList("0", "1")));
    }

    private void httpTemplatePreload(List<AppAuthMigrationDumpVo> preloadVoList, EaiHttpTemplate httpTemplate, String appCode, Boolean isNewAppCode) {
        if (ToolUtil.isNotEmpty((Object)httpTemplate)) {
            EaiHttpTemplate localHttpTemplate = null;
            int changeType = AppMigrationDataChangeTypeEnum.ADD.getType();
            if (!isNewAppCode.booleanValue()) {
                localHttpTemplate = (EaiHttpTemplate)this.eaiHttpTemplateService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiHttpTemplate::getApplicationCode, (Object)httpTemplate.getApplicationCode())).isNotNull(EaiHttpTemplate::getTemplateType));
                if (HussarUtils.isEmpty((Object)localHttpTemplate)) {
                    changeType = AppMigrationDataChangeTypeEnum.UPDATE.getType();
                }
            } else {
                httpTemplate.setApplicationCode(appCode);
            }
            AppAuthMigrationDumpVo httpTemplatePreloadVo = this.getHttpTemplateDumpVo(httpTemplate, changeType);
            httpTemplatePreloadVo.setUpdateDetailList(this.eaiUpdateDetailManager.getHttpTemplateDetailList(HttpTemplateUpdateBo.convert((EaiHttpTemplate)httpTemplate), HttpTemplateUpdateBo.convert(localHttpTemplate), changeType));
            preloadVoList.add(httpTemplatePreloadVo);
        }
    }

    private AppAuthMigrationDumpVo getHttpTemplateDumpVo(EaiHttpTemplate httpTemplate, int changeType) {
        AppAuthMigrationDumpVo authDumpVo = this.getHttpTemplateDumpVo(httpTemplate);
        authDumpVo.setChangeType(changeType);
        return authDumpVo;
    }

    private AppAuthMigrationDumpVo getHttpTemplateDumpVo(EaiHttpTemplate httpTemplate) {
        AppAuthMigrationDumpVo authDumpVo = new AppAuthMigrationDumpVo();
        authDumpVo.setId(httpTemplate.getTemplateId());
        authDumpVo.setLabel(this.buildLabel(AppAuthMigrationDataTypeEnum.HTTP_TEMPLATE.getTypeName(), AppAuthMigrationLabelEnum.getByType((String)httpTemplate.getHttpType())));
        authDumpVo.setParentId(Constants.ROOT_NODE_ID);
        authDumpVo.setType(AppAuthMigrationDataTypeEnum.HTTP_TEMPLATE.getType());
        authDumpVo.setTypeName(AppAuthMigrationDataTypeEnum.HTTP_TEMPLATE.getTypeName());
        authDumpVo.setHasChildren(Boolean.valueOf(false));
        authDumpVo.setIcon("tree-Webservice-auth-config");
        authDumpVo.setAuthType(httpTemplate.getHttpType());
        return authDumpVo;
    }

    private String buildLabel(String per, AppAuthMigrationLabelEnum authMigrationLabelEnum) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(per).append(SPLIT_CHAR).append(authMigrationLabelEnum.getLabel());
        return stringBuilder.toString();
    }

    public ApplicationMigrationExportEnum dumpType() {
        return ApplicationMigrationExportEnum.APP_AUTH_HTTP_INFO_FILE;
    }
}

