/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.migration.preview.auth.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiApplicationAuth;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiApplicationAuthService;
import com.jxdinfo.hussar.eai.migration.business.bo.ApplicationAuthUpdateBo;
import com.jxdinfo.hussar.eai.migration.business.dump.vo.AppAuthMigrationDumpVo;
import com.jxdinfo.hussar.eai.migration.business.enums.AppAuthMigrationDataTypeEnum;
import com.jxdinfo.hussar.eai.migration.business.enums.AppMigrationDataChangeTypeEnum;
import com.jxdinfo.hussar.eai.migration.business.manager.EaiUpdateDetailManager;
import com.jxdinfo.hussar.eai.migration.business.migration.preview.auth.service.IEaiMigrationAuthParamsDumpService;
import com.jxdinfo.hussar.eai.migration.dto.EaiCommonResourcesDto;
import com.jxdinfo.hussar.eai.migration.dump.dto.EaiMigrationLoadDto;
import com.jxdinfo.hussar.eai.migration.enums.ApplicationMigrationExportEnum;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.migration.business.migration.preview.auth.service.impl.EaiMigrationAuthParamsDumpServiceImpl")
public class EaiMigrationAuthParamsDumpServiceImpl
implements IEaiMigrationAuthParamsDumpService {
    @Autowired
    private IEaiApplicationAuthService eaiApplicationAuthService;
    @Autowired
    private EaiUpdateDetailManager eaiUpdateDetailManager;

    public List<AppAuthMigrationDumpVo> dumpList(List<EaiApplicationAuth> result, EaiCommonResourcesDto commonResources) {
        ArrayList<AppAuthMigrationDumpVo> dumpVoList = new ArrayList<AppAuthMigrationDumpVo>();
        for (EaiApplicationAuth auth : result) {
            AppAuthMigrationDumpVo dumpVo = this.getAuthParamDumpVo(auth, AppMigrationDataChangeTypeEnum.UNCHANGED.getType());
            dumpVoList.add(dumpVo);
        }
        return dumpVoList;
    }

    public List<AppAuthMigrationDumpVo> preload(String appCode, Boolean isNewAppCode, List<EaiApplicationAuth> args) {
        if (HussarUtils.isEmpty(args)) {
            return Collections.emptyList();
        }
        ArrayList<AppAuthMigrationDumpVo> preloadVoList = new ArrayList<AppAuthMigrationDumpVo>();
        List<Object> updateParams = new ArrayList();
        List dtos = JSON.parseArray((String)JSON.toJSONString(args), EaiApplicationAuth.class);
        if (!isNewAppCode.booleanValue()) {
            List codes = dtos.stream().map(EaiApplicationAuth::getParamsNameEn).collect(Collectors.toList());
            List applicationAuths = this.eaiApplicationAuthService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiApplicationAuth::getApplicationCode, (Object)appCode)).in(EaiApplicationAuth::getParamsNameEn, codes));
            if (HussarUtils.isNotEmpty((Object)applicationAuths)) {
                updateParams = applicationAuths.stream().map(EaiApplicationAuth::getParamsNameEn).collect(Collectors.toList());
            }
        }
        for (EaiApplicationAuth auth : dtos) {
            AppAuthMigrationDumpVo vo;
            if (isNewAppCode.booleanValue()) {
                auth.setApplicationCode(appCode);
            }
            if (updateParams.contains(auth.getParamsNameEn())) {
                vo = this.getAuthParamDumpVo(auth, AppMigrationDataChangeTypeEnum.UNCHANGED.getType());
                vo.setUpdateDetailList(this.eaiUpdateDetailManager.getAppAuthDetailList(ApplicationAuthUpdateBo.convert((EaiApplicationAuth)auth), ApplicationAuthUpdateBo.convert((EaiApplicationAuth)auth), AppMigrationDataChangeTypeEnum.UNCHANGED.getType()));
                preloadVoList.add(vo);
                continue;
            }
            vo = this.getAuthParamDumpVo(auth, AppMigrationDataChangeTypeEnum.ADD.getType());
            vo.setUpdateDetailList(this.eaiUpdateDetailManager.getAppAuthDetailList(ApplicationAuthUpdateBo.convert((EaiApplicationAuth)auth), ApplicationAuthUpdateBo.convert((EaiApplicationAuth)new EaiApplicationAuth()), AppMigrationDataChangeTypeEnum.ADD.getType()));
            preloadVoList.add(vo);
        }
        return HussarTreeParser.getTreeList(preloadVoList);
    }

    public EaiMigrationLoadDto<AppAuthMigrationDumpVo> load(String appCode, Boolean isNewAppCode, List<AppAuthMigrationDumpVo> userSelectInfos, List<EaiApplicationAuth> args) {
        if (HussarUtils.isEmpty(args)) {
            return null;
        }
        List dtos = JSON.parseArray((String)JSON.toJSONString(args), EaiApplicationAuth.class);
        ArrayList<AppAuthMigrationDumpVo> voList = new ArrayList<AppAuthMigrationDumpVo>();
        int total = 0;
        if (isNewAppCode.booleanValue()) {
            for (EaiApplicationAuth auth : dtos) {
                this.eaiApplicationAuthService.remove((Wrapper)new LambdaQueryWrapper().eq(EaiApplicationAuth::getApplicationCode, (Object)appCode));
                auth.setApplicationCode(appCode);
                auth.setParamsId(EngineUtil.getId());
                this.eaiApplicationAuthService.save((Object)auth);
                voList.add(this.getAuthParamDumpVo(auth, AppMigrationDataChangeTypeEnum.ADD.getType()));
                ++total;
            }
        } else {
            if (HussarUtils.isEmpty(userSelectInfos)) {
                return null;
            }
            List userSelectInfo = JSON.parseArray((String)JSON.toJSONString(userSelectInfos), AppAuthMigrationDumpVo.class);
            for (AppAuthMigrationDumpVo userSelected : userSelectInfo) {
                for (EaiApplicationAuth auth : dtos) {
                    LambdaUpdateWrapper wrapper;
                    if (!auth.getParamsNameEn().equals(userSelected.getTypeName())) continue;
                    auth.setApplicationCode(appCode);
                    if (AppMigrationDataChangeTypeEnum.UPDATE.getType() == userSelected.getType()) {
                        wrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(EaiApplicationAuth::getApplicationCode, (Object)appCode)).eq(EaiApplicationAuth::getParamsNameEn, (Object)auth.getParamsNameEn());
                        this.eaiApplicationAuthService.update((Object)auth, (Wrapper)wrapper);
                        voList.add(this.getAuthParamDumpVo(auth, AppMigrationDataChangeTypeEnum.UPDATE.getType()));
                        ++total;
                        continue;
                    }
                    if (AppMigrationDataChangeTypeEnum.ADD.getType() != userSelected.getType()) continue;
                    wrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(EaiApplicationAuth::getApplicationCode, (Object)appCode)).eq(EaiApplicationAuth::getParamsNameEn, (Object)auth.getParamsNameEn());
                    EaiApplicationAuth applicationAuth = (EaiApplicationAuth)this.eaiApplicationAuthService.getOne((Wrapper)wrapper);
                    if (HussarUtils.isEmpty((Object)applicationAuth)) {
                        auth.setParamsId(EngineUtil.getId());
                        this.eaiApplicationAuthService.save((Object)auth);
                    } else {
                        auth.setParamsId(applicationAuth.getParamsId());
                    }
                    voList.add(this.getAuthParamDumpVo(auth, AppMigrationDataChangeTypeEnum.ADD.getType()));
                    ++total;
                }
            }
        }
        EaiMigrationLoadDto result = new EaiMigrationLoadDto();
        result.setList(HussarTreeParser.getTreeList(voList));
        result.setTotal(total);
        return result;
    }

    private AppAuthMigrationDumpVo getAuthParamDumpVo(EaiApplicationAuth applicationAuth, int changeType) {
        AppAuthMigrationDumpVo dumpVo = new AppAuthMigrationDumpVo();
        dumpVo.setId(applicationAuth.getParamsId());
        dumpVo.setLabel(applicationAuth.getParamsName());
        dumpVo.setCode(applicationAuth.getParamsNameEn());
        dumpVo.setParentId(Constants.ROOT_NODE_ID);
        dumpVo.setType(AppAuthMigrationDataTypeEnum.AUTH_PARAM.getType());
        dumpVo.setTypeName(AppAuthMigrationDataTypeEnum.AUTH_PARAM.getTypeName());
        dumpVo.setHasChildren(Boolean.valueOf(false));
        dumpVo.setIcon("tree-auth-param");
        dumpVo.setChangeType(changeType);
        return dumpVo;
    }

    public ApplicationMigrationExportEnum dumpType() {
        return ApplicationMigrationExportEnum.APP_AUTH_PARAMS_FILE;
    }
}

