/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.migration.preview.auth.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiApplicationAuth;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiCustomizeAuth;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpExtend;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpParams;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpVerifyBase;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiParamsPosition;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiTokenInvali;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiApplicationAuthService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiCustomizeAuthSerivce;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpExtendService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpParamsService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpVerifyBaseService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiParamsPositionService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiTokenInvaliService;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.AuthHTTPBodyParams;
import com.jxdinfo.hussar.eai.common.enums.app.EaiResourcesEnum;
import com.jxdinfo.hussar.eai.migration.business.bo.ConstantUpdateBo;
import com.jxdinfo.hussar.eai.migration.business.bo.StructureUpdateBo;
import com.jxdinfo.hussar.eai.migration.business.compare.service.IEaiCompareService;
import com.jxdinfo.hussar.eai.migration.business.dump.vo.AppAuthMigrationDumpVo;
import com.jxdinfo.hussar.eai.migration.business.enums.AppAuthMigrationDataTypeEnum;
import com.jxdinfo.hussar.eai.migration.business.enums.AppMigrationDataChangeTypeEnum;
import com.jxdinfo.hussar.eai.migration.business.manager.EaiUpdateDetailManager;
import com.jxdinfo.hussar.eai.migration.resources.service.vo.EaiCompareResult;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonConstant;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonStructure;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.ConstantVersion;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.StructureVersion;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;

public abstract class EaiMigrationAuthAbstract {
    @Resource
    protected IEaiCompareService eaiCompareService;
    @Resource
    protected EaiUpdateDetailManager eaiUpdateDetailManager;
    @Resource
    private IEaiHttpExtendService eaiHttpExtendService;
    @Resource
    private IEaiTokenInvaliService tokenInvaliService;
    @Resource
    private IEaiHttpVerifyBaseService eaiHttpVerifyBaseService;
    @Resource
    private IEaiHttpParamsService eaiHttpParamsService;
    @Resource
    private IEaiParamsPositionService eaiParamsPositionService;
    @Resource
    private IEaiCustomizeAuthSerivce eaiCustomizeAuthSerivce;
    @Resource
    private IEaiApplicationAuthService eaiApplicationAuthService;

    protected void constantPreload(List<AppAuthMigrationDumpVo> preloadVoList, List<ConstantVersion> constantVersions, String appCode, Boolean isNewAppCode, Long parentId) {
        EaiCompareResult result = this.eaiCompareService.preloadCompare(constantVersions, appCode, isNewAppCode, EaiResourcesEnum.CONSTANT.getType());
        if (HussarUtils.isNotEmpty((Object)result.getAddResult())) {
            for (ConstantVersion constantVersion : result.getAddResult()) {
                AppAuthMigrationDumpVo constantPreloadVo = this.getConstantTemplateDumpVo(constantVersion, parentId, AppMigrationDataChangeTypeEnum.ADD.getType());
                constantPreloadVo.setUpdateDetailList(this.eaiUpdateDetailManager.getConstantDetailList(ConstantUpdateBo.convert((ConstantVersion)constantVersion), null, AppMigrationDataChangeTypeEnum.ADD.getType()));
                preloadVoList.add(constantPreloadVo);
            }
        }
        if (HussarUtils.isNotEmpty((Object)result.getUpdateResult())) {
            Map map = result.getUpdateLocalResult().stream().collect(Collectors.toMap(CommonConstant::getConstantNameEn, Function.identity()));
            for (ConstantVersion constantVersion : result.getAddResult()) {
                AppAuthMigrationDumpVo constantPreloadVo = this.getConstantTemplateDumpVo(constantVersion, parentId, AppMigrationDataChangeTypeEnum.UPDATE.getType());
                constantPreloadVo.setUpdateDetailList(this.eaiUpdateDetailManager.getConstantDetailList(ConstantUpdateBo.convert((ConstantVersion)constantVersion), ConstantUpdateBo.convert((CommonConstant)((CommonConstant)map.get(constantVersion.getConstantNameEn()))), AppMigrationDataChangeTypeEnum.UPDATE.getType()));
                preloadVoList.add(constantPreloadVo);
            }
        }
    }

    protected void structurePreload(List<AppAuthMigrationDumpVo> preloadVoList, List<StructureVersion> structureVersions, String appCode, Boolean isNewAppCode, Long parentId) {
        EaiCompareResult result = this.eaiCompareService.preloadCompare(structureVersions, appCode, isNewAppCode, EaiResourcesEnum.STRUCTURE.getType());
        if (HussarUtils.isNotEmpty((Object)result.getAddResult())) {
            for (StructureVersion structureVersion : result.getAddResult()) {
                AppAuthMigrationDumpVo constantPreloadVo = this.getStructureTemplateDumpVo(structureVersion, parentId, AppMigrationDataChangeTypeEnum.ADD.getType());
                constantPreloadVo.setUpdateDetailList(this.eaiUpdateDetailManager.getStructureDetailList(StructureUpdateBo.convert((StructureVersion)structureVersion), new StructureUpdateBo(), AppMigrationDataChangeTypeEnum.ADD.getType()));
                preloadVoList.add(constantPreloadVo);
            }
        }
        if (HussarUtils.isNotEmpty((Object)result.getUpdateResult())) {
            Map map = result.getUpdateLocalResult().stream().collect(Collectors.toMap(CommonStructure::getStructureCode, Function.identity()));
            for (StructureVersion structureVersion : result.getAddResult()) {
                AppAuthMigrationDumpVo constantPreloadVo = this.getStructureTemplateDumpVo(structureVersion, parentId, AppMigrationDataChangeTypeEnum.UPDATE.getType());
                constantPreloadVo.setUpdateDetailList(this.eaiUpdateDetailManager.getStructureDetailList(StructureUpdateBo.convert((StructureVersion)structureVersion), StructureUpdateBo.convert((CommonStructure)((CommonStructure)map.get(structureVersion.getStructureCode()))), AppMigrationDataChangeTypeEnum.UPDATE.getType()));
                preloadVoList.add(constantPreloadVo);
            }
        }
    }

    protected Map<Long, Long> saveEaiHttpExtend(List<EaiHttpExtend> authextends, Long templateId) {
        if (HussarUtils.isEmpty(authextends)) {
            return null;
        }
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        for (EaiHttpExtend authextend : authextends) {
            authextend.setTemplateId(templateId);
            Long id = EngineUtil.getId();
            map.put(authextend.getExtendId(), id);
            authextend.setExtendId(id);
        }
        this.eaiHttpExtendService.saveBatch(authextends);
        return map;
    }

    private List<EaiApplicationAuth> getAuthParams(String appCode) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiApplicationAuth::getApplicationCode, (Object)appCode);
        return this.eaiApplicationAuthService.list((Wrapper)queryWrapper);
    }

    protected int saveEaiParamsPosition(List<EaiParamsPosition> paramsPositions, Map<Long, Long> extendIdMap, String appCode) {
        if (HussarUtils.isEmpty(paramsPositions)) {
            return 0;
        }
        int i = 0;
        List<EaiApplicationAuth> applicationAuths = this.getAuthParams(appCode);
        if (HussarUtils.isNotEmpty(applicationAuths)) {
            Map<String, Long> map = applicationAuths.stream().collect(Collectors.toMap(EaiApplicationAuth::getParamsNameEn, EaiApplicationAuth::getParamsId));
            for (EaiParamsPosition paramsPosition : paramsPositions) {
                paramsPosition.setPositionId(EngineUtil.getId());
                paramsPosition.setExtendId(extendIdMap.get(paramsPosition.getExtendId()));
                if (!HussarUtils.isNotEmpty((Object)paramsPosition.getEffective())) continue;
                List list = JSON.parseArray((String)paramsPosition.getEffective(), EaiHttpParams.class);
                for (EaiHttpParams httpParams : list) {
                    String paramsValue = httpParams.getParamsValue();
                    if (!"2".equals(httpParams.getParamsFrom()) || !HussarUtils.isNotEmpty((Object)paramsValue)) continue;
                    httpParams.setParamsValue(String.valueOf(map.get(paramsValue)));
                }
                paramsPosition.setEffective(JSON.toJSONString((Object)list));
            }
        } else {
            for (EaiParamsPosition paramsPosition : paramsPositions) {
                paramsPosition.setPositionId(EngineUtil.getId());
                paramsPosition.setExtendId(extendIdMap.get(paramsPosition.getExtendId()));
            }
        }
        this.eaiParamsPositionService.saveBatch(paramsPositions);
        return i += paramsPositions.size();
    }

    protected Map<Long, Long> saveVerifyBase(List<EaiHttpVerifyBase> httpVerifyBases, Map<Long, Long> extendIdMap) {
        if (HussarUtils.isEmpty(httpVerifyBases)) {
            return null;
        }
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        for (EaiHttpVerifyBase httpVerifyBase : httpVerifyBases) {
            Long id = EngineUtil.getId();
            map.put(httpVerifyBase.getHttpBaseId(), id);
            httpVerifyBase.setHttpBaseId(id);
            httpVerifyBase.setExtendId(extendIdMap.get(httpVerifyBase.getExtendId()));
        }
        this.eaiHttpVerifyBaseService.saveBatch(httpVerifyBases);
        return map;
    }

    protected int saveHttpParams(List<EaiHttpParams> httpParams, Map<Long, Long> httpIdMap, String appCode) {
        if (HussarUtils.isEmpty(httpParams)) {
            return 0;
        }
        List<EaiApplicationAuth> applicationAuths = this.getAuthParams(appCode);
        if (HussarUtils.isNotEmpty(applicationAuths)) {
            Map<String, Long> map = applicationAuths.stream().collect(Collectors.toMap(EaiApplicationAuth::getParamsNameEn, EaiApplicationAuth::getParamsId));
            for (EaiHttpParams httpParam : httpParams) {
                httpParam.setParamsId(EngineUtil.getId());
                httpParam.setHttpId(httpIdMap.get(httpParam.getHttpId()));
                if (!"2".equals(httpParam.getParamsFrom()) || !HussarUtils.isNotEmpty((Object)httpParam.getParamsValue())) continue;
                AuthHTTPBodyParams newParam = (AuthHTTPBodyParams)JSON.parseObject((String)httpParam.getParamsValue(), AuthHTTPBodyParams.class);
                newParam.setParamsValue(String.valueOf(map.get(newParam.getParamsValue())));
                httpParam.setParamsValue(JSON.toJSONString((Object)newParam));
            }
        } else {
            for (EaiHttpParams httpParam : httpParams) {
                httpParam.setParamsId(EngineUtil.getId());
                httpParam.setHttpId(httpIdMap.get(httpParam.getHttpId()));
            }
        }
        this.eaiHttpParamsService.saveBatch(httpParams);
        return httpParams.size();
    }

    protected int saveToken(List<EaiTokenInvali> tokenInvalis, Map<Long, Long> map) {
        if (HussarUtils.isEmpty(tokenInvalis)) {
            return 0;
        }
        for (EaiTokenInvali tokenInvali : tokenInvalis) {
            tokenInvali.setExtendId(map.get(tokenInvali.getExtendId()));
            tokenInvali.setInvalidationId(EngineUtil.getId());
        }
        this.tokenInvaliService.saveBatch(tokenInvalis);
        return tokenInvalis.size();
    }

    protected int saveCustomizeAuth(List<EaiCustomizeAuth> customizeAuths, Map<Long, Long> map) {
        if (HussarUtils.isEmpty(customizeAuths)) {
            return 0;
        }
        for (EaiCustomizeAuth customizeAuth : customizeAuths) {
            customizeAuth.setId(EngineUtil.getId());
            customizeAuth.setExtendId(map.get(customizeAuth.getExtendId()));
        }
        this.eaiCustomizeAuthSerivce.saveBatch(customizeAuths);
        return customizeAuths.size();
    }

    protected AppAuthMigrationDumpVo getStructureTemplateDumpVo(StructureVersion structure, Long templateId, int changeType) {
        AppAuthMigrationDumpVo structureDumpVo = this.getStructureTemplateDumpVo(templateId);
        structureDumpVo.setId(structure.getId());
        structureDumpVo.setLabel(structure.getStructureName());
        structureDumpVo.setChangeType(changeType);
        return structureDumpVo;
    }

    protected AppAuthMigrationDumpVo getStructureTemplateDumpVo(StructureVersion structure, Long templateId) {
        AppAuthMigrationDumpVo structureDumpVo = this.getStructureTemplateDumpVo(templateId);
        structureDumpVo.setId(structure.getId());
        structureDumpVo.setLabel(structure.getStructureName());
        structureDumpVo.setCode(structure.getStructureCode());
        return structureDumpVo;
    }

    protected AppAuthMigrationDumpVo getStructureTemplateDumpVo(Long templateId) {
        AppAuthMigrationDumpVo structureDumpVo = new AppAuthMigrationDumpVo();
        structureDumpVo.setParentId(templateId);
        structureDumpVo.setType(AppAuthMigrationDataTypeEnum.STRUCTURE.getType());
        structureDumpVo.setTypeName(AppAuthMigrationDataTypeEnum.STRUCTURE.getTypeName());
        structureDumpVo.setHasChildren(Boolean.valueOf(false));
        structureDumpVo.setIcon("tree-data-structure");
        return structureDumpVo;
    }

    protected AppAuthMigrationDumpVo getConstantTemplateDumpVo(ConstantVersion constant, Long templateId, int changeType) {
        AppAuthMigrationDumpVo constantDumpVo = this.getConstantTemplateDumpVo(templateId);
        constantDumpVo.setId(constant.getId());
        constantDumpVo.setLabel(constant.getConstantName());
        constantDumpVo.setChangeType(changeType);
        return constantDumpVo;
    }

    protected AppAuthMigrationDumpVo getConstantTemplateDumpVo(ConstantVersion constant, Long templateId) {
        AppAuthMigrationDumpVo constantDumpVo = this.getConstantTemplateDumpVo(templateId);
        constantDumpVo.setId(constant.getId());
        constantDumpVo.setLabel(constant.getConstantName());
        constantDumpVo.setCode(constant.getConstantNameEn());
        return constantDumpVo;
    }

    protected AppAuthMigrationDumpVo getConstantTemplateDumpVo(Long templateId) {
        AppAuthMigrationDumpVo constantDumpVo = new AppAuthMigrationDumpVo();
        constantDumpVo.setParentId(templateId);
        constantDumpVo.setType(AppAuthMigrationDataTypeEnum.CONSTANT.getType());
        constantDumpVo.setTypeName(AppAuthMigrationDataTypeEnum.CONSTANT.getTypeName());
        constantDumpVo.setHasChildren(Boolean.valueOf(false));
        constantDumpVo.setIcon("tree-constant");
        return constantDumpVo;
    }
}

