/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.migration.preview.app.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.application.model.SysAppGroup;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysAppGroupService;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.eai.migration.business.dump.vo.ApplicationMigrationDumpVo;
import com.jxdinfo.hussar.eai.migration.business.enums.AppMigrationDataChangeTypeEnum;
import com.jxdinfo.hussar.eai.migration.business.enums.ApplicationMigrationDataTypeEnum;
import com.jxdinfo.hussar.eai.migration.business.migration.preview.app.service.IEaiMigrationAppGroupDumpService;
import com.jxdinfo.hussar.eai.migration.dto.EaiCommonResourcesDto;
import com.jxdinfo.hussar.eai.migration.dump.dto.EaiMigrationLoadDto;
import com.jxdinfo.hussar.eai.migration.enums.ApplicationMigrationExportEnum;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.migration.business.migration.preview.app.service.impl.EaiMigrationAppGroupDumpServiceImpl")
public class EaiMigrationAppGroupDumpServiceImpl
implements IEaiMigrationAppGroupDumpService {
    @Autowired
    private ISysAppGroupService appGroupService;
    @Autowired
    private ISysApplicationService sysApplicationService;

    public List<ApplicationMigrationDumpVo> dumpList(List<SysAppGroup> result, EaiCommonResourcesDto commonResources) {
        ArrayList<ApplicationMigrationDumpVo> dumpVoList = new ArrayList<ApplicationMigrationDumpVo>();
        if (HussarUtils.isNotEmpty(result)) {
            SysAppGroup appGroup = result.get(0);
            dumpVoList.add(new ApplicationMigrationDumpVo(String.valueOf(EngineUtil.getId()), ApplicationMigrationDataTypeEnum.APP_GROUP.getTypeName(), appGroup.getGroupName()));
        } else {
            dumpVoList.add(new ApplicationMigrationDumpVo(String.valueOf(EngineUtil.getId()), ApplicationMigrationDataTypeEnum.APP_GROUP.getTypeName(), ""));
        }
        return dumpVoList;
    }

    public List<ApplicationMigrationDumpVo> preload(String appCode, Boolean isNewAppCode, List<SysAppGroup> args) {
        if (HussarUtils.isEmpty(args)) {
            return Collections.emptyList();
        }
        List dtos = JSON.parseArray((String)JSON.toJSONString(args), SysAppGroup.class);
        ArrayList<ApplicationMigrationDumpVo> preloadVoList = new ArrayList<ApplicationMigrationDumpVo>();
        for (SysAppGroup appGroup : dtos) {
            SysAppGroup localGroup = (SysAppGroup)this.appGroupService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysAppGroup::getGroupName, (Object)appGroup.getGroupName()));
            if (HussarUtils.isNotEmpty((Object)localGroup)) {
                preloadVoList.add(new ApplicationMigrationDumpVo(String.valueOf(EngineUtil.getId()), Integer.valueOf(ApplicationMigrationDataTypeEnum.APP_GROUP.getType()), ApplicationMigrationDataTypeEnum.APP_GROUP.getTypeName(), localGroup.getGroupName(), AppMigrationDataChangeTypeEnum.UNCHANGED.getType(), localGroup.getGroupName()));
                continue;
            }
            preloadVoList.add(new ApplicationMigrationDumpVo(String.valueOf(EngineUtil.getId()), Integer.valueOf(ApplicationMigrationDataTypeEnum.APP_GROUP.getType()), ApplicationMigrationDataTypeEnum.APP_GROUP.getTypeName(), appGroup.getGroupName(), AppMigrationDataChangeTypeEnum.ADD.getType(), ""));
        }
        return HussarTreeParser.getTreeList(preloadVoList);
    }

    public EaiMigrationLoadDto<ApplicationMigrationDumpVo> load(String appCode, Boolean isNewAppCode, List<ApplicationMigrationDumpVo> userSelectInfos, List<SysAppGroup> args) {
        if (HussarUtils.isEmpty(args)) {
            return null;
        }
        int total = 0;
        ArrayList<ApplicationMigrationDumpVo> list = new ArrayList<ApplicationMigrationDumpVo>();
        List dtos = JSON.parseArray((String)JSON.toJSONString(args), SysAppGroup.class);
        if (isNewAppCode.booleanValue()) {
            SysApplication application = (SysApplication)this.sysApplicationService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysApplication::getAppCode, (Object)appCode));
            SysAppGroup sysAppGroup = (SysAppGroup)dtos.get(0);
            sysAppGroup.setId(EngineUtil.getId());
            LambdaUpdateWrapper queryWrapper = (LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysAppGroup::getGroupName, (Object)sysAppGroup.getGroupName());
            SysAppGroup appGroup = (SysAppGroup)this.appGroupService.getOne((Wrapper)queryWrapper);
            Long groupId = null;
            if (HussarUtils.isEmpty((Object)appGroup)) {
                this.appGroupService.save((Object)sysAppGroup);
                groupId = sysAppGroup.getId();
            } else {
                groupId = appGroup.getId();
            }
            application.setAppGroupId(groupId);
            this.sysApplicationService.updateById((Object)application);
            list.add(new ApplicationMigrationDumpVo(String.valueOf(EngineUtil.getId()), ApplicationMigrationDataTypeEnum.APP_GROUP.getTypeName(), sysAppGroup.getGroupName()));
            ++total;
        } else {
            if (HussarUtils.isEmpty(userSelectInfos)) {
                return null;
            }
            List userSelectInfo = JSON.parseArray((String)JSON.toJSONString(userSelectInfos), ApplicationMigrationDumpVo.class);
            for (ApplicationMigrationDumpVo migrationDumpVo : userSelectInfo) {
                if (HussarUtils.isEmpty((Object)migrationDumpVo.getType()) || ApplicationMigrationDataTypeEnum.APP_GROUP.getType() != migrationDumpVo.getType().intValue() || AppMigrationDataChangeTypeEnum.UPDATE.getType() != migrationDumpVo.getChangeType()) continue;
                for (SysAppGroup sysAppGroup : dtos) {
                    sysAppGroup.setId(EngineUtil.getId());
                    LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysAppGroup::getGroupName, (Object)sysAppGroup.getGroupName());
                    this.appGroupService.update((Object)sysAppGroup, (Wrapper)updateWrapper);
                    list.add(new ApplicationMigrationDumpVo(String.valueOf(EngineUtil.getId()), ApplicationMigrationDataTypeEnum.APP_GROUP.getTypeName(), sysAppGroup.getGroupName()));
                    ++total;
                }
            }
        }
        EaiMigrationLoadDto result = new EaiMigrationLoadDto();
        result.setList(HussarTreeParser.getTreeList(list));
        result.setTotal(total);
        return result;
    }

    public ApplicationMigrationExportEnum dumpType() {
        return ApplicationMigrationExportEnum.APP_GROUP_FILE;
    }
}

