/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.migration.preview.app.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.eai.appinfo.api.model.EaiApplicationExtendConfiguration;
import com.jxdinfo.hussar.eai.appinfo.api.service.IEaiApplicationExtendConfigurationService;
import com.jxdinfo.hussar.eai.migration.business.dump.vo.ApplicationMigrationDumpVo;
import com.jxdinfo.hussar.eai.migration.business.enums.AppMigrationDataChangeTypeEnum;
import com.jxdinfo.hussar.eai.migration.business.enums.ApplicationMigrationDataTypeEnum;
import com.jxdinfo.hussar.eai.migration.business.migration.preview.app.service.IEaiMigrationAppExtendConfigDumpService;
import com.jxdinfo.hussar.eai.migration.dto.EaiCommonResourcesDto;
import com.jxdinfo.hussar.eai.migration.dump.dto.EaiMigrationLoadDto;
import com.jxdinfo.hussar.eai.migration.enums.ApplicationMigrationExportEnum;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.migration.business.migration.preview.app.service.impl.EaiMigrationAppExtendConfigDumpServiceImpl")
public class EaiMigrationAppExtendConfigDumpServiceImpl
implements IEaiMigrationAppExtendConfigDumpService {
    private static String NAME_FORMAT = "%s-%s";
    @Autowired
    private IEaiApplicationExtendConfigurationService eaiApplicationExtendConfigurationService;

    public List<ApplicationMigrationDumpVo> dumpList(List<EaiApplicationExtendConfiguration> result, EaiCommonResourcesDto commonResources) {
        ArrayList<ApplicationMigrationDumpVo> dumpVoList = new ArrayList<ApplicationMigrationDumpVo>();
        for (EaiApplicationExtendConfiguration appExtendConfig : result) {
            dumpVoList.add(new ApplicationMigrationDumpVo(String.valueOf(EngineUtil.getId()), appExtendConfig.getConfigType(), this.getName(appExtendConfig.getConfigType())));
        }
        return dumpVoList;
    }

    private String getName(String configType) {
        return String.format(NAME_FORMAT, ApplicationMigrationDataTypeEnum.APP_EXTEND_CONFIG.getTypeName(), configType);
    }

    public List<ApplicationMigrationDumpVo> preload(String appCode, Boolean isNewAppCode, List<EaiApplicationExtendConfiguration> args) {
        if (HussarUtils.isEmpty(args)) {
            return Collections.emptyList();
        }
        ArrayList<ApplicationMigrationDumpVo> preloadVoList = new ArrayList<ApplicationMigrationDumpVo>();
        List<EaiApplicationExtendConfiguration> oldList = this.getLocalConfig(appCode);
        List dtos = JSON.parseArray((String)JSON.toJSONString(args), EaiApplicationExtendConfiguration.class);
        if (HussarUtils.isNotEmpty(oldList)) {
            for (EaiApplicationExtendConfiguration configuration : dtos) {
                if (oldList.contains(configuration)) {
                    preloadVoList.add(new ApplicationMigrationDumpVo(String.valueOf(EngineUtil.getId()), configuration.getConfigType(), this.getName(configuration.getConfigType()), AppMigrationDataChangeTypeEnum.UNCHANGED.getType(), this.getName(configuration.getConfigType())));
                    continue;
                }
                int type = EaiMigrationAppExtendConfigDumpServiceImpl.getType(configuration, oldList);
                preloadVoList.add(new ApplicationMigrationDumpVo(String.valueOf(EngineUtil.getId()), configuration.getConfigType(), this.getName(configuration.getConfigType()), type, this.getName(configuration.getConfigType())));
            }
        } else {
            for (EaiApplicationExtendConfiguration configuration : dtos) {
                preloadVoList.add(new ApplicationMigrationDumpVo(String.valueOf(EngineUtil.getId()), configuration.getConfigType(), this.getName(configuration.getConfigType()), AppMigrationDataChangeTypeEnum.ADD.getType(), this.getName(configuration.getConfigType())));
            }
        }
        return preloadVoList;
    }

    public EaiMigrationLoadDto<ApplicationMigrationDumpVo> load(String appCode, Boolean isNewAppCode, List<ApplicationMigrationDumpVo> userSelectInfos, List<EaiApplicationExtendConfiguration> args) {
        ArrayList<ApplicationMigrationDumpVo> voList = new ArrayList<ApplicationMigrationDumpVo>();
        int total = 0;
        if (HussarUtils.isEmpty(args)) {
            if (isNewAppCode.booleanValue()) {
                EaiApplicationExtendConfiguration configuration = this.createNewConfiguration(appCode);
                this.eaiApplicationExtendConfigurationService.save((Object)configuration);
                voList.add(new ApplicationMigrationDumpVo(String.valueOf(EngineUtil.getId()), configuration.getConfigType(), this.getName(configuration.getConfigType()), AppMigrationDataChangeTypeEnum.ADD.getType(), this.getName(configuration.getConfigType())));
                ++total;
            }
            EaiMigrationLoadDto result = new EaiMigrationLoadDto();
            result.setList(HussarTreeParser.getTreeList(voList));
            result.setTotal(total);
        }
        List dtos = JSON.parseArray((String)JSON.toJSONString(args), EaiApplicationExtendConfiguration.class);
        if (isNewAppCode.booleanValue()) {
            for (EaiApplicationExtendConfiguration configuration : dtos) {
                configuration.setApplicationCode(appCode);
                configuration.setConfigId(EngineUtil.getId());
                this.eaiApplicationExtendConfigurationService.save((Object)configuration);
                voList.add(this.newLoadVo(configuration, AppMigrationDataChangeTypeEnum.ADD.getType()));
                ++total;
            }
        } else {
            if (HussarUtils.isEmpty(userSelectInfos)) {
                return null;
            }
            List userSelectInfo = JSON.parseArray((String)JSON.toJSONString(userSelectInfos), ApplicationMigrationDumpVo.class);
            for (ApplicationMigrationDumpVo userSelected : userSelectInfo) {
                for (EaiApplicationExtendConfiguration configuration : dtos) {
                    if (!configuration.getConfigType().equals(userSelected.getTypeName())) continue;
                    LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiApplicationExtendConfiguration::getApplicationCode, (Object)appCode)).eq(EaiApplicationExtendConfiguration::getConfigType, (Object)configuration.getConfigType());
                    EaiApplicationExtendConfiguration localConfiguration = (EaiApplicationExtendConfiguration)this.eaiApplicationExtendConfigurationService.getOne((Wrapper)wrapper);
                    if (HussarUtils.isNotEmpty((Object)localConfiguration)) {
                        configuration.setConfigId(localConfiguration.getConfigId());
                    } else {
                        configuration.setConfigId(EngineUtil.getId());
                    }
                    this.eaiApplicationExtendConfigurationService.saveOrUpdate((Object)configuration);
                    voList.add(this.newLoadVo(configuration, AppMigrationDataChangeTypeEnum.UPDATE.getType()));
                    ++total;
                }
            }
        }
        EaiMigrationLoadDto result = new EaiMigrationLoadDto();
        result.setList(HussarTreeParser.getTreeList(voList));
        result.setTotal(total);
        return result;
    }

    private ApplicationMigrationDumpVo newLoadVo(EaiApplicationExtendConfiguration configuration, int type) {
        return new ApplicationMigrationDumpVo(String.valueOf(EngineUtil.getId()), configuration.getConfigType(), this.getName(configuration.getConfigType()), type, this.getName(configuration.getConfigType()));
    }

    private EaiApplicationExtendConfiguration createNewConfiguration(String appCode) {
        EaiApplicationExtendConfiguration commonConfiguration = new EaiApplicationExtendConfiguration();
        commonConfiguration.setConfigId(EngineUtil.getId());
        commonConfiguration.setApplicationCode(appCode);
        commonConfiguration.setCreateBy(BaseSecurityUtil.getUser().getUserName());
        return commonConfiguration;
    }

    private static int getType(EaiApplicationExtendConfiguration configuration, List<EaiApplicationExtendConfiguration> oldList) {
        boolean update = false;
        for (EaiApplicationExtendConfiguration old : oldList) {
            if (!configuration.getConfigType().equals(old.getConfigType())) continue;
            update = true;
            break;
        }
        int type = update ? AppMigrationDataChangeTypeEnum.UPDATE.getType() : AppMigrationDataChangeTypeEnum.ADD.getType();
        return type;
    }

    private List<EaiApplicationExtendConfiguration> getLocalConfig(String appCode) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(EaiApplicationExtendConfiguration::getApplicationCode, (Object)appCode);
        return this.eaiApplicationExtendConfigurationService.list((Wrapper)queryWrapper);
    }

    public ApplicationMigrationExportEnum dumpType() {
        return ApplicationMigrationExportEnum.APP_EXTEND_CONFIG_FILE;
    }
}

