/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.migration.preview.app.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.dto.SysApplicationDto;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.migration.business.dump.vo.ApplicationMigrationDumpVo;
import com.jxdinfo.hussar.eai.migration.business.enums.AppMigrationDataChangeTypeEnum;
import com.jxdinfo.hussar.eai.migration.business.enums.ApplicationMigrationDataTypeEnum;
import com.jxdinfo.hussar.eai.migration.business.migration.preview.app.service.IEaiMigrationAppDumpService;
import com.jxdinfo.hussar.eai.migration.business.service.IEaiNewAppService;
import com.jxdinfo.hussar.eai.migration.dto.EaiCommonResourcesDto;
import com.jxdinfo.hussar.eai.migration.dump.dto.EaiMigrationLoadDto;
import com.jxdinfo.hussar.eai.migration.enums.ApplicationMigrationExportEnum;
import com.jxdinfo.hussar.iam.client.service.ISysClientModelService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.migration.business.migration.preview.app.service.impl.EaiMigrationAppDumpServiceImpl")
public class EaiMigrationAppDumpServiceImpl
implements IEaiMigrationAppDumpService {
    @Autowired
    private ISysApplicationService sysApplicationService;
    @Autowired
    private ISysClientModelService sysClientModelService;
    @Autowired
    private IEaiNewAppService eaiNewAppService;

    public List<ApplicationMigrationDumpVo> dumpList(List<SysApplication> result, EaiCommonResourcesDto commonResources) {
        if (HussarUtils.isEmpty(result)) {
            return Collections.emptyList();
        }
        SysApplication application = result.get(0);
        ArrayList<ApplicationMigrationDumpVo> dumpVoList = new ArrayList<ApplicationMigrationDumpVo>();
        dumpVoList.add(new ApplicationMigrationDumpVo(String.valueOf(EngineUtil.getId()), ApplicationMigrationDataTypeEnum.APP_NAME.getTypeName(), application.getAppName()));
        dumpVoList.add(new ApplicationMigrationDumpVo(String.valueOf(EngineUtil.getId()), ApplicationMigrationDataTypeEnum.APP_CODE.getTypeName(), application.getAppCode()));
        dumpVoList.add(new ApplicationMigrationDumpVo(String.valueOf(EngineUtil.getId()), ApplicationMigrationDataTypeEnum.APP_DESCRIBE.getTypeName(), application.getAppDescribe()));
        return dumpVoList;
    }

    public List<ApplicationMigrationDumpVo> preload(String appCode, Boolean isNewAppCode, List<SysApplication> args) {
        if (ToolUtil.isEmpty(args)) {
            return Collections.emptyList();
        }
        List dtos = JSON.parseArray((String)JSON.toJSONString(args), SysApplication.class);
        SysApplication dumpApplication = (SysApplication)dtos.get(0);
        ArrayList<ApplicationMigrationDumpVo> preloadVoList = new ArrayList<ApplicationMigrationDumpVo>();
        int changeNameType = AppMigrationDataChangeTypeEnum.ADD.getType();
        int changeCodeType = AppMigrationDataChangeTypeEnum.ADD.getType();
        String localAppName = dumpApplication.getAppName();
        String localAppCode = dumpApplication.getAppCode();
        String localDescribe = dumpApplication.getAppDescribe();
        if (!isNewAppCode.booleanValue()) {
            SysApplication application = (SysApplication)this.sysApplicationService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysApplication::getAppCode, (Object)appCode));
            changeNameType = dumpApplication.getAppName().equals(application.getAppName()) ? AppMigrationDataChangeTypeEnum.UNCHANGED.getType() : AppMigrationDataChangeTypeEnum.UPDATE.getType();
            localAppName = application.getAppName();
            localAppCode = application.getAppCode();
            localDescribe = application.getAppDescribe();
            changeCodeType = AppMigrationDataChangeTypeEnum.UNCHANGED.getType();
        }
        preloadVoList.add(new ApplicationMigrationDumpVo(String.valueOf(EngineUtil.getId()), Integer.valueOf(ApplicationMigrationDataTypeEnum.APP_NAME.getType()), ApplicationMigrationDataTypeEnum.APP_NAME.getTypeName(), dumpApplication.getAppName(), changeNameType, localAppName));
        preloadVoList.add(new ApplicationMigrationDumpVo(String.valueOf(EngineUtil.getId()), Integer.valueOf(ApplicationMigrationDataTypeEnum.APP_CODE.getType()), ApplicationMigrationDataTypeEnum.APP_CODE.getTypeName(), appCode, changeCodeType, localAppCode));
        preloadVoList.add(new ApplicationMigrationDumpVo(String.valueOf(EngineUtil.getId()), Integer.valueOf(ApplicationMigrationDataTypeEnum.APP_DESCRIBE.getType()), ApplicationMigrationDataTypeEnum.APP_DESCRIBE.getTypeName(), dumpApplication.getAppDescribe(), changeCodeType, localDescribe));
        return preloadVoList;
    }

    public EaiMigrationLoadDto<ApplicationMigrationDumpVo> load(String appCode, Boolean isNewAppCode, List<ApplicationMigrationDumpVo> dumpVos, List<SysApplication> args) {
        if (HussarUtils.isEmpty(args)) {
            throw new BaseException("\u65e0\u5e94\u7528\u4fe1\u606f");
        }
        List dtos = JSON.parseArray((String)JSON.toJSONString(args), SysApplication.class);
        int total = 0;
        ArrayList<ApplicationMigrationDumpVo> voList = new ArrayList<ApplicationMigrationDumpVo>();
        SysApplication sysApplication = (SysApplication)dtos.get(0);
        if (isNewAppCode.booleanValue()) {
            SysApplicationDto sysApplicationDto = (SysApplicationDto)BeanUtil.copyProperties((Object)sysApplication, SysApplicationDto.class);
            sysApplicationDto.setAppCode(appCode);
            sysApplicationDto.setReleaseStatus("0");
            this.eaiNewAppService.addApp(sysApplicationDto);
            voList.add(new ApplicationMigrationDumpVo(String.valueOf(EngineUtil.getId()), Integer.valueOf(ApplicationMigrationDataTypeEnum.APP_NAME.getType()), ApplicationMigrationDataTypeEnum.APP_NAME.getTypeName(), sysApplicationDto.getAppName(), AppMigrationDataChangeTypeEnum.ADD.getType(), sysApplicationDto.getAppName()));
            voList.add(new ApplicationMigrationDumpVo(String.valueOf(EngineUtil.getId()), Integer.valueOf(ApplicationMigrationDataTypeEnum.APP_CODE.getType()), ApplicationMigrationDataTypeEnum.APP_CODE.getTypeName(), appCode, AppMigrationDataChangeTypeEnum.ADD.getType(), appCode));
            voList.add(new ApplicationMigrationDumpVo(String.valueOf(EngineUtil.getId()), Integer.valueOf(ApplicationMigrationDataTypeEnum.APP_DESCRIBE.getType()), ApplicationMigrationDataTypeEnum.APP_DESCRIBE.getTypeName(), sysApplicationDto.getAppDescribe(), AppMigrationDataChangeTypeEnum.ADD.getType(), sysApplicationDto.getAppDescribe()));
            total += 3;
        } else {
            if (HussarUtils.isEmpty(dumpVos)) {
                return null;
            }
            List dumpVoList = JSON.parseArray((String)JSON.toJSONString(dumpVos), ApplicationMigrationDumpVo.class);
            SysApplicationDto application = new SysApplicationDto();
            SysApplication localApp = (SysApplication)this.sysApplicationService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysApplication::getAppCode, (Object)appCode));
            application.setId(localApp.getId());
            for (ApplicationMigrationDumpVo loadDto : dumpVoList) {
                if (HussarUtils.isEmpty((Object)loadDto.getType())) continue;
                if (ApplicationMigrationDataTypeEnum.APP_NAME.getType() == loadDto.getType().intValue()) {
                    application.setAppName(loadDto.getLabel());
                    voList.add(this.newLoadApp(loadDto, localApp, ApplicationMigrationDataTypeEnum.APP_NAME));
                    ++total;
                    continue;
                }
                if (ApplicationMigrationDataTypeEnum.APP_CODE.getType() == loadDto.getType().intValue()) {
                    application.setAppCode(appCode);
                    voList.add(this.newLoadApp(loadDto, localApp, ApplicationMigrationDataTypeEnum.APP_CODE));
                    ++total;
                    continue;
                }
                if (ApplicationMigrationDataTypeEnum.APP_DESCRIBE.getType() != loadDto.getType().intValue()) continue;
                application.setAppDescribe(loadDto.getLabel());
                voList.add(this.newLoadApp(loadDto, localApp, ApplicationMigrationDataTypeEnum.APP_DESCRIBE));
                ++total;
            }
            this.sysApplicationService.updateById((Object)application);
        }
        EaiMigrationLoadDto result = new EaiMigrationLoadDto();
        result.setList(HussarTreeParser.getTreeList(voList));
        result.setTotal(total);
        return result;
    }

    private ApplicationMigrationDumpVo newLoadApp(ApplicationMigrationDumpVo loadDto, SysApplication localApp, ApplicationMigrationDataTypeEnum typeEnum) {
        return new ApplicationMigrationDumpVo(String.valueOf(EngineUtil.getId()), Integer.valueOf(typeEnum.getType()), typeEnum.getTypeName(), loadDto.getLabel(), loadDto.getChangeType(), localApp.getAppDescribe());
    }

    public ApplicationMigrationExportEnum dumpType() {
        return ApplicationMigrationExportEnum.APP_CODE_FILE;
    }
}

