/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.migration.preview.api.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiCallSpecificationInfo;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiInfo;
import com.jxdinfo.hussar.eai.apiinfo.api.model.EaiApiClassification;
import com.jxdinfo.hussar.eai.apiinfo.api.model.EditApi;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IApiCallSpecificationInfoService;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiApiClassificationService;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiApiInfoService;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiEditApiService;
import com.jxdinfo.hussar.eai.apirelease.api.model.EaiApiClassificationVersion;
import com.jxdinfo.hussar.eai.apirelease.api.model.EaiApiVersion;
import com.jxdinfo.hussar.eai.common.enums.app.EaiResourcesEnum;
import com.jxdinfo.hussar.eai.migration.business.bo.ApiInfoUpdateBo;
import com.jxdinfo.hussar.eai.migration.business.bo.ConnectionUpdateBo;
import com.jxdinfo.hussar.eai.migration.business.bo.ConstantUpdateBo;
import com.jxdinfo.hussar.eai.migration.business.bo.LogicUpdateBo;
import com.jxdinfo.hussar.eai.migration.business.bo.StructureUpdateBo;
import com.jxdinfo.hussar.eai.migration.business.bo.WsdlTemplateUpdateBo;
import com.jxdinfo.hussar.eai.migration.business.dump.vo.AppApiMigrationDumpVo;
import com.jxdinfo.hussar.eai.migration.business.enums.AppApiMigrationDataTypeEnum;
import com.jxdinfo.hussar.eai.migration.business.enums.AppMigrationDataChangeTypeEnum;
import com.jxdinfo.hussar.eai.migration.business.manager.EaiUpdateDetailManager;
import com.jxdinfo.hussar.eai.migration.business.migration.preview.api.service.IEaiMigrationApiDumpService;
import com.jxdinfo.hussar.eai.migration.business.resources.api.factory.EaiApiExtraResourcesFactory;
import com.jxdinfo.hussar.eai.migration.business.resources.api.service.IEaiApiConfigService;
import com.jxdinfo.hussar.eai.migration.business.service.IEaiMigrationRemoveApiService;
import com.jxdinfo.hussar.eai.migration.dto.EaiCommonLogicDto;
import com.jxdinfo.hussar.eai.migration.dto.EaiCommonResourcesDto;
import com.jxdinfo.hussar.eai.migration.dump.dto.EaiMigrationLoadDto;
import com.jxdinfo.hussar.eai.migration.enums.ApplicationMigrationExportEnum;
import com.jxdinfo.hussar.eai.migration.resources.api.dto.ApiResourceCodeMaps;
import com.jxdinfo.hussar.eai.migration.resources.api.dto.EaiApiResourcesDto;
import com.jxdinfo.hussar.eai.resourcebase.api.service.ICommonStructureService;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.ConstantVersion;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.StructureVersion;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CanvasInfo;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICanvasInfoService;
import com.jxdinfo.hussar.eai.resourceexternalopen.api.model.ConnectionVersion;
import com.jxdinfo.hussar.eai.resourceexternalopen.api.model.LogicVersion;
import com.jxdinfo.hussar.eai.webservice.manager.api.model.EaiAppWsdlVersion;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.migration.business.migration.preview.api.service.impl.EaiMigrationApiDumpServiceImpl")
public class EaiMigrationApiDumpServiceImpl
implements IEaiMigrationApiDumpService {
    @Resource
    private IEaiApiClassificationService eaiApiClassificationService;
    @Resource
    private IEaiApiInfoService eaiApiInfoService;
    @Resource
    private IEaiEditApiService eaiEditApiService;
    @Resource
    private ICanvasInfoService eaiCanvasInfoService;
    @Resource
    private IApiCallSpecificationInfoService apiCallSpecificationInfoService;
    @Resource
    private IEaiMigrationRemoveApiService eaiMigrationRemoveApiService;
    @Resource
    private ICommonStructureService commonStructureService;
    @Resource
    private EaiUpdateDetailManager eaiUpdateDetailManager;
    private static final String WSDL = "wsdl";

    public ApplicationMigrationExportEnum dumpType() {
        return ApplicationMigrationExportEnum.APP_API_INFO_FILE;
    }

    public List<AppApiMigrationDumpVo> dumpList(List<EaiApiResourcesDto> result, EaiCommonResourcesDto commonResources) {
        if (HussarUtils.isEmpty(result)) {
            return Collections.emptyList();
        }
        ArrayList<AppApiMigrationDumpVo> dumpList = new ArrayList<AppApiMigrationDumpVo>();
        for (EaiApiResourcesDto apiResourcesDto : result) {
            List apiVersions = apiResourcesDto.getApiVersionList();
            List classificationList = apiResourcesDto.getClassificationList();
            this.addClassificationDumpVos(dumpList, apiVersions, classificationList);
            if (!HussarUtils.isNotEmpty((Object)apiVersions)) continue;
            for (EaiApiVersion apiInfo : apiVersions) {
                dumpList.add(this.getApiInfoDumpVo(apiInfo));
                List resourceCodeMaps = apiResourcesDto.getApiResourceCodeMaps();
                if (!HussarUtils.isNotEmpty((Object)resourceCodeMaps)) continue;
                for (ApiResourceCodeMaps resourceCodeMap : resourceCodeMaps) {
                    if (!apiInfo.getApiCode().equals(resourceCodeMap.getApiCode())) continue;
                    dumpList.addAll(this.getResultDumpVo(apiInfo.getApiVersionId(), resourceCodeMap, commonResources));
                }
            }
        }
        return HussarTreeParser.getTreeList(dumpList);
    }

    public List<AppApiMigrationDumpVo> preload(String appCode, Boolean isNewAppCode, List<EaiApiResourcesDto> args) {
        if (HussarUtils.isEmpty(args)) {
            return Collections.emptyList();
        }
        ArrayList<AppApiMigrationDumpVo> preloadVoList = new ArrayList<AppApiMigrationDumpVo>();
        List dtos = JSON.parseArray((String)JSON.toJSONString(args), EaiApiResourcesDto.class);
        for (EaiApiResourcesDto apiResourcesDto : dtos) {
            List apiVersions = apiResourcesDto.getApiVersionList();
            this.apiVersionsPreLoad(preloadVoList, apiVersions, appCode, apiResourcesDto);
            List classificationList = apiResourcesDto.getClassificationList();
            if (!HussarUtils.isNotEmpty((Object)classificationList)) continue;
            this.classificationPreLoad(preloadVoList, classificationList, appCode);
        }
        return HussarTreeParser.getTreeList(preloadVoList);
    }

    public EaiMigrationLoadDto<AppApiMigrationDumpVo> load(String appCode, Boolean isNewAppCode, List<AppApiMigrationDumpVo> userSelectInfos, List<EaiApiResourcesDto> args) {
        ArrayList<AppApiMigrationDumpVo> voList = new ArrayList<AppApiMigrationDumpVo>();
        int total = 0;
        if (HussarUtils.isEmpty(args)) {
            return null;
        }
        List userSelectInfo = JSON.parseArray((String)JSON.toJSONString(userSelectInfos), AppApiMigrationDumpVo.class);
        if (isNewAppCode.booleanValue()) {
            voList.addAll(userSelectInfo);
            for (EaiApiResourcesDto apiResourcesDto : args) {
                total += this.addAllApi(apiResourcesDto, appCode, voList);
            }
        } else {
            voList.addAll(userSelectInfo);
            for (AppApiMigrationDumpVo userSelected : userSelectInfo) {
                for (EaiApiResourcesDto apiResourcesDto : args) {
                    List apiVersions = apiResourcesDto.getApiVersionList();
                    if (HussarUtils.isEmpty((Object)apiVersions)) continue;
                    if (AppMigrationDataChangeTypeEnum.UPDATE.getType() == userSelected.getChangeType()) {
                        for (EaiApiVersion apiVersion : apiVersions) {
                            if (!apiVersion.getApiCode().equals(userSelected.getCode())) continue;
                            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ApiInfo::getApplicationCode, (Object)appCode)).eq(ApiInfo::getApiCode, (Object)apiVersion.getApiCode());
                            ApiInfo apiInfo = (ApiInfo)this.eaiApiInfoService.getOne((Wrapper)wrapper);
                            ApiInfo saveApi = (ApiInfo)BeanUtil.copyProperties((Object)apiVersion, ApiInfo.class);
                            this.setApiInfo(apiInfo.getId(), appCode, saveApi, apiInfo);
                            this.eaiMigrationRemoveApiService.removeById(apiInfo.getId(), appCode);
                            this.addNewApi(apiVersion.getApiVersionId(), saveApi, apiResourcesDto, appCode);
                            ++total;
                        }
                        continue;
                    }
                    if (AppMigrationDataChangeTypeEnum.ADD.getType() != userSelected.getChangeType()) continue;
                    for (EaiApiVersion apiVersion : apiVersions) {
                        if (!apiVersion.getApiCode().equals(userSelected.getCode())) continue;
                        ApiInfo saveApi = (ApiInfo)BeanUtil.copyProperties((Object)apiVersion, ApiInfo.class);
                        Long id = EngineUtil.getId();
                        this.setApiInfo(id, appCode, saveApi, new ApiInfo());
                        this.addNewApi(apiVersion.getApiVersionId(), saveApi, apiResourcesDto, appCode);
                        ++total;
                    }
                }
            }
        }
        EaiMigrationLoadDto result = new EaiMigrationLoadDto();
        result.setList(this.getTreeList(voList, isNewAppCode));
        result.setTotal(total);
        return result;
    }

    private List<AppApiMigrationDumpVo> getTreeList(List<AppApiMigrationDumpVo> voList, Boolean isNewAppCode) {
        if (isNewAppCode.booleanValue()) {
            return HussarTreeParser.getTreeList(voList);
        }
        ArrayList<AppApiMigrationDumpVo> result = new ArrayList<AppApiMigrationDumpVo>();
        for (AppApiMigrationDumpVo vo : voList) {
            if (!HussarUtils.isNotEmpty((Object)vo.getType()) || AppApiMigrationDataTypeEnum.API.getType() != vo.getType()) continue;
            ArrayList<AppApiMigrationDumpVo> childList = new ArrayList<AppApiMigrationDumpVo>();
            String id = (String)((Object)vo.getId());
            for (AppApiMigrationDumpVo child : voList) {
                if (!id.equals(child.getParentId())) continue;
                childList.add(child);
            }
            vo.setChildren(childList);
            result.add(vo);
        }
        return result;
    }

    private int addNewApi(Long oldId, ApiInfo saveApi, EaiApiResourcesDto apiResourcesDto, String appCode) {
        int i = 0;
        if (!HussarUtils.isEmpty((Object)saveApi.getClassificId())) {
            i += this.saveClassific(saveApi, apiResourcesDto, appCode);
        }
        this.eaiApiInfoService.save((Object)saveApi);
        ++i;
        i += this.saveEditApi(oldId, saveApi.getId(), apiResourcesDto);
        i += this.saveCallSpecificationInfoList(oldId, saveApi.getId(), apiResourcesDto);
        return i += this.saveExtra(oldId, saveApi.getId(), apiResourcesDto);
    }

    private int saveExtra(Long oldId, Long newId, EaiApiResourcesDto apiResourcesDto) {
        if (HussarUtils.isEmpty((Object)apiResourcesDto.getExtraList())) {
            return 0;
        }
        int i = 0;
        Map extras = apiResourcesDto.getExtraList();
        for (Map.Entry entry : extras.entrySet()) {
            IEaiApiConfigService service = EaiApiExtraResourcesFactory.getByModel((String)entry.getKey());
            if (!HussarUtils.isNotEmpty((Object)service)) continue;
            i += service.saveExtraList(oldId, newId, new ArrayList((Collection)entry.getValue()));
        }
        return i;
    }

    private int saveCallSpecificationInfoList(Long oldId, Long newId, EaiApiResourcesDto apiResourcesDto) {
        List callSpecificationInfos = apiResourcesDto.getCallSpecificationInfoList();
        if (HussarUtils.isEmpty((Object)callSpecificationInfos)) {
            return 0;
        }
        ArrayList<ApiCallSpecificationInfo> list = new ArrayList<ApiCallSpecificationInfo>();
        for (ApiCallSpecificationInfo callSpecificationInfo : callSpecificationInfos) {
            if (!oldId.equals(callSpecificationInfo.getApiId())) continue;
            callSpecificationInfo.setApiId(newId);
            list.add(callSpecificationInfo);
        }
        if (HussarUtils.isNotEmpty(list)) {
            this.apiCallSpecificationInfoService.saveBatch(list);
            return list.size();
        }
        return 0;
    }

    private int saveEditApi(Long oldId, Long newId, EaiApiResourcesDto apiResourcesDto) {
        int i = 0;
        Map map = apiResourcesDto.getEditApiList().stream().collect(Collectors.toMap(EditApi::getApiId, Function.identity()));
        if (map.containsKey(oldId)) {
            EditApi editApi = (EditApi)map.get(oldId);
            editApi.setId(EngineUtil.getId());
            editApi.setApiId(newId);
            if (HussarUtils.isNotEmpty((Object)editApi.getCanvasId())) {
                Long id = this.saveNewCanvas(editApi.getCanvasId(), apiResourcesDto);
                editApi.setCanvasId(id);
                ++i;
            }
            this.eaiEditApiService.save((Object)editApi);
            ++i;
        }
        return i;
    }

    private Long saveNewCanvas(Long canvasId, EaiApiResourcesDto commonResourcesDto) {
        Map map = commonResourcesDto.getCanvasInfoList().stream().collect(Collectors.toMap(CanvasInfo::getId, Function.identity()));
        if (map.containsKey(canvasId)) {
            CanvasInfo canvasInfo = (CanvasInfo)map.get(canvasId);
            Long id = EngineUtil.getId();
            canvasInfo.setId(id);
            this.eaiCanvasInfoService.save((Object)canvasInfo);
            return id;
        }
        return null;
    }

    private int saveClassific(ApiInfo saveApi, EaiApiResourcesDto apiResourcesDto, String appCode) {
        Map classificationVersionMap;
        int i = 0;
        saveApi.setApplicationCode(appCode);
        if (HussarUtils.isNotEmpty((Object)apiResourcesDto.getClassificationList()) && (classificationVersionMap = apiResourcesDto.getClassificationList().stream().collect(Collectors.toMap(EaiApiClassificationVersion::getId, Function.identity()))).containsKey(saveApi.getClassificId())) {
            EaiApiClassificationVersion classificationVersion = (EaiApiClassificationVersion)classificationVersionMap.get(saveApi.getClassificId());
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiApiClassification::getApplicationCode, (Object)appCode)).eq(EaiApiClassification::getClassificName, (Object)classificationVersion.getClassificName());
            List classifications = this.eaiApiClassificationService.list((Wrapper)queryWrapper);
            if (HussarUtils.isNotEmpty((Object)classifications)) {
                saveApi.setClassificId(((EaiApiClassification)classifications.get(0)).getId());
            } else {
                Long id = EngineUtil.getId();
                saveApi.setClassificId(id);
                EaiApiClassification classification = (EaiApiClassification)BeanUtil.copyProperties((Object)classificationVersion, EaiApiClassification.class);
                classification.setId(id);
                this.eaiApiClassificationService.save((Object)classification);
                i = 1;
            }
        }
        return i;
    }

    private int addAllApi(EaiApiResourcesDto apiResourcesDto, String appCode, List<AppApiMigrationDumpVo> voList) {
        int total = 0;
        if (HussarUtils.isNotEmpty((Object)apiResourcesDto.getApiVersionList())) {
            Map<Long, Long> classificationMap = this.addClassification(apiResourcesDto.getClassificationList(), appCode);
            Map<Long, Long> apiMap = this.addApiInfo(apiResourcesDto.getApiVersionList(), classificationMap, appCode, voList);
            if (HussarUtils.isEmpty(apiMap)) {
                return 0;
            }
            total += apiMap.size();
            Map<Long, Long> canvasMap = this.addCanvasInfo(apiResourcesDto.getCanvasInfoList());
            if (!HussarUtils.isEmpty(canvasMap)) {
                total += canvasMap.size();
            }
            total += this.addCallSpecificationInfoList(apiResourcesDto.getCallSpecificationInfoList(), apiMap);
            total += this.addEditApi(apiResourcesDto.getEditApiList(), apiMap, canvasMap);
            total += this.addExtraApi(apiResourcesDto.getExtraList(), apiMap);
            ++total;
        }
        return total;
    }

    private int addExtraApi(Map<String, List> map, Map<Long, Long> apiMap) {
        if (HussarUtils.isEmpty(map)) {
            return 0;
        }
        int i = 0;
        for (Map.Entry<String, List> entry : map.entrySet()) {
            IEaiApiConfigService service = EaiApiExtraResourcesFactory.getByModel(entry.getKey());
            if (!HussarUtils.isNotEmpty((Object)service)) continue;
            i += service.saveExtraList(new ArrayList(entry.getValue()), apiMap);
        }
        return i;
    }

    private int addEditApi(List<EditApi> editApis, Map<Long, Long> apiMap, Map<Long, Long> canvasMap) {
        if (HussarUtils.isEmpty(editApis)) {
            return 0;
        }
        for (EditApi editApi : editApis) {
            editApi.setApiId(apiMap.get(editApi.getApiId()));
            editApi.setId(EngineUtil.getId());
            if (editApi.getCanvasId() != null && canvasMap.containsKey(editApi.getCanvasId())) {
                editApi.setCanvasId(canvasMap.get(editApi.getCanvasId()));
                continue;
            }
            editApi.setCanvasId(null);
        }
        this.eaiEditApiService.saveBatch(editApis);
        return editApis.size();
    }

    private int addCallSpecificationInfoList(List<ApiCallSpecificationInfo> callSpecificationInfos, Map<Long, Long> classifiMap) {
        if (HussarUtils.isEmpty(callSpecificationInfos)) {
            return 0;
        }
        ArrayList<ApiCallSpecificationInfo> list = new ArrayList<ApiCallSpecificationInfo>();
        for (ApiCallSpecificationInfo callSpecificationInfo : callSpecificationInfos) {
            if (!classifiMap.containsKey(callSpecificationInfo.getApiId())) continue;
            callSpecificationInfo.setApiId(classifiMap.get(callSpecificationInfo.getApiId()));
            callSpecificationInfo.setSpecificatId(EngineUtil.getId());
            list.add(callSpecificationInfo);
        }
        if (HussarUtils.isNotEmpty(list)) {
            this.apiCallSpecificationInfoService.saveBatch(list);
        }
        return list.size();
    }

    private Map<Long, Long> addCanvasInfo(List<CanvasInfo> canvasInfos) {
        if (HussarUtils.isEmpty(canvasInfos)) {
            return null;
        }
        ArrayList<CanvasInfo> list = new ArrayList<CanvasInfo>();
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        for (CanvasInfo canvasInfo : canvasInfos) {
            Long id = EngineUtil.getId();
            map.put(canvasInfo.getId(), id);
            canvasInfo.setId(id);
            list.add(canvasInfo);
        }
        this.eaiCanvasInfoService.saveBatch(list);
        return map;
    }

    private Map<Long, Long> addClassification(List<EaiApiClassificationVersion> classificationVersions, String appCode) {
        if (HussarUtils.isEmpty(classificationVersions)) {
            return null;
        }
        ArrayList<EaiApiClassification> list = new ArrayList<EaiApiClassification>();
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        for (EaiApiClassificationVersion classificationVersion : classificationVersions) {
            EaiApiClassification classification = (EaiApiClassification)BeanUtil.copyProperties((Object)classificationVersion, EaiApiClassification.class);
            Long id = EngineUtil.getId();
            classification.setId(id);
            classification.setApplicationCode(appCode);
            list.add(classification);
            map.put(classificationVersion.getId(), id);
        }
        this.eaiApiClassificationService.saveBatch(list);
        return map;
    }

    private Map<Long, Long> addApiInfo(List<EaiApiVersion> apiVersions, Map<Long, Long> classifiMap, String appCode, List<AppApiMigrationDumpVo> voList) {
        if (HussarUtils.isEmpty(apiVersions)) {
            return null;
        }
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        ArrayList<ApiInfo> list = new ArrayList<ApiInfo>();
        for (EaiApiVersion apiVersion : apiVersions) {
            voList.add(this.getApiInfoDumpVo(apiVersion, AppMigrationDataChangeTypeEnum.ADD.getType()));
            ApiInfo apiInfo = (ApiInfo)BeanUtil.copyProperties((Object)apiVersion, ApiInfo.class);
            Long id = EngineUtil.getId();
            this.setApiInfo(id, appCode, apiInfo, new ApiInfo());
            if (classifiMap != null && classifiMap.containsKey(apiInfo.getClassificId())) {
                apiInfo.setClassificId(classifiMap.get(apiInfo.getClassificId()));
            }
            apiInfo.setApplicationCode(appCode);
            map.put(apiVersion.getApiVersionId(), id);
            list.add(apiInfo);
        }
        this.eaiApiInfoService.saveBatch(list);
        return map;
    }

    private void setApiInfo(Long id, String appCode, ApiInfo apiInfo, ApiInfo localApi) {
        apiInfo.setId(id);
        apiInfo.setApplicationCode(appCode);
        if (HussarUtils.isEmpty((Object)apiInfo.getPublicState())) {
            if (HussarUtils.isEmpty((Object)localApi.getPublicState())) {
                apiInfo.setPublicState("1");
            } else {
                apiInfo.setPublicState(localApi.getPublicState());
            }
        }
        if (HussarUtils.isEmpty((Object)apiInfo.getApiState())) {
            if (HussarUtils.isEmpty((Object)localApi.getApiState())) {
                apiInfo.setApiState("0");
            } else {
                apiInfo.setApiState(localApi.getApiState());
            }
        }
        apiInfo.setDraftState("0");
        apiInfo.setTestState("0");
    }

    private List<AppApiMigrationDumpVo> getResultDumpVo(Long parentId, ApiResourceCodeMaps resourceCodeMap, EaiCommonResourcesDto commonResources) {
        return this.getResultDumpVo(parentId, resourceCodeMap, commonResources, null);
    }

    private List<AppApiMigrationDumpVo> getResultDumpVo(Long parentId, ApiResourceCodeMaps resourceCodeMap, EaiCommonResourcesDto commonResources, Integer type) {
        List logicMaps;
        List structureMaps;
        List linkMaps;
        List constantMaps;
        ArrayList<AppApiMigrationDumpVo> list = new ArrayList<AppApiMigrationDumpVo>();
        if (HussarUtils.isEmpty((Object)resourceCodeMap.getTypeCodes())) {
            return list;
        }
        List wsdlCodeMaps = (List)resourceCodeMap.getTypeCodes().get(WSDL);
        if (HussarUtils.isNotEmpty((Object)wsdlCodeMaps)) {
            ArrayList<String> wsdlCode = new ArrayList<String>(2);
            if (HussarUtils.isNotEmpty((Object)commonResources.getWsdlList())) {
                for (Object wsdlVersion : commonResources.getWsdlList()) {
                    if (!wsdlCodeMaps.contains(wsdlVersion.getWsdlPath()) || wsdlCode.contains(wsdlVersion.getWsdlPath())) continue;
                    AppApiMigrationDumpVo vo = this.getWSDLDumpVo(parentId, (EaiAppWsdlVersion)wsdlVersion);
                    if (HussarUtils.isNotEmpty((Object)type)) {
                        vo.setUpdateDetailList(this.eaiUpdateDetailManager.getWsdlTemplateDetailList(WsdlTemplateUpdateBo.convert((EaiAppWsdlVersion)wsdlVersion), WsdlTemplateUpdateBo.convert((EaiAppWsdlVersion)new EaiAppWsdlVersion()), type));
                    }
                    list.add(vo);
                    wsdlCode.add(wsdlVersion.getWsdlPath());
                }
            }
        }
        if (HussarUtils.isNotEmpty((Object)(constantMaps = (List)resourceCodeMap.getTypeCodes().get(EaiResourcesEnum.CONSTANT.getType())))) {
            ArrayList constantCode = new ArrayList(8);
            if (HussarUtils.isNotEmpty((Object)commonResources.getConstantList())) {
                for (Object constantVersion : commonResources.getConstantList()) {
                    if (!constantMaps.contains(constantVersion.getConstantNameEn()) || constantCode.contains(constantVersion.getConstantNameEn())) continue;
                    AppApiMigrationDumpVo vo = this.getConstantDumpVo(parentId, (ConstantVersion)constantVersion);
                    if (HussarUtils.isNotEmpty((Object)type)) {
                        vo.setUpdateDetailList(this.eaiUpdateDetailManager.getConstantDetailList(ConstantUpdateBo.convert((ConstantVersion)constantVersion), ConstantUpdateBo.convert((ConstantVersion)new ConstantVersion()), type));
                    }
                    list.add(vo);
                }
            }
        }
        if (HussarUtils.isNotEmpty((Object)(linkMaps = (List)resourceCodeMap.getTypeCodes().get(EaiResourcesEnum.LINK.getType())))) {
            ArrayList<String> linkCode = new ArrayList<String>(4);
            if (HussarUtils.isNotEmpty((Object)commonResources.getConnectionList())) {
                for (Object connectionVersion : commonResources.getConnectionList()) {
                    if (!linkMaps.contains(connectionVersion.getConnectionNameEn()) || linkCode.contains(connectionVersion.getConnectionNameEn())) continue;
                    AppApiMigrationDumpVo vo = this.getConnectionVersionDumpVo(parentId, (ConnectionVersion)connectionVersion);
                    if (HussarUtils.isNotEmpty((Object)type)) {
                        vo.setUpdateDetailList(this.eaiUpdateDetailManager.getConnectionDetailList(ConnectionUpdateBo.convert((ConnectionVersion)connectionVersion), ConnectionUpdateBo.convert((ConnectionVersion)new ConnectionVersion()), type));
                    }
                    list.add(vo);
                    linkCode.add(connectionVersion.getConnectionNameEn());
                }
            }
        }
        if (HussarUtils.isNotEmpty((Object)(structureMaps = (List)resourceCodeMap.getTypeCodes().get(EaiResourcesEnum.STRUCTURE.getType())))) {
            ArrayList<String> code = new ArrayList<String>();
            if (HussarUtils.isNotEmpty((Object)commonResources.getStructureList())) {
                for (StructureVersion structureVersion : commonResources.getStructureList()) {
                    if (!structureMaps.contains(structureVersion.getStructureCode()) || code.contains(structureVersion.getStructureCode())) continue;
                    AppApiMigrationDumpVo vo = this.getStructureVersionDumpVo(parentId, structureVersion);
                    if (HussarUtils.isNotEmpty((Object)type)) {
                        vo.setUpdateDetailList(this.eaiUpdateDetailManager.getStructureDetailList(StructureUpdateBo.convert((StructureVersion)structureVersion), StructureUpdateBo.convert((StructureVersion)new StructureVersion()), type));
                    }
                    list.add(vo);
                    code.add(structureVersion.getStructureCode());
                }
            }
        }
        if (HussarUtils.isNotEmpty((Object)(logicMaps = (List)resourceCodeMap.getTypeCodes().get(EaiResourcesEnum.LOGIC.getType())))) {
            ArrayList<String> logicCode = new ArrayList<String>(4);
            if (HussarUtils.isNotEmpty((Object)commonResources.getCommonLogicList())) {
                for (EaiCommonLogicDto logicDto : commonResources.getCommonLogicList()) {
                    LogicVersion logicVersion = logicDto.getLogicVersion();
                    if (!logicMaps.contains(logicVersion.getLogicCode()) || logicCode.contains(logicVersion.getLogicCode())) continue;
                    AppApiMigrationDumpVo vo = this.getLogicVersionDumpVo(parentId, logicVersion);
                    if (HussarUtils.isNotEmpty((Object)type)) {
                        vo.setUpdateDetailList(this.eaiUpdateDetailManager.getLogicDetailList(LogicUpdateBo.convert((LogicVersion)logicVersion), LogicUpdateBo.convert((LogicVersion)new LogicVersion()), type));
                    }
                    list.add(vo);
                    logicCode.add(logicVersion.getLogicCode());
                }
            }
        }
        return list;
    }

    private AppApiMigrationDumpVo getLogicVersionDumpVo(Long parentId, LogicVersion logicVersion) {
        AppApiMigrationDumpVo dumpVo = new AppApiMigrationDumpVo();
        dumpVo.setId(logicVersion.getId());
        dumpVo.setLabel(logicVersion.getLogicName());
        dumpVo.setCode(logicVersion.getLogicCode());
        dumpVo.setParentId(parentId);
        dumpVo.setType(AppApiMigrationDataTypeEnum.LOGIC.getType());
        dumpVo.setTypeName(AppApiMigrationDataTypeEnum.LOGIC.getTypeName());
        dumpVo.setHasChildren(Boolean.valueOf(false));
        dumpVo.setIcon("tree-logic");
        return dumpVo;
    }

    private AppApiMigrationDumpVo getStructureVersionDumpVo(Long parentId, StructureVersion structureVersion) {
        AppApiMigrationDumpVo dumpVo = new AppApiMigrationDumpVo();
        dumpVo.setId(structureVersion.getId());
        dumpVo.setLabel(HussarUtils.isEmpty((Object)structureVersion.getStructureName()) ? structureVersion.getStructureCode() : structureVersion.getStructureName());
        dumpVo.setCode(structureVersion.getStructureCode());
        dumpVo.setParentId(parentId);
        dumpVo.setType(AppApiMigrationDataTypeEnum.STRUCTURE.getType());
        dumpVo.setTypeName(AppApiMigrationDataTypeEnum.STRUCTURE.getTypeName());
        dumpVo.setHasChildren(Boolean.valueOf(false));
        dumpVo.setIcon("tree-data-structure");
        return dumpVo;
    }

    private AppApiMigrationDumpVo getConnectionVersionDumpVo(Long parentId, ConnectionVersion conn) {
        AppApiMigrationDumpVo dumpVo = new AppApiMigrationDumpVo();
        dumpVo.setId(conn.getId());
        dumpVo.setLabel(HussarUtils.isEmpty((Object)conn.getConnectionName()) ? conn.getConnectionName() : conn.getConnectionNameEn());
        dumpVo.setCode(conn.getConnectionNameEn());
        dumpVo.setParentId(parentId);
        dumpVo.setType(AppApiMigrationDataTypeEnum.CONNECTION.getType());
        dumpVo.setTypeName(AppApiMigrationDataTypeEnum.CONNECTION.getTypeName());
        dumpVo.setHasChildren(Boolean.valueOf(false));
        dumpVo.setIcon("tree-connection-config");
        return dumpVo;
    }

    private AppApiMigrationDumpVo getConstantDumpVo(Long parentId, ConstantVersion constant) {
        AppApiMigrationDumpVo dumpVo = new AppApiMigrationDumpVo();
        dumpVo.setId(constant.getId());
        dumpVo.setLabel(HussarUtils.isEmpty((Object)constant.getConstantName()) ? constant.getConstantNameEn() : constant.getConstantName());
        dumpVo.setCode(constant.getConstantNameEn());
        dumpVo.setParentId(parentId);
        dumpVo.setType(AppApiMigrationDataTypeEnum.CONSTANT.getType());
        dumpVo.setTypeName(AppApiMigrationDataTypeEnum.CONSTANT.getTypeName());
        dumpVo.setHasChildren(Boolean.valueOf(false));
        dumpVo.setIcon("tree-constant");
        return dumpVo;
    }

    private AppApiMigrationDumpVo getWSDLDumpVo(Long parentId, EaiAppWsdlVersion wsdlVersion) {
        AppApiMigrationDumpVo dumpVo = new AppApiMigrationDumpVo();
        dumpVo.setId(wsdlVersion.getId());
        dumpVo.setLabel(wsdlVersion.getWsdlName());
        dumpVo.setCode(wsdlVersion.getWsdlPath());
        dumpVo.setParentId(parentId);
        dumpVo.setCode(wsdlVersion.getWsdlPath());
        dumpVo.setType(AppApiMigrationDataTypeEnum.WSDL.getType());
        dumpVo.setTypeName(AppApiMigrationDataTypeEnum.WSDL.getTypeName());
        dumpVo.setHasChildren(Boolean.valueOf(false));
        dumpVo.setIcon("tree-Webservice-port");
        return dumpVo;
    }

    private void apiVersionsPreLoad(List<AppApiMigrationDumpVo> preloadVoList, List<EaiApiVersion> apiVersions, String appCode, EaiApiResourcesDto apiResourcesDto) {
        if (HussarUtils.isEmpty(apiVersions)) {
            return;
        }
        List codes = apiVersions.stream().map(EaiApiVersion::getApiCode).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{ApiInfo::getApiCode}).eq(ApiInfo::getApplicationCode, (Object)appCode)).in(ApiInfo::getApiCode, codes);
        List apiInfos = this.eaiApiInfoService.list((Wrapper)queryWrapper);
        List apiCode = null;
        if (HussarUtils.isNotEmpty((Object)apiInfos)) {
            apiCode = apiInfos.stream().map(ApiInfo::getApiCode).collect(Collectors.toList());
        }
        for (EaiApiVersion apiVersion : apiVersions) {
            AppApiMigrationDumpVo vo;
            int type = AppMigrationDataChangeTypeEnum.UPDATE.getType();
            if (apiCode != null && apiCode.contains(apiVersion.getApiCode())) {
                vo = this.getApiInfoDumpVo(apiVersion, type);
                ApiInfo apiInfo = apiInfos.stream().filter(f -> apiVersion.getApiCode().equals(f.getApiCode())).findFirst().get();
                vo.setUpdateDetailList(this.eaiUpdateDetailManager.getApiInfoDetailList(ApiInfoUpdateBo.convert((EaiApiVersion)apiVersion), ApiInfoUpdateBo.convert((ApiInfo)apiInfo), type));
                preloadVoList.add(vo);
            } else {
                type = AppMigrationDataChangeTypeEnum.ADD.getType();
                vo = this.getApiInfoDumpVo(apiVersion, type);
                vo.setUpdateDetailList(this.eaiUpdateDetailManager.getApiInfoDetailList(ApiInfoUpdateBo.convert((EaiApiVersion)apiVersion), ApiInfoUpdateBo.convert((ApiInfo)new ApiInfo()), type));
                preloadVoList.add(vo);
            }
            if (!HussarUtils.isNotEmpty((Object)apiResourcesDto.getApiResourceCodeMaps())) continue;
            for (ApiResourceCodeMaps resourceCodeMap : apiResourcesDto.getApiResourceCodeMaps()) {
                if (!apiVersion.getApiCode().equals(resourceCodeMap.getApiCode())) continue;
                preloadVoList.addAll(this.getResultDumpVo(apiVersion.getApiVersionId(), resourceCodeMap, (EaiCommonResourcesDto)apiResourcesDto, type));
            }
        }
    }

    private void classificationPreLoad(List<AppApiMigrationDumpVo> preloadVoList, List<EaiApiClassificationVersion> classificationList, String appCode) {
        List classificNames = classificationList.stream().map(EaiApiClassificationVersion::getClassificName).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiApiClassification::getApplicationCode, (Object)appCode)).in(EaiApiClassification::getClassificName, classificNames);
        List classifications = this.eaiApiClassificationService.list((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)classifications)) {
            List name = classifications.stream().map(EaiApiClassification::getClassificName).collect(Collectors.toList());
            for (EaiApiClassificationVersion classification : classificationList) {
                if (name.contains(classification.getClassificName())) {
                    preloadVoList.add(this.getClassificationDumpVo(classification, AppMigrationDataChangeTypeEnum.UNCHANGED.getType()));
                    continue;
                }
                preloadVoList.add(this.getClassificationDumpVo(classification, AppMigrationDataChangeTypeEnum.ADD.getType()));
            }
        }
    }

    private void addClassificationDumpVos(List<AppApiMigrationDumpVo> dumpList, List<EaiApiVersion> apiVersionList, List<EaiApiClassificationVersion> apiClassificationList) {
        if (HussarUtils.isEmpty(apiVersionList)) {
            return;
        }
        for (EaiApiVersion apiVersion : apiVersionList) {
            if (!HussarUtils.isEmpty((Object)apiVersion.getClassificId())) continue;
            dumpList.add(this.getDefaultClassificationDumpVo());
            break;
        }
        if (HussarUtils.isEmpty(apiClassificationList)) {
            return;
        }
        ArrayList<Long> classificIdList = new ArrayList<Long>();
        for (EaiApiClassificationVersion classificationVersion : apiClassificationList) {
            if (classificIdList.contains(classificationVersion.getClassificId())) continue;
            dumpList.add(this.getClassificationDumpVo(classificationVersion));
            classificIdList.add(classificationVersion.getClassificId());
        }
    }

    private AppApiMigrationDumpVo getClassificationDumpVo(EaiApiClassificationVersion classification, int changeType) {
        AppApiMigrationDumpVo dumpVo = this.getClassificationDumpVo(classification);
        dumpVo.setChangeType(changeType);
        return dumpVo;
    }

    private AppApiMigrationDumpVo getClassificationDumpVo(EaiApiClassificationVersion classification) {
        AppApiMigrationDumpVo dumpVo = new AppApiMigrationDumpVo();
        dumpVo.setId(classification.getId());
        dumpVo.setLabel(classification.getClassificName());
        dumpVo.setParentId(Constants.ROOT_NODE_ID);
        dumpVo.setType(AppApiMigrationDataTypeEnum.API_CLASSIFICATION.getType());
        dumpVo.setTypeName(AppApiMigrationDataTypeEnum.API_CLASSIFICATION.getTypeName());
        dumpVo.setHasChildren(Boolean.valueOf(false));
        dumpVo.setIcon("tree-port");
        return dumpVo;
    }

    private AppApiMigrationDumpVo getDefaultClassificationDumpVo() {
        AppApiMigrationDumpVo dumpVo = new AppApiMigrationDumpVo();
        dumpVo.setId(Long.valueOf(111L));
        dumpVo.setLabel("\u9ed8\u8ba4\u7c7b\u578b");
        dumpVo.setParentId(Constants.ROOT_NODE_ID);
        dumpVo.setType(AppApiMigrationDataTypeEnum.API_CLASSIFICATION.getType());
        dumpVo.setTypeName(AppApiMigrationDataTypeEnum.API_CLASSIFICATION.getTypeName());
        dumpVo.setHasChildren(Boolean.valueOf(false));
        dumpVo.setIcon("tree-port");
        dumpVo.setChangeType(AppMigrationDataChangeTypeEnum.UNCHANGED.getType());
        return dumpVo;
    }

    private AppApiMigrationDumpVo getApiInfoDumpVo(EaiApiVersion apiInfo, int changeType) {
        AppApiMigrationDumpVo dumpVo = this.getApiInfoDumpVo(apiInfo);
        dumpVo.setChangeType(changeType);
        return dumpVo;
    }

    private AppApiMigrationDumpVo getApiInfoDumpVo(EaiApiVersion apiInfo) {
        AppApiMigrationDumpVo dumpVo = new AppApiMigrationDumpVo();
        dumpVo.setId(apiInfo.getApiVersionId());
        dumpVo.setLabel(apiInfo.getApiName());
        dumpVo.setCode(apiInfo.getApiCode());
        dumpVo.setParentId(Long.valueOf(ToolUtil.isNotEmpty((Object)apiInfo.getClassificId()) ? apiInfo.getClassificId() : 111L));
        dumpVo.setType(AppApiMigrationDataTypeEnum.API.getType());
        dumpVo.setTypeName(AppApiMigrationDataTypeEnum.API.getTypeName());
        dumpVo.setHasChildren(Boolean.valueOf(false));
        dumpVo.setIcon("tree-api-port");
        return dumpVo;
    }
}

