/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.manager.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.common.constant.EaiDataType;
import com.jxdinfo.hussar.eai.common.enums.api.EaiCategoryEnum;
import com.jxdinfo.hussar.eai.common.enums.api.EaiDataCategoryEnum;
import com.jxdinfo.hussar.eai.common.enums.app.EaiAppConnectionEnum;
import com.jxdinfo.hussar.eai.common.enums.app.HttpAuthTypeEnum;
import com.jxdinfo.hussar.eai.common.enums.sys.EaiCharsetEnum;
import com.jxdinfo.hussar.eai.common.util.StructureItems;
import com.jxdinfo.hussar.eai.common.vo.PageVo;
import com.jxdinfo.hussar.eai.migration.business.bo.ApiInfoUpdateBo;
import com.jxdinfo.hussar.eai.migration.business.bo.ApplicationAuthUpdateBo;
import com.jxdinfo.hussar.eai.migration.business.bo.ConnectionUpdateBo;
import com.jxdinfo.hussar.eai.migration.business.bo.ConstantUpdateBo;
import com.jxdinfo.hussar.eai.migration.business.bo.HttpTemplateUpdateBo;
import com.jxdinfo.hussar.eai.migration.business.bo.LogicUpdateBo;
import com.jxdinfo.hussar.eai.migration.business.bo.StructureUpdateBo;
import com.jxdinfo.hussar.eai.migration.business.bo.WebServiceTemplateUpdateBo;
import com.jxdinfo.hussar.eai.migration.business.bo.WsdlTemplateUpdateBo;
import com.jxdinfo.hussar.eai.migration.business.manager.EaiUpdateDetailManager;
import com.jxdinfo.hussar.eai.migration.business.vo.UpdateDetailVo;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.migration.business.manager.impl.eaiUpdateDetailManagerImpl")
public class EaiUpdateDetailManagerImpl
implements EaiUpdateDetailManager {
    private static final Logger logger = LoggerFactory.getLogger(EaiUpdateDetailManagerImpl.class);
    private static final String DEFAULT_DATE_STR = "1970-01-01 00:00:00";

    @Override
    public List<UpdateDetailVo> getAppAuthDetailList(ApplicationAuthUpdateBo newAuthParam, ApplicationAuthUpdateBo oldAuthParam, int changeType) {
        ArrayList<UpdateDetailVo> updateDetailVoList = new ArrayList<UpdateDetailVo>();
        updateDetailVoList.add(new UpdateDetailVo(EngineUtil.getId(), "\u5165\u53c2\u540d\u79f0", oldAuthParam.getParamsName(), newAuthParam.getParamsName(), Integer.valueOf(changeType), newAuthParam.getId()));
        updateDetailVoList.add(new UpdateDetailVo(EngineUtil.getId(), "\u82f1\u6587\u540d\u79f0", oldAuthParam.getParamsNameEn(), newAuthParam.getParamsNameEn(), Integer.valueOf(changeType), newAuthParam.getId()));
        updateDetailVoList.add(new UpdateDetailVo(EngineUtil.getId(), "\u6570\u636e\u7c7b\u578b", this.getParamsTypeName(oldAuthParam.getParamsType()), this.getParamsTypeName(newAuthParam.getParamsType()), Integer.valueOf(changeType), newAuthParam.getId()));
        updateDetailVoList.add(new UpdateDetailVo(EngineUtil.getId(), "\u63cf\u8ff0", oldAuthParam.getRemark(), newAuthParam.getRemark(), Integer.valueOf(changeType), newAuthParam.getId()));
        return updateDetailVoList;
    }

    @Override
    public List<UpdateDetailVo> getHttpTemplateDetailList(HttpTemplateUpdateBo newTemplate, HttpTemplateUpdateBo oldTemplate, int changeType) {
        ArrayList<UpdateDetailVo> updateDetailVoList = new ArrayList<UpdateDetailVo>();
        updateDetailVoList.add(new UpdateDetailVo(EngineUtil.getId(), "\u9274\u6743\u7c7b\u578b", this.getAuthTypeName(oldTemplate.getHttpType()), this.getAuthTypeName(newTemplate.getHttpType()), Integer.valueOf(changeType), newTemplate.getId()));
        return updateDetailVoList;
    }

    private String getAuthTypeName(String httpType) {
        if (ToolUtil.isEmpty((Object)httpType)) {
            return null;
        }
        try {
            return HttpAuthTypeEnum.getHttpAuthTypeEnum((String)httpType).getAuthTypeName();
        }
        catch (BaseException e) {
            logger.info("\u9274\u6743\u7c7b\u578b\u540d\u79f0\u83b7\u53d6\u5931\u8d25", (Throwable)e);
            return httpType;
        }
    }

    @Override
    public List<UpdateDetailVo> getWebServiceTemplateDetailList(WebServiceTemplateUpdateBo newTemplate, WebServiceTemplateUpdateBo oldTemplate, int changeType) {
        ArrayList<UpdateDetailVo> updateDetailVoList = new ArrayList<UpdateDetailVo>();
        updateDetailVoList.add(new UpdateDetailVo(EngineUtil.getId(), "\u9274\u6743\u7c7b\u578b", this.getAuthTypeName(oldTemplate.getAuthType()), this.getAuthTypeName(newTemplate.getAuthType()), Integer.valueOf(changeType), newTemplate.getId()));
        return updateDetailVoList;
    }

    @Override
    public List<UpdateDetailVo> getWsdlTemplateDetailList(WsdlTemplateUpdateBo newWsdl, WsdlTemplateUpdateBo oldWsdl, int changeType) {
        ArrayList<UpdateDetailVo> updateDetailVoList = new ArrayList<UpdateDetailVo>();
        updateDetailVoList.add(new UpdateDetailVo(EngineUtil.getId(), "WSDL\u6587\u4ef6", oldWsdl.getWsdlName(), newWsdl.getWsdlName(), Integer.valueOf(changeType), newWsdl.getId()));
        updateDetailVoList.add(new UpdateDetailVo(EngineUtil.getId(), "WSDL\u5730\u5740", oldWsdl.getWsdlPath(), newWsdl.getWsdlPath(), Integer.valueOf(changeType), newWsdl.getId()));
        updateDetailVoList.add(new UpdateDetailVo(EngineUtil.getId(), "WSDL\u7248\u672c", oldWsdl.getWsdlVersion(), newWsdl.getWsdlVersion(), Integer.valueOf(changeType), newWsdl.getId()));
        return updateDetailVoList;
    }

    @Override
    public List<UpdateDetailVo> getApiInfoDetailList(ApiInfoUpdateBo newApi, ApiInfoUpdateBo oldApi, int changeType) {
        ArrayList<UpdateDetailVo> updateDetailVoList = new ArrayList<UpdateDetailVo>();
        updateDetailVoList.add(new UpdateDetailVo(EngineUtil.getId(), "\u63a5\u53e3\u540d\u79f0", oldApi.getApiName(), newApi.getApiName(), Integer.valueOf(changeType), newApi.getId()));
        updateDetailVoList.add(new UpdateDetailVo(EngineUtil.getId(), "\u63a5\u53e3\u8def\u5f84", oldApi.getApiPath(), newApi.getApiPath(), Integer.valueOf(changeType), newApi.getId()));
        updateDetailVoList.add(new UpdateDetailVo(EngineUtil.getId(), "\u6570\u636e\u683c\u5f0f", this.getDataFormatName(oldApi.getDataFormat()), this.getDataFormatName(newApi.getDataFormat()), Integer.valueOf(changeType), newApi.getId()));
        updateDetailVoList.add(new UpdateDetailVo(EngineUtil.getId(), "\u7f16\u7801\u65b9\u5f0f", this.getEncodingTypeName(oldApi.getEncodingType()), this.getEncodingTypeName(newApi.getEncodingType()), Integer.valueOf(changeType), newApi.getId()));
        updateDetailVoList.add(new UpdateDetailVo(EngineUtil.getId(), "\u8bf7\u6c42\u65b9\u5f0f", oldApi.getHttpMethod(), newApi.getHttpMethod(), Integer.valueOf(changeType), newApi.getId()));
        updateDetailVoList.add(new UpdateDetailVo(EngineUtil.getId(), "\u5185\u5bb9\u7c7b\u578b", oldApi.getContentType(), newApi.getContentType(), Integer.valueOf(changeType), newApi.getId()));
        updateDetailVoList.add(new UpdateDetailVo(EngineUtil.getId(), "\u63cf\u8ff0", oldApi.getRemark(), newApi.getRemark(), Integer.valueOf(changeType), newApi.getId()));
        return updateDetailVoList;
    }

    private String getDataFormatName(String dataFormat) {
        if (ToolUtil.isEmpty((Object)dataFormat)) {
            return null;
        }
        try {
            return EaiDataCategoryEnum.getByCode((int)Integer.parseInt(dataFormat)).getDescription();
        }
        catch (BaseException e) {
            logger.info("\u6570\u636e\u683c\u5f0f\u540d\u79f0\u83b7\u53d6\u5931\u8d25", (Throwable)e);
            return dataFormat;
        }
    }

    private String getEncodingTypeName(String encodingType) {
        if (ToolUtil.isEmpty((Object)encodingType)) {
            return null;
        }
        try {
            return EaiCharsetEnum.getByCode((int)Integer.parseInt(encodingType)).getName();
        }
        catch (BaseException e) {
            logger.info("\u7f16\u7801\u65b9\u5f0f\u540d\u79f0\u83b7\u53d6\u5931\u8d25", (Throwable)e);
            return encodingType;
        }
    }

    @Override
    public List<UpdateDetailVo> getConstantDetailList(ConstantUpdateBo newConstant, ConstantUpdateBo oldConstant, int changeType) {
        ArrayList<UpdateDetailVo> updateDetailVoList = new ArrayList<UpdateDetailVo>();
        updateDetailVoList.add(new UpdateDetailVo(EngineUtil.getId(), "\u5e38\u91cf\u540d\u79f0", oldConstant == null ? "" : oldConstant.getConstantName(), newConstant.getConstantName(), Integer.valueOf(changeType), newConstant.getId()));
        updateDetailVoList.add(new UpdateDetailVo(EngineUtil.getId(), "\u82f1\u6587\u540d\u79f0", oldConstant == null ? "" : oldConstant.getConstantNameEn(), newConstant.getConstantNameEn(), Integer.valueOf(changeType), newConstant.getId()));
        updateDetailVoList.add(new UpdateDetailVo(EngineUtil.getId(), "\u6570\u636e\u7c7b\u578b", this.getParamsTypeName(oldConstant == null ? "" : oldConstant.getParamsType()), this.getParamsTypeName(newConstant.getParamsType()), Integer.valueOf(changeType), newConstant.getId()));
        updateDetailVoList.add(new UpdateDetailVo(EngineUtil.getId(), "\u5e38\u91cf\u503c", oldConstant == null ? "" : oldConstant.getConstantValue(), newConstant.getConstantValue(), Integer.valueOf(changeType), newConstant.getId()));
        updateDetailVoList.add(new UpdateDetailVo(EngineUtil.getId(), "\u5e38\u91cf\u5206\u7c7b", oldConstant == null ? "" : oldConstant.getConstantClassify(), newConstant.getConstantClassify(), Integer.valueOf(changeType), newConstant.getId()));
        updateDetailVoList.add(new UpdateDetailVo(EngineUtil.getId(), "\u63cf\u8ff0", oldConstant == null ? "" : oldConstant.getRemark(), newConstant.getRemark(), Integer.valueOf(changeType), newConstant.getId()));
        return updateDetailVoList;
    }

    @Override
    public List<UpdateDetailVo> getStructureDetailList(StructureUpdateBo newStructure, StructureUpdateBo oldStructure, int changeType) {
        ArrayList<UpdateDetailVo> updateDetailVoList = new ArrayList<UpdateDetailVo>();
        updateDetailVoList.add(new UpdateDetailVo(EngineUtil.getId(), "\u6570\u636e\u7c7b\u578b", this.getParamsTypeName(oldStructure.getParamsType()), this.getParamsTypeName(newStructure.getParamsType()), Integer.valueOf(changeType), newStructure.getId()));
        updateDetailVoList.add(new UpdateDetailVo(EngineUtil.getId(), "\u6570\u636e\u7ed3\u6784\u540d\u79f0", oldStructure.getStructureName(), newStructure.getStructureName(), Integer.valueOf(changeType), newStructure.getId()));
        updateDetailVoList.add(new UpdateDetailVo(EngineUtil.getId(), "\u53c2\u6570\u4fe1\u606f", this.getJsonStringFromStructureValue(oldStructure.getStructureValue()), this.getJsonStringFromStructureValue(newStructure.getStructureValue()), Integer.valueOf(changeType), newStructure.getId()));
        updateDetailVoList.add(new UpdateDetailVo(EngineUtil.getId(), "\u63cf\u8ff0", oldStructure.getRemark(), newStructure.getRemark(), Integer.valueOf(changeType), newStructure.getId()));
        updateDetailVoList.add(new UpdateDetailVo(EngineUtil.getId(), "\u6570\u636e\u7ed3\u6784\u5206\u7c7b", this.getClassifyName(oldStructure.getStructureClassify()), this.getClassifyName(newStructure.getStructureClassify()), Integer.valueOf(changeType), newStructure.getId()));
        return updateDetailVoList;
    }

    private String getJsonStringFromStructureValue(String structureValue) {
        List structureItems = (List)JSONObject.parseObject((String)structureValue, (TypeReference)new TypeReference<List<StructureItems>>(){}, (Feature[])new Feature[0]);
        JSONObject jsonObject = new JSONObject();
        this.getJsonObjFromItems(jsonObject, structureItems);
        return JSONObject.toJSONString((Object)jsonObject);
    }

    private void getJsonObjFromItems(JSONObject jsonObject, List<StructureItems> structureItems) {
        if (ToolUtil.isEmpty(structureItems)) {
            return;
        }
        for (StructureItems item : structureItems) {
            Integer type = item.getType();
            if (ToolUtil.isEmpty((Object)type)) continue;
            if (EaiDataType.DATA_TYPE_BOOLEAN.getType() == type.intValue()) {
                jsonObject.put(item.getName(), (Object)false);
                continue;
            }
            if (EaiDataType.DATA_TYPE_INTEGER.getType() == type.intValue()) {
                jsonObject.put(item.getName(), (Object)0);
                continue;
            }
            if (EaiDataType.DATA_TYPE_LONG.getType() == type.intValue()) {
                jsonObject.put(item.getName(), (Object)0L);
                continue;
            }
            if (EaiDataType.DATA_TYPE_DOUBLE.getType() == type.intValue()) {
                jsonObject.put(item.getName(), (Object)0.1);
                continue;
            }
            if (EaiDataType.DATA_TYPE_STRING.getType() == type.intValue()) {
                jsonObject.put(item.getName(), (Object)"");
                continue;
            }
            if (EaiDataType.DATA_TYPE_DATE.getType() == type.intValue()) {
                jsonObject.put(item.getName(), (Object)DEFAULT_DATE_STR);
                continue;
            }
            if (EaiDataType.DATA_TYPE_LIST.getType() == type.intValue()) {
                JSONArray itemArray = new JSONArray();
                this.getJsonArrayFromItem(itemArray, item);
                jsonObject.put(item.getName(), (Object)itemArray);
                continue;
            }
            if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == type.intValue()) {
                JSONObject itemJson = new JSONObject();
                this.getJsonObjFromItems(itemJson, item.getItems());
                jsonObject.put(item.getName(), (Object)itemJson);
                continue;
            }
            if (EaiDataType.DATA_TYPE_PAGE.getType() != type.intValue()) continue;
            jsonObject.put(item.getName(), (Object)new PageVo());
        }
    }

    private void getJsonArrayFromItem(JSONArray jsonArray, StructureItems item) {
        if (ToolUtil.isEmpty((Object)item)) {
            return;
        }
        Integer type = item.getItemType();
        if (ToolUtil.isEmpty((Object)type)) {
            return;
        }
        if (EaiDataType.DATA_TYPE_BOOLEAN.getType() == type.intValue()) {
            jsonArray.add((Object)false);
        } else if (EaiDataType.DATA_TYPE_INTEGER.getType() == type.intValue()) {
            jsonArray.add((Object)0);
        } else if (EaiDataType.DATA_TYPE_LONG.getType() == type.intValue()) {
            jsonArray.add((Object)0L);
        } else if (EaiDataType.DATA_TYPE_DOUBLE.getType() == type.intValue()) {
            jsonArray.add((Object)0.1);
        } else if (EaiDataType.DATA_TYPE_STRING.getType() == type.intValue()) {
            jsonArray.add((Object)"");
        } else if (EaiDataType.DATA_TYPE_DATE.getType() == type.intValue()) {
            jsonArray.add((Object)DEFAULT_DATE_STR);
        } else if (EaiDataType.DATA_TYPE_LIST.getType() == type.intValue()) {
            JSONArray itemArray = new JSONArray();
            if (ToolUtil.isNotEmpty((Object)item.getItems()) && ToolUtil.isNotEmpty(item.getItems().get(0))) {
                this.getJsonArrayFromItem(itemArray, (StructureItems)item.getItems().get(0));
            }
            jsonArray.add((Object)itemArray);
        } else if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == type.intValue()) {
            JSONObject itemJson = new JSONObject();
            if (ToolUtil.isNotEmpty((Object)item.getItems()) && ToolUtil.isNotEmpty(item.getItems().get(0))) {
                this.getJsonObjFromItems(itemJson, ((StructureItems)item.getItems().get(0)).getItems());
            }
            jsonArray.add((Object)itemJson);
        } else if (EaiDataType.DATA_TYPE_PAGE.getType() == type.intValue()) {
            jsonArray.add((Object)new PageVo());
        }
    }

    private String getParamsTypeName(String paramsType) {
        if (ToolUtil.isEmpty((Object)paramsType)) {
            return null;
        }
        try {
            return EaiDataType.getEaiDataType((Integer)Integer.parseInt(paramsType)).getMsg();
        }
        catch (HussarException e) {
            logger.info("\u6570\u636e\u7c7b\u578b\u540d\u79f0\u83b7\u53d6\u5931\u8d25", (Throwable)e);
            return paramsType;
        }
    }

    private String getClassifyName(String classify) {
        if (ToolUtil.isEmpty((Object)classify)) {
            return null;
        }
        try {
            return EaiCategoryEnum.getByCode((String)classify).getDescription();
        }
        catch (RuntimeException e) {
            logger.info("\u5206\u7c7b\u540d\u79f0\u83b7\u53d6\u5931\u8d25", (Throwable)e);
            return classify;
        }
    }

    @Override
    public List<UpdateDetailVo> getLogicDetailList(LogicUpdateBo newLogic, LogicUpdateBo oldLogic, int changeType) {
        ArrayList<UpdateDetailVo> updateDetailVoList = new ArrayList<UpdateDetailVo>();
        updateDetailVoList.add(new UpdateDetailVo(EngineUtil.getId(), "\u903b\u8f91\u540d\u79f0", oldLogic.getLogicName(), newLogic.getLogicName(), Integer.valueOf(changeType), newLogic.getId()));
        updateDetailVoList.add(new UpdateDetailVo(EngineUtil.getId(), "\u903b\u8f91\u5206\u7c7b", this.getClassifyName(oldLogic.getLogicClassify()), this.getClassifyName(newLogic.getLogicClassify()), Integer.valueOf(changeType), newLogic.getId()));
        updateDetailVoList.add(new UpdateDetailVo(EngineUtil.getId(), "\u63cf\u8ff0", oldLogic.getRemark(), newLogic.getRemark(), Integer.valueOf(changeType), newLogic.getId()));
        return updateDetailVoList;
    }

    @Override
    public List<UpdateDetailVo> getConnectionDetailList(ConnectionUpdateBo newConn, ConnectionUpdateBo oldConn, int changeType) {
        ArrayList<UpdateDetailVo> updateDetailVoList = new ArrayList<UpdateDetailVo>();
        updateDetailVoList.add(new UpdateDetailVo(EngineUtil.getId(), "\u8fde\u63a5\u540d\u79f0", oldConn.getConnName(), newConn.getConnName(), Integer.valueOf(changeType), newConn.getId()));
        updateDetailVoList.add(new UpdateDetailVo(EngineUtil.getId(), "\u82f1\u6587\u540d\u79f0", oldConn.getConnNameEn(), newConn.getConnNameEn(), Integer.valueOf(changeType), newConn.getId()));
        updateDetailVoList.add(new UpdateDetailVo(EngineUtil.getId(), "\u5206\u7c7b", this.getClassifyName(oldConn.getClassify()), this.getClassifyName(newConn.getClassify()), Integer.valueOf(changeType), newConn.getId()));
        updateDetailVoList.add(new UpdateDetailVo(EngineUtil.getId(), "\u8fde\u63a5\u5206\u7c7b", this.getConnClassifyName(oldConn.getConnectionClassify()), this.getConnClassifyName(newConn.getConnectionClassify()), Integer.valueOf(changeType), newConn.getId()));
        updateDetailVoList.add(new UpdateDetailVo(EngineUtil.getId(), "\u4e8c\u7ea7\u5206\u7c7b", oldConn.getClassifyChild(), newConn.getClassifyChild(), Integer.valueOf(changeType), newConn.getId()));
        updateDetailVoList.add(new UpdateDetailVo(EngineUtil.getId(), "\u8fde\u63a5\u914d\u7f6e", oldConn.getConnConf(), newConn.getConnConf(), Integer.valueOf(changeType), newConn.getId()));
        updateDetailVoList.add(new UpdateDetailVo(EngineUtil.getId(), "\u63cf\u8ff0", oldConn.getRemark(), newConn.getRemark(), Integer.valueOf(changeType), newConn.getId()));
        return updateDetailVoList;
    }

    private String getConnClassifyName(String connClassify) {
        if (ToolUtil.isEmpty((Object)connClassify)) {
            return null;
        }
        try {
            return EaiAppConnectionEnum.getByClassify((String)connClassify).getClassifyChildName();
        }
        catch (BaseException e) {
            logger.info("\u8fde\u63a5\u5206\u7c7b\u540d\u79f0\u83b7\u53d6\u5931\u8d25", (Throwable)e);
            return connClassify;
        }
    }
}

