/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeamMember;
import com.jxdinfo.hussar.application.service.ISysAppDevelopTeamMemberService;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.migration.business.manager.EaiTeamMemberAddManager;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.migration.business.manager.impl.eaiTeamMemberAddManagerImpl")
public class EaiTeamMemberAddManagerImpl
implements EaiTeamMemberAddManager {
    @Autowired
    private ISysAppDevelopTeamMemberService sysAppDevelopTeamMemberService;
    @Autowired
    private ISysUsersService sysUsersService;
    private static final int DEFAULT_MEMBER_TYPE = 1;

    @Override
    public List<SysAppDevelopTeamMember> getExistAndLoadTeamMember(List<SysAppDevelopTeamMember> teamMemberList) {
        List usersList;
        ArrayList<SysAppDevelopTeamMember> resultList = new ArrayList<SysAppDevelopTeamMember>();
        if (ToolUtil.isEmpty(teamMemberList)) {
            return resultList;
        }
        ArrayList<Long> teamIds = new ArrayList<Long>();
        ArrayList<Long> userIds = new ArrayList<Long>();
        for (SysAppDevelopTeamMember teamMember : teamMemberList) {
            teamIds.add(teamMember.getTeamId());
            userIds.add(teamMember.getUserId());
        }
        if (ToolUtil.isNotEmpty(userIds) && ToolUtil.isNotEmpty((Object)(usersList = this.sysUsersService.listByIds(userIds)))) {
            List currentUserIds = usersList.stream().map(SysUsers::getId).collect(Collectors.toList());
            for (SysAppDevelopTeamMember teamMember : teamMemberList) {
                if (!currentUserIds.contains(teamMember.getUserId())) continue;
                resultList.add(teamMember);
            }
        }
        if (ToolUtil.isNotEmpty((Object)BaseSecurityUtil.getUser()) && !userIds.contains(BaseSecurityUtil.getUser().getId())) {
            resultList.addAll(this.getCurrentUserTeamMember(BaseSecurityUtil.getUser().getId(), teamIds));
        }
        List currentTeamMemberList = this.sysAppDevelopTeamMemberService.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysAppDevelopTeamMember::getTeamId, teamIds));
        List existKey = currentTeamMemberList.stream().map(c -> this.getKeyStr(c.getTeamId(), c.getUserId())).collect(Collectors.toList());
        return resultList.stream().filter(r -> !existKey.contains(this.getKeyStr(r.getTeamId(), r.getUserId()))).collect(Collectors.toList());
    }

    private List<SysAppDevelopTeamMember> getCurrentUserTeamMember(Long currentUserId, List<Long> teamIds) {
        ArrayList<SysAppDevelopTeamMember> resultList = new ArrayList<SysAppDevelopTeamMember>();
        if (ToolUtil.isEmpty(teamIds)) {
            return resultList;
        }
        teamIds = teamIds.stream().distinct().collect(Collectors.toList());
        for (Long teamId : teamIds) {
            SysAppDevelopTeamMember teamMember = new SysAppDevelopTeamMember();
            teamMember.setTeamId(teamId);
            teamMember.setUserId(currentUserId);
            teamMember.setMemberType(Integer.valueOf(1));
            resultList.add(teamMember);
        }
        return resultList;
    }

    private String getKeyStr(Long teamId, Long userId) {
        return String.valueOf(teamId) + userId;
    }
}

