/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.manager.impl;

import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.vo.StructureItemsVo;
import com.jxdinfo.hussar.eai.atomicbase.api.info.service.EaiCommonStructureService;
import com.jxdinfo.hussar.eai.common.constant.EaiDataType;
import com.jxdinfo.hussar.eai.migration.business.manager.EaiStructureSelectManager;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.StructureVersion;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.migration.business.manager.impl.eaiStructureSelectManagerImpl")
public class EaiStructureSelectManagerImpl
implements EaiStructureSelectManager {
    @Autowired
    private EaiCommonStructureService commonStructureService;

    @Override
    public void addChildStructureVersionIdToList(List<Long> idList, Long structureVersionId, Map<Long, StructureVersion> structureVersionMap) {
        if (ToolUtil.isEmpty((Object)structureVersionId) || ToolUtil.isEmpty(structureVersionMap)) {
            return;
        }
        StructureVersion structureVersion = structureVersionMap.get(structureVersionId);
        if (ToolUtil.isNotEmpty((Object)structureVersion)) {
            idList.add(structureVersionId);
            List values = this.commonStructureService.strToItemsList(structureVersion.getStructureValues(), String.valueOf(structureVersion.getId()));
            if (ToolUtil.isNotEmpty((Object)values)) {
                this.addChildIdToList(idList, values, structureVersionMap);
            }
        }
    }

    private void addChildIdToList(List<Long> idList, List<StructureItemsVo> values, Map<Long, StructureVersion> structureVersionMap) {
        if (ToolUtil.isEmpty(values)) {
            return;
        }
        for (StructureItemsVo itemsVo : values) {
            List newValues;
            StructureVersion structureVersion;
            Long structureId;
            if (EaiDataType.DATA_TYPE_LIST.getType() == itemsVo.getType().intValue()) {
                this.addChildIdToList(idList, itemsVo.getItems(), structureVersionMap);
            }
            String structureIdStr = itemsVo.getQuoteStructureId();
            if (EaiDataType.DATA_TYPE_STRUCTURE.getType() != itemsVo.getType().intValue() || !ToolUtil.isNotEmpty((Object)structureIdStr) || idList.contains(structureId = Long.valueOf(structureIdStr)) || !ToolUtil.isNotEmpty((Object)(structureVersion = structureVersionMap.get(structureId)))) continue;
            idList.add(structureId);
            if (ToolUtil.isNotEmpty((Object)itemsVo.getItems())) {
                this.addChildIdToList(idList, itemsVo.getItems(), structureVersionMap);
            }
            if (!ToolUtil.isNotEmpty((Object)(newValues = this.commonStructureService.strToItemsList(structureVersion.getStructureValues(), String.valueOf(structureVersion.getId()))))) continue;
            this.addChildIdToList(idList, newValues, structureVersionMap);
        }
    }
}

