/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.manager.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.migration.business.bo.AppApiResources;
import com.jxdinfo.hussar.eai.migration.business.manager.EaiLogicResourcesManager;
import com.jxdinfo.hussar.eai.migration.business.manager.EaiStructureSelectManager;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.StructureVersion;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CanvasInfo;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICanvasInfoService;
import com.jxdinfo.hussar.eai.resourceexternalopen.api.model.LogicVersion;
import com.jxdinfo.hussar.eai.resourceexternalopen.api.service.IEaiLogicVersionService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.migration.business.manager.impl.eaiLogicResourcesManagerImpl")
public class EaiLogicResourcesManagerImpl
implements EaiLogicResourcesManager {
    @Autowired
    private IEaiLogicVersionService eaiLogicVersionService;
    @Autowired
    private ICanvasInfoService canvasInfoService;
    @Autowired
    private EaiStructureSelectManager eaiStructureSelectManager;
    public static final String RESOURCE_SPLIT_STR = ":";

    @Override
    public List<CanvasInfo> addResourcesFromLogic(AppApiResources apiResources, String appCode, Map<Long, StructureVersion> structureVersionMap) {
        ArrayList<CanvasInfo> canvasInfoList = new ArrayList<CanvasInfo>();
        if (ToolUtil.isEmpty((Object)apiResources.getLogicIds())) {
            return canvasInfoList;
        }
        List allLogicVersionList = this.eaiLogicVersionService.list((Wrapper)new LambdaQueryWrapper().eq(LogicVersion::getApplicationCode, (Object)appCode));
        HashMap<Long, LogicVersion> logicVersionMap = new HashMap<Long, LogicVersion>();
        ArrayList<Long> canvasIds = new ArrayList<Long>();
        for (LogicVersion logicVersion : allLogicVersionList) {
            logicVersionMap.put(logicVersion.getId(), logicVersion);
            if (!ToolUtil.isNotEmpty((Object)logicVersion.getCanvasId())) continue;
            canvasIds.add(logicVersion.getCanvasId());
        }
        List allCanvasInfoList = new ArrayList();
        if (ToolUtil.isNotEmpty(canvasIds)) {
            allCanvasInfoList = this.canvasInfoService.listByIds(canvasIds);
        }
        Map<Long, CanvasInfo> canvasInfoMap = allCanvasInfoList.stream().collect(Collectors.toMap(CanvasInfo::getId, Function.identity()));
        this.addResourcesFromLogic(apiResources.getLogicIds(), apiResources, logicVersionMap, canvasInfoMap, structureVersionMap, canvasInfoList);
        return canvasInfoList;
    }

    private void addResourcesFromLogic(List<Long> logicIds, AppApiResources apiResources, Map<Long, LogicVersion> allLogicVersionMap, Map<Long, CanvasInfo> allCanvasInfoMap, Map<Long, StructureVersion> structureVersionMap, List<CanvasInfo> canvasInfoList) {
        Map logicMap = apiResources.getLogicMap();
        if (ToolUtil.isEmpty(logicIds)) {
            return;
        }
        for (Long logicId : logicIds) {
            Long canvasId;
            CanvasInfo canvasInfo;
            LogicVersion logicVersion = allLogicVersionMap.get(logicId);
            List parentIds = (List)logicMap.get(logicId);
            if (ToolUtil.isEmpty((Object)logicVersion) || ToolUtil.isEmpty((Object)logicVersion.getCanvasId()) || ToolUtil.isEmpty((Object)parentIds) || ToolUtil.isEmpty((Object)(canvasInfo = allCanvasInfoMap.get(canvasId = Long.valueOf(logicVersion.getCanvasId()))))) continue;
            canvasInfoList.add(canvasInfo);
            this.addResourcesFromCanvas(canvasInfo, apiResources, allLogicVersionMap, allCanvasInfoMap, parentIds, structureVersionMap, canvasInfoList);
        }
    }

    private void addResourcesFromCanvas(CanvasInfo canvasInfo, AppApiResources apiResources, Map<Long, LogicVersion> allLogicVersionMap, Map<Long, CanvasInfo> allCanvasInfoMap, List<Long> parentIds, Map<Long, StructureVersion> structureVersionMap, List<CanvasInfo> canvasInfoList) {
        String resources = canvasInfo.getCanvasResources();
        if (ToolUtil.isEmpty((Object)resources)) {
            return;
        }
        List constantIds = apiResources.getConstantIds();
        List structureIds = apiResources.getStructureIds();
        List logicIds = apiResources.getLogicIds();
        List connectionIds = apiResources.getConnectionIds();
        Map constantMap = apiResources.getConstantMap();
        Map structureMap = apiResources.getStructureMap();
        Map logicMap = apiResources.getLogicMap();
        Map connectionMap = apiResources.getConnectionMap();
        ArrayList<Long> currentConstantIds = new ArrayList<Long>();
        ArrayList<Long> currentStructureIds = new ArrayList<Long>();
        ArrayList<Long> currentLogicIds = new ArrayList<Long>();
        ArrayList<Long> currentConnectionIds = new ArrayList<Long>();
        Map resourceMap = (Map)JSON.parseObject((String)resources, (TypeReference)new TypeReference<Map<String, Integer>>(){}, (Feature[])new Feature[0]);
        Set keySet = resourceMap.keySet();
        for (String key : keySet) {
            String[] keyArray = key.split(RESOURCE_SPLIT_STR);
            if (!ToolUtil.isNotEmpty((Object)keyArray) || keyArray.length != 2) continue;
            switch (keyArray[0]) {
                case "constant": {
                    Long constantId = Long.valueOf(keyArray[1]);
                    constantIds.add(constantId);
                    currentConstantIds.add(constantId);
                    break;
                }
                case "structure": {
                    Long structureId = Long.valueOf(keyArray[1]);
                    ArrayList<Long> structureIdList = new ArrayList<Long>();
                    this.eaiStructureSelectManager.addChildStructureVersionIdToList(structureIdList, structureId, structureVersionMap);
                    structureIds.addAll(structureIdList);
                    currentStructureIds.addAll(structureIdList);
                    break;
                }
                case "logic": {
                    Long logicId = Long.valueOf(keyArray[1]);
                    logicIds.add(logicId);
                    currentLogicIds.add(logicId);
                    break;
                }
                case "link": {
                    Long connectionId = Long.valueOf(keyArray[1]);
                    connectionIds.add(connectionId);
                    currentConnectionIds.add(connectionId);
                    break;
                }
            }
        }
        for (Long parentId : parentIds) {
            this.updateMapListValue(constantMap, currentConstantIds, parentId);
            this.updateMapListValue(structureMap, currentStructureIds, parentId);
            this.updateMapListValue(logicMap, currentLogicIds, parentId);
            this.updateMapListValue(connectionMap, currentConnectionIds, parentId);
        }
        this.addResourcesFromLogic(currentLogicIds, apiResources, allLogicVersionMap, allCanvasInfoMap, structureVersionMap, canvasInfoList);
    }

    private void updateMapListValue(Map<Long, List<Long>> map, List<Long> currentIds, Long id) {
        List list = currentIds.stream().distinct().collect(Collectors.toList());
        for (Long key : list) {
            List<Long> ids = map.get(key);
            if (ToolUtil.isEmpty(ids)) {
                ids = new ArrayList<Long>();
            }
            if (ids.contains(id)) continue;
            ids.add(id);
            map.put(key, ids);
        }
    }
}

