/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.manager.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.apirelease.api.model.EaiApiVersion;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.dto.ApiCanvasInfo;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.dto.CanvasSlotsDefault;
import com.jxdinfo.hussar.eai.migration.business.manager.EaiCanvasExternalUpdateManager;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.migration.business.manager.impl.eaiCanvasExternalUpdateManagerImpl")
public class EaiCanvasExternalUpdateManagerImpl
implements EaiCanvasExternalUpdateManager {
    private static final String SLOTS_DEFAULT_KEY = "default";
    private static final String EXTERNAL_INTERFACE_PREFIX = "backendAppInterfaceInvoke_";

    @Override
    public String getApiUpdatedCanvasContent(String canvasContent, EaiApiVersion apiVersion, SysApplication application) {
        if (ToolUtil.isEmpty((Object)canvasContent) || ToolUtil.isEmpty((Object)apiVersion) || ToolUtil.isEmpty((Object)application)) {
            return canvasContent;
        }
        ApiCanvasInfo apiCanvasInfo = (ApiCanvasInfo)JSONObject.parseObject((String)canvasContent, ApiCanvasInfo.class);
        Map slots = apiCanvasInfo.getSlots();
        if (ToolUtil.isEmpty((Object)slots) || ToolUtil.isEmpty(slots.get(SLOTS_DEFAULT_KEY))) {
            return canvasContent;
        }
        List defaults = JSONObject.parseArray((String)JSONObject.toJSONString(slots.get(SLOTS_DEFAULT_KEY)), CanvasSlotsDefault.class);
        this.updateSlotsDefaults(defaults, apiVersion, application);
        slots.put(SLOTS_DEFAULT_KEY, defaults);
        apiCanvasInfo.setSlots(slots);
        return JSON.toJSONString((Object)apiCanvasInfo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.DisableCircularReferenceDetect});
    }

    private void updateSlotsDefaults(List<CanvasSlotsDefault> defaults, EaiApiVersion apiVersion, SysApplication application) {
        if (ToolUtil.isEmpty(defaults)) {
            return;
        }
        for (CanvasSlotsDefault slotsDefault : defaults) {
            JSONObject props;
            String apiId;
            if (!ToolUtil.isNotEmpty((Object)slotsDefault.getInstanceKey()) || !ToolUtil.isNotEmpty((Object)slotsDefault.getProps()) || !slotsDefault.getInstanceKey().contains(EXTERNAL_INTERFACE_PREFIX) || ToolUtil.isEmpty((Object)(apiId = (props = JSONObject.parseObject((String)JSONObject.toJSONString((Object)slotsDefault.getProps()))).getString("interfaceId"))) || !apiId.equals(String.valueOf(apiVersion.getApiId()))) continue;
            this.updateProps(props, apiVersion, application);
            slotsDefault.setProps((Object)props);
        }
    }

    private void updateProps(JSONObject props, EaiApiVersion apiVersion, SysApplication application) {
        props.put("applicationCode", (Object)application.getAppCode());
        props.put("appNameCache", (Object)application.getAppName());
        props.put("interfaceNameCache", (Object)apiVersion.getApiName());
        JSONObject interfaceInfoCache = props.getJSONObject("interfaceInfoCache");
        if (ToolUtil.isNotEmpty((Object)interfaceInfoCache)) {
            this.updateInterfaceInfoCache(interfaceInfoCache, apiVersion, application);
            props.put("interfaceInfoCache", (Object)interfaceInfoCache);
        }
    }

    private void updateInterfaceInfoCache(JSONObject interfaceInfoCache, EaiApiVersion apiVersion, SysApplication application) {
        interfaceInfoCache.put("name", (Object)apiVersion.getApiName());
        interfaceInfoCache.put("desc", (Object)apiVersion.getApiName());
        interfaceInfoCache.put("applicationCode", (Object)application.getAppCode());
        interfaceInfoCache.put("id", (Object)apiVersion.getApiVersionId());
        interfaceInfoCache.put("apiName", (Object)apiVersion.getApiName());
        interfaceInfoCache.put("apiCode", (Object)apiVersion.getApiCode());
        interfaceInfoCache.put("apiVersion", (Object)apiVersion.getApiVersion());
        interfaceInfoCache.put("apiPath", (Object)apiVersion.getApiPath());
        interfaceInfoCache.put("remark", (Object)apiVersion.getApiName());
        interfaceInfoCache.put("dataFormat", (Object)apiVersion.getDataFormat());
        interfaceInfoCache.put("encodingType", (Object)apiVersion.getEncodingType());
        interfaceInfoCache.put("requestType", (Object)apiVersion.getRequestType());
    }
}

