/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.manager.impl;

import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.eai.atomicenhancements.api.commonlink.service.IEaiDynamicDataSourceService;
import com.jxdinfo.hussar.eai.migration.business.manager.EaiAddDynamicDataSourceManager;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.migration.business.manager.impl.eaiAddDynamicDataSourceManagerImpl")
public class EaiAddDynamicDataSourceManagerImpl
implements EaiAddDynamicDataSourceManager {
    private static final Logger logger = LoggerFactory.getLogger(EaiAddDynamicDataSourceManagerImpl.class);
    @Autowired
    private IEaiDynamicDataSourceService eaiDynamicDataSourceService;

    @Override
    public void addDynamicDataSources(List<SysDataSource> sysDataSourceList) {
        if (ToolUtil.isEmpty(sysDataSourceList)) {
            return;
        }
        for (SysDataSource dataSource : sysDataSourceList) {
            try {
                this.eaiDynamicDataSourceService.saveDynamicDatasource(dataSource);
            }
            catch (Exception e) {
                logger.error(String.format("\u6dfb\u52a0\u6570\u636e\u6e90 %s \u5931\u8d25", dataSource.getConnName()), (Throwable)e);
            }
        }
    }
}

