/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.distinct.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.constant.EaiDataType;
import com.jxdinfo.hussar.eai.common.util.EaiParamsConvertDto;
import com.jxdinfo.hussar.eai.migration.business.distinct.service.IEaiCommonStructureResourcesService;
import com.jxdinfo.hussar.eai.migration.business.distinct.service.IEaiWSDLInfoResourcesService;
import com.jxdinfo.hussar.eai.migration.business.service.IEaiCanvasResourceIdReplaceService;
import com.jxdinfo.hussar.eai.migration.dto.EaiCommonResourcesDto;
import com.jxdinfo.hussar.eai.migration.dto.EaiCommonResourcesResultDto;
import com.jxdinfo.hussar.eai.migration.util.MigrationUtil;
import com.jxdinfo.hussar.eai.resourcebase.api.service.ICommonStructureService;
import com.jxdinfo.hussar.eai.webservice.common.entity.WSDLPort;
import com.jxdinfo.hussar.eai.webservice.common.entity.WSDLService;
import com.jxdinfo.hussar.eai.webservice.common.entity.WSDLinfo;
import com.jxdinfo.hussar.eai.webservice.common.entity.WsdlOperation;
import com.jxdinfo.hussar.eai.webservice.manager.api.model.EaiAppWsdl;
import com.jxdinfo.hussar.eai.webservice.manager.api.model.EaiAppWsdlVersion;
import com.jxdinfo.hussar.eai.webservice.manager.api.service.IEaiAppWsdlVersionService;
import com.jxdinfo.hussar.eai.webservice.manager.api.service.IWsdlInfoService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.migration.business.distinct.service.impl.EaiWSDLInfoResourcesServiceImpl")
public class EaiWSDLInfoResourcesServiceImpl
implements IEaiWSDLInfoResourcesService {
    @Resource
    private IEaiAppWsdlVersionService wsdlVersionService;
    @Resource
    private IWsdlInfoService wsdlInfoService;
    @Resource
    private IEaiCanvasResourceIdReplaceService eaiCanvasResourceIdReplaceService;
    @Resource
    private IEaiCommonStructureResourcesService commonStructureResourcesService;
    @Resource
    private ICommonStructureService commonStructureService;

    public void fillExportResourcesDumpInfo(EaiCommonResourcesDto resources, EaiCommonResourcesResultDto eaiCommonResourcesResultDto, String version) {
        List<EaiAppWsdlVersion> wsdls = resources.getWsdlList();
        if (HussarUtils.isEmpty((Object)wsdls)) {
            return;
        }
        HashMap ids = new HashMap();
        Map<Long, Long> map = HussarUtils.isEmpty((Object)eaiCommonResourcesResultDto.getAppWsdlIdMap()) ? new HashMap() : eaiCommonResourcesResultDto.getAppWsdlIdMap();
        Map<String, Long> codeIdMap = HussarUtils.isEmpty((Object)eaiCommonResourcesResultDto.getAppWsdlCodeIdMap()) ? new HashMap() : eaiCommonResourcesResultDto.getAppWsdlCodeIdMap();
        for (EaiAppWsdlVersion wsdlVersion : wsdls) {
            if (map.containsKey(wsdlVersion.getId())) continue;
            if (codeIdMap.containsKey(wsdlVersion.getWsdlPath())) {
                if (!wsdlVersion.getId().equals(codeIdMap.get(wsdlVersion.getWsdlPath()))) {
                    map.put(wsdlVersion.getId(), (Long)codeIdMap.get(wsdlVersion.getWsdlPath()));
                    ids.put(wsdlVersion.getWsdlPath(), codeIdMap.get(wsdlVersion.getWsdlPath()));
                    continue;
                }
                map.put(wsdlVersion.getId(), wsdlVersion.getId());
                continue;
            }
            if (version.equals(wsdlVersion.getWsdlVersion())) {
                codeIdMap.put(wsdlVersion.getWsdlPath(), wsdlVersion.getId());
                map.put(wsdlVersion.getId(), wsdlVersion.getId());
                continue;
            }
            Integer v = Integer.valueOf(version.substring(1));
            EaiAppWsdlVersion eaiAppWsdlVersion = this.getLastVersion(v, wsdlVersion);
            if (HussarUtils.isNotEmpty((Object)eaiAppWsdlVersion.getApplicationVersion())) {
                ids.put(wsdlVersion.getWsdlPath(), eaiAppWsdlVersion.getId());
                codeIdMap.put(wsdlVersion.getWsdlPath(), eaiAppWsdlVersion.getId());
                map.put(wsdlVersion.getId(), eaiAppWsdlVersion.getId());
                continue;
            }
            codeIdMap.put(wsdlVersion.getWsdlPath(), wsdlVersion.getId());
            map.put(wsdlVersion.getId(), wsdlVersion.getId());
        }
        if (HussarUtils.isNotEmpty(ids)) {
            List curr = wsdls.stream().map(EaiAppWsdlVersion::getId).collect(Collectors.toList());
            ArrayList val = new ArrayList(ids.values());
            if (HussarUtils.isNotEmpty(curr)) {
                val.removeAll(curr);
            }
            if (HussarUtils.isNotEmpty(val)) {
                List wsdlVersions = this.wsdlVersionService.listByIds(val);
                wsdls.addAll(wsdlVersions);
            }
        }
        if (HussarUtils.isNotEmpty(wsdls = this.lastVersion(wsdls, version))) {
            ArrayList<Long> structureIds = new ArrayList<Long>();
            List contents = wsdls.stream().map(EaiAppWsdlVersion::getWsdlContent).collect(Collectors.toList());
            for (String content : contents) {
                WSDLinfo wsdLinfo = (WSDLinfo)JSON.parseObject((String)content, WSDLinfo.class);
                List wsdlPorts = wsdLinfo.getWsdlServiceDtos().stream().map(WSDLService::getPorts).flatMap(Collection::stream).collect(Collectors.toList());
                List<WsdlOperation> wsdlOperations = wsdlPorts.stream().map(WSDLPort::getOperations).flatMap(Collection::stream).collect(Collectors.toList());
                if (!HussarUtils.isNotEmpty(wsdlOperations)) continue;
                this.operation(wsdlOperations, structureIds);
            }
            List commonStructures = this.commonStructureService.listByIds(structureIds);
            EaiCommonResourcesDto commonResourcesDto = new EaiCommonResourcesDto();
            HashMap<Long, Long> vMap = new HashMap<Long, Long>();
            if (HussarUtils.isNotEmpty((Object)resources.getStructureList())) {
                commonResourcesDto.setStructureList(resources.getStructureList());
            }
            List structureVersions = this.commonStructureResourcesService.fillExportCommonStructure(commonStructures, commonResourcesDto, vMap);
            for (EaiAppWsdlVersion wsdl : wsdls) {
                wsdl.setWsdlContent(this.replaceWsdlContent(wsdl.getWsdlContent(), vMap));
            }
            commonResourcesDto.setStructureList(structureVersions);
            if (HussarUtils.isNotEmpty((Object)commonResourcesDto.getStructureList())) {
                if (HussarUtils.isNotEmpty((Object)resources.getStructureList())) {
                    resources.getStructureList().addAll(commonResourcesDto.getStructureList());
                } else {
                    resources.setStructureList(commonResourcesDto.getStructureList());
                }
            }
            this.commonStructureResourcesService.fillExportResourcesDumpInfo(resources, eaiCommonResourcesResultDto, version);
        }
        for (EaiAppWsdlVersion wsdl : wsdls) {
            wsdl.setWsdlContent(this.replaceWsdlContent(wsdl.getWsdlContent(), eaiCommonResourcesResultDto.getStructureIdMap()));
        }
        resources.setWsdlList(wsdls);
        map = MigrationUtil.lastMapping(map);
        eaiCommonResourcesResultDto.setAppWsdlIdMap(map);
        eaiCommonResourcesResultDto.setAppWsdlCodeIdMap(codeIdMap);
    }

    public void importResourcesIdCodeMap(String appCode, Boolean isNewAppCode, EaiCommonResourcesDto resourcesDto, EaiCommonResourcesResultDto eaiCommonResourcesResultDto) {
        if (HussarUtils.isEmpty((Object)resourcesDto) && HussarUtils.isEmpty((Object)resourcesDto.getWsdlList())) {
            return;
        }
        this.commonStructureResourcesService.importResourcesIdCodeMap(appCode, isNewAppCode, resourcesDto, eaiCommonResourcesResultDto);
        this.replaceNewCodeId(appCode, resourcesDto.getWsdlList(), eaiCommonResourcesResultDto, isNewAppCode == false);
    }

    private void operation(List<WsdlOperation> operations, List<Long> structureIds) {
        for (WsdlOperation wsdlOperation : operations) {
            EaiParamsConvertDto outParams;
            EaiParamsConvertDto inparams = wsdlOperation.getInParams();
            if (HussarUtils.isNotEmpty((Object)inparams)) {
                EaiParamsItems paramsItems = inparams.getBody();
                this.structureIds(paramsItems, structureIds);
                List header = inparams.getHeader();
                this.structureIds(header, structureIds);
                List query = inparams.getQuery();
                this.structureIds(query, structureIds);
            }
            if (!HussarUtils.isNotEmpty((Object)(outParams = wsdlOperation.getOutParams()))) continue;
            EaiParamsItems paramsItems = outParams.getBody();
            this.structureIds(paramsItems, structureIds);
            List header = outParams.getHeader();
            this.structureIds(header, structureIds);
            List query = outParams.getQuery();
            this.structureIds(query, structureIds);
        }
    }

    private void structureIds(List<EaiParamsItems> paramsItems, List<Long> structureIds) {
        if (HussarUtils.isNotEmpty(paramsItems)) {
            for (EaiParamsItems eaiParamsItem : paramsItems) {
                this.structureIds(eaiParamsItem, structureIds);
            }
        }
    }

    private void structureIds(EaiParamsItems paramsItems, List<Long> structureIds) {
        Long id;
        if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == paramsItems.getType().intValue()) {
            Long id2 = Long.valueOf(paramsItems.getQuoteStructureId());
            if (!structureIds.contains(id2)) {
                structureIds.add(id2);
            }
        } else if (EaiDataType.DATA_TYPE_LIST.getType() == paramsItems.getType().intValue() && EaiDataType.DATA_TYPE_STRUCTURE.getType() == paramsItems.getItemType().intValue() && !structureIds.contains(id = Long.valueOf(((EaiParamsItems)paramsItems.getItems().get(0)).getQuoteStructureId()))) {
            structureIds.add(id);
        }
        if (HussarUtils.isNotEmpty((Object)paramsItems.getItems())) {
            this.structureIds(paramsItems.getItems(), structureIds);
        }
    }

    private List<EaiAppWsdlVersion> lastVersion(List<EaiAppWsdlVersion> wsdlVersions, String version) {
        if (HussarUtils.isEmpty(wsdlVersions)) {
            return Collections.emptyList();
        }
        HashMap<String, EaiAppWsdlVersion> map = new HashMap<String, EaiAppWsdlVersion>(wsdlVersions.size());
        for (EaiAppWsdlVersion wsdlVersion : wsdlVersions) {
            if (map.containsKey(wsdlVersion.getWsdlPath())) {
                String v = wsdlVersion.getApplicationVersion();
                if (HussarUtils.isEmpty((Object)v)) continue;
                if (version.equals(v)) {
                    map.put(wsdlVersion.getWsdlPath(), wsdlVersion);
                    continue;
                }
                String oldV = ((EaiAppWsdlVersion)map.get(wsdlVersion.getWsdlPath())).getWsdlPath();
                if (HussarUtils.isEmpty((Object)oldV)) {
                    map.put(wsdlVersion.getWsdlPath(), wsdlVersion);
                    continue;
                }
                if (!MigrationUtil.compareVersion((String)v, (String)oldV)) continue;
                map.put(wsdlVersion.getWsdlPath(), wsdlVersion);
                continue;
            }
            map.put(wsdlVersion.getWsdlPath(), wsdlVersion);
        }
        return new ArrayList<EaiAppWsdlVersion>(map.values());
    }

    private void replaceNewCodeId(String appCpde, List<EaiAppWsdlVersion> wsdlVersions, EaiCommonResourcesResultDto eaiCommonResourcesResultDto, Boolean compare) {
        Map<String, Long> codeIdMap;
        Map<Long, Long> idMap = eaiCommonResourcesResultDto.getAppWsdlIdMap() == null ? new HashMap() : eaiCommonResourcesResultDto.getAppWsdlIdMap();
        Map map = codeIdMap = eaiCommonResourcesResultDto.getAppWsdlCodeIdMap() == null ? new HashMap() : eaiCommonResourcesResultDto.getAppWsdlCodeIdMap();
        if (HussarUtils.isNotEmpty(wsdlVersions)) {
            for (EaiAppWsdlVersion wsdlVersion : wsdlVersions) {
                if (codeIdMap.containsKey(wsdlVersion.getWsdlPath())) continue;
                Long id = EngineUtil.getId();
                LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiAppWsdl::getApplicationCode, (Object)appCpde)).eq(EaiAppWsdl::getWsdlPath, (Object)wsdlVersion.getWsdlPath());
                EaiAppWsdl wsdl = (EaiAppWsdl)this.wsdlInfoService.getOne((Wrapper)queryWrapper);
                if (HussarUtils.isNotEmpty((Object)wsdl)) {
                    id = wsdl.getId();
                    EaiAppWsdl updateWsdl = (EaiAppWsdl)BeanUtil.copyProperties((Object)wsdlVersion, EaiAppWsdl.class);
                    updateWsdl.setId(id);
                    updateWsdl.setApplicationCode(appCpde);
                    updateWsdl.setWsdlContent(this.replaceWsdlContent(updateWsdl.getWsdlContent(), eaiCommonResourcesResultDto));
                    this.wsdlInfoService.updateById((Object)updateWsdl);
                } else {
                    EaiAppWsdl eaiAppWsdl = (EaiAppWsdl)BeanUtil.copyProperties((Object)wsdlVersion, EaiAppWsdl.class);
                    eaiAppWsdl.setId(id);
                    eaiAppWsdl.setApplicationCode(appCpde);
                    eaiAppWsdl.setWsdlContent(this.replaceWsdlContent(eaiAppWsdl.getWsdlContent(), eaiCommonResourcesResultDto));
                    this.wsdlInfoService.save((Object)eaiAppWsdl);
                }
                idMap.put(wsdlVersion.getId(), id);
                codeIdMap.put(wsdlVersion.getWsdlPath(), wsdlVersion.getId());
            }
        }
        eaiCommonResourcesResultDto.setAppWsdlIdMap(idMap);
        eaiCommonResourcesResultDto.setAppWsdlCodeIdMap(codeIdMap);
    }

    private String replaceWsdlContent(String content, Map<Long, Long> map) {
        return this.eaiCanvasResourceIdReplaceService.replaceIds(content, map);
    }

    private String replaceWsdlContent(String content, EaiCommonResourcesResultDto eaiCommonResourcesResultDto) {
        return this.eaiCanvasResourceIdReplaceService.replaceIds(content, eaiCommonResourcesResultDto.getStructureIdMap());
    }

    private EaiAppWsdlVersion getLastVersion(Integer v, EaiAppWsdlVersion wsdl) {
        EaiAppWsdlVersion wsdlVersion = wsdl;
        while (v > 0) {
            String version = String.format("v%s", v);
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiAppWsdlVersion::getWsdlPath, (Object)wsdl.getWsdlPath())).eq(EaiAppWsdlVersion::getApplicationCode, (Object)wsdl.getApplicationCode())).eq(EaiAppWsdlVersion::getApplicationVersion, (Object)version);
            EaiAppWsdlVersion finalVersion = (EaiAppWsdlVersion)this.wsdlVersionService.getOne((Wrapper)queryWrapper);
            if (finalVersion == null) {
                Integer n = v;
                Integer n2 = v = Integer.valueOf(v - 1);
                continue;
            }
            wsdlVersion = finalVersion;
            break;
        }
        return wsdlVersion;
    }
}

