/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.distinct.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.eai.common.constant.EaiDataType;
import com.jxdinfo.hussar.eai.common.util.StructureItems;
import com.jxdinfo.hussar.eai.migration.business.distinct.service.IEaiCommonStructureResourcesService;
import com.jxdinfo.hussar.eai.migration.business.resources.service.IEaiCleanStructureItemService;
import com.jxdinfo.hussar.eai.migration.dto.EaiCommonResourcesDto;
import com.jxdinfo.hussar.eai.migration.dto.EaiCommonResourcesResultDto;
import com.jxdinfo.hussar.eai.migration.util.MigrationUtil;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonStructure;
import com.jxdinfo.hussar.eai.resourcebase.api.service.ICommonStructureService;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.StructureVersion;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.serevice.IStructureVersionService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.migration.business.distinct.service.impl.EaiCommonStructureResourcesServiceImpl")
public class EaiCommonStructureResourcesServiceImpl
implements IEaiCommonStructureResourcesService {
    @Resource
    private IStructureVersionService structureVersionService;
    @Resource
    private ICommonStructureService commonStructureService;
    @Resource
    private IEaiCleanStructureItemService eaiCleanStructureItemService;
    private static final Logger logger = LoggerFactory.getLogger(EaiCommonStructureResourcesServiceImpl.class);
    private static String ERROR_MSG = "\u5e94\u7528\u5bfc\u51fa\u5931\u8d25,\u5bfc\u51fa\u6570\u636e\u7ed3\u6784\u4fe1\u606f\u7f3a\u5931:\u3010STRUCTURE_VERSION_ID=%s\u3011";

    public void fillExportResourcesDumpInfo(EaiCommonResourcesDto resources, EaiCommonResourcesResultDto eaiCommonResourcesResultDto, String version) {
        List commonStructures = resources.getStructureList();
        if (HussarUtils.isEmpty((Object)commonStructures)) {
            return;
        }
        HashMap<String, Long> ids = new HashMap<String, Long>();
        Map map = HussarUtils.isEmpty((Object)eaiCommonResourcesResultDto.getStructureIdMap()) ? new HashMap() : eaiCommonResourcesResultDto.getStructureIdMap();
        HashMap<String, Long> codeIdMap = HussarUtils.isEmpty((Object)eaiCommonResourcesResultDto.getStructureCodeIdMap()) ? new HashMap() : eaiCommonResourcesResultDto.getStructureCodeIdMap();
        for (StructureVersion commonStructure : commonStructures) {
            this.fillCommonStructure(ids, commonStructure, codeIdMap, map, version);
        }
        if (HussarUtils.isNotEmpty(ids)) {
            List curr = commonStructures.stream().map(StructureVersion::getId).collect(Collectors.toList());
            ArrayList val = new ArrayList(ids.values());
            if (HussarUtils.isNotEmpty(curr)) {
                val.removeAll(curr);
            }
            if (HussarUtils.isNotEmpty(val)) {
                List structureVersions = this.structureVersionService.listByIds(val);
                this.eaiCleanStructureItemService.cleanItems(structureVersions);
                commonStructures.addAll(structureVersions);
                commonStructures = this.lastVersion(commonStructures, version, map, codeIdMap);
                this.replaceResultStructureId(commonStructures, map);
                resources.setStructureList(commonStructures);
                map = MigrationUtil.lastMapping(map);
                eaiCommonResourcesResultDto.setStructureIdMap(map);
                eaiCommonResourcesResultDto.setStructureCodeIdMap(codeIdMap);
                this.fillExportResourcesDumpInfo(resources, eaiCommonResourcesResultDto, version);
                commonStructures = resources.getStructureList();
            }
        }
        commonStructures = this.lastVersion(commonStructures, version, map, codeIdMap);
        this.replaceResultStructureId(commonStructures, map);
        resources.setStructureList(commonStructures);
        map = MigrationUtil.lastMapping(map);
        eaiCommonResourcesResultDto.setStructureIdMap(map);
        eaiCommonResourcesResultDto.setStructureCodeIdMap(codeIdMap);
    }

    public void importResourcesIdCodeMap(String appCode, Boolean isNewAppCode, EaiCommonResourcesDto resourcesDto, EaiCommonResourcesResultDto eaiCommonResourcesResultDto) {
        if (HussarUtils.isEmpty((Object)resourcesDto) && HussarUtils.isEmpty((Object)resourcesDto.getStructureList())) {
            return;
        }
        this.replaceNewCodeId(appCode, resourcesDto.getStructureList(), eaiCommonResourcesResultDto, isNewAppCode == false);
    }

    public List<StructureVersion> fillExportCommonStructure(List<CommonStructure> commonStructures, EaiCommonResourcesDto commonResourcesDto, Map<Long, Long> vIds) {
        if (HussarUtils.isEmpty(commonStructures)) {
            return Collections.emptyList();
        }
        if (vIds == null) {
            vIds = new HashMap<Long, Long>();
        }
        ArrayList<StructureVersion> structureVersions = new ArrayList<StructureVersion>(commonStructures.size());
        HashMap<Long, Object> structureVersionMap = new HashMap<Long, Object>();
        if (HussarUtils.isNotEmpty((Object)commonResourcesDto.getStructureList())) {
            for (Object structureVersion : commonResourcesDto.getStructureList()) {
                if (vIds.containsKey(structureVersion.getStructureId())) continue;
                vIds.put(structureVersion.getStructureId(), structureVersion.getId());
                structureVersionMap.put(structureVersion.getId(), structureVersion);
                structureVersions.add((StructureVersion)structureVersion);
            }
        }
        HashMap<Long, CommonStructure> ids = new HashMap<Long, CommonStructure>();
        for (CommonStructure commonStructure : commonStructures) {
            ids.put(commonStructure.getId(), commonStructure);
        }
        if (HussarUtils.isNotEmpty(vIds)) {
            for (Map.Entry entry : vIds.entrySet()) {
                if (!HussarUtils.isNotEmpty(ids) || !ids.containsKey(entry.getKey())) continue;
                ids.remove(entry.getKey());
            }
        }
        if (HussarUtils.isEmpty(ids)) {
            return structureVersions;
        }
        ArrayList commonStructures1 = new ArrayList(ids.values());
        for (CommonStructure commonStructure : commonStructures1) {
            List itemStructures;
            List<StructureVersion> itemVersions;
            if (vIds.containsKey(commonStructure.getId())) continue;
            Long id = EngineUtil.getId();
            StructureVersion structureVersion = this.initStructureVersion(commonStructure, id);
            vIds.put(commonStructure.getId(), id);
            if (HussarUtils.isEmpty((Object)structureVersion.getStructureValues())) {
                structureVersions.add(structureVersion);
                continue;
            }
            List structureItems = JSON.parseArray((String)commonStructure.getStructureValues(), StructureItems.class);
            ArrayList<Long> itemIds = new ArrayList<Long>();
            for (StructureItems structureItem : structureItems) {
                this.structureIds(structureItem, vIds, itemIds);
            }
            if (HussarUtils.isEmpty(itemIds)) {
                this.replaceStructureId(structureItems, vIds);
                structureVersion.setStructureValues(JSON.toJSONString((Object)structureItems));
                structureVersions.add(structureVersion);
                continue;
            }
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(StructureVersion::getStructureId, itemIds);
            List publishVersions = this.structureVersionService.list((Wrapper)queryWrapper);
            if (HussarUtils.isNotEmpty((Object)publishVersions)) {
                HashMap<String, StructureVersion> items = new HashMap<String, StructureVersion>();
                this.eaiCleanStructureItemService.cleanItems(publishVersions);
                for (StructureVersion publishVersion : publishVersions) {
                    if (vIds.containsKey(publishVersion.getStructureId()) || items.containsKey(publishVersion.getStructureCode())) continue;
                    items.put(publishVersion.getStructureCode(), publishVersion);
                    vIds.put(publishVersion.getStructureId(), publishVersion.getId());
                }
                structureVersions.addAll(items.values());
                itemIds.removeAll(vIds.keySet());
            }
            if (HussarUtils.isNotEmpty(itemIds) && HussarUtils.isNotEmpty(itemVersions = this.fillExportCommonStructure(itemStructures = this.commonStructureService.listByIds(itemIds), commonResourcesDto, vIds))) {
                structureVersions.addAll(itemVersions);
            }
            this.replaceStructureId(structureItems, vIds);
            structureVersion.setStructureValues(JSON.toJSONString((Object)structureItems));
            structureVersions.add(structureVersion);
        }
        this.mergeCommonResourcesDto(commonResourcesDto, structureVersions);
        return structureVersions;
    }

    private StructureVersion initStructureVersion(CommonStructure commonStructure, Long id) {
        StructureVersion structureVersion = (StructureVersion)BeanUtil.copyProperties((Object)commonStructure, StructureVersion.class);
        structureVersion.setStructureVersion("v1");
        structureVersion.setId(id);
        structureVersion.setStructureId(commonStructure.getId());
        return structureVersion;
    }

    private void mergeCommonResourcesDto(EaiCommonResourcesDto commonResourcesDto, List<StructureVersion> structureVersions) {
        if (HussarUtils.isEmpty(structureVersions)) {
            return;
        }
        if (HussarUtils.isNotEmpty((Object)commonResourcesDto.getStructureList())) {
            commonResourcesDto.getStructureList().addAll(structureVersions);
        } else {
            commonResourcesDto.setStructureList(structureVersions);
        }
    }

    private void structureIds(List<StructureItems> paramsItems, Map<Long, Long> vIds, List<Long> structureIds) {
        if (HussarUtils.isNotEmpty(paramsItems)) {
            for (StructureItems eaiParamsItem : paramsItems) {
                this.structureIds(eaiParamsItem, vIds, structureIds);
            }
        }
    }

    private void structureIds(StructureItems paramsItems, Map<Long, Long> vIds, List<Long> structureIds) {
        Long id;
        if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == paramsItems.getType().intValue()) {
            Long id2 = Long.valueOf(paramsItems.getQuoteStructureId());
            if (!vIds.containsKey(id2) && !structureIds.contains(id2)) {
                structureIds.add(id2);
            }
        } else if (EaiDataType.DATA_TYPE_LIST.getType() == paramsItems.getType().intValue() && EaiDataType.DATA_TYPE_STRUCTURE.getType() == paramsItems.getItemType().intValue() && !vIds.containsKey(id = Long.valueOf(((StructureItems)paramsItems.getItems().get(0)).getQuoteStructureId())) && !structureIds.contains(id)) {
            structureIds.add(id);
        }
        if (HussarUtils.isNotEmpty((Object)paramsItems.getItems())) {
            this.structureIds(paramsItems.getItems(), vIds, structureIds);
        }
    }

    private List<StructureVersion> lastVersion(List<StructureVersion> commonStructures, String version, Map<Long, Long> structureIdMap, Map<String, Long> codeIdMap) {
        if (HussarUtils.isEmpty(commonStructures)) {
            return Collections.emptyList();
        }
        HashMap<String, StructureVersion> map = new HashMap<String, StructureVersion>(commonStructures.size());
        for (StructureVersion structureVersion : commonStructures) {
            if (map.containsKey(structureVersion.getStructureCode())) {
                String v = structureVersion.getStructureVersion();
                if (version.equals(v)) {
                    map.put(structureVersion.getStructureCode(), structureVersion);
                    continue;
                }
                String oldV = ((StructureVersion)map.get(structureVersion.getStructureCode())).getStructureVersion();
                if (!MigrationUtil.compareVersion((String)v, (String)oldV)) continue;
                structureIdMap.put(((StructureVersion)map.get(structureVersion.getStructureCode())).getId(), structureVersion.getId());
                codeIdMap.put(structureVersion.getStructureCode(), structureVersion.getId());
                map.put(structureVersion.getStructureCode(), structureVersion);
                continue;
            }
            map.put(structureVersion.getStructureCode(), structureVersion);
        }
        return new ArrayList<StructureVersion>(map.values());
    }

    private void saveStructureItems(Long parentId, String appCode, List<StructureVersion> structureVersions, List<StructureItems> structureItems, Map<Long, Long> idMap, Map<String, Long> codeIdMap, Map<Long, List<Long>> ids, Boolean compare) {
        for (StructureItems structureItem : structureItems) {
            if (EaiDataType.DATA_TYPE_LIST.getType() == structureItem.getType().intValue()) {
                this.saveStructureItems(parentId, appCode, structureVersions, structureItem.getItems(), idMap, codeIdMap, ids, compare);
                continue;
            }
            if (EaiDataType.DATA_TYPE_STRUCTURE.getType() != structureItem.getType().intValue()) continue;
            Long id = Long.valueOf(structureItem.getQuoteStructureId());
            if (idMap.containsKey(id)) {
                structureItem.setQuoteStructureId(String.valueOf(idMap.get(id)));
                continue;
            }
            StructureVersion structureVersion = structureVersions.stream().filter(f -> f.getId().equals(id)).findAny().orElse(null);
            if (ids.containsKey(parentId)) {
                ids.get(parentId).add(structureVersion.getId());
            } else {
                ArrayList<Long> child = new ArrayList<Long>(1);
                child.add(structureVersion.getId());
                ids.put(parentId, child);
            }
            this.replaceStructureId(appCode, structureVersion, structureVersions, idMap, codeIdMap, ids, compare);
            structureItem.setQuoteStructureId(String.valueOf(structureVersion.getId()));
        }
    }

    private void replaceResultStructureId(List<StructureVersion> structureVersions, Map<Long, Long> map) {
        if (HussarUtils.isEmpty(structureVersions) || HussarUtils.isEmpty(map)) {
            return;
        }
        for (StructureVersion structureVersion : structureVersions) {
            if (HussarUtils.isEmpty((Object)structureVersion.getStructureValues())) continue;
            List structureItems = JSON.parseArray((String)structureVersion.getStructureValues(), StructureItems.class);
            this.replaceStructureId(structureItems, map);
            structureVersion.setStructureValues(JSON.toJSONString((Object)structureItems));
        }
    }

    private void replaceStructureId(List<StructureItems> structureItems, Map<Long, Long> map) {
        if (HussarUtils.isEmpty(map)) {
            return;
        }
        for (StructureItems structureItem : structureItems) {
            Long id;
            if (HussarUtils.isNotEmpty((Object)structureItem.getQuoteStructureId()) && map.containsKey(id = Long.valueOf(structureItem.getQuoteStructureId()))) {
                structureItem.setQuoteStructureId(String.valueOf(map.get(id)));
            }
            if (!HussarUtils.isNotEmpty((Object)structureItem.getItems())) continue;
            this.replaceStructureId(structureItem.getItems(), map);
        }
    }

    private void replaceStructureId(String appCode, StructureVersion structureVersion, List<StructureVersion> structureVersions, Map<Long, Long> idMap, Map<String, Long> codeIdMap, Boolean compare) {
        HashMap<Long, List<Long>> map = new HashMap<Long, List<Long>>(2);
        this.replaceStructureId(appCode, structureVersion, structureVersions, idMap, codeIdMap, map, compare);
        if (HussarUtils.isNotEmpty(map)) {
            for (Map.Entry entry : map.entrySet()) {
                Long savedId = idMap.get(entry.getKey());
                CommonStructure structure = (CommonStructure)this.commonStructureService.getById((Serializable)savedId);
                String structureValues = structure.getStructureValues();
                structureValues = this.replaceStructureValues(structureValues, (List)entry.getValue(), idMap);
                structure.setStructureValues(structureValues);
                this.commonStructureService.updateById((Object)structure);
            }
        }
    }

    private void replaceStructureId(String appCode, StructureVersion structureVersion, List<StructureVersion> structureVersions, Map<Long, Long> idMap, Map<String, Long> codeIdMap, Map<Long, List<Long>> ids, Boolean compare) {
        if (HussarUtils.isEmpty((Object)structureVersion)) {
            return;
        }
        if (!codeIdMap.containsKey(structureVersion.getStructureCode())) {
            if (HussarUtils.isNotEmpty((Object)structureVersion.getStructureValues()) && !ids.containsKey(structureVersion.getId())) {
                List structureItems = JSON.parseArray((String)structureVersion.getStructureValues(), StructureItems.class);
                this.saveStructureItems(structureVersion.getId(), appCode, structureVersions, structureItems, idMap, codeIdMap, ids, compare);
                structureVersion.setStructureValues(JSON.toJSONString((Object)structureItems));
            }
            Long id = this.saveStructure(structureVersion, appCode);
            idMap.put(structureVersion.getId(), id);
            codeIdMap.put(structureVersion.getStructureCode(), id);
        } else {
            idMap.put(structureVersion.getId(), codeIdMap.get(structureVersion.getStructureCode()));
        }
    }

    private String replaceStructureValues(String structureValues, List<Long> childIds, Map<Long, Long> idMaps) {
        for (Long childId : childIds) {
            structureValues = structureValues.replace(this.getQuoteId(childId), this.getQuoteId(idMaps.get(childId)));
        }
        return structureValues;
    }

    private String getQuoteId(Long id) {
        return String.format("\"quoteStructureId\":\"%s\"", id);
    }

    private Long saveStructure(StructureVersion structureVersion, String appCode) {
        Long id = EngineUtil.getId();
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CommonStructure::getApplicationCode, (Object)appCode)).eq(CommonStructure::getStructureCode, (Object)structureVersion.getStructureCode());
        List structureList = this.commonStructureService.list((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)structureList)) {
            if (structureList.size() == 1) {
                CommonStructure structure = (CommonStructure)structureList.get(0);
                id = structure.getId();
                CommonStructure updateStructure = (CommonStructure)BeanUtil.copyProperties((Object)structureVersion, CommonStructure.class);
                updateStructure.setId(id);
                updateStructure.setApplicationCode(appCode);
                this.commonStructureService.updateById((Object)updateStructure);
            } else {
                List ids = structureList.stream().filter(f -> HussarUtils.isEmpty((Object)f.getStructureName())).map(CommonStructure::getId).collect(Collectors.toList());
                this.commonStructureService.removeByIds(ids);
                CommonStructure commonStructure = (CommonStructure)BeanUtil.copyProperties((Object)structureVersion, CommonStructure.class);
                commonStructure.setId(id);
                commonStructure.setApplicationCode(appCode);
                this.commonStructureService.save((Object)commonStructure);
            }
        } else {
            CommonStructure commonStructure = (CommonStructure)BeanUtil.copyProperties((Object)structureVersion, CommonStructure.class);
            commonStructure.setId(id);
            commonStructure.setApplicationCode(appCode);
            this.commonStructureService.save((Object)commonStructure);
        }
        return id;
    }

    private void replaceNewCodeId(String appCode, List<StructureVersion> structureVersions, EaiCommonResourcesResultDto eaiCommonResourcesResultDto, Boolean compare) {
        HashMap<String, Long> codeIdMap;
        HashMap<Long, Long> idMap = eaiCommonResourcesResultDto.getStructureIdMap() == null ? new HashMap() : eaiCommonResourcesResultDto.getStructureIdMap();
        Map map = codeIdMap = eaiCommonResourcesResultDto.getStructureCodeIdMap() == null ? new HashMap() : eaiCommonResourcesResultDto.getStructureCodeIdMap();
        if (HussarUtils.isNotEmpty(structureVersions)) {
            for (StructureVersion structureVersion : structureVersions) {
                this.replaceStructureId(appCode, structureVersion, structureVersions, idMap, codeIdMap, compare);
            }
        }
        eaiCommonResourcesResultDto.setStructureIdMap(idMap);
        eaiCommonResourcesResultDto.setStructureCodeIdMap(codeIdMap);
    }

    private void fillCommonStructure(Map<String, Long> ids, StructureVersion commonStructure, Map<String, Long> codeIdMap, Map<Long, Long> map, String version) {
        if (!map.containsKey(commonStructure.getId())) {
            if (codeIdMap.containsKey(commonStructure.getStructureCode())) {
                if (!commonStructure.getId().equals(codeIdMap.get(commonStructure.getStructureCode()))) {
                    map.put(commonStructure.getId(), codeIdMap.get(commonStructure.getStructureCode()));
                    ids.put(commonStructure.getStructureCode(), commonStructure.getId());
                } else {
                    map.put(commonStructure.getId(), commonStructure.getId());
                }
            } else {
                StructureVersion structureVersion = commonStructure;
                if (version.equals(commonStructure.getStructureVersion())) {
                    codeIdMap.put(commonStructure.getStructureCode(), commonStructure.getId());
                    map.put(commonStructure.getId(), commonStructure.getId());
                    String values = commonStructure.getStructureValues();
                    if (HussarUtils.isNotEmpty((Object)values)) {
                        List structureItems = JSON.parseArray((String)values, StructureItems.class);
                        this.structureItems(structureItems, codeIdMap, map, version, ids);
                        commonStructure.setStructureValues(JSON.toJSONString((Object)structureItems));
                    }
                } else {
                    Integer v = Integer.valueOf(version.substring(1));
                    structureVersion = this.getLastVersion(v, commonStructure);
                    codeIdMap.put(structureVersion.getStructureCode(), structureVersion.getId());
                    map.put(commonStructure.getId(), structureVersion.getId());
                    ids.put(structureVersion.getStructureCode(), structureVersion.getId());
                    ArrayList<StructureVersion> structureVersions = new ArrayList<StructureVersion>(1);
                    structureVersions.add(structureVersion);
                    this.eaiCleanStructureItemService.cleanItems(structureVersions);
                    String val = ((StructureVersion)structureVersions.get(0)).getStructureValues();
                    if (HussarUtils.isNotEmpty((Object)val)) {
                        List structureItems = JSON.parseArray((String)val, StructureItems.class);
                        this.structureItems(structureItems, codeIdMap, map, version, ids);
                        commonStructure = structureVersion;
                        commonStructure.setStructureValues(JSON.toJSONString((Object)structureItems));
                    }
                }
            }
        }
    }

    private void structureItems(List<StructureItems> structureItems, Map<String, Long> codeIdMap, Map<Long, Long> map, String version, Map<String, Long> ids) {
        for (StructureItems structureItem : structureItems) {
            if (EaiDataType.DATA_TYPE_LIST.getType() == structureItem.getType().intValue()) {
                this.structureItems(structureItem.getItems(), codeIdMap, map, version, ids);
                continue;
            }
            if (EaiDataType.DATA_TYPE_STRUCTURE.getType() != structureItem.getType().intValue() || map.containsKey(Long.valueOf(structureItem.getQuoteStructureId()))) continue;
            StructureVersion structureVersion = (StructureVersion)this.structureVersionService.getById((Serializable)Long.valueOf(structureItem.getQuoteStructureId()));
            if (HussarUtils.isEmpty((Object)structureVersion)) {
                logger.info(String.format(ERROR_MSG, structureItem.getQuoteStructureId()));
                throw new BaseException(String.format(ERROR_MSG, structureItem.getQuoteStructureId()));
            }
            if (!ids.containsKey(structureVersion.getStructureCode())) {
                ids.put(structureVersion.getStructureCode(), structureVersion.getId());
            }
            ArrayList<StructureVersion> structureVersions = new ArrayList<StructureVersion>(1);
            structureVersions.add(structureVersion);
            this.eaiCleanStructureItemService.cleanItems(structureVersions);
            this.fillCommonStructure(ids, structureVersion, codeIdMap, map, version);
            structureItem.setQuoteStructureId(String.valueOf(map.get(structureVersion.getId())));
        }
    }

    private StructureVersion getLastVersion(Integer v, StructureVersion structure) {
        StructureVersion structureVersion = structure;
        while (v > 0) {
            String version = String.format("v%s", v);
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(StructureVersion::getStructureCode, (Object)structure.getStructureCode())).eq(StructureVersion::getApplicationCode, (Object)structure.getApplicationCode())).eq(StructureVersion::getStructureVersion, (Object)version);
            StructureVersion finalVersion = (StructureVersion)this.structureVersionService.getOne((Wrapper)queryWrapper);
            if (finalVersion == null) {
                Integer n = v;
                Integer n2 = v = Integer.valueOf(v - 1);
                continue;
            }
            ArrayList<StructureVersion> structureVersions = new ArrayList<StructureVersion>(1);
            structureVersions.add(finalVersion);
            this.eaiCleanStructureItemService.cleanItems(structureVersions);
            structureVersion = (StructureVersion)structureVersions.get(0);
            break;
        }
        return structureVersion;
    }
}

