/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.distinct.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.eai.common.enums.app.EaiResourcesEnum;
import com.jxdinfo.hussar.eai.migration.business.distinct.service.IEaiCanvasInfoResourcesService;
import com.jxdinfo.hussar.eai.migration.business.distinct.service.IEaiCommonConstantResourcesService;
import com.jxdinfo.hussar.eai.migration.business.distinct.service.IEaiCommonLinkResourcesService;
import com.jxdinfo.hussar.eai.migration.business.distinct.service.IEaiCommonLogicResourcesService;
import com.jxdinfo.hussar.eai.migration.business.distinct.service.IEaiCommonStructureResourcesService;
import com.jxdinfo.hussar.eai.migration.business.service.IEaiCanvasResourceIdReplaceService;
import com.jxdinfo.hussar.eai.migration.dto.EaiCommonLogicDto;
import com.jxdinfo.hussar.eai.migration.dto.EaiCommonResourcesDto;
import com.jxdinfo.hussar.eai.migration.dto.EaiCommonResourcesResultDto;
import com.jxdinfo.hussar.eai.migration.util.MigrationUtil;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.serevice.IConstantVersionService;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.serevice.IStructureVersionService;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CanvasInfo;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CommonLogic;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICanvasInfoService;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICommonLogicService;
import com.jxdinfo.hussar.eai.resourceexternalopen.api.model.LogicVersion;
import com.jxdinfo.hussar.eai.resourceexternalopen.api.service.IConnectionVersionService;
import com.jxdinfo.hussar.eai.resourceexternalopen.api.service.IEaiLogicVersionService;
import com.jxdinfo.hussar.eai.webservice.manager.api.service.IEaiAppWsdlVersionService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.migration.business.distinct.service.impl.EaiCommonLogicResourcesServiceImpl")
public class EaiCommonLogicResourcesServiceImpl
implements IEaiCommonLogicResourcesService {
    @Resource
    private ICanvasInfoService canvasInfoService;
    @Resource
    private IStructureVersionService structureVersionService;
    @Resource
    private IConstantVersionService constantVersionService;
    @Resource
    private IEaiLogicVersionService logicVersionService;
    @Resource
    private IConnectionVersionService connectionVersionService;
    @Resource
    private IEaiCommonStructureResourcesService eaiCommonStructureResourcesService;
    @Resource
    private IEaiCommonConstantResourcesService eaiCommonConstantResourcesService;
    @Resource
    private IEaiCommonLinkResourcesService eaiCommonLinkResourcesService;
    @Resource
    private ICommonLogicService commonLogicService;
    @Resource
    private IEaiCanvasInfoResourcesService eaiCanvasInfoResourcesService;
    @Resource
    private IEaiCanvasResourceIdReplaceService eaiCanvasResourceIdReplaceService;
    @Resource
    private IEaiAppWsdlVersionService wsdlVersionService;
    private static final String WSDL = "wsdl";
    private static final String LOGIC_ERROR = "\u5e94\u7528\u5bfc\u51fa\u5931\u8d25\uff0c\u903b\u8f91\u753b\u5e03\u4fe1\u606f\u7f3a\u5931\uff0c\u903b\u8f91\u540d\u79f0\u3010%s\u3011,\u903b\u8f91\u6807\u8bc6\u3010%s\u3011";
    private static final Pattern pattern = Pattern.compile("\"wsdlId\":\"[0-9]{18}\"");

    public void fillExportResourcesDumpInfo(EaiCommonResourcesDto resources, EaiCommonResourcesResultDto eaiCommonResourcesResultDto, String version) {
        List<EaiCommonLogicDto> commonLogicDtos = resources.getCommonLogicList();
        if (HussarUtils.isEmpty((Object)commonLogicDtos)) {
            return;
        }
        HashMap ids = new HashMap();
        Map<Long, Long> map = HussarUtils.isEmpty((Object)eaiCommonResourcesResultDto.getCommonLogicIdMap()) ? new HashMap() : eaiCommonResourcesResultDto.getCommonLogicIdMap();
        Map<String, Long> codeIdMap = HussarUtils.isEmpty((Object)eaiCommonResourcesResultDto.getCommonLogicCodeIdMap()) ? new HashMap() : eaiCommonResourcesResultDto.getCommonLogicCodeIdMap();
        ArrayList<Long> constantId = new ArrayList<Long>();
        ArrayList<Long> structureId = new ArrayList<Long>();
        ArrayList<Long> connId = new ArrayList<Long>();
        ArrayList<Long> logicId = new ArrayList<Long>();
        ArrayList<Long> wsdlId = new ArrayList<Long>();
        for (EaiCommonLogicDto commonLogicDto : commonLogicDtos) {
            LogicVersion commonLogic = commonLogicDto.getLogicVersion();
            CanvasInfo canvasInfo = commonLogicDto.getCanvasInfo();
            if (map.containsKey(commonLogic.getId())) continue;
            if (codeIdMap.containsKey(commonLogic.getLogicCode())) {
                if (!commonLogic.getId().equals(codeIdMap.get(commonLogic.getLogicCode()))) {
                    map.put(commonLogic.getId(), (Long)codeIdMap.get(commonLogic.getLogicCode()));
                    ids.put(commonLogic.getLogicCode(), codeIdMap.get(commonLogic.getLogicCode()));
                } else {
                    map.put(commonLogic.getId(), commonLogic.getId());
                }
            } else if (version.equals(commonLogic.getLogicVersion())) {
                codeIdMap.put(commonLogic.getLogicCode(), commonLogic.getId());
                map.put(commonLogic.getId(), commonLogic.getId());
            } else {
                Integer v = Integer.valueOf(version.substring(1));
                LogicVersion logicVersion = this.getLastVersion(v, commonLogic);
                if (logicVersion.getLogicVersion().equals(commonLogic.getLogicVersion())) {
                    codeIdMap.put(commonLogic.getLogicCode(), commonLogic.getId());
                    map.put(commonLogic.getId(), commonLogic.getId());
                } else {
                    map.put(commonLogic.getId(), logicVersion.getId());
                    codeIdMap.put(logicVersion.getLogicCode(), logicVersion.getId());
                    ids.put(commonLogic.getLogicCode(), logicVersion.getId());
                }
            }
            if (HussarUtils.isEmpty((Object)canvasInfo)) {
                throw new BaseException(String.format(LOGIC_ERROR, commonLogic.getLogicName(), commonLogic.getLogicCode()));
            }
            String resource = canvasInfo.getCanvasResources();
            if (!HussarUtils.isNotEmpty((Object)resource)) continue;
            HashMap resourceMap = (HashMap)JSON.parseObject((String)resource, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
            List<String> wsdl = this.getWsdlId(canvasInfo.getCanvasContent());
            if (HussarUtils.isEmpty((Object)resourceMap)) {
                resourceMap = new HashMap();
            }
            Set<String> canvasId = resourceMap.keySet();
            if (HussarUtils.isNotEmpty(wsdl)) {
                canvasId.addAll(wsdl);
            }
            this.checkIds(canvasId, constantId, structureId, connId, logicId, wsdlId);
        }
        if (HussarUtils.isNotEmpty(ids)) {
            List curr = commonLogicDtos.stream().map(m -> m.getLogicVersion().getId()).collect(Collectors.toList());
            ArrayList val = new ArrayList(ids.values());
            if (HussarUtils.isNotEmpty(curr)) {
                val.removeAll(curr);
            }
            if (HussarUtils.isNotEmpty(val)) {
                logicId.addAll(val);
            }
        }
        commonLogicDtos = this.lastVersion(commonLogicDtos, version);
        resources.setCommonLogicList(commonLogicDtos);
        map = MigrationUtil.lastMapping(map);
        eaiCommonResourcesResultDto.setCommonLogicIdMap(map);
        eaiCommonResourcesResultDto.setCommonLogicCodeIdMap(codeIdMap);
        this.newResourceIds(eaiCommonResourcesResultDto, constantId, structureId, connId, logicId, wsdlId);
        this.otherResource(resources, constantId, structureId, connId, logicId, wsdlId, eaiCommonResourcesResultDto, version);
        this.replaceLogicCanvasIds(resources.getCommonLogicList(), eaiCommonResourcesResultDto);
    }

    public void importResourcesIdCodeMap(String appCode, Boolean isNewAppCode, EaiCommonResourcesDto resourcesDto, EaiCommonResourcesResultDto eaiCommonResourcesResultDto) {
        if (HussarUtils.isEmpty((Object)resourcesDto) && HussarUtils.isEmpty((Object)resourcesDto.getCommonLogicList())) {
            return;
        }
        this.replaceNewCodeId(appCode, resourcesDto.getCommonLogicList(), resourcesDto, eaiCommonResourcesResultDto, isNewAppCode);
    }

    private void replaceLogicCanvasIds(List<EaiCommonLogicDto> eaiCommonLogicDtos, EaiCommonResourcesResultDto resourcesResultDto) {
        if (HussarUtils.isEmpty(eaiCommonLogicDtos)) {
            return;
        }
        for (EaiCommonLogicDto commonLogicDto : eaiCommonLogicDtos) {
            CanvasInfo canvasInfo = commonLogicDto.getCanvasInfo();
            String constant = canvasInfo.getCanvasContent();
            String resource = canvasInfo.getCanvasResources();
            constant = this.eaiCanvasResourceIdReplaceService.replaceIds(constant, resourcesResultDto.getConstantIdMap());
            constant = this.eaiCanvasResourceIdReplaceService.replaceIds(constant, resourcesResultDto.getStructureIdMap());
            constant = this.eaiCanvasResourceIdReplaceService.replaceIds(constant, resourcesResultDto.getCommonLogicIdMap());
            constant = this.eaiCanvasResourceIdReplaceService.replaceIds(constant, resourcesResultDto.getConnectionIdMap());
            constant = this.eaiCanvasResourceIdReplaceService.replaceIds(constant, resourcesResultDto.getAppWsdlIdMap());
            resource = this.eaiCanvasResourceIdReplaceService.replaceIds(resource, resourcesResultDto.getConstantIdMap());
            resource = this.eaiCanvasResourceIdReplaceService.replaceIds(resource, resourcesResultDto.getStructureIdMap());
            resource = this.eaiCanvasResourceIdReplaceService.replaceIds(resource, resourcesResultDto.getCommonLogicIdMap());
            resource = this.eaiCanvasResourceIdReplaceService.replaceIds(resource, resourcesResultDto.getConnectionIdMap());
            resource = this.eaiCanvasResourceIdReplaceService.replaceIds(resource, resourcesResultDto.getAppWsdlIdMap());
            canvasInfo.setCanvasContent(constant);
            canvasInfo.setCanvasResources(resource);
            commonLogicDto.setCanvasInfo(canvasInfo);
        }
    }

    private List<String> getWsdlId(String val) {
        Matcher matcher = pattern.matcher(val);
        ArrayList<String> list = new ArrayList<String>(1);
        while (matcher.find()) {
            String result = matcher.group();
            String[] str = result.split(":");
            list.add(String.format("%s:%s", str[0], str[1]));
        }
        return list;
    }

    private List<EaiCommonLogicDto> lastVersion(List<EaiCommonLogicDto> logicVersions, String version) {
        if (HussarUtils.isEmpty(logicVersions)) {
            return Collections.emptyList();
        }
        HashMap<String, EaiCommonLogicDto> map = new HashMap<String, EaiCommonLogicDto>(logicVersions.size());
        for (EaiCommonLogicDto commonLogicDto : logicVersions) {
            LogicVersion logicVersion = commonLogicDto.getLogicVersion();
            if (map.containsKey(logicVersion.getLogicCode())) {
                String v = logicVersion.getLogicVersion();
                if (version.equals(v)) {
                    map.put(logicVersion.getLogicCode(), commonLogicDto);
                    continue;
                }
                String oldV = ((EaiCommonLogicDto)map.get(logicVersion.getLogicCode())).getLogicVersion().getLogicVersion();
                if (!MigrationUtil.compareVersion((String)v, (String)oldV)) continue;
                map.put(logicVersion.getLogicCode(), commonLogicDto);
                continue;
            }
            map.put(logicVersion.getLogicCode(), commonLogicDto);
        }
        return new ArrayList<EaiCommonLogicDto>(map.values());
    }

    private void newResourceIds(EaiCommonResourcesResultDto eaiCommonResourcesResultDto, List<Long> constantId, List<Long> structureId, List<Long> connId, List<Long> logicId, List<Long> wsdlId) {
        Map wsdlMap;
        Map constantMap = HussarUtils.isEmpty((Object)eaiCommonResourcesResultDto.getConstantIdMap()) ? new HashMap() : eaiCommonResourcesResultDto.getConstantIdMap();
        Map linkMap = HussarUtils.isEmpty((Object)eaiCommonResourcesResultDto.getConnectionIdMap()) ? new HashMap() : eaiCommonResourcesResultDto.getConnectionIdMap();
        Map structureMap = HussarUtils.isEmpty((Object)eaiCommonResourcesResultDto.getStructureIdMap()) ? new HashMap() : eaiCommonResourcesResultDto.getStructureIdMap();
        Map logicMap = HussarUtils.isEmpty((Object)eaiCommonResourcesResultDto.getCommonLogicIdMap()) ? new HashMap() : eaiCommonResourcesResultDto.getCommonLogicIdMap();
        Map map = wsdlMap = HussarUtils.isEmpty((Object)eaiCommonResourcesResultDto.getAppWsdlIdMap()) ? new HashMap() : eaiCommonResourcesResultDto.getAppWsdlIdMap();
        if (HussarUtils.isNotEmpty(constantMap) && HussarUtils.isNotEmpty(constantId)) {
            constantId.removeAll(constantMap.keySet());
        }
        if (HussarUtils.isNotEmpty(linkMap) && HussarUtils.isNotEmpty(connId)) {
            connId.removeAll(linkMap.keySet());
        }
        if (HussarUtils.isNotEmpty(structureMap) && HussarUtils.isNotEmpty(structureId)) {
            structureId.removeAll(structureMap.keySet());
        }
        if (HussarUtils.isNotEmpty(logicMap) && HussarUtils.isNotEmpty(logicId)) {
            logicId.removeAll(logicMap.keySet());
        }
        if (HussarUtils.isNotEmpty(wsdlMap) && HussarUtils.isNotEmpty(wsdlId)) {
            wsdlId.removeAll(wsdlMap.keySet());
        }
    }

    private void replaceNewCodeId(String appCode, List<EaiCommonLogicDto> logicVersions, EaiCommonResourcesDto resourcesDto, EaiCommonResourcesResultDto eaiCommonResourcesResultDto, Boolean isNewAppCode) {
        Map<String, Long> codeIdMap;
        Map<Long, Long> idMap = eaiCommonResourcesResultDto.getCommonLogicIdMap() == null ? new HashMap() : eaiCommonResourcesResultDto.getCommonLogicIdMap();
        Map map = codeIdMap = eaiCommonResourcesResultDto.getCommonLogicCodeIdMap() == null ? new HashMap() : eaiCommonResourcesResultDto.getCommonLogicCodeIdMap();
        if (HussarUtils.isNotEmpty(logicVersions)) {
            for (EaiCommonLogicDto commonLogicDto : logicVersions) {
                CommonLogic saveLogic;
                LogicVersion logicVersion = commonLogicDto.getLogicVersion();
                if (codeIdMap.containsKey(logicVersion.getLogicCode())) continue;
                Long id = EngineUtil.getId();
                LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CommonLogic::getApplicationCode, (Object)appCode)).eq(CommonLogic::getLogicCode, (Object)logicVersion.getLogicCode());
                CommonLogic commonLogic = (CommonLogic)this.commonLogicService.getOne((Wrapper)queryWrapper);
                if (HussarUtils.isNotEmpty((Object)commonLogic)) {
                    id = commonLogic.getId();
                    saveLogic = (CommonLogic)BeanUtil.copyProperties((Object)logicVersion, CommonLogic.class);
                    saveLogic.setId(id);
                    Long canvasId = EngineUtil.getId();
                    CanvasInfo canvasInfo = commonLogicDto.getCanvasInfo();
                    canvasInfo = this.eaiCanvasInfoResourcesService.importResourcesIdCodeMap(appCode, isNewAppCode, canvasInfo, resourcesDto, eaiCommonResourcesResultDto);
                    canvasInfo.setId(canvasId);
                    this.canvasInfoService.removeById((Serializable)Long.valueOf(commonLogic.getCanvasId()));
                    this.canvasInfoService.save((Object)canvasInfo);
                    saveLogic.setCanvasId(canvasId.longValue());
                    saveLogic.setApplicationCode(appCode);
                    this.replaceParamsId(saveLogic, eaiCommonResourcesResultDto.getStructureIdMap());
                    this.commonLogicService.updateById((Object)saveLogic);
                } else {
                    saveLogic = (CommonLogic)BeanUtil.copyProperties((Object)logicVersion, CommonLogic.class);
                    saveLogic.setId(id);
                    CanvasInfo canvasInfo = commonLogicDto.getCanvasInfo();
                    canvasInfo = this.eaiCanvasInfoResourcesService.importResourcesIdCodeMap(appCode, isNewAppCode, canvasInfo, resourcesDto, eaiCommonResourcesResultDto);
                    Long canvasId = EngineUtil.getId();
                    canvasInfo.setId(canvasId);
                    this.canvasInfoService.save((Object)canvasInfo);
                    saveLogic.setCanvasId(canvasId.longValue());
                    saveLogic.setApplicationCode(appCode);
                    this.replaceParamsId(saveLogic, eaiCommonResourcesResultDto.getStructureIdMap());
                    this.commonLogicService.save((Object)saveLogic);
                }
                idMap.put(logicVersion.getId(), id);
                codeIdMap.put(logicVersion.getLogicCode(), id);
            }
        }
        eaiCommonResourcesResultDto.setCommonLogicIdMap(idMap);
        eaiCommonResourcesResultDto.setCommonLogicCodeIdMap(codeIdMap);
    }

    private void replaceParamsId(CommonLogic commonLogic, Map<Long, Long> map) {
        if (HussarUtils.isEmpty(map) || HussarUtils.isEmpty((Object)commonLogic)) {
            return;
        }
        commonLogic.setInParams(this.eaiCanvasResourceIdReplaceService.replaceIds(commonLogic.getInParams(), map));
        commonLogic.setOutParams(this.eaiCanvasResourceIdReplaceService.replaceIds(commonLogic.getOutParams(), map));
    }

    private void checkIds(Set<String> resourcesIds, List<Long> constantId, List<Long> structureId, List<Long> connId, List<Long> logicId, List<Long> wsdlId) {
        if (HussarUtils.isEmpty(resourcesIds)) {
            return;
        }
        for (String id : resourcesIds) {
            Long realId = this.getId(id, EaiResourcesEnum.STRUCTURE.getType());
            if (realId != null) {
                structureId.add((long)realId);
                continue;
            }
            realId = this.getId(id, EaiResourcesEnum.CONSTANT.getType());
            if (realId != null) {
                constantId.add((long)realId);
                continue;
            }
            realId = this.getId(id, EaiResourcesEnum.LINK.getType());
            if (realId != null) {
                connId.add((long)realId);
                continue;
            }
            realId = this.getId(id, EaiResourcesEnum.LOGIC.getType());
            if (realId != null) {
                logicId.add((long)realId);
            }
            if ((realId = this.getId(id, WSDL)) == null) continue;
            wsdlId.add((long)realId);
        }
    }

    private void otherResource(EaiCommonResourcesDto resourcesDto, List<Long> constantId, List<Long> structureId, List<Long> connId, List<Long> logicId, List<Long> wsdlId, EaiCommonResourcesResultDto eaiCommonResourcesResultDto, String version) {
        EaiCommonResourcesDto commonResourcesDto;
        if (HussarUtils.isNotEmpty(structureId)) {
            commonResourcesDto = new EaiCommonResourcesDto();
            List structureVersions = this.structureVersionService.listByIds(structureId);
            commonResourcesDto.setStructureList(structureVersions);
            this.eaiCommonStructureResourcesService.fillExportResourcesDumpInfo(commonResourcesDto, eaiCommonResourcesResultDto, version);
            this.mergeStructure(resourcesDto, commonResourcesDto);
        }
        if (HussarUtils.isNotEmpty(constantId)) {
            commonResourcesDto = new EaiCommonResourcesDto();
            List constantVersions = this.constantVersionService.listByIds(constantId);
            commonResourcesDto.setConstantList(constantVersions);
            this.eaiCommonConstantResourcesService.fillExportResourcesDumpInfo(commonResourcesDto, eaiCommonResourcesResultDto, version);
            this.mergeConstant(resourcesDto, commonResourcesDto);
        }
        if (HussarUtils.isNotEmpty(connId)) {
            commonResourcesDto = new EaiCommonResourcesDto();
            List connectionVersions = this.connectionVersionService.listByIds(connId);
            commonResourcesDto.setConnectionList(connectionVersions);
            this.eaiCommonLinkResourcesService.fillExportResourcesDumpInfo(commonResourcesDto, eaiCommonResourcesResultDto, version);
            this.mergeConnection(resourcesDto, commonResourcesDto);
        }
        if (HussarUtils.isNotEmpty(wsdlId)) {
            commonResourcesDto = new EaiCommonResourcesDto();
            List wsdlVersions = this.wsdlVersionService.listByIds(connId);
            commonResourcesDto.setWsdlList(wsdlVersions);
            this.eaiCommonLinkResourcesService.fillExportResourcesDumpInfo(commonResourcesDto, eaiCommonResourcesResultDto, version);
            this.mergeWsdl(resourcesDto, commonResourcesDto);
        }
        if (HussarUtils.isNotEmpty(logicId)) {
            commonResourcesDto = new EaiCommonResourcesDto();
            List logicVersions = this.logicVersionService.listByIds(logicId);
            commonResourcesDto.setCommonLogicList(this.eaiCommonLogicDtoList(logicVersions, constantId, structureId, connId, logicId, wsdlId));
            this.fillExportResourcesDumpInfo(commonResourcesDto, eaiCommonResourcesResultDto, version);
            this.mergeLogic(resourcesDto, commonResourcesDto);
            this.mergeStructure(resourcesDto, commonResourcesDto);
            this.mergeConstant(resourcesDto, commonResourcesDto);
            this.mergeConnection(resourcesDto, commonResourcesDto);
            this.mergeWsdl(resourcesDto, commonResourcesDto);
        }
    }

    private void mergeWsdl(EaiCommonResourcesDto resourcesDto, EaiCommonResourcesDto commonResourcesDto) {
        if (HussarUtils.isNotEmpty((Object)commonResourcesDto.getWsdlList())) {
            if (HussarUtils.isNotEmpty((Object)resourcesDto.getWsdlList())) {
                resourcesDto.getWsdlList().addAll(commonResourcesDto.getWsdlList());
            } else {
                resourcesDto.setWsdlList(commonResourcesDto.getWsdlList());
            }
        }
    }

    private void mergeStructure(EaiCommonResourcesDto resourcesDto, EaiCommonResourcesDto commonResourcesDto) {
        if (HussarUtils.isNotEmpty((Object)commonResourcesDto.getStructureList())) {
            if (HussarUtils.isNotEmpty((Object)resourcesDto.getStructureList())) {
                resourcesDto.getStructureList().addAll(commonResourcesDto.getStructureList());
            } else {
                resourcesDto.setStructureList(commonResourcesDto.getStructureList());
            }
        }
    }

    private void mergeLogic(EaiCommonResourcesDto resourcesDto, EaiCommonResourcesDto commonResourcesDto) {
        if (HussarUtils.isNotEmpty((Object)commonResourcesDto.getCommonLogicList())) {
            if (HussarUtils.isNotEmpty((Object)resourcesDto.getCommonLogicList())) {
                resourcesDto.getCommonLogicList().addAll(commonResourcesDto.getCommonLogicList());
            } else {
                resourcesDto.setCommonLogicList(commonResourcesDto.getCommonLogicList());
            }
        }
    }

    private void mergeConnection(EaiCommonResourcesDto resourcesDto, EaiCommonResourcesDto commonResourcesDto) {
        if (HussarUtils.isNotEmpty((Object)commonResourcesDto.getConnectionList())) {
            if (HussarUtils.isNotEmpty((Object)resourcesDto.getConnectionList())) {
                resourcesDto.getConnectionList().addAll(commonResourcesDto.getConnectionList());
            } else {
                resourcesDto.setConnectionList(commonResourcesDto.getConnectionList());
            }
        }
    }

    private void mergeConstant(EaiCommonResourcesDto resourcesDto, EaiCommonResourcesDto commonResourcesDto) {
        if (HussarUtils.isNotEmpty((Object)commonResourcesDto.getConstantList())) {
            if (HussarUtils.isNotEmpty((Object)resourcesDto.getConstantList())) {
                resourcesDto.getConstantList().addAll(commonResourcesDto.getConstantList());
            } else {
                resourcesDto.setConstantList(commonResourcesDto.getConstantList());
            }
        }
    }

    private Long getId(String id, String type) {
        if (id.startsWith(type) && !(id = id.substring(type.length() + 1)).startsWith("open")) {
            return Long.valueOf(id);
        }
        return null;
    }

    private List<EaiCommonLogicDto> eaiCommonLogicDtoList(List<LogicVersion> logicVersions, List<Long> constantId, List<Long> structureId, List<Long> connId, List<Long> logicId, List<Long> wsdlId) {
        if (HussarUtils.isEmpty(logicVersions)) {
            return Collections.emptyList();
        }
        ArrayList<EaiCommonLogicDto> result = new ArrayList<EaiCommonLogicDto>();
        for (LogicVersion logicVersion : logicVersions) {
            CanvasInfo canvasInfo = (CanvasInfo)this.canvasInfoService.getById((Serializable)Long.valueOf(logicVersion.getCanvasId()));
            String resources = canvasInfo.getCanvasResources();
            if (HussarUtils.isEmpty((Object)resources)) {
                Map resourceMap = (Map)JSON.parseObject((String)resources, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                Set<String> resourcesIds = resourceMap.keySet();
                this.checkIds(resourcesIds, constantId, structureId, connId, logicId, wsdlId);
            }
            EaiCommonLogicDto commonLogicDto = new EaiCommonLogicDto();
            commonLogicDto.setCanvasInfo(canvasInfo);
            commonLogicDto.setLogicVersion(logicVersion);
            result.add(commonLogicDto);
        }
        return result;
    }

    private LogicVersion getLastVersion(Integer v, LogicVersion logic) {
        LogicVersion logicVersion = logic;
        while (v > 0) {
            String version = String.format("v%s", v);
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(LogicVersion::getLogicCode, (Object)logicVersion.getLogicCode())).eq(LogicVersion::getApplicationCode, (Object)logicVersion.getApplicationCode())).eq(LogicVersion::getLogicVersion, (Object)version);
            LogicVersion finalVersion = (LogicVersion)this.logicVersionService.getOne((Wrapper)queryWrapper);
            if (finalVersion == null) {
                Integer n = v;
                Integer n2 = v = Integer.valueOf(v - 1);
                continue;
            }
            logicVersion = finalVersion;
            break;
        }
        return logicVersion;
    }
}

