/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.distinct.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.eai.atomicenhancements.api.commonlink.dto.CommonConnectionDto;
import com.jxdinfo.hussar.eai.atomicenhancements.api.commonlink.service.EaiCommonConnectionService;
import com.jxdinfo.hussar.eai.migration.business.distinct.service.IEaiCommonLinkResourcesService;
import com.jxdinfo.hussar.eai.migration.dto.EaiCommonResourcesDto;
import com.jxdinfo.hussar.eai.migration.dto.EaiCommonResourcesResultDto;
import com.jxdinfo.hussar.eai.migration.util.MigrationUtil;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CommonConnection;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICommonConnectionService;
import com.jxdinfo.hussar.eai.resourceexternalopen.api.model.ConnectionVersion;
import com.jxdinfo.hussar.eai.resourceexternalopen.api.service.IConnectionVersionService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.migration.business.distinct.service.impl.EaiCommonLinkResourcesServiceImpl")
public class EaiCommonLinkResourcesServiceImpl
implements IEaiCommonLinkResourcesService {
    @Autowired
    private IConnectionVersionService connectionVersionService;
    @Autowired
    private ICommonConnectionService commonConnectionService;
    @Autowired
    private EaiCommonConnectionService connectionService;
    private static final String ID = "id";

    public void fillExportResourcesDumpInfo(EaiCommonResourcesDto resources, EaiCommonResourcesResultDto eaiCommonResourcesResultDto, String version) {
        List<ConnectionVersion> commonConnections = resources.getConnectionList();
        if (HussarUtils.isEmpty((Object)commonConnections)) {
            return;
        }
        HashMap ids = new HashMap();
        Map<Long, Long> map = HussarUtils.isEmpty((Object)eaiCommonResourcesResultDto.getConnectionIdMap()) ? new HashMap() : eaiCommonResourcesResultDto.getConnectionIdMap();
        Map<String, Long> codeIdMap = HussarUtils.isEmpty((Object)eaiCommonResourcesResultDto.getConnectionCodeIdMap()) ? new HashMap() : eaiCommonResourcesResultDto.getConnectionCodeIdMap();
        for (ConnectionVersion commonConnection : commonConnections) {
            if (map.containsKey(commonConnection.getId())) continue;
            if (codeIdMap.containsKey(commonConnection.getConnectionNameEn())) {
                if (!commonConnection.getId().equals(codeIdMap.get(commonConnection.getConnectionNameEn()))) {
                    map.put(commonConnection.getId(), (Long)codeIdMap.get(commonConnection.getConnectionNameEn()));
                    ids.put(commonConnection.getConnectionNameEn(), codeIdMap.get(commonConnection.getConnectionNameEn()));
                    continue;
                }
                map.put(commonConnection.getId(), commonConnection.getId());
                continue;
            }
            if (version.equals(commonConnection.getConnVersion())) {
                codeIdMap.put(commonConnection.getConnectionNameEn(), commonConnection.getId());
                map.put(commonConnection.getId(), commonConnection.getId());
                continue;
            }
            Integer v = Integer.valueOf(version.substring(1));
            ConnectionVersion connectionVersion = this.getLastVersion(v, commonConnection);
            if (!commonConnection.getConnVersion().equals(connectionVersion.getConnVersion())) {
                ids.put(commonConnection.getConnectionNameEn(), connectionVersion.getId());
            }
            codeIdMap.put(commonConnection.getConnectionNameEn(), connectionVersion.getId());
            map.put(commonConnection.getId(), connectionVersion.getId());
        }
        if (HussarUtils.isNotEmpty(ids)) {
            List curr = commonConnections.stream().map(ConnectionVersion::getId).collect(Collectors.toList());
            ArrayList val = new ArrayList(ids.values());
            if (HussarUtils.isNotEmpty(curr)) {
                val.removeAll(curr);
            }
            if (HussarUtils.isNotEmpty(val)) {
                List connectionVersions = this.connectionVersionService.listByIds(val);
                commonConnections.addAll(connectionVersions);
            }
        }
        commonConnections = this.lastVersion(commonConnections, version);
        resources.setConnectionList(commonConnections);
        map = MigrationUtil.lastMapping(map);
        eaiCommonResourcesResultDto.setConnectionIdMap(map);
        eaiCommonResourcesResultDto.setConnectionCodeIdMap(codeIdMap);
    }

    public void importResourcesIdCodeMap(String appCode, Boolean isNewAppCode, EaiCommonResourcesDto resourcesDto, EaiCommonResourcesResultDto eaiCommonResourcesResultDto) {
        if (HussarUtils.isEmpty((Object)resourcesDto) && HussarUtils.isEmpty((Object)resourcesDto.getConnectionList())) {
            return;
        }
        this.replaceNewCodeId(appCode, resourcesDto.getConnectionList(), eaiCommonResourcesResultDto, isNewAppCode == false);
    }

    private List<ConnectionVersion> lastVersion(List<ConnectionVersion> connectionVersions, String version) {
        if (HussarUtils.isEmpty(connectionVersions)) {
            return Collections.emptyList();
        }
        HashMap<String, ConnectionVersion> map = new HashMap<String, ConnectionVersion>(connectionVersions.size());
        for (ConnectionVersion connectionVersion : connectionVersions) {
            if (map.containsKey(connectionVersion.getConnectionNameEn())) {
                String v = connectionVersion.getConnVersion();
                if (version.equals(v)) {
                    map.put(connectionVersion.getConnectionNameEn(), connectionVersion);
                    continue;
                }
                String oldV = ((ConnectionVersion)map.get(connectionVersion.getConnectionNameEn())).getConnVersion();
                if (!MigrationUtil.compareVersion((String)v, (String)oldV)) continue;
                map.put(connectionVersion.getConnectionNameEn(), connectionVersion);
                continue;
            }
            map.put(connectionVersion.getConnectionNameEn(), connectionVersion);
        }
        return new ArrayList<ConnectionVersion>(map.values());
    }

    private void replaceNewCodeId(String appCpde, List<ConnectionVersion> connectionVersions, EaiCommonResourcesResultDto eaiCommonResourcesResultDto, Boolean compare) {
        Map<String, Long> codeIdMap;
        Map<Long, Long> idMap = eaiCommonResourcesResultDto.getConnectionIdMap() == null ? new HashMap() : eaiCommonResourcesResultDto.getConnectionIdMap();
        Map map = codeIdMap = eaiCommonResourcesResultDto.getConnectionCodeIdMap() == null ? new HashMap() : eaiCommonResourcesResultDto.getConnectionCodeIdMap();
        if (HussarUtils.isNotEmpty(connectionVersions)) {
            for (ConnectionVersion connectionVersion : connectionVersions) {
                if (codeIdMap.containsKey(connectionVersion.getConnectionNameEn())) continue;
                Long id = EngineUtil.getId();
                LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CommonConnection::getApplicationCode, (Object)appCpde)).eq(CommonConnection::getConnectionNameEn, (Object)connectionVersion.getConnectionNameEn());
                CommonConnection connection = (CommonConnection)this.commonConnectionService.getOne((Wrapper)queryWrapper);
                if (HussarUtils.isNotEmpty((Object)connection)) {
                    id = connection.getId();
                    CommonConnection updateConn = (CommonConnection)BeanUtil.copyProperties((Object)connectionVersion, CommonConnection.class);
                    updateConn.setId(id);
                    updateConn.setApplicationCode(appCpde);
                    this.connectionService.deleteConnection(id);
                    this.saveConn(updateConn, false, eaiCommonResourcesResultDto);
                } else {
                    CommonConnection commonConnection = (CommonConnection)BeanUtil.copyProperties((Object)connectionVersion, CommonConnection.class);
                    commonConnection.setId(id);
                    commonConnection.setApplicationCode(appCpde);
                    this.saveConn(commonConnection, true, eaiCommonResourcesResultDto);
                }
                idMap.put(connectionVersion.getId(), id);
                codeIdMap.put(connectionVersion.getConnectionNameEn(), id);
            }
        }
        eaiCommonResourcesResultDto.setConnectionIdMap(idMap);
        eaiCommonResourcesResultDto.setConnectionCodeIdMap(codeIdMap);
    }

    private void saveConn(CommonConnection commonConnection, Boolean isNew, EaiCommonResourcesResultDto eaiCommonResourcesResultDto) {
        CommonConnectionDto commonConnectionDto = (CommonConnectionDto)BeanUtil.copyProperties((Object)commonConnection, CommonConnectionDto.class);
        Map map = (Map)JSON.parseObject((String)commonConnection.getConnectionConfig(), (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
        if (isNew.booleanValue() && map.containsKey(ID)) {
            Long id = EngineUtil.getId();
            if (HussarUtils.isEmpty((Object)eaiCommonResourcesResultDto.getConnConfigIdMap())) {
                HashMap<Long, Long> connConfigMap = new HashMap<Long, Long>(1);
                connConfigMap.put((Long)map.get(ID), id);
                eaiCommonResourcesResultDto.setConnConfigIdMap(connConfigMap);
            } else {
                eaiCommonResourcesResultDto.getConnConfigIdMap().put((Long)map.get(ID), id);
            }
            map.put(ID, id);
        }
        commonConnectionDto.setConnectionConfigMap(map);
        commonConnectionDto.setName(commonConnection.getConnectionNameEn());
        commonConnectionDto.setDesc(commonConnection.getConnectionName());
        this.connectionService.addConnection(commonConnectionDto);
    }

    private ConnectionVersion getLastVersion(Integer v, ConnectionVersion commonConnection) {
        ConnectionVersion connectionVersion = commonConnection;
        while (v > 0) {
            String version = String.format("v%s", v);
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ConnectionVersion::getConnectionNameEn, (Object)commonConnection.getConnectionNameEn())).eq(ConnectionVersion::getApplicationCode, (Object)commonConnection.getApplicationCode())).eq(ConnectionVersion::getConnVersion, (Object)version);
            ConnectionVersion finalVersion = (ConnectionVersion)this.connectionVersionService.getOne((Wrapper)queryWrapper);
            if (finalVersion == null) {
                Integer n = v;
                Integer n2 = v = Integer.valueOf(v - 1);
                continue;
            }
            connectionVersion = finalVersion;
            break;
        }
        return connectionVersion;
    }
}

