/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.distinct.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.eai.migration.business.distinct.service.IEaiCommonConstantResourcesService;
import com.jxdinfo.hussar.eai.migration.dto.EaiCommonResourcesDto;
import com.jxdinfo.hussar.eai.migration.dto.EaiCommonResourcesResultDto;
import com.jxdinfo.hussar.eai.migration.util.MigrationUtil;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonConstant;
import com.jxdinfo.hussar.eai.resourcebase.api.service.ICommonConstantService;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.ConstantVersion;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.serevice.IConstantVersionService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.migration.business.distinct.service.impl.EaiCommonConstantResourcesServiceImpl")
public class EaiCommonConstantResourcesServiceImpl
implements IEaiCommonConstantResourcesService {
    @Autowired
    private IConstantVersionService constantVersionService;
    @Autowired
    private ICommonConstantService commonConstantService;

    public void fillExportResourcesDumpInfo(EaiCommonResourcesDto resources, EaiCommonResourcesResultDto eaiCommonResourcesResultDto, String version) {
        List<ConstantVersion> commonConstants = resources.getConstantList();
        if (HussarUtils.isEmpty((Object)commonConstants)) {
            return;
        }
        HashMap ids = new HashMap();
        Map<Long, Long> map = HussarUtils.isEmpty((Object)eaiCommonResourcesResultDto.getConstantIdMap()) ? new HashMap() : eaiCommonResourcesResultDto.getConstantIdMap();
        Map<String, Long> codeIdMap = HussarUtils.isEmpty((Object)eaiCommonResourcesResultDto.getConstantCodeIdMap()) ? new HashMap() : eaiCommonResourcesResultDto.getConstantCodeIdMap();
        for (ConstantVersion commonConstant : commonConstants) {
            if (map.containsKey(commonConstant.getId())) continue;
            if (codeIdMap.containsKey(commonConstant.getConstantNameEn())) {
                if (!commonConstant.getId().equals(codeIdMap.get(commonConstant.getConstantNameEn()))) {
                    map.put(commonConstant.getId(), (Long)codeIdMap.get(commonConstant.getConstantNameEn()));
                    ids.put(commonConstant.getConstantNameEn(), codeIdMap.get(commonConstant.getConstantNameEn()));
                    continue;
                }
                map.put(commonConstant.getId(), commonConstant.getId());
                continue;
            }
            if (version.equals(commonConstant.getConstantVersion())) {
                codeIdMap.put(commonConstant.getConstantNameEn(), commonConstant.getId());
                map.put(commonConstant.getId(), commonConstant.getId());
                continue;
            }
            Integer v = Integer.valueOf(version.substring(1));
            ConstantVersion constantVersion = this.getLastVersion(v, commonConstant);
            if (!commonConstant.getConstantVersion().equals(constantVersion.getConstantVersion())) {
                ids.put(commonConstant.getConstantNameEn(), constantVersion.getId());
            }
            codeIdMap.put(commonConstant.getConstantNameEn(), constantVersion.getId());
            map.put(commonConstant.getId(), constantVersion.getId());
        }
        if (HussarUtils.isNotEmpty(ids)) {
            List curr = commonConstants.stream().map(ConstantVersion::getId).collect(Collectors.toList());
            ArrayList val = new ArrayList(ids.values());
            if (HussarUtils.isNotEmpty(curr)) {
                val.removeAll(curr);
            }
            if (HussarUtils.isNotEmpty(val)) {
                List constantVersions = this.constantVersionService.listByIds(val);
                commonConstants.addAll(constantVersions);
            }
        }
        commonConstants = this.lastVersion(commonConstants, version);
        resources.setConstantList(commonConstants);
        map = MigrationUtil.lastMapping(map);
        eaiCommonResourcesResultDto.setConstantIdMap(map);
        eaiCommonResourcesResultDto.setConstantCodeIdMap(codeIdMap);
    }

    private List<ConstantVersion> lastVersion(List<ConstantVersion> constantVersions, String version) {
        if (HussarUtils.isEmpty(constantVersions)) {
            return Collections.emptyList();
        }
        HashMap<String, ConstantVersion> map = new HashMap<String, ConstantVersion>(constantVersions.size());
        for (ConstantVersion constantVersion : constantVersions) {
            if (map.containsKey(constantVersion.getConstantNameEn())) {
                String v = constantVersion.getConstantVersion();
                if (version.equals(v)) {
                    map.put(constantVersion.getConstantNameEn(), constantVersion);
                    continue;
                }
                String oldV = ((ConstantVersion)map.get(constantVersion.getConstantNameEn())).getConstantVersion();
                if (!MigrationUtil.compareVersion((String)v, (String)oldV)) continue;
                map.put(constantVersion.getConstantNameEn(), constantVersion);
                continue;
            }
            map.put(constantVersion.getConstantNameEn(), constantVersion);
        }
        return new ArrayList<ConstantVersion>(map.values());
    }

    private ConstantVersion getLastVersion(Integer v, ConstantVersion constant) {
        ConstantVersion constantVersion = constant;
        while (v > 0) {
            String version = String.format("v%s", v);
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ConstantVersion::getConstantNameEn, (Object)constant.getConstantNameEn())).eq(ConstantVersion::getApplicationCode, (Object)constant.getApplicationCode())).eq(ConstantVersion::getConstantVersion, (Object)version);
            ConstantVersion finalVersion = (ConstantVersion)this.constantVersionService.getOne((Wrapper)queryWrapper);
            if (finalVersion == null) {
                Integer n = v;
                Integer n2 = v = Integer.valueOf(v - 1);
                continue;
            }
            constantVersion = finalVersion;
            break;
        }
        return constantVersion;
    }

    public void importResourcesIdCodeMap(String appCode, Boolean isNewAppCode, EaiCommonResourcesDto resourcesDto, EaiCommonResourcesResultDto eaiCommonResourcesResultDto) {
        if (HussarUtils.isEmpty((Object)resourcesDto) && HussarUtils.isEmpty((Object)resourcesDto.getConstantList())) {
            return;
        }
        this.replaceNewCodeId(appCode, resourcesDto.getConstantList(), eaiCommonResourcesResultDto, isNewAppCode == false);
    }

    private void replaceNewCodeId(String appCpde, List<ConstantVersion> constantVersions, EaiCommonResourcesResultDto eaiCommonResourcesResultDto, Boolean compare) {
        Map<String, Long> codeIdMap;
        Map<Long, Long> idMap = eaiCommonResourcesResultDto.getConstantIdMap() == null ? new HashMap() : eaiCommonResourcesResultDto.getConstantIdMap();
        Map map = codeIdMap = eaiCommonResourcesResultDto.getConstantCodeIdMap() == null ? new HashMap() : eaiCommonResourcesResultDto.getConstantCodeIdMap();
        if (HussarUtils.isNotEmpty(constantVersions)) {
            for (ConstantVersion constantVersion : constantVersions) {
                if (codeIdMap.containsKey(constantVersion.getConstantNameEn())) continue;
                Long id = EngineUtil.getId();
                LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CommonConstant::getApplicationCode, (Object)appCpde)).eq(CommonConstant::getConstantNameEn, (Object)constantVersion.getConstantNameEn());
                CommonConstant commonConstant = (CommonConstant)this.commonConstantService.getOne((Wrapper)queryWrapper);
                if (HussarUtils.isNotEmpty((Object)commonConstant)) {
                    id = commonConstant.getId();
                    CommonConstant updateConstant = (CommonConstant)BeanUtil.copyProperties((Object)constantVersion, CommonConstant.class);
                    updateConstant.setId(id);
                    updateConstant.setApplicationCode(appCpde);
                    this.commonConstantService.updateById((Object)updateConstant);
                } else {
                    CommonConstant constant = (CommonConstant)BeanUtil.copyProperties((Object)constantVersion, CommonConstant.class);
                    constant.setId(id);
                    constant.setApplicationCode(appCpde);
                    this.commonConstantService.save((Object)constant);
                }
                idMap.put(constantVersion.getId(), id);
                codeIdMap.put(constantVersion.getConstantNameEn(), id);
            }
        }
        eaiCommonResourcesResultDto.setConstantIdMap(idMap);
        eaiCommonResourcesResultDto.setConstantCodeIdMap(codeIdMap);
    }
}

