/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.distinct.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.eai.common.enums.app.EaiResourcesEnum;
import com.jxdinfo.hussar.eai.migration.business.distinct.service.IEaiCanvasInfoResourcesService;
import com.jxdinfo.hussar.eai.migration.business.service.IEaiCanvasResourceIdReplaceService;
import com.jxdinfo.hussar.eai.migration.dto.EaiCommonLogicDto;
import com.jxdinfo.hussar.eai.migration.dto.EaiCommonResourcesDto;
import com.jxdinfo.hussar.eai.migration.dto.EaiCommonResourcesResultDto;
import com.jxdinfo.hussar.eai.migration.resources.service.IEaiCommonResourcesService;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.ConstantVersion;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.StructureVersion;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CanvasInfo;
import com.jxdinfo.hussar.eai.resourceexternalopen.api.model.ConnectionVersion;
import com.jxdinfo.hussar.eai.webservice.manager.api.model.EaiAppWsdlVersion;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.rmi.core.utils.TypeReference;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.migration.business.distinct.service.impl.EaiCanvasInfoResourcesServiceImpl")
public class EaiCanvasInfoResourcesServiceImpl
implements IEaiCanvasInfoResourcesService {
    @Resource
    private List<IEaiCommonResourcesService> eaiCommonResourcesServices;
    @Resource
    private IEaiCanvasResourceIdReplaceService eaiCanvasResourceIdReplaceService;
    private static final String WSDL = "wsdl";
    private static final Pattern pattern = Pattern.compile("\"wsdlId\":\"[0-9]{18}\"");
    private static final String SPLIT = ":";

    public CanvasInfo importResourcesIdCodeMap(String appCode, Boolean isNewAppCode, CanvasInfo canvasInfo, EaiCommonResourcesDto eaiCommonResourcesDto, EaiCommonResourcesResultDto eaiCommonResourcesResultDto) {
        if (HussarUtils.isEmpty((Object)canvasInfo)) {
            return new CanvasInfo();
        }
        Map structureIdMap = eaiCommonResourcesResultDto.getStructureIdMap() == null ? new HashMap() : eaiCommonResourcesResultDto.getStructureIdMap();
        Map constantIdMap = eaiCommonResourcesResultDto.getConstantIdMap() == null ? new HashMap() : eaiCommonResourcesResultDto.getConstantIdMap();
        Map linkIdMap = eaiCommonResourcesResultDto.getConnectionIdMap() == null ? new HashMap() : eaiCommonResourcesResultDto.getConnectionIdMap();
        Map logicIdMap = eaiCommonResourcesResultDto.getCommonLogicIdMap() == null ? new HashMap() : eaiCommonResourcesResultDto.getCommonLogicIdMap();
        Map wsdlIdMap = eaiCommonResourcesResultDto.getAppWsdlIdMap() == null ? new HashMap() : eaiCommonResourcesResultDto.getAppWsdlIdMap();
        String resources = canvasInfo.getCanvasResources();
        Map<Long, String> ids = this.getIds(resources);
        Map<Long, String> wsdlIds = this.getWsdlId(canvasInfo.getCanvasContent());
        if (HussarUtils.isNotEmpty(wsdlIds)) {
            if (HussarUtils.isNotEmpty(ids)) {
                ids.putAll(wsdlIds);
            } else {
                ids = wsdlIds;
            }
        }
        if (HussarUtils.isEmpty(ids)) {
            return canvasInfo;
        }
        ArrayList<StructureVersion> saveStructures = new ArrayList<StructureVersion>();
        List structureVersions = eaiCommonResourcesDto.getStructureList();
        ArrayList<ConstantVersion> saveConstants = new ArrayList<ConstantVersion>();
        List constantVersions = eaiCommonResourcesDto.getConstantList();
        ArrayList<EaiCommonLogicDto> saveLogics = new ArrayList<EaiCommonLogicDto>();
        List logics = eaiCommonResourcesDto.getCommonLogicList();
        ArrayList<ConnectionVersion> saveConnections = new ArrayList<ConnectionVersion>();
        List connections = eaiCommonResourcesDto.getConnectionList();
        List wsdlVersions = eaiCommonResourcesDto.getWsdlList();
        ArrayList<EaiAppWsdlVersion> saveWsdl = new ArrayList<EaiAppWsdlVersion>();
        for (Map.Entry<Long, String> entry : ids.entrySet()) {
            EaiAppWsdlVersion wsdlVersion;
            ConnectionVersion connectionVersion;
            EaiCommonLogicDto logicVersion;
            ConstantVersion constantVersion;
            StructureVersion structureVersion;
            if (EaiResourcesEnum.STRUCTURE.getType().equals(entry.getValue()) && !structureIdMap.containsKey(entry.getKey()) && HussarUtils.isNotEmpty((Object)structureVersions) && (structureVersion = (StructureVersion)structureVersions.stream().filter(f -> f.getId().equals(entry.getKey())).findAny().orElse(null)) != null) {
                saveStructures.add(structureVersion);
            }
            if (EaiResourcesEnum.CONSTANT.getType().equals(entry.getValue()) && !constantIdMap.containsKey(entry.getKey()) && HussarUtils.isNotEmpty((Object)constantVersions) && (constantVersion = (ConstantVersion)constantVersions.stream().filter(f -> f.getId().equals(entry.getKey())).findAny().orElse(null)) != null) {
                saveConstants.add(constantVersion);
            }
            if (EaiResourcesEnum.LOGIC.getType().equals(entry.getValue()) && !logicIdMap.containsKey(entry.getKey()) && HussarUtils.isNotEmpty((Object)logics) && (logicVersion = (EaiCommonLogicDto)logics.stream().filter(f -> f.getLogicVersion().getId().equals(entry.getKey())).findAny().orElse(null)) != null) {
                saveLogics.add(logicVersion);
            }
            if (EaiResourcesEnum.LINK.getType().equals(entry.getValue()) && !linkIdMap.containsKey(entry.getKey()) && HussarUtils.isNotEmpty((Object)connections) && (connectionVersion = (ConnectionVersion)connections.stream().filter(f -> f.getId().equals(entry.getKey())).findAny().orElse(null)) != null) {
                saveConnections.add(connectionVersion);
            }
            if (!WSDL.equals(entry.getValue()) || wsdlIdMap.containsKey(entry.getKey()) || !HussarUtils.isNotEmpty((Object)wsdlVersions) || (wsdlVersion = (EaiAppWsdlVersion)wsdlVersions.stream().filter(f -> f.getId().equals(entry.getKey())).findAny().orElse(null)) == null) continue;
            saveWsdl.add(wsdlVersion);
        }
        EaiCommonResourcesDto commonResourcesDto = new EaiCommonResourcesDto();
        if (HussarUtils.isNotEmpty(saveStructures)) {
            if (HussarUtils.isNotEmpty((Object)structureVersions)) {
                saveStructures.addAll(structureVersions);
            }
            commonResourcesDto.setStructureList(saveStructures);
        }
        if (HussarUtils.isNotEmpty(saveConstants)) {
            if (HussarUtils.isNotEmpty((Object)constantVersions)) {
                saveConstants.addAll(constantVersions);
            }
            commonResourcesDto.setConstantList(saveConstants);
        }
        if (HussarUtils.isNotEmpty(saveConnections)) {
            if (HussarUtils.isNotEmpty((Object)connections)) {
                saveConnections.addAll(connections);
            }
            commonResourcesDto.setConnectionList(saveConnections);
        }
        if (HussarUtils.isNotEmpty(saveLogics)) {
            if (HussarUtils.isNotEmpty((Object)logics)) {
                saveLogics.addAll(logics);
            }
            commonResourcesDto.setCommonLogicList(saveLogics);
        }
        if (HussarUtils.isNotEmpty(saveWsdl)) {
            if (HussarUtils.isNotEmpty((Object)wsdlVersions)) {
                saveWsdl.addAll(wsdlVersions);
            }
            commonResourcesDto.setWsdlList(saveWsdl);
        }
        for (IEaiCommonResourcesService eaiCommonResourcesService : this.eaiCommonResourcesServices) {
            eaiCommonResourcesService.importResourcesIdCodeMap(appCode, isNewAppCode, commonResourcesDto, eaiCommonResourcesResultDto);
        }
        return this.replaceIds(canvasInfo, eaiCommonResourcesResultDto);
    }

    private Map<Long, String> getWsdlId(String val) {
        Matcher matcher = pattern.matcher(val);
        HashMap<Long, String> map = new HashMap<Long, String>(1);
        while (matcher.find()) {
            String result = matcher.group();
            String[] str = result.split(SPLIT);
            String strId = str[1].replace("\"", "");
            if (map.containsKey(Long.valueOf(strId))) continue;
            map.put(Long.valueOf(strId), WSDL);
        }
        return map;
    }

    public CanvasInfo replaceIds(CanvasInfo canvasInfo, EaiCommonResourcesResultDto eaiCommonResourcesResultDto) {
        Map structureIdMap = eaiCommonResourcesResultDto.getStructureIdMap();
        Map constantIdMap = eaiCommonResourcesResultDto.getConstantIdMap();
        Map linkIdMap = eaiCommonResourcesResultDto.getConnectionIdMap();
        Map logicIdMap = eaiCommonResourcesResultDto.getCommonLogicIdMap();
        Map wsdlIdMap = eaiCommonResourcesResultDto.getAppWsdlIdMap();
        Map connConfigIdMap = eaiCommonResourcesResultDto.getConnConfigIdMap();
        String content = canvasInfo.getCanvasContent();
        String resource = canvasInfo.getCanvasResources();
        if (HussarUtils.isNotEmpty((Object)structureIdMap)) {
            content = this.eaiCanvasResourceIdReplaceService.replaceIds(content, structureIdMap);
            resource = this.eaiCanvasResourceIdReplaceService.replaceCanvasIds(resource, structureIdMap, EaiResourcesEnum.STRUCTURE.getType());
        }
        if (HussarUtils.isNotEmpty((Object)constantIdMap)) {
            content = this.eaiCanvasResourceIdReplaceService.replaceIds(content, constantIdMap);
            resource = this.eaiCanvasResourceIdReplaceService.replaceCanvasIds(resource, constantIdMap, EaiResourcesEnum.CONSTANT.getType());
        }
        if (HussarUtils.isNotEmpty((Object)linkIdMap)) {
            content = this.eaiCanvasResourceIdReplaceService.replaceIds(content, linkIdMap);
            resource = this.eaiCanvasResourceIdReplaceService.replaceCanvasIds(resource, linkIdMap, EaiResourcesEnum.LINK.getType());
        }
        if (HussarUtils.isNotEmpty((Object)logicIdMap)) {
            content = this.eaiCanvasResourceIdReplaceService.replaceIds(content, logicIdMap);
            resource = this.eaiCanvasResourceIdReplaceService.replaceCanvasIds(resource, logicIdMap, EaiResourcesEnum.LOGIC.getType());
        }
        if (HussarUtils.isNotEmpty((Object)wsdlIdMap)) {
            content = this.eaiCanvasResourceIdReplaceService.replaceIds(content, wsdlIdMap);
            resource = this.eaiCanvasResourceIdReplaceService.replaceCanvasIds(resource, wsdlIdMap, WSDL);
        }
        if (HussarUtils.isNotEmpty((Object)connConfigIdMap)) {
            content = this.eaiCanvasResourceIdReplaceService.replaceIds(content, connConfigIdMap);
        }
        canvasInfo.setCanvasResources(resource);
        canvasInfo.setCanvasContent(content);
        return canvasInfo;
    }

    private Map<Long, String> getIds(String content) {
        if (HussarUtils.isEmpty((Object)content)) {
            return null;
        }
        HashMap<Long, String> map = new HashMap<Long, String>();
        Map mapList = (Map)JSON.parseObject((String)content, (Type)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        for (String id : mapList.keySet()) {
            this.idType(id, map, EaiResourcesEnum.STRUCTURE.getType());
            this.idType(id, map, EaiResourcesEnum.CONSTANT.getType());
            this.idType(id, map, EaiResourcesEnum.LOGIC.getType());
            this.idType(id, map, EaiResourcesEnum.LINK.getType());
            this.idType(id, map, WSDL);
        }
        return map;
    }

    private void idType(String id, Map<Long, String> map, String type) {
        if (id.startsWith(type)) {
            id.split(SPLIT);
            id = id.substring(type.length() + 1);
            if (!id.startsWith("v")) {
                map.put(Long.valueOf(id), type);
            }
        }
    }
}

