/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.compare.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.eai.migration.business.compare.service.IEaiWSDLCompareService;
import com.jxdinfo.hussar.eai.migration.resources.service.vo.EaiCompareResult;
import com.jxdinfo.hussar.eai.webservice.manager.api.model.EaiAppWsdl;
import com.jxdinfo.hussar.eai.webservice.manager.api.model.EaiAppWsdlVersion;
import com.jxdinfo.hussar.eai.webservice.manager.api.service.IWsdlInfoService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.migration.business.compare.service.impl.EaiWSDLCompareServiceImpl")
public class EaiWSDLCompareServiceImpl
implements IEaiWSDLCompareService {
    private static final String WSDL = "wsdl";
    @Resource
    private IWsdlInfoService wsdlInfoService;

    public String getType() {
        return WSDL;
    }

    public EaiCompareResult<EaiAppWsdlVersion, EaiAppWsdl> preloadCompare(List<EaiAppWsdlVersion> resources, String appCode, Boolean isNewApp) {
        EaiCompareResult result = new EaiCompareResult();
        if (HussarUtils.isEmpty(resources)) {
            return result;
        }
        if (isNewApp.booleanValue()) {
            for (EaiAppWsdlVersion resource : resources) {
                resource.setApplicationCode(appCode);
            }
            result.setAddResult(resources);
            return result;
        }
        List codes = resources.stream().map(EaiAppWsdlVersion::getWsdlPath).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiAppWsdl::getApplicationCode, (Object)appCode)).in(EaiAppWsdl::getWsdlPath, codes);
        List eaiAppWsdls = this.wsdlInfoService.list((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)eaiAppWsdls)) {
            List updateCode = eaiAppWsdls.stream().map(EaiAppWsdl::getWsdlPath).collect(Collectors.toList());
            ArrayList<EaiAppWsdlVersion> addVersions = new ArrayList<EaiAppWsdlVersion>();
            ArrayList<EaiAppWsdlVersion> updateVersions = new ArrayList<EaiAppWsdlVersion>();
            for (EaiAppWsdlVersion EaiAppWsdlVersion2 : resources) {
                if (updateCode.contains(EaiAppWsdlVersion2.getWsdlPath())) {
                    updateVersions.add(EaiAppWsdlVersion2);
                    continue;
                }
                addVersions.add(EaiAppWsdlVersion2);
            }
            result.setAddResult(addVersions);
            result.setUpdateResult(updateVersions);
            result.setUpdateLocalResult(eaiAppWsdls);
            return result;
        }
        result.setAddResult(resources);
        return result;
    }
}

