/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.compare.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.eai.common.enums.app.EaiResourcesEnum;
import com.jxdinfo.hussar.eai.migration.business.compare.service.IEaiStructureCompareService;
import com.jxdinfo.hussar.eai.migration.resources.service.vo.EaiCompareResult;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonStructure;
import com.jxdinfo.hussar.eai.resourcebase.api.service.ICommonStructureService;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.StructureVersion;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.migration.business.compare.service.impl.EaiStructureCompareServiceImpl")
public class EaiStructureCompareServiceImpl
implements IEaiStructureCompareService {
    @Resource
    private ICommonStructureService commonStructureService;

    public String getType() {
        return EaiResourcesEnum.STRUCTURE.getType();
    }

    public EaiCompareResult<StructureVersion, CommonStructure> preloadCompare(List<StructureVersion> resources, String appCode, Boolean isNewApp) {
        EaiCompareResult result = new EaiCompareResult();
        if (HussarUtils.isEmpty(resources)) {
            return result;
        }
        if (isNewApp.booleanValue()) {
            for (StructureVersion resource : resources) {
                resource.setApplicationCode(appCode);
            }
            result.setAddResult(resources);
            return result;
        }
        List codes = resources.stream().map(StructureVersion::getStructureCode).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CommonStructure::getApplicationCode, (Object)appCode)).in(CommonStructure::getStructureCode, codes);
        List commonStructures = this.commonStructureService.list((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)commonStructures)) {
            List updateCode = commonStructures.stream().map(CommonStructure::getStructureCode).collect(Collectors.toList());
            ArrayList<StructureVersion> addVersions = new ArrayList<StructureVersion>();
            ArrayList<StructureVersion> updateVersions = new ArrayList<StructureVersion>();
            for (StructureVersion StructureVersion2 : resources) {
                if (updateCode.contains(StructureVersion2.getStructureCode())) {
                    updateVersions.add(StructureVersion2);
                    continue;
                }
                addVersions.add(StructureVersion2);
            }
            result.setAddResult(addVersions);
            result.setUpdateResult(updateVersions);
            result.setUpdateLocalResult(commonStructures);
            return result;
        }
        result.setAddResult(resources);
        return result;
    }
}

