/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.compare.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.eai.common.enums.app.EaiResourcesEnum;
import com.jxdinfo.hussar.eai.migration.business.compare.service.IEaiLogicCompareService;
import com.jxdinfo.hussar.eai.migration.resources.service.vo.EaiCompareResult;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CommonLogic;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICommonLogicService;
import com.jxdinfo.hussar.eai.resourceexternalopen.api.model.LogicVersion;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.migration.business.compare.service.impl.EaiLogicCompareServiceImpl")
public class EaiLogicCompareServiceImpl
implements IEaiLogicCompareService {
    @Resource
    private ICommonLogicService commonLogicService;

    public String getType() {
        return EaiResourcesEnum.LOGIC.getType();
    }

    public EaiCompareResult<LogicVersion, CommonLogic> preloadCompare(List<LogicVersion> resources, String appCode, Boolean isNewApp) {
        EaiCompareResult result = new EaiCompareResult();
        if (HussarUtils.isEmpty(resources)) {
            return result;
        }
        if (isNewApp.booleanValue()) {
            for (LogicVersion resource : resources) {
                resource.setApplicationCode(appCode);
            }
            result.setAddResult(resources);
            return result;
        }
        List codes = resources.stream().map(LogicVersion::getLogicCode).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CommonLogic::getApplicationCode, (Object)appCode)).in(CommonLogic::getLogicCode, codes);
        List commonLogics = this.commonLogicService.list((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)commonLogics)) {
            List updateCode = commonLogics.stream().map(CommonLogic::getLogicCode).collect(Collectors.toList());
            ArrayList<LogicVersion> addVersions = new ArrayList<LogicVersion>();
            ArrayList<LogicVersion> updateVersions = new ArrayList<LogicVersion>();
            for (LogicVersion LogicVersion2 : resources) {
                if (updateCode.contains(LogicVersion2.getLogicCode())) {
                    updateVersions.add(LogicVersion2);
                    continue;
                }
                addVersions.add(LogicVersion2);
            }
            result.setAddResult(addVersions);
            result.setUpdateResult(updateVersions);
            result.setUpdateLocalResult(commonLogics);
            return result;
        }
        result.setAddResult(resources);
        return result;
    }
}

