/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.compare.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.eai.common.enums.app.EaiResourcesEnum;
import com.jxdinfo.hussar.eai.migration.business.compare.service.IEaiLinkCompareService;
import com.jxdinfo.hussar.eai.migration.resources.service.vo.EaiCompareResult;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CommonConnection;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICommonConnectionService;
import com.jxdinfo.hussar.eai.resourceexternalopen.api.model.ConnectionVersion;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.migration.business.compare.service.impl.EaiLinkCompareServiceImpl")
public class EaiLinkCompareServiceImpl
implements IEaiLinkCompareService {
    @Resource
    private ICommonConnectionService commonConnectionService;

    public String getType() {
        return EaiResourcesEnum.LINK.getType();
    }

    public EaiCompareResult<ConnectionVersion, CommonConnection> preloadCompare(List<ConnectionVersion> resources, String appCode, Boolean isNewApp) {
        EaiCompareResult result = new EaiCompareResult();
        if (HussarUtils.isEmpty(resources)) {
            return result;
        }
        if (isNewApp.booleanValue()) {
            for (ConnectionVersion resource : resources) {
                resource.setApplicationCode(appCode);
            }
            result.setAddResult(resources);
            return result;
        }
        List codes = resources.stream().map(ConnectionVersion::getConnectionNameEn).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CommonConnection::getApplicationCode, (Object)appCode)).in(CommonConnection::getConnectionNameEn, codes);
        List commonConnections = this.commonConnectionService.list((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)commonConnections)) {
            List updateCode = commonConnections.stream().map(CommonConnection::getConnectionNameEn).collect(Collectors.toList());
            ArrayList<ConnectionVersion> addVersions = new ArrayList<ConnectionVersion>();
            ArrayList<ConnectionVersion> updateVersions = new ArrayList<ConnectionVersion>();
            for (ConnectionVersion ConnectionVersion2 : resources) {
                if (updateCode.contains(ConnectionVersion2.getConnectionNameEn())) {
                    updateVersions.add(ConnectionVersion2);
                    continue;
                }
                addVersions.add(ConnectionVersion2);
            }
            result.setAddResult(addVersions);
            result.setUpdateResult(updateVersions);
            result.setUpdateLocalResult(commonConnections);
            return result;
        }
        result.setAddResult(resources);
        return result;
    }
}

