/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.compare.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.eai.common.enums.app.EaiResourcesEnum;
import com.jxdinfo.hussar.eai.migration.business.compare.service.IEaiConstantCompareService;
import com.jxdinfo.hussar.eai.migration.resources.service.vo.EaiCompareResult;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonConstant;
import com.jxdinfo.hussar.eai.resourcebase.api.service.ICommonConstantService;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.ConstantVersion;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.migration.business.compare.service.impl.EaiConstantCompareServiceImpl")
public class EaiConstantCompareServiceImpl
implements IEaiConstantCompareService {
    @Resource
    private ICommonConstantService commonConstantService;

    public String getType() {
        return EaiResourcesEnum.CONSTANT.getType();
    }

    public EaiCompareResult<ConstantVersion, CommonConstant> preloadCompare(List<ConstantVersion> resources, String appCode, Boolean isNewApp) {
        EaiCompareResult result = new EaiCompareResult();
        if (HussarUtils.isEmpty(resources)) {
            return result;
        }
        if (isNewApp.booleanValue()) {
            for (ConstantVersion resource : resources) {
                resource.setApplicationCode(appCode);
            }
            result.setAddResult(resources);
            return result;
        }
        List codes = resources.stream().map(ConstantVersion::getConstantNameEn).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CommonConstant::getApplicationCode, (Object)appCode)).in(CommonConstant::getConstantNameEn, codes);
        List commonConstants = this.commonConstantService.list((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)commonConstants)) {
            List updateCode = commonConstants.stream().map(CommonConstant::getConstantNameEn).collect(Collectors.toList());
            ArrayList<ConstantVersion> addVersions = new ArrayList<ConstantVersion>();
            ArrayList<ConstantVersion> updateVersions = new ArrayList<ConstantVersion>();
            for (ConstantVersion constantVersion : resources) {
                if (updateCode.contains(constantVersion.getConstantNameEn())) {
                    updateVersions.add(constantVersion);
                    continue;
                }
                addVersions.add(constantVersion);
            }
            result.setAddResult(addVersions);
            result.setUpdateResult(updateVersions);
            result.setUpdateLocalResult(commonConstants);
            return result;
        }
        result.setAddResult(resources);
        return result;
    }
}

