/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.datasource.rdb.service.impl;

import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.handler.EngineParamTokenHandler;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.util.EngineDdlSqlUtil;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.util.SqlNodeHandlerHelper;
import com.jxdinfo.hussar.eai.datasource.rdb.entity.CheckParamItem;
import com.jxdinfo.hussar.eai.datasource.rdb.service.ISqlParseService;
import com.jxdinfo.hussar.eai.datasource.rdb.util.SQLUtil;
import com.jxdinfo.hussar.eai.datasource.rdb.util.SqlParamUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ibatis.parsing.GenericTokenParser;
import org.apache.ibatis.parsing.TokenHandler;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.datasource.rdb.service.impl.sqlParseServiceImpl")
public class SqlParseServiceImpl
implements ISqlParseService {
    @Autowired
    private SqlSessionFactory sqlSessionFactory;

    public List<String> parseSql(String sql) {
        return this.getParam(sql);
    }

    public Map<String, String> parseSqlWithType(String sql) {
        return this.getParamWithType(sql);
    }

    public List<CheckParamItem> parseSqlWithObjectType(String sql) {
        Map<String, String> out = this.parseSqlWithType(sql);
        ArrayList<CheckParamItem> result = new ArrayList<CheckParamItem>();
        if (HussarUtils.isEmpty(out)) {
            return result;
        }
        for (String name : out.keySet()) {
            CheckParamItem checkParamItem = new CheckParamItem();
            checkParamItem.setName(name);
            checkParamItem.setType(SqlParamUtil.getEaiDataType((String)out.get(name)));
            result.add(checkParamItem);
        }
        return result;
    }

    private Map<String, String> getParamWithType(String script) {
        Configuration configuration = this.sqlSessionFactory.getConfiguration();
        script = SQLUtil.filterComments((String)script);
        script = SQLUtil.escEscapeSql((String)script);
        script = String.format("<script>%s</script>", script);
        SqlNode sqlNode = EngineDdlSqlUtil.getSqlNode((String)script, (Configuration)configuration);
        LinkedHashMap<String, String> columnMap = new LinkedHashMap<String, String>();
        GenericTokenParser parser = EngineDdlSqlUtil.getGenericTokenParser((TokenHandler)new EngineParamTokenHandler(configuration, columnMap));
        SqlNodeHandlerHelper.apply((SqlNode)sqlNode, columnMap, (GenericTokenParser)parser);
        this.removeProperty(columnMap);
        if (columnMap.keySet().stream().anyMatch(key -> key.contains("."))) {
            throw new BaseException("SQL\u53c2\u6570\u4e2d\u4e0d\u80fd\u5305\u542b . \u5b57\u7b26");
        }
        return columnMap;
    }

    private List<String> getParam(String script) {
        ArrayList<String> list = new ArrayList<String>();
        Map<String, String> columnMap = this.getParamWithType(script);
        Set<String> strings = columnMap.keySet();
        list.addAll(strings);
        return list;
    }

    private void removeProperty(Map<String, String> columnMap) {
        ArrayList<String> removeFiled = new ArrayList<String>();
        List<String> keys = Arrays.asList(".size", ".isEmpty", ".size()", ".isEmpty()");
        for (String c : columnMap.keySet()) {
            if (c != null && !keys.stream().anyMatch(key -> c.endsWith((String)key) && columnMap.containsKey(c.substring(0, c.length() - key.length())))) continue;
            removeFiled.add(c);
        }
        if (!removeFiled.isEmpty()) {
            for (String key2 : removeFiled) {
                columnMap.remove(key2);
            }
        }
    }
}

