/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.datasource.rdb.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.ttl.threadpool.TtlExecutors;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.datasource.dto.SysDataSourceDto;
import com.jxdinfo.hussar.datasource.manager.api.entity.SysDatasourceConfig;
import com.jxdinfo.hussar.datasource.manager.api.service.DatasourceService;
import com.jxdinfo.hussar.datasource.manager.plugin.datasource.service.DatasourceConfigService;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.vo.CommonConnectionVo;
import com.jxdinfo.hussar.eai.atomicenhancements.api.commonlink.dto.CommonConnectionDto;
import com.jxdinfo.hussar.eai.atomicenhancements.api.commonlink.factory.EaiAppConnectionFactory;
import com.jxdinfo.hussar.eai.atomicenhancements.api.commonlink.service.IEaiAppConnectionExtendService;
import com.jxdinfo.hussar.eai.atomicenhancements.api.commonlink.service.IEaiDynamicDataSourceService;
import com.jxdinfo.hussar.eai.common.enums.app.EaiAppConnectionEnum;
import com.jxdinfo.hussar.eai.datapacket.business.api.enums.EaiDataPacketSyncStatusEnum;
import com.jxdinfo.hussar.eai.datapacket.business.api.service.IEaiDataPacketBusinessService;
import com.jxdinfo.hussar.eai.datasource.rdb.util.BeanMapUtil;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CommonConnection;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICommonConnectionService;
import com.jxdinfo.hussar.eai.sysapi.api.dto.EaiDataSourceDto;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.datasource.rdb.service.impl.rdbActionServiceImpl")
public class RdbActionServiceImpl
implements IEaiAppConnectionExtendService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RdbActionServiceImpl.class);
    @Autowired
    private DatasourceService datasourceService;
    @Autowired
    private DatasourceConfigService datasourceConfigService;
    @Autowired
    private ICommonConnectionService commonConnectionService;
    @Autowired
    private DynamicDatasourceService dynamicDataSourceService;
    @Autowired
    private IEaiDynamicDataSourceService eaiDynamicDataSourceService;
    @Autowired
    private IEaiDataPacketBusinessService eaiDataPacketBusinessService;
    private final ExecutorService threadPoolExecutor = TtlExecutors.getTtlExecutorService((ExecutorService)Executors.newSingleThreadExecutor());

    @HussarTransactional
    public boolean saveConnection(CommonConnectionDto commonConnectionDto) {
        CommonConnection commonConnection = new CommonConnection();
        Map connectionConfigMap = commonConnectionDto.getConnectionConfigMap();
        SysDataSourceDto dataSourceDto = new SysDataSourceDto();
        BeanMapUtil.fillBeanWithMapIgnoreCase((Map)connectionConfigMap, (Object)dataSourceDto, (boolean)false);
        String flag = UUID.randomUUID().toString().replace("-", "");
        dataSourceDto.setDbName(flag);
        dataSourceDto.setConnName(flag);
        dataSourceDto.setDatasourceType("3");
        dataSourceDto.setLazyEnable(Integer.valueOf(1));
        ApiResponse sysDataSourceApiResponse = this.datasourceService.saveDataSourceWithCheck(dataSourceDto, false);
        SysDataSource data = (SysDataSource)sysDataSourceApiResponse.getData();
        BeanUtil.copy((Object)commonConnectionDto, (Object)commonConnection);
        commonConnection.setClassify("0");
        if (HussarUtils.isNotEmpty((Object)commonConnectionDto.getConnectionConfigMap())) {
            SysDatasourceConfig datasourceConfig = (SysDatasourceConfig)this.datasourceConfigService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysDatasourceConfig::getConnName, (Object)data.getConnName()), false);
            connectionConfigMap.put("id", data.getId());
            connectionConfigMap.put("dbName", flag);
            connectionConfigMap.put("connName", flag);
            if (datasourceConfig != null) {
                connectionConfigMap.put("properties", datasourceConfig.getParameterValue());
            } else {
                connectionConfigMap.put("properties", "");
            }
            commonConnection.setConnectionConfig(JSON.toJSONString((Object)connectionConfigMap));
        }
        try {
            boolean result = this.commonConnectionService.save((Object)commonConnection);
            if (HussarUtils.isNotEmpty((Object)this.threadPoolExecutor)) {
                this.threadPoolExecutor.execute(() -> {
                    try {
                        this.eaiDataPacketBusinessService.updateConnSyncStatus(commonConnection.getId(), Integer.valueOf(EaiDataPacketSyncStatusEnum.SYNCING.getStatus()));
                        this.eaiDataPacketBusinessService.syncAddDataPacket(commonConnection);
                    }
                    catch (Exception e) {
                        LOGGER.error("\u8fde\u63a5\u65b0\u589e\u540c\u6b65\u6570\u636e\u5305\u5931\u8d25", (Throwable)e);
                    }
                    finally {
                        this.eaiDataPacketBusinessService.updateConnSyncStatus(commonConnection.getId(), Integer.valueOf(EaiDataPacketSyncStatusEnum.END.getStatus()));
                    }
                });
            }
            return result;
        }
        catch (Exception e) {
            this.dynamicDataSourceService.removeDynamicDatasource(flag);
            throw e;
        }
    }

    @HussarTransactional
    public boolean updateConnection(CommonConnectionDto commonConnectionDto) {
        SysDataSourceDto data;
        Map connectionConfigMap = commonConnectionDto.getConnectionConfigMap();
        Long connectionId = commonConnectionDto.getId();
        CommonConnection byId = (CommonConnection)this.commonConnectionService.getById((Serializable)connectionId);
        AssertUtil.isNotNull((Object)byId, (String)"\u672a\u67e5\u8be2\u5230\u8fde\u63a5\u4fe1\u606f\uff01");
        SysDataSourceDto dataSourceDto = new SysDataSourceDto();
        BeanMapUtil.fillBeanWithMapIgnoreCase((Map)connectionConfigMap, (Object)dataSourceDto, (boolean)false);
        SysDataSource oldData = null;
        boolean mainFlag = false;
        if (EaiAppConnectionEnum.CLASSIFY_CLASSIFYCHILD_RDB.getClassify().equals(byId.getConnectionClassify())) {
            mainFlag = this.checkConnMainInformation(byId, commonConnectionDto);
            if (mainFlag) {
                if (this.eaiDataPacketBusinessService.checkConnSyncStatus(byId.getId())) {
                    throw new BaseException("\u8bf7\u7b49\u5f85\u6570\u636e\u5305\u540c\u6b65\u7ed3\u675f\u540e\u518d\u4fee\u6539\u8fde\u63a5\uff01");
                }
                this.eaiDataPacketBusinessService.syncDeleteDataPacket(byId, "\u6570\u636e\u6e90\u5173\u8054\u6570\u636e\u5305\u5df2\u4e0a\u67b6\u8d44\u4ea7\u5e02\u573a\uff0c\u5982\u4ecd\u9700\u8c03\u6574\uff0c\u8bf7\u5148\u4e0b\u67b6\u76f8\u5173\u6570\u636e\u5305\uff01");
            }
            oldData = (SysDataSource)this.datasourceService.getById((Serializable)dataSourceDto.getId());
            data = this.datasourceService.updateDatasource(dataSourceDto);
            this.eaiDynamicDataSourceService.saveDynamicDatasource((SysDataSource)data);
        } else {
            mainFlag = true;
            String flag = UUID.randomUUID().toString().replace("-", "");
            dataSourceDto.setDbName(flag);
            dataSourceDto.setConnName(flag);
            dataSourceDto.setDatasourceType("3");
            dataSourceDto.setLazyEnable(Integer.valueOf(1));
            ApiResponse sysDataSourceApiResponse = this.datasourceService.saveDataSourceWithCheck(dataSourceDto, false);
            data = (SysDataSource)sysDataSourceApiResponse.getData();
            connectionConfigMap.put("dbName", flag);
            connectionConfigMap.put("connName", flag);
        }
        BeanUtil.copy((Object)commonConnectionDto, (Object)byId);
        SysDatasourceConfig datasourceConfig = (SysDatasourceConfig)this.datasourceConfigService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysDatasourceConfig::getConnName, (Object)data.getConnName()), false);
        connectionConfigMap.put("id", data.getId());
        if (datasourceConfig != null) {
            connectionConfigMap.put("properties", datasourceConfig.getParameterValue());
        } else {
            connectionConfigMap.put("properties", "");
        }
        byId.setConnectionConfig(JSON.toJSONString((Object)connectionConfigMap));
        try {
            boolean result = this.commonConnectionService.updateById((Object)byId);
            if (mainFlag) {
                if (!this.eaiDataPacketBusinessService.updateConnSyncStatus(byId.getId(), Integer.valueOf(EaiDataPacketSyncStatusEnum.SYNCING.getStatus()))) {
                    return result;
                }
                if (HussarUtils.isNotEmpty((Object)this.threadPoolExecutor)) {
                    this.threadPoolExecutor.execute(() -> {
                        try {
                            this.eaiDataPacketBusinessService.syncAddDataPacket(byId);
                        }
                        catch (Exception e) {
                            LOGGER.error("\u8fde\u63a5\u4fee\u6539\u540c\u6b65\u6570\u636e\u5305\u5931\u8d25", (Throwable)e);
                        }
                        finally {
                            this.eaiDataPacketBusinessService.updateConnSyncStatus(byId.getId(), Integer.valueOf(EaiDataPacketSyncStatusEnum.END.getStatus()));
                        }
                    });
                }
            }
            return result;
        }
        catch (Exception e) {
            if (HussarUtils.isNotEmpty((Object)oldData)) {
                this.eaiDynamicDataSourceService.saveDynamicDatasource((SysDataSource)data);
            } else {
                this.dynamicDataSourceService.removeDynamicDatasource(dataSourceDto.getConnName());
            }
            throw e;
        }
    }

    private Boolean checkConnMainInformation(CommonConnection oldConnection, CommonConnectionDto commonConnectionDto) {
        if (!HussarUtils.equals((Object)oldConnection.getClassifyChild(), (Object)commonConnectionDto.getClassifyChild())) {
            return true;
        }
        EaiDataSourceDto dataSourceDto = (EaiDataSourceDto)JSON.parseObject((String)oldConnection.getConnectionConfig(), EaiDataSourceDto.class);
        EaiDataSourceDto newDataSourceDto = (EaiDataSourceDto)JSON.parseObject((String)JSONObject.toJSONString((Object)commonConnectionDto.getConnectionConfigMap()), EaiDataSourceDto.class);
        return this.eaiDataPacketBusinessService.checkDbMainInformation(oldConnection.getClassifyChild(), dataSourceDto, newDataSourceDto);
    }

    public CommonConnectionVo getConnectionById(CommonConnection commonConnection) {
        CommonConnectionVo connectionVo = new CommonConnectionVo();
        if (HussarUtils.isNotEmpty((Object)commonConnection)) {
            BeanUtil.copy((Object)commonConnection, (Object)connectionVo);
            if (HussarUtils.isNotEmpty((Object)commonConnection.getConnectionConfig())) {
                connectionVo.setConnectionConfigMap((Map)JSONObject.parseObject((String)commonConnection.getConnectionConfig(), Map.class));
            }
            connectionVo.setName(connectionVo.getConnectionNameEn());
            connectionVo.setDesc(connectionVo.getConnectionName());
        }
        return connectionVo;
    }

    public Boolean connectionTest(CommonConnectionDto commonConnectionDto) {
        Map connectionConfigMap = commonConnectionDto.getConnectionConfigMap();
        SysDataSourceDto dataSourceDto = new SysDataSourceDto();
        BeanMapUtil.fillBeanWithMapIgnoreCase((Map)connectionConfigMap, (Object)dataSourceDto, (boolean)false);
        this.tryConnection(dataSourceDto);
        return true;
    }

    private Connection getConnection(String url, String username, String password) throws SQLException {
        if (url.startsWith("jdbc:oscar")) {
            try {
                Class.forName("com.oscar.Driver");
            }
            catch (ClassNotFoundException var5) {
                LOGGER.error("ClassNotFoundException", (Throwable)var5);
            }
        }
        DriverManager.setLoginTimeout(30);
        return DriverManager.getConnection(url.replace("autoReconnect=true", "autoReconnect=false"), username, password);
    }

    private ApiResponse<String> tryConnection(SysDataSourceDto sysDataSourceDto) {
        if (!(HussarUtils.isEmpty((Object)sysDataSourceDto) || HussarUtils.isEmpty((Object)sysDataSourceDto.getJdbcUrl()) || HussarUtils.isEmpty((Object)sysDataSourceDto.getUserName()))) {
            ApiResponse var4;
            Connection conn = null;
            try {
                conn = this.getConnection(sysDataSourceDto.getJdbcUrl(), sysDataSourceDto.getUserName(), sysDataSourceDto.getPassword());
                String driverName = conn.getMetaData().getDriverName();
                var4 = ApiResponse.success((String)driverName.toUpperCase());
            }
            catch (Exception e) {
                LOGGER.error("\u6570\u636e\u5e93\u8fde\u63a5\u9519\u8bef", (Throwable)e);
                throw new HussarException("\u6570\u636e\u5e93\u8fde\u63a5\u9519\u8bef: " + e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    if (conn != null && !conn.isClosed()) {
                        conn.close();
                    }
                }
                catch (SQLException var12) {
                    LOGGER.error("\u5173\u95ed\u8fde\u63a5\u5931\u8d25", (Throwable)var12);
                }
            }
            return var4;
        }
        throw new HussarException("\u53c2\u6570\u4f20\u9012\u4e3a\u7a7a\uff01");
    }

    @HussarTransactional
    public Boolean deleteConnection(CommonConnection commonConnection) {
        String connectionConfig = commonConnection.getConnectionConfig();
        if (HussarUtils.isNotBlank((CharSequence)connectionConfig)) {
            SysDataSource data = (SysDataSource)JSON.parseObject((String)connectionConfig, SysDataSource.class);
            this.datasourceService.deleteDataSource((List)Lists.newArrayList((Object[])new String[]{data.getId() + ""}));
        }
        if (this.eaiDataPacketBusinessService.checkConnSyncStatus(commonConnection.getId())) {
            throw new BaseException("\u8bf7\u7b49\u5f85\u6570\u636e\u5305\u540c\u6b65\u7ed3\u675f\u540e\u518d\u5220\u9664\u8fde\u63a5\uff01");
        }
        this.eaiDataPacketBusinessService.syncDeleteDataPacket(commonConnection, "\u6570\u636e\u6e90\u5173\u8054\u6570\u636e\u5305\u5df2\u4e0a\u67b6\u8d44\u4ea7\u5e02\u573a\uff0c\u5982\u4ecd\u9700\u5220\u9664\uff0c\u8bf7\u5148\u4e0b\u67b6\u76f8\u5173\u6570\u636e\u5305\uff01");
        return this.commonConnectionService.deleteConnection(commonConnection.getId());
    }

    public void afterPropertiesSet() throws Exception {
        EaiAppConnectionFactory.registerAppConnection((String)(EaiAppConnectionEnum.CLASSIFY_CLASSIFYCHILD_RDB.getClassify() + "_" + EaiAppConnectionEnum.CLASSIFY_CLASSIFYCHILD_RDB.getClassifyChild()), (IEaiAppConnectionExtendService)this);
    }
}

