/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.datasource.rdb.service.impl;

import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiApiResponse;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiApiResponseVo;
import com.jxdinfo.hussar.eai.atomicbase.api.info.factory.ApiVerifyFactory;
import com.jxdinfo.hussar.eai.atomicbase.api.info.service.ApiVerifyService;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.config.EaiApiProperties;
import com.jxdinfo.hussar.eai.common.enums.api.EaiApiParamMappingEnum;
import com.jxdinfo.hussar.eai.common.util.EaiParamsTestConvertDto;
import com.jxdinfo.hussar.eai.datasource.rdb.dto.QuerySqlInterfaceVerifyDto;
import com.jxdinfo.hussar.eai.datasource.rdb.dto.RunCustomSqlDto;
import com.jxdinfo.hussar.eai.datasource.rdb.service.IQuerySqlService;
import com.jxdinfo.hussar.eai.datasource.rdb.util.SqlParamUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.validator.service.IHussarValidateService;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.datasource.rdb.service.impl.eaiQuerySqlVerifyServiceImpl")
public class EaiQuerySqlVerifyServiceImpl
implements ApiVerifyService<QuerySqlInterfaceVerifyDto> {
    @Autowired
    private IQuerySqlService querySqlService;
    @Autowired
    private EaiApiProperties eaiApiProperties;
    @Autowired
    protected IHussarValidateService validateService;

    public ApiResponse verifySavedApi(QuerySqlInterfaceVerifyDto apiVerifyDto) {
        return this.verifyApi(apiVerifyDto);
    }

    public ApiResponse<EaiApiResponseVo> verifyApi(QuerySqlInterfaceVerifyDto apiVerifyDto) {
        String validateMsg = this.validateService.validate((Object)apiVerifyDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        this.querySqlService.checkSql(apiVerifyDto.getCustomSql());
        EaiParamsTestConvertDto inParams = apiVerifyDto.getInParams();
        Object body = apiVerifyDto.getBody();
        Map outurlRequestParams = new LinkedHashMap();
        RunCustomSqlDto runCustomSqlDto = new RunCustomSqlDto();
        runCustomSqlDto.setCustomSql(apiVerifyDto.getCustomSql());
        runCustomSqlDto.setDsId(apiVerifyDto.getDsId());
        runCustomSqlDto.setPageFlag(apiVerifyDto.getPageFlag());
        runCustomSqlDto.setBody(body);
        List items = inParams.getBody();
        if (HussarUtils.isNotEmpty((Object)body) && HussarUtils.isNotEmpty((Object)items)) {
            outurlRequestParams = SqlParamUtil.getQuerySqlRealParams((List)items, (Object)body);
            for (EaiParamsItems item : items) {
                item.setMapping(Integer.valueOf(EaiApiParamMappingEnum.BODY.getCode()));
            }
            runCustomSqlDto.setInParams(items);
        }
        runCustomSqlDto.setLimit(this.eaiApiProperties.getQuerySqlTestLimit());
        Object sqlApiResponse = this.querySqlService.runTest(runCustomSqlDto);
        EaiApiResponseVo eaiApiResponseVo = new EaiApiResponseVo();
        eaiApiResponseVo.setOuturlRequestParams(outurlRequestParams);
        eaiApiResponseVo.setEscapeResponse((Object)ApiResponse.success((Object)sqlApiResponse));
        EaiApiResponse eaiApiResponse = new EaiApiResponse();
        eaiApiResponse.setBody(sqlApiResponse);
        eaiApiResponseVo.setOuturlResponse(eaiApiResponse);
        return ApiResponse.success((Object)eaiApiResponseVo);
    }

    public void afterPropertiesSet() throws Exception {
        ApiVerifyFactory.register((String)"3", (ApiVerifyService)this);
    }
}

