/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.datasource.rdb.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiInfo;
import com.jxdinfo.hussar.eai.apiinfo.api.model.EditApi;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiApiInfoService;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiEditApiService;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiApiResponse;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiApiResponseVo;
import com.jxdinfo.hussar.eai.atomicbase.api.info.factory.LogicVerifyFactory;
import com.jxdinfo.hussar.eai.atomicbase.api.info.service.LogicVerifyService;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.logicresource.dto.CanvasDebugDto;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.runtime.service.EaiCanvasRuntimeService;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.enums.api.EaiApiParamMappingEnum;
import com.jxdinfo.hussar.eai.common.enums.app.EaiResourcesEnum;
import com.jxdinfo.hussar.eai.common.util.EaiParamsConvertDto;
import com.jxdinfo.hussar.eai.common.util.EaiParamsTestConvertDto;
import com.jxdinfo.hussar.eai.common.util.ParamsConvertUtil;
import com.jxdinfo.hussar.eai.common.util.TempHttpCode;
import com.jxdinfo.hussar.eai.datasource.rdb.dto.QuerySqlInterfaceVerifyDto;
import com.jxdinfo.hussar.eai.datasource.rdb.dto.RunCustomSqlDto;
import com.jxdinfo.hussar.eai.datasource.rdb.service.IQuerySqlService;
import com.jxdinfo.hussar.eai.datasource.rdb.util.SqlParamUtil;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CanvasInfo;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICanvasInfoService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.validator.service.IHussarValidateService;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.datasource.rdb.service.impl.eaiQuerySqlLogicVerifyServiceImpl")
public class EaiQuerySqlLogicVerifyServiceImpl
implements LogicVerifyService<QuerySqlInterfaceVerifyDto> {
    @Autowired
    private IQuerySqlService querySqlService;
    @Autowired
    IEaiApiInfoService eaiApiInfoService;
    @Autowired
    private IEaiEditApiService iEaiEditApiService;
    @Autowired
    private ICanvasInfoService eaiCanvasInfoService;
    @Autowired
    EaiCanvasRuntimeService canvasRuntimeService;
    private static final String RESULT_STR = "result";
    private static final Logger LOGGER = LoggerFactory.getLogger(EaiQuerySqlLogicVerifyServiceImpl.class);
    @Autowired
    protected IHussarValidateService validateService;

    public ApiResponse<EaiApiResponseVo> verifyApi(QuerySqlInterfaceVerifyDto apiVerifyDto) {
        Long apiId = apiVerifyDto.getApiId();
        ApiInfo apiInfo = (ApiInfo)this.eaiApiInfoService.getById((Serializable)apiId);
        if (HussarUtils.isEmpty((Object)apiInfo)) {
            throw new BaseException("\u672a\u67e5\u8be2\u5230api\u4fe1\u606f");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(EditApi::getApiId, (Object)apiId);
        EditApi editApi = (EditApi)this.iEaiEditApiService.getOne((Wrapper)queryWrapper);
        if (HussarUtils.isEmpty((Object)editApi.getCanvasId())) {
            return this.getEaiApiResponseVoApiResponseNoCanvas(apiVerifyDto);
        }
        return this.getEaiApiResponseVoApiResponseCanvas(apiVerifyDto, apiInfo, editApi);
    }

    private ApiResponse<EaiApiResponseVo> getEaiApiResponseVoApiResponseCanvas(QuerySqlInterfaceVerifyDto apiVerifyDto, ApiInfo apiInfo, EditApi editApi) {
        CanvasDebugDto canvasDebugDto = this.convetTestParams(apiVerifyDto, apiInfo, editApi);
        ApiResponse apiResponse = null;
        try {
            apiResponse = this.canvasRuntimeService.runWithDebug(canvasDebugDto);
        }
        catch (BaseException e) {
            LOGGER.error("\u753b\u5e03\u8c03\u8bd5\u4ee3\u7801\u751f\u6210\u6216\u6267\u884c\u5f02\u5e38 id={}, code={}, name={}, app={}", new Object[]{canvasDebugDto.getId(), canvasDebugDto.getCode(), canvasDebugDto.getName(), canvasDebugDto.getApplicationCode(), e});
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
        catch (Exception ex) {
            LOGGER.error("\u753b\u5e03\u8c03\u8bd5\u4ee3\u7801\u751f\u6210\u6216\u6267\u884c\u5f02\u5e38 id={}, code={}, name={}, app={}", new Object[]{canvasDebugDto.getId(), canvasDebugDto.getCode(), canvasDebugDto.getName(), canvasDebugDto.getApplicationCode(), ex});
            throw new BaseException("\u9a8c\u8bc1\u5931\u8d25", (Throwable)ex);
        }
        finally {
            TempHttpCode.removeAll();
        }
        if (apiResponse.isSuccess()) {
            if (HussarUtils.isNotEmpty((Object)apiResponse.getData())) {
                JSONObject debugResult = JSON.parseObject((String)JSON.toJSONString((Object)apiResponse.getData()));
                if (debugResult.getBoolean("success").booleanValue()) {
                    EaiApiResponseVo apiResponseVo = new EaiApiResponseVo();
                    Object obj = debugResult.get((Object)RESULT_STR);
                    apiResponseVo.setEscapeResponse(obj);
                    return ApiResponse.success((Object)apiResponseVo);
                }
                JSONObject error = debugResult.getJSONObject("error");
                String exceptionMessage = error.getString("exceptionMessage");
                LOGGER.error("\u9519\u8bef\u5806\u6808\uff1a{}", (Object)error.getString("javaStacktrace"));
                throw new BaseException(exceptionMessage);
            }
            return ApiResponse.success((Object)new EaiApiResponseVo());
        }
        LOGGER.error("\u5f02\u5e38\uff1a{}", (Object)apiResponse.getMsg());
        throw new BaseException(apiResponse.getMsg());
    }

    @NotNull
    private ApiResponse<EaiApiResponseVo> getEaiApiResponseVoApiResponseNoCanvas(QuerySqlInterfaceVerifyDto apiVerifyDto) {
        AssertUtil.isNotEmpty((String)apiVerifyDto.getDsId(), (String)"\u6570\u636e\u6e90ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtil.isNotEmpty((String)apiVerifyDto.getCustomSql(), (String)"\u67e5\u8be2SQL\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        TempHttpCode.removeAll();
        EaiParamsTestConvertDto inParams = apiVerifyDto.getInParams();
        Object body = apiVerifyDto.getBody();
        Map outurlRequestParams = new LinkedHashMap();
        RunCustomSqlDto runCustomSqlDto = new RunCustomSqlDto();
        runCustomSqlDto.setCustomSql(apiVerifyDto.getCustomSql());
        runCustomSqlDto.setDsId(apiVerifyDto.getDsId());
        runCustomSqlDto.setPageFlag(apiVerifyDto.getPageFlag());
        runCustomSqlDto.setBody(body);
        List items = inParams.getBody();
        if (HussarUtils.isNotEmpty((Object)body) && HussarUtils.isNotEmpty((Object)items)) {
            outurlRequestParams = SqlParamUtil.getQuerySqlRealParams((List)inParams.getBody(), (Object)body);
            for (EaiParamsItems item : items) {
                item.setMapping(Integer.valueOf(EaiApiParamMappingEnum.BODY.getCode()));
            }
            runCustomSqlDto.setInParams(items);
        }
        Object sqlApiResponse = this.querySqlService.runTest(runCustomSqlDto);
        EaiApiResponseVo eaiApiResponseVo = new EaiApiResponseVo();
        eaiApiResponseVo.setOuturlRequestParams(outurlRequestParams);
        eaiApiResponseVo.setEscapeResponse((Object)ApiResponse.success((Object)sqlApiResponse));
        EaiApiResponse eaiApiResponse = new EaiApiResponse();
        eaiApiResponse.setBody(sqlApiResponse);
        eaiApiResponseVo.setOuturlResponse(eaiApiResponse);
        return ApiResponse.success((Object)eaiApiResponseVo);
    }

    private CanvasDebugDto convetTestParams(QuerySqlInterfaceVerifyDto apiVerifyDto, ApiInfo apiInfo, EditApi editApi) {
        CanvasInfo canvasInfo = (CanvasInfo)this.eaiCanvasInfoService.getById((Serializable)editApi.getCanvasId());
        CanvasDebugDto canvasDebugDto = new CanvasDebugDto();
        canvasDebugDto.setCode(apiInfo.getApiCode());
        canvasDebugDto.setCanvas(canvasInfo.getCanvasContent());
        canvasDebugDto.setResourceEnum(EaiResourcesEnum.API);
        canvasDebugDto.setName(apiInfo.getApiName());
        canvasDebugDto.setApplicationCode(apiInfo.getApplicationCode());
        EaiParamsConvertDto dto = ParamsConvertUtil.toEaiParamsConvertDto((String)apiInfo.getInParams());
        if (HussarUtils.isNotEmpty((Object)dto) && HussarUtils.isNotEmpty((Object)dto.getBody()) && HussarUtils.isNotEmpty((Object)dto.getBody().getItems())) {
            canvasDebugDto.setHttpBody(apiVerifyDto.getBody());
        } else {
            canvasDebugDto.setHttpBody(apiVerifyDto.getBody());
        }
        canvasDebugDto.setId(apiInfo.getId());
        return canvasDebugDto;
    }

    public void afterPropertiesSet() throws Exception {
        LogicVerifyFactory.register((String)"3", (LogicVerifyService)this);
    }

    private Map<String, Object> parseParams(Object body) {
        if (HussarUtils.isEmpty((Object)body)) {
            return new HashMap<String, Object>();
        }
        Map requestParams = (Map)body;
        String key = (String)requestParams.keySet().iterator().next();
        if (key.startsWith("sql_in_")) {
            requestParams = (Map)requestParams.get(key);
        }
        return SqlParamUtil.getDfRealRequestParams((Map)requestParams);
    }
}

