/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.datasource.rdb.service.impl;

import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.datasource.dto.SysDataSourceDto;
import com.jxdinfo.hussar.datasource.manager.api.model.CustomSqlDto;
import com.jxdinfo.hussar.datasource.manager.api.service.DatasourceService;
import com.jxdinfo.hussar.datasource.manager.api.service.HussarDdlService;
import com.jxdinfo.hussar.df.data.set.api.customsql.model.DfColumnValue;
import com.jxdinfo.hussar.df.data.set.api.customsql.service.CustomSqlQueryService;
import com.jxdinfo.hussar.df.data.set.api.customsql.vo.TestDfCustomSqlVo;
import com.jxdinfo.hussar.eai.api.canvas.runtime.dto.EaiQuerySqlParams;
import com.jxdinfo.hussar.eai.api.canvas.support.service.EaiQuerySqlInvokeService;
import com.jxdinfo.hussar.eai.common.config.EaiApiProperties;
import com.jxdinfo.hussar.eai.common.vo.PageVo;
import com.jxdinfo.hussar.eai.datasource.rdb.util.SQLUtil;
import com.jxdinfo.hussar.eai.datasource.rdb.util.SqlParamUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.validator.service.IHussarValidateService;
import java.util.ArrayList;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.datasource.rdb.service.impl.eaiQuerySqlInvokeServiceImpl")
public class EaiQuerySqlInvokeServiceImpl
implements EaiQuerySqlInvokeService {
    @Autowired
    private CustomSqlQueryService customSqlQueryService;
    @Autowired
    private EaiApiProperties eaiApiProperties;
    @Autowired
    private DatasourceService datasourceService;
    @Autowired
    protected IHussarValidateService validateService;

    public ApiResponse<Object> getResponse(EaiQuerySqlParams eaiQuerySqlParams) {
        String validateMsg = this.validateService.validate((Object)eaiQuerySqlParams);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        String dsId = eaiQuerySqlParams.getDsId();
        String customSql = eaiQuerySqlParams.getCustomSql();
        boolean pageFlag = eaiQuerySqlParams.getPageFlag();
        Map requestParams = eaiQuerySqlParams.getRequestParams();
        boolean debug = eaiQuerySqlParams.getDebug();
        Integer limit = this.eaiApiProperties.getQuerySqlTestLimit();
        if (!debug) {
            limit = this.eaiApiProperties.getQuerySqlProdLimit();
        }
        ArrayList parameterValues = new ArrayList();
        Map dfRealRequestParams = SqlParamUtil.getDfRealRequestParams((Map)requestParams);
        if (HussarUtils.isNotEmpty((Object)dfRealRequestParams)) {
            dfRealRequestParams.forEach((k, v) -> {
                DfColumnValue df = new DfColumnValue();
                df.setCode(k);
                df.setValue(v);
                parameterValues.add(df);
            });
        }
        com.jxdinfo.hussar.df.data.set.api.customsql.dto.CustomSqlDto customSqlDto = new com.jxdinfo.hussar.df.data.set.api.customsql.dto.CustomSqlDto();
        customSqlDto.setDataSourceId(dsId);
        customSqlDto.setParameterValues(parameterValues);
        customSqlDto.setPagination(pageFlag);
        customSqlDto.setCustomSql(SQLUtil.escEscapeSql((String)customSql));
        if (pageFlag) {
            Integer size;
            Integer current = requestParams.get("current") != null ? (Integer)requestParams.get("current") : 1;
            if (current < 1) {
                current = 1;
            }
            if ((size = Integer.valueOf(requestParams.get("size") != null ? (Integer)requestParams.get("size") : 10)) > limit) {
                throw new BaseException("\u8d85\u51fa\u67e5\u8be2\u5206\u9875\u9650\u5236\u3010" + limit + "\u3011");
            }
            customSqlDto.setCurrent(current);
            customSqlDto.setSize(size);
        } else {
            HussarDdlService hussarDdlService = (HussarDdlService)SpringContextUtil.getBean(HussarDdlService.class);
            SysDataSourceDto sysDataSource = this.datasourceService.getDataSourceById(Long.valueOf(Long.parseLong(dsId)));
            CustomSqlDto countDto = new CustomSqlDto();
            countDto.setSql(customSqlDto.getCustomSql());
            countDto.setPollName(sysDataSource.getDbName());
            Long cnt = (Long)hussarDdlService.selectCount(countDto);
            if (cnt > (long)limit.intValue()) {
                throw new BaseException("\u8d85\u51fa\u67e5\u8be2\u9650\u5236\u3010" + limit + "\u3011,\u8bf7\u4f7f\u7528\u5206\u9875\u67e5\u8be2");
            }
        }
        TestDfCustomSqlVo testDfCustomSqlVo = this.customSqlQueryService.preivewDataBySql(customSqlDto);
        if (pageFlag) {
            PageVo pageVo = new PageVo();
            pageVo.setRecords(testDfCustomSqlVo.getQueryResult());
            pageVo.setTotal(testDfCustomSqlVo.getTotal().longValue());
            return ApiResponse.success((Object)pageVo);
        }
        return ApiResponse.success((Object)testDfCustomSqlVo.getQueryResult());
    }
}

