/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.datasource.rdb.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.datasource.dto.SysDataSourceDto;
import com.jxdinfo.hussar.datasource.manager.api.service.DatasourceService;
import com.jxdinfo.hussar.eai.common.api.common.dto.DeleteEaiAppDto;
import com.jxdinfo.hussar.eai.common.service.IEaiDeleteAppService;
import com.jxdinfo.hussar.eai.datasource.rdb.model.EaiDatasetRelation;
import com.jxdinfo.hussar.eai.datasource.rdb.model.EaiQuerySqlConf;
import com.jxdinfo.hussar.eai.datasource.rdb.service.IEaiDatasetRelationService;
import com.jxdinfo.hussar.eai.datasource.rdb.service.IEaiQuerySqlConfService;
import com.jxdinfo.hussar.eai.datasource.rdb.util.BeanMapUtil;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CommonConnection;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICommonConnectionService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.datasource.rdb.service.impl.eaiDeleteAppQuerySqlServiceImpl")
public class EaiDeleteAppQuerySqlServiceImpl
implements IEaiDeleteAppService {
    private static final Logger logger = LoggerFactory.getLogger(EaiDeleteAppQuerySqlServiceImpl.class);
    @Autowired
    private IEaiDatasetRelationService eaiDatasetRelationService;
    @Autowired
    private IEaiQuerySqlConfService eaiQuerySqlConfService;
    @Autowired
    private ICommonConnectionService commonConnectionService;
    @Autowired
    private DatasourceService datasourceService;
    private static final String ERROR = "\u5220\u9664\u5e94\u7528\u56de\u8c03:\u5220\u9664\u6570\u636e\u6e90\u5931\u8d25";

    @HussarTransactional
    public void deleteAppResource(DeleteEaiAppDto deleteEaiAppDto) {
        String appCode = deleteEaiAppDto.getAppCode();
        LambdaQueryWrapper removeEaiQuerySqlConfWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiQuerySqlConf::getApplicationCode, (Object)appCode);
        this.eaiQuerySqlConfService.remove((Wrapper)removeEaiQuerySqlConfWrapper);
        LambdaQueryWrapper removeEaiDatasetRelationWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiDatasetRelation::getApplicationCode, (Object)appCode);
        this.eaiDatasetRelationService.remove((Wrapper)removeEaiDatasetRelationWrapper);
        List list = this.commonConnectionService.list((Wrapper)new LambdaQueryWrapper().eq(CommonConnection::getApplicationCode, (Object)appCode));
        if (HussarUtils.isNotEmpty((Object)list)) {
            ArrayList<String> ids = new ArrayList<String>();
            for (CommonConnection commonConnection : list) {
                String connectionConfig = commonConnection.getConnectionConfig();
                Map connectionConfigMap = (Map)JSONObject.parseObject((String)connectionConfig, Map.class);
                SysDataSourceDto dataSourceDto = new SysDataSourceDto();
                BeanMapUtil.fillBeanWithMapIgnoreCase((Map)connectionConfigMap, (Object)dataSourceDto, (boolean)false);
                ids.add(dataSourceDto.getId() + "");
            }
            try {
                this.datasourceService.deleteDataSource(ids);
            }
            catch (Exception e) {
                logger.error(ERROR, (Throwable)e);
            }
        }
    }
}

