/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.datasource.rdb.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.datasource.dto.SysDataSourceDto;
import com.jxdinfo.hussar.eai.datasource.rdb.entity.RdbDatasourceConnector;
import com.jxdinfo.hussar.eai.datasource.rdb.util.BeanMapUtil;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CommonConnection;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICommonConnectionService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5173\u7cfb\u578b\u6570\u636e\u5e93\u8fde\u63a5\u5668"})
@RestController(value="com.jxdinfo.hussar.eai.datasource.rdb.controller.rdbConnectorController")
@RequestMapping(value={"/eai/sql/connector"})
public class RdbConnectorController {
    @Autowired
    private ICommonConnectionService commonConnectionService;

    @ApiOperation(value="\u67e5\u8be2\u5173\u7cfb\u578b\u6570\u636e\u5e93\u8fde\u63a5\u5668\u5217\u8868\u6570\u636e", notes="\u67e5\u8be2\u5173\u7cfb\u578b\u6570\u636e\u5e93\u8fde\u63a5\u5668\u5217\u8868\u6570\u636e")
    @GetMapping(value={"/getRdbDatasourceConnectorList"})
    public ApiResponse<List<RdbDatasourceConnector>> getRdbDatasourceConnectorList(@Param(value="applicationCode") String applicationCode) {
        List list = this.commonConnectionService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CommonConnection::getConnectionClassify, (Object)"01")).eq(CommonConnection::getApplicationCode, (Object)applicationCode));
        ArrayList<RdbDatasourceConnector> result = new ArrayList<RdbDatasourceConnector>();
        if (HussarUtils.isEmpty((Object)list)) {
            return ApiResponse.success(new ArrayList());
        }
        for (CommonConnection commonConnection : list) {
            RdbDatasourceConnector rdbDatasourceConnector = new RdbDatasourceConnector();
            rdbDatasourceConnector.setEaiConnName(commonConnection.getConnectionName());
            String connectionConfig = commonConnection.getConnectionConfig();
            Map connectionConfigMap = (Map)JSONObject.parseObject((String)connectionConfig, Map.class);
            SysDataSourceDto dataSourceDto = new SysDataSourceDto();
            BeanMapUtil.fillBeanWithMapIgnoreCase((Map)connectionConfigMap, (Object)dataSourceDto, (boolean)false);
            rdbDatasourceConnector.setDsId(dataSourceDto.getId() + "");
            result.add(rdbDatasourceConnector);
        }
        return ApiResponse.success(result);
    }

    @ApiOperation(value="\u67e5\u8be2\u8fde\u63a5", notes="\u67e5\u8be2\u8fde\u63a5")
    @GetMapping(value={"/getCommonConnectionByDsId"})
    public ApiResponse<CommonConnection> getCommonConnectionByDsId(@ApiParam(value="\u6570\u636e\u6e90ID") @RequestParam(name="dsId", required=true) String dsId) {
        List list = this.commonConnectionService.list((Wrapper)new LambdaQueryWrapper().eq(CommonConnection::getConnectionClassify, (Object)"01"));
        if (HussarUtils.isEmpty((Object)list)) {
            return ApiResponse.fail((String)"\u672a\u77e5\u6570\u636e\u6e90\uff01");
        }
        for (CommonConnection commonConnection : list) {
            RdbDatasourceConnector rdbDatasourceConnector = new RdbDatasourceConnector();
            rdbDatasourceConnector.setEaiConnName(commonConnection.getConnectionName());
            String connectionConfig = commonConnection.getConnectionConfig();
            Map connectionConfigMap = (Map)JSONObject.parseObject((String)connectionConfig, Map.class);
            SysDataSourceDto dataSourceDto = new SysDataSourceDto();
            BeanMapUtil.fillBeanWithMapIgnoreCase((Map)connectionConfigMap, (Object)dataSourceDto, (boolean)false);
            if (!Objects.equals(dsId, dataSourceDto.getId() + "")) continue;
            return ApiResponse.success((Object)commonConnection);
        }
        return ApiResponse.fail((String)"\u672a\u77e5\u6570\u636e\u6e90\uff01");
    }
}

