/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.datasource.rdb.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.core.util.ExtendedChecker;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiApiInfoService;
import com.jxdinfo.hussar.eai.common.annotation.EaiAuthCheck;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.util.EaiParamsConvertDto;
import com.jxdinfo.hussar.eai.datasource.rdb.dto.AddSqlApiDto;
import com.jxdinfo.hussar.eai.datasource.rdb.dto.CheckInParamDto;
import com.jxdinfo.hussar.eai.datasource.rdb.dto.EditSqlApiDto;
import com.jxdinfo.hussar.eai.datasource.rdb.dto.LogicMappingOutParamDto;
import com.jxdinfo.hussar.eai.datasource.rdb.dto.MappingOutParamDto;
import com.jxdinfo.hussar.eai.datasource.rdb.dto.OutCheckDto;
import com.jxdinfo.hussar.eai.datasource.rdb.dto.RunCustomSqlDto;
import com.jxdinfo.hussar.eai.datasource.rdb.service.IQuerySqlService;
import com.jxdinfo.hussar.eai.datasource.rdb.util.SQLUtil;
import com.jxdinfo.hussar.eai.datasource.rdb.vo.LogicQuerySqlOutParamVo;
import com.jxdinfo.hussar.eai.datasource.rdb.vo.QuerySqlApiInfoVo;
import com.jxdinfo.hussar.eai.datasource.rdb.vo.ScriptLabelVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"SQL\u67e5\u8be2API"})
@RestController(value="com.jxdinfo.hussar.eai.datasource.rdb.controller.querySqlApiController")
@RequestMapping(value={"/eai/querySql/api"})
public class QuerySqlApiController {
    @Autowired
    private IQuerySqlService querySqlService;
    @Autowired
    private IEaiApiInfoService eaiApiInfoService;

    @EaiAuthCheck
    @ApiOperation(value="SQL\u67e5\u8be2API-\u65b0\u589e\u63a5\u53e3", notes="SQL\u67e5\u8be2API-\u65b0\u589e\u63a5\u53e3")
    @PostMapping(value={"/saveApiInfo"})
    public ApiResponse<String> saveApiInfo(@ApiParam(value="SQL\u67e5\u8be2API\u65b0\u589edto") @RequestBody AddSqlApiDto addSqlApiDto) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        Long count = this.eaiApiInfoService.count((Wrapper)queryWrapper);
        Integer limitCount = (Integer)ExtendedChecker.getValue((String)"apiNum");
        if (HussarUtils.isEmpty((Object)limitCount)) {
            return ApiResponse.fail((String)"\u7f3a\u5c11\u6388\u6743\u6587\u4ef6\u3002\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (count >= (long)limitCount.intValue()) {
            return ApiResponse.fail((String)("\u63a5\u53e3\u6570\u91cf\u5df2\u8fbe\u4e0a\u9650:" + limitCount + "\uff0c\u5982\u6709\u9700\u8981\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
        }
        return this.querySqlService.saveApiInfo(addSqlApiDto);
    }

    @EaiAuthCheck
    @ApiOperation(value="SQL\u67e5\u8be2API-\u4fee\u6539\u63a5\u53e3", notes="SQL\u67e5\u8be2API-\u4fee\u6539\u63a5\u53e3")
    @PostMapping(value={"/editApiInfo"})
    public ApiResponse<String> editApiInfo(@ApiParam(value="SQL\u67e5\u8be2API\u4fee\u6539dto") @RequestBody EditSqlApiDto editSqlApiDto) {
        return this.querySqlService.editApiInfo(editSqlApiDto);
    }

    @EaiAuthCheck
    @ApiOperation(value="SQL\u67e5\u8be2API-\u8fd0\u884c\u6d4b\u8bd5", notes="SQL\u67e5\u8be2API-\u8fd0\u884c\u6d4b\u8bd5")
    @PostMapping(value={"/runTest"})
    public ApiResponse<Object> runTest(@ApiParam(value="SQL\u67e5\u8be2API\u65b0\u589edto") @RequestBody RunCustomSqlDto runCustomSqlDto) {
        return ApiResponse.success((Object)this.querySqlService.runTest(runCustomSqlDto));
    }

    @ApiOperation(value="SQL\u67e5\u8be2API-\u51fa\u53c2\u81ea\u52a8\u6620\u5c04", notes="SQL\u67e5\u8be2API-\u51fa\u53c2\u81ea\u52a8\u6620\u5c04")
    @GetMapping(value={"/mappingOutParam"})
    public ApiResponse<List<EaiParamsItems>> mappingOutParam(@ApiParam(value="SQL\u67e5\u8be2API\u51fa\u53c2\u6620dto") MappingOutParamDto mappingOutParamDto) {
        return ApiResponse.success((Object)this.querySqlService.mapOut(mappingOutParamDto));
    }

    @ApiOperation(value="SQL\u67e5\u8be2API-\u51fa\u53c2\u81ea\u52a8\u6620\u5c04\u5e76\u521b\u5efa\u6570\u636e\u7ed3\u6784", notes="SQL\u67e5\u8be2API-\u51fa\u53c2\u81ea\u52a8\u6620\u5c04\u5e76\u521b\u5efa\u6570\u636e\u7ed3\u6784")
    @GetMapping(value={"/mappingOutParamAndCreateStructure"})
    public ApiResponse<LogicQuerySqlOutParamVo> mappingOutParamAndCreateStructure(@ApiParam(value="SQL\u67e5\u8be2API\u51fa\u53c2\u6620dto") LogicMappingOutParamDto mappingOutParamDto) {
        return ApiResponse.success((Object)this.querySqlService.mapOutAndCreateStructure(mappingOutParamDto));
    }

    @ApiOperation(value="SQL\u67e5\u8be2API-SQL\u5feb\u901f\u7f16\u5199", notes="SQL\u67e5\u8be2API-SQL\u5feb\u901f\u7f16\u5199")
    @GetMapping(value={"/quickFill"})
    public ApiResponse<ScriptLabelVo> quickFill(@ApiParam(value="\u8bf7\u6c42\u6807\u7b7e") String label) {
        return ApiResponse.success((Object)this.querySqlService.quickFill(label));
    }

    @ApiOperation(value="SQL\u67e5\u8be2API-\u683c\u5f0f\u5316", notes="SQL\u67e5\u8be2API-\u683c\u5f0f\u5316")
    @PostMapping(value={"/prettyFormat"})
    public ApiResponse<String> prettyFormat(@ApiParam(value="\u52a8\u6001sql") @RequestBody String sql) {
        ApiResponse success = ApiResponse.success((String)"success");
        AssertUtil.isNotEmpty((String)sql, (String)"SQL\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        success.setData((Object)SQLUtil.prettyFormat((String)sql));
        return success;
    }

    @ApiOperation(value="SQL\u67e5\u8be2API-\u5165\u53c2\u68c0\u67e5", notes="SQL\u67e5\u8be2API-\u5165\u53c2\u68c0\u67e5")
    @PostMapping(value={"/checkInParam"})
    public ApiResponse<String> checkInParam(@ApiParam(value="\u5165\u53c2\u68c0\u67e5dto") @RequestBody CheckInParamDto checkInParamDto) {
        if (!this.querySqlService.checkInParam(checkInParamDto)) {
            return ApiResponse.fail((String)"\u68c0\u6d4b\u5230sql\u4e2d\u7684\u5165\u53c2\u4e0e\u5165\u53c2\u914d\u7f6e\u53c2\u6570\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2\u914d\u7f6e! ");
        }
        return ApiResponse.success((String)"\u68c0\u6d4b\u6210\u529f! ");
    }

    @ApiOperation(value="SQL\u67e5\u8be2API-\u51fa\u53c2\u68c0\u67e5", notes="SQL\u67e5\u8be2API-\u51fa\u53c2\u68c0\u67e5")
    @PostMapping(value={"/checkOutRight"})
    public ApiResponse<Boolean> checkOutRight(@ApiParam(value="\u5165\u53c2\u68c0\u67e5dto") @RequestBody OutCheckDto outCheckDto) {
        ApiResponse apiResponse = new ApiResponse();
        apiResponse.setCode(ApiResponse.success().getCode());
        apiResponse.setData((Object)this.querySqlService.checkOutRight(outCheckDto));
        return apiResponse;
    }

    @ApiOperation(value="SQL\u67e5\u8be2API-\u7ec4\u88c5\u5165\u53c2", notes="SQL\u67e5\u8be2API-\u7ec4\u88c5\u5165\u53c2")
    @PostMapping(value={"/assembleInParam"})
    public ApiResponse<EaiParamsConvertDto> assembleInParam(@ApiParam(value="\u52a8\u6001sql") @RequestBody String sql) {
        return ApiResponse.success((Object)this.querySqlService.assembleInParam(sql));
    }

    @EaiAuthCheck
    @ApiOperation(value="\u5e94\u7528\u63a5\u53e3\u5f00\u653e-\u5220\u9664\u63a5\u53e3", notes="\u5e94\u7528\u63a5\u53e3\u5f00\u653e-\u5220\u9664\u63a5\u53e3")
    @PostMapping(value={"/deleteApi"})
    public ApiResponse<Boolean> deleteApi(@ApiParam(value="\u7ec4\u7ec7\u673a\u6784id") @RequestBody String id) {
        return ApiResponse.success((Object)this.querySqlService.deleteApi(id));
    }

    @EaiAuthCheck
    @ApiOperation(value="\u5e94\u7528\u63a5\u53e3\u5f00\u653e-\u66f4\u591a\u63a5\u53e3\u9a8c\u8bc1\u67e5\u770b", notes="\u5e94\u7528\u63a5\u53e3\u5f00\u653e-\u66f4\u591a\u63a5\u53e3\u9a8c\u8bc1\u67e5\u770b")
    @GetMapping(value={"/getQuerySqlApiInfo"})
    public ApiResponse<QuerySqlApiInfoVo> getQuerySqlApiInfo(@ApiParam(value="\u63a5\u53e3id") @RequestParam(name="id") Long id) {
        return ApiResponse.success((Object)this.querySqlService.getQuerySqlApiInfo(id));
    }
}

