/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.common.util;

import com.jxdinfo.hussar.eai.common.config.EaiApiProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.text.DateFormat;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ServerEndpoint(value="/ws/eai/{serviceId}")
public class WebSocketUtil {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketUtil.class);
    private static final ConcurrentHashMap<String, WebSocketUtil> server = new ConcurrentHashMap();
    private Session session;
    private String serviceId;
    private static EaiApiProperties eaiApiProperties;

    @Resource
    public void setEaiApiProperties(EaiApiProperties eaiApiProperties) {
        WebSocketUtil.eaiApiProperties = eaiApiProperties;
    }

    @OnOpen
    public void onOpen(Session session, @PathParam(value="serviceId") String serviceId) {
        this.session = session;
        this.serviceId = serviceId;
        if (WebSocketUtil.isDCS().booleanValue()) {
            if (!HussarCacheUtil.containKey((String)"eai:ws:log", (Object)WebSocketUtil.getCacheKey(this.serviceId))) {
                HussarCacheUtil.put((String)"eai:ws:log", (Object)WebSocketUtil.getCacheKey(this.serviceId), (Object)this);
            }
        } else if (!server.containsKey(this.serviceId)) {
            server.put(this.serviceId, this);
        }
        this.sendMessage("1");
    }

    private static Boolean isDCS() {
        return null != eaiApiProperties.getSingleMode() && eaiApiProperties.getSingleMode() == false;
    }

    private static WebSocketUtil getUtil(String serviceId) {
        WebSocketUtil webSocketUtil = null;
        if (WebSocketUtil.isDCS().booleanValue()) {
            if (HussarCacheUtil.containKey((String)"eai:ws:log", (Object)WebSocketUtil.getCacheKey(serviceId))) {
                webSocketUtil = (WebSocketUtil)HussarCacheUtil.get((String)"eai:ws:log", (Object)WebSocketUtil.getCacheKey(serviceId));
            }
        } else if (HussarUtils.isNotEmpty((Object)serviceId) && server.containsKey(serviceId)) {
            webSocketUtil = server.get(serviceId);
        }
        return webSocketUtil;
    }

    @OnClose
    public void onClose() {
        server.remove(this.serviceId);
    }

    private void sendMessage(String msg) {
        try {
            this.session.getAsyncRemote().sendText(msg);
        }
        catch (Exception e) {
            if (!WebSocketUtil.isDCS().booleanValue()) {
                server.remove(this.serviceId);
            }
            HussarCacheUtil.evict((String)"eai:ws:log", (Object)WebSocketUtil.getCacheKey(this.serviceId));
        }
    }

    @OnMessage
    public void OnMessage(String msg) {
    }

    public static void senMsg(String serviceId, String msg, String type, Throwable exception) {
        String time = DateFormat.getDateTimeInstance().format(System.currentTimeMillis());
        try {
            WebSocketUtil ws;
            String str = null;
            str = exception == null ? String.format("%s [%s] %s", time, type, msg) : String.format("%s [%s] %s %s", time, type, msg, exception);
            if (str != null && HussarUtils.isNotEmpty((Object)(ws = WebSocketUtil.getUtil(serviceId)))) {
                ws.session.getAsyncRemote().sendText(str);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private static String getCacheKey(String serviceId) {
        return String.format("%s%s", "eai:ws:log", serviceId);
    }
}

