/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.common.util;

import com.jxdinfo.hussar.integration.support.jackson.config.JsonConfiguration;
import com.jxdinfo.hussar.integration.support.jackson.config.JsonMultipartFileStrategy;
import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationJsonUtils;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public enum JsonParseToStringUtil {
    INSTANCE;

    private static JsonConfiguration configuration;
    private static HussarIntegrationJsonUtils.JsonUtilsBean bean;
    private static final String ENGINE_MULTIPART_KEY = "multipartRequest";

    public String toString(Object object) {
        if (object instanceof Map && ((Map)object).containsKey(ENGINE_MULTIPART_KEY)) {
            Object v = ((Map)object).get(ENGINE_MULTIPART_KEY);
            if (v == null) {
                return "";
            }
            if (v instanceof MultipartHttpServletRequest) {
                return this.getBean().toString(this.requestToMap((MultipartHttpServletRequest)v));
            }
        }
        return this.getBean().toString(object);
    }

    public Object toObject(Object object) {
        return this.getBean().convert(object, Object.class);
    }

    private JsonConfiguration getConfiguration() {
        if (configuration == null) {
            configuration = JsonConfiguration.Builder.begin().multipartFileStrategy(JsonMultipartFileStrategy.BRIEF_INFO).build();
        }
        return configuration;
    }

    private HussarIntegrationJsonUtils.JsonUtilsBean getBean() {
        if (bean == null) {
            bean = HussarIntegrationJsonUtils.createUtilsBean((JsonConfiguration)this.getConfiguration());
        }
        return bean;
    }

    private Map<String, Object> requestToMap(MultipartHttpServletRequest multipartRequest) {
        if (multipartRequest == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Enumeration parameterNames = multipartRequest.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String name = (String)parameterNames.nextElement();
            map.put(name, multipartRequest.getParameter(name));
        }
        MultiValueMap fileMap = multipartRequest.getMultiFileMap();
        map.putAll((Map<String, Object>)fileMap);
        return map;
    }
}

