/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.common.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;

public class ExpressionRegUtil {
    private static final Pattern REGEXP_PILL = Pattern.compile("/\\*\\s*#META\\s*((?:[^*]|\\*(?!/))*)\\*/((?:[^/]|/(?!\\*))*)/\\*\\s*META#\\s*\\*/");
    private static final Pattern REGEXP_EAI_CONSTANT = Pattern.compile("^\\s*getEaiConstant\\(\"([^\"]+)\"\\)\\s*$");
    private static final Pattern REGEXP_AUTH_PARAM = Pattern.compile("^\\s*getEaiAuthParam\\(\"([^\"]+)\"\\)\\s*$");
    private static final Pattern VALID_SYMBOL_PATTERN = Pattern.compile("^[a-zA-Z_$][a-zA-Z0-9_$]*$");

    public static List<Long> findConstantIds(String expression) {
        return ExpressionRegUtil.findPillContents(expression, inner -> {
            Matcher matcher = REGEXP_EAI_CONSTANT.matcher((CharSequence)inner);
            if (!matcher.matches()) {
                return null;
            }
            String literal = matcher.group(1);
            try {
                return literal != null ? Long.valueOf(Long.parseLong(literal)) : null;
            }
            catch (NumberFormatException ignore) {
                return null;
            }
        });
    }

    public static List<Long> findAuthParamIds(String expression) {
        return ExpressionRegUtil.findPillContents(expression, inner -> {
            Matcher matcher = REGEXP_AUTH_PARAM.matcher((CharSequence)inner);
            if (!matcher.matches()) {
                return null;
            }
            String literal = matcher.group(1);
            try {
                return literal != null ? Long.valueOf(Long.parseLong(literal)) : null;
            }
            catch (NumberFormatException ignore) {
                return null;
            }
        });
    }

    private static <T> List<T> findPillContents(String expression, Function<String, T> filter) {
        Matcher matcher = REGEXP_PILL.matcher(expression);
        ArrayList<T> contents = new ArrayList<T>();
        while (matcher.find()) {
            String inner = matcher.group(2);
            T content = filter.apply(inner);
            if (content == null) continue;
            contents.add(content);
        }
        return contents;
    }

    public static String analysiSpecialExp(String expStr) {
        String[] splitSStr = expStr.split("\\.");
        ArrayList listStr = Lists.newArrayListWithCapacity((int)5);
        for (int i = 0; i < splitSStr.length; ++i) {
            String str = splitSStr[i];
            if (!VALID_SYMBOL_PATTERN.matcher(str).matches()) {
                str = "['" + StringEscapeUtils.escapeEcmaScript((String)str) + "']";
            }
            listStr.add(str);
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < listStr.size(); ++i) {
            buffer.append((String)listStr.get(i));
            if (i >= listStr.size() - 1 || ((String)listStr.get(i + 1)).startsWith("['")) continue;
            buffer.append(".");
        }
        return buffer.toString();
    }
}

