/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.common.util;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Calendar;

public class EaiDateUtil {
    private static final long ONE_MILLISECOND = 1000L;
    private static final long ONE_MINUTE = 60000L;
    private static final long ONE_HOUR = 3600000L;
    private static final long ONE_DAY = 86400000L;
    private static final String ONE_WEEK_AGO = "1\u5468\u524d";
    private static final String TWO_WEEK_AGO = "2\u5468\u524d";
    private static final String THREE_WEEK_AGO = "3\u5468\u524d";
    private static final String ONE_SECOND_AGO = "\u79d2\u524d";
    private static final String ONE_MINUTE_AGO = "\u5206\u949f\u524d";
    private static final String ONE_HOUR_AGO = "\u5c0f\u65f6\u524d";
    private static final String ONE_DAY_AGO = "\u5929\u524d";
    private static final String ONE_MONTH_AGO = "1\u4e2a\u6708\u524d";
    private static final String TWO_MONTH_AGO = "2\u4e2a\u6708\u524d";
    private static final String THREE_MONTH_AGO = "3\u4e2a\u6708\u524d";
    private static final String FOUR_MONTH_AGO = "4\u4e2a\u6708\u524d";
    private static final String FIVE_MONTH_AGO = "5\u4e2a\u6708\u524d";
    private static final String SIX_MONTH_AGO = "6\u4e2a\u6708\u524d";
    private static final String SEVEN_MONTH_AGO = "7\u4e2a\u6708\u524d";
    private static final String EIGHT_MONTH_AGO = "8\u4e2a\u6708\u524d";
    private static final String NINE_MONTH_AGO = "9\u4e2a\u6708\u524d";
    private static final String TEN_MONTH_AGO = "10\u4e2a\u6708\u524d";
    private static final String ELEVEN_MONTH_AGO = "11\u4e2a\u6708\u524d";
    private static final String ONE_YEAR_AGO = "1\u5e74\u524d";

    public static boolean isToday(LocalDateTime createTime) {
        Calendar now = Calendar.getInstance();
        int yearNow = now.get(1);
        int monthNow = now.get(2);
        int dayNow = now.get(5);
        int checkYear = createTime.getYear();
        int checkMonth = createTime.getMonthValue();
        int checkDay = createTime.getDayOfMonth();
        return yearNow == checkYear && monthNow == checkMonth && dayNow == checkDay;
    }

    public static LocalDateTime startOfToday() {
        LocalDate localDate = LocalDate.now();
        return localDate.atStartOfDay();
    }

    public static String diffTimeformat(LocalDateTime date, long now) {
        Calendar calendar = Calendar.getInstance();
        long delta = now - date.toInstant(ZoneOffset.of("+8")).toEpochMilli();
        if (delta < 60000L) {
            return delta / 1000L + ONE_SECOND_AGO;
        }
        if (delta < 3600000L) {
            return delta / 60000L + ONE_MINUTE_AGO;
        }
        if (delta < 86400000L) {
            return delta / 3600000L + ONE_HOUR_AGO;
        }
        if (delta < EaiDateUtil.getTime(calendar, now)) {
            return delta / 86400000L + ONE_DAY_AGO;
        }
        if (delta < EaiDateUtil.getWeekTime(calendar, now)) {
            return ONE_WEEK_AGO;
        }
        if (delta < EaiDateUtil.getWeekTime(calendar, now)) {
            return TWO_WEEK_AGO;
        }
        if (delta < EaiDateUtil.getWeekTime(calendar, now)) {
            return THREE_WEEK_AGO;
        }
        if (delta < EaiDateUtil.getTime(calendar, now)) {
            return ONE_MONTH_AGO;
        }
        if (delta < EaiDateUtil.getTime(calendar, now)) {
            return TWO_MONTH_AGO;
        }
        if (delta < EaiDateUtil.getTime(calendar, now)) {
            return THREE_MONTH_AGO;
        }
        if (delta < EaiDateUtil.getTime(calendar, now)) {
            return FOUR_MONTH_AGO;
        }
        if (delta < EaiDateUtil.getTime(calendar, now)) {
            return FIVE_MONTH_AGO;
        }
        if (delta < EaiDateUtil.getTime(calendar, now)) {
            return SIX_MONTH_AGO;
        }
        if (delta < EaiDateUtil.getTime(calendar, now)) {
            return SEVEN_MONTH_AGO;
        }
        if (delta < EaiDateUtil.getTime(calendar, now)) {
            return EIGHT_MONTH_AGO;
        }
        if (delta < EaiDateUtil.getTime(calendar, now)) {
            return NINE_MONTH_AGO;
        }
        if (delta < EaiDateUtil.getTime(calendar, now)) {
            return TEN_MONTH_AGO;
        }
        if (delta < EaiDateUtil.getTime(calendar, now)) {
            return ELEVEN_MONTH_AGO;
        }
        return ONE_YEAR_AGO;
    }

    private static long getWeekTime(Calendar calendar, long now) {
        calendar.add(7, -1);
        return now - calendar.getTimeInMillis();
    }

    private static long getTime(Calendar calendar, long now) {
        calendar.add(2, -1);
        return now - calendar.getTimeInMillis();
    }
}

