/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.common.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;

public class EaiConvertPinYinUtil {
    public static String convertHanzi2Pinyin(String hanzi, boolean full) {
        String regExp = "^[\u4e00-\u9fff]+$";
        StringBuffer sb = new StringBuffer();
        if (hanzi == null || "".equals(hanzi.trim())) {
            return "";
        }
        String pinyin = "";
        for (int i = 0; i < hanzi.length(); ++i) {
            char unit = hanzi.charAt(i);
            if (EaiConvertPinYinUtil.match(String.valueOf(unit), regExp)) {
                pinyin = EaiConvertPinYinUtil.convertSingleHanzi2Pinyin(unit, hanzi);
                if (full) {
                    sb.append(pinyin);
                    continue;
                }
                sb.append(pinyin.charAt(0));
                continue;
            }
            sb.append(unit);
        }
        return sb.toString();
    }

    public static boolean match(String str, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(str);
        return matcher.find();
    }

    private static String convertSingleHanzi2Pinyin(char hanzi, String hanziAll) {
        HanyuPinyinOutputFormat outputFormat = new HanyuPinyinOutputFormat();
        outputFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        outputFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        try {
            String[] res = PinyinHelper.toHanyuPinyinStringArray((char)hanzi, (HanyuPinyinOutputFormat)outputFormat);
            return res[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

