/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.common.util;

import com.jxdinfo.hussar.common.exception.BaseException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ApplicationExportUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationExportUtils.class);

    private ApplicationExportUtils() {
    }

    public static void exportTxt(String data, String fileName) {
        HttpServletResponse httpServletResponse = null;
        PrintWriter out = null;
        try {
            httpServletResponse = ApplicationExportUtils.getHttpServletResponse(fileName);
            out = httpServletResponse.getWriter();
            out.write(data);
            out.flush();
        }
        catch (Exception e) {
            LOGGER.error("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new BaseException("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (null != out) {
                out.close();
            }
        }
    }

    private static HttpServletResponse getHttpServletResponse(String fileName) throws Exception {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletResponse response = servletRequestAttributes.getResponse();
        response.setContentType("application/octet-stream");
        response.setCharacterEncoding("utf-8");
        fileName = URLEncoder.encode(fileName + ".txt", "UTF-8").replace("\\+", "%20");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName);
        return response;
    }
}

