/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.common.enums.api;

import com.jxdinfo.hussar.support.exception.HussarException;

public enum EaiRequestTypeEnum {
    POST(0, "POST"),
    GET(1, "GET"),
    PUT(2, "PUT"),
    PATCH(3, "PATCH"),
    HEAD(4, "HEAD"),
    OPTIONS(5, "OPTIONS"),
    DELETE(6, "DELETE"),
    TRACE(7, "TRACE");

    private int requestType;
    private String type;

    private EaiRequestTypeEnum(int requestType, String type) {
        this.requestType = requestType;
        this.type = type;
    }

    public int getRequestType() {
        return this.requestType;
    }

    public String getRequestTypeStr() {
        return String.valueOf(this.requestType);
    }

    public String getType() {
        return this.type;
    }

    public static EaiRequestTypeEnum getRequestTypeEnum(int requestType) {
        for (EaiRequestTypeEnum typeEnum : EaiRequestTypeEnum.values()) {
            if (typeEnum.getRequestType() != requestType) continue;
            return typeEnum;
        }
        throw new HussarException("\u4e0d\u5b58\u5728\u7684\u7c7b\u578b");
    }

    public static EaiRequestTypeEnum getByType(String type) {
        for (EaiRequestTypeEnum typeEnum : EaiRequestTypeEnum.values()) {
            if (!typeEnum.getType().equals(type)) continue;
            return typeEnum;
        }
        throw new HussarException("\u4e0d\u5b58\u5728\u7684\u7c7b\u578b");
    }

    public static EaiRequestTypeEnum getByRequestType(String requestType) {
        for (EaiRequestTypeEnum typeEnum : EaiRequestTypeEnum.values()) {
            if (!typeEnum.getRequestTypeStr().equals(requestType)) continue;
            return typeEnum;
        }
        throw new HussarException("\u4e0d\u5b58\u5728\u7684\u7c7b\u578b");
    }
}

