/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.client.sdk.api.service.impl;

import com.jxdinfo.hussar.eai.client.sdk.api.bo.EaiApiSdkInvokeParams;
import com.jxdinfo.hussar.eai.client.sdk.api.bo.EaiApiSdkTokenParams;
import com.jxdinfo.hussar.eai.client.sdk.api.bo.EaiClientAuthResponse;
import com.jxdinfo.hussar.eai.client.sdk.api.service.EaiClientTokenApiSdkService;
import com.jxdinfo.hussar.eai.client.sdk.properties.EaiClientSdkProperties;
import com.jxdinfo.hussar.eai.client.sdk.utils.EaiApiSdkUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.client.sdk.api.service.impl.EaiClientTokenApiSdkServiceImpl")
public class EaiClientTokenApiSdkServiceImpl
implements EaiClientTokenApiSdkService {
    @Resource
    private EaiClientSdkProperties eaiClientSdkProperties;

    @Override
    public String getClientToken(EaiApiSdkInvokeParams eaiApiInvokeParams) {
        String clientId = StringUtil.isEmpty((Object)eaiApiInvokeParams.getClientId()) ? this.eaiClientSdkProperties.getClientId() : eaiApiInvokeParams.getClientId();
        String clientSecret = StringUtil.isEmpty((Object)eaiApiInvokeParams.getClientSecret()) ? this.eaiClientSdkProperties.getClientSecret() : eaiApiInvokeParams.getClientSecret();
        eaiApiInvokeParams.setClientId(clientId);
        eaiApiInvokeParams.setClientSecret(clientSecret);
        String clientToken = (String)HussarCacheUtil.get((String)"eai_client_token", (Object)eaiApiInvokeParams.getClientId());
        if (StringUtil.isNotEmpty((Object)clientToken)) {
            return clientToken;
        }
        EaiClientAuthResponse authResponse = EaiApiSdkUtil.getClientToken((EaiApiSdkTokenParams)this.convertTokenParams(eaiApiInvokeParams));
        if (HussarUtils.isNotEmpty((Object)authResponse)) {
            HussarCacheUtil.put((String)"eai_client_token", (Object)authResponse.getClientId(), (Object)authResponse.getClientToken(), (long)authResponse.getExpiresIn());
            return authResponse.getClientToken();
        }
        return null;
    }

    @Override
    public String getClientTokenByApi(EaiApiSdkInvokeParams eaiApiInvokeParams) {
        HussarCacheUtil.evict((String)"eai_client_token", (Object)eaiApiInvokeParams.getClientId());
        EaiClientAuthResponse authResponse = EaiApiSdkUtil.getClientToken((EaiApiSdkTokenParams)this.convertTokenParams(eaiApiInvokeParams));
        if (HussarUtils.isNotEmpty((Object)authResponse)) {
            HussarCacheUtil.put((String)"eai_client_token", (Object)authResponse.getClientId(), (Object)authResponse.getClientToken(), (long)authResponse.getExpiresIn());
            return authResponse.getClientToken();
        }
        return null;
    }

    private EaiApiSdkTokenParams convertTokenParams(EaiApiSdkInvokeParams eaiApiInvokeParams) {
        EaiApiSdkTokenParams tokenParams = new EaiApiSdkTokenParams();
        tokenParams.setServerUrl(eaiApiInvokeParams.getServerUrl());
        tokenParams.setClientId(eaiApiInvokeParams.getClientId());
        tokenParams.setClientSecret(eaiApiInvokeParams.getClientSecret());
        return tokenParams;
    }
}

