/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicenhancements.server.publish.service.impl;

import com.jxdinfo.hussar.eai.apirelease.api.model.EaiApiVersion;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.enums.EaiPublishEngineType;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.factory.IPublishEngineFactory;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiPublishEngineService;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.runtime.service.EaiCanvasConvertService;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CanvasInfo;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICanvasInfoService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicenhancements.server.publish.service.impl.GenCanvasCodeAndPublishEngineServiceImpl")
public class GenCanvasCodeAndPublishEngineServiceImpl
implements EaiPublishEngineService {
    @Resource
    private EaiPublishEngineService eaiPublishEngineService;
    @Resource
    private EaiCanvasConvertService canvasConvertService;
    @Resource
    ICanvasInfoService canvasInfoService;

    public void pushEngine(List<EaiApiVersion> apiVersions, String appVersion) {
        IPublishEngineFactory.getService((String)EaiPublishEngineType.DEFAULT.getType()).pushEngine(apiVersions, appVersion);
    }

    public void pushEngine(List<EaiApiVersion> apiVersions, String appVersion, Map<Long, String> maps) {
        IPublishEngineFactory.getService((String)EaiPublishEngineType.DEFAULT.getType()).pushEngine(apiVersions, appVersion, maps);
    }

    public void pushEngine(List<Long> canvasIds, Map<Long, Long> map, List<EaiApiVersion> apiVersions, String appcode, String appVersion) {
        List canvasInfos = this.canvasInfoService.listByIds(canvasIds);
        this.pushCanvasEngine(canvasInfos, map, apiVersions, appcode, appVersion);
    }

    public void afterPropertiesSet() throws Exception {
        IPublishEngineFactory.register((String)EaiPublishEngineType.LOGIC.getType(), (EaiPublishEngineService)this);
    }

    private void pushCanvasEngine(List<CanvasInfo> canvasInfos, Map<Long, Long> map, List<EaiApiVersion> apiVersions, String appcode, String appVersion) {
        HashMap apiVersionMap = new HashMap();
        apiVersions.forEach(apiVersion -> apiVersionMap.put(map.get(apiVersion.getApiVersionId()), apiVersion));
        Map maps = this.canvasConvertService.generatedCode(canvasInfos, apiVersionMap, appcode, appVersion);
        this.pushEngine(apiVersions, appVersion, maps);
    }
}

